/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util.infos;

import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import org.jdom.Document;
import org.jdom.Element;

public class Info {
    Document doc;
    File xmlFile;
    String id;
    String displayNameKey;
    String descriptionKey;
    String resourcePropertiesFile;
    String defaultDisplayName;
    HashMap displayNames;

    public Info() {
    }

    public Info(Document doc, File xmlFile) {
        this.doc = doc;
        this.xmlFile = xmlFile;
        if (doc != null) {
            Element root = doc.getRootElement();
            this.id = root.getChildTextTrim("id");
            this.displayNameKey = root.getChildTextTrim("display-name-key");
            this.descriptionKey = root.getChildTextTrim("description-key");
            this.resourcePropertiesFile = root.getChildTextTrim("resource-properties-file");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getResourcePropertiesFile() {
        return this.resourcePropertiesFile;
    }

    public Document getDocument() {
        return this.doc;
    }

    public File getXMLFile() {
        return this.xmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(TaskContext context) {
        Locale l;
        String displayName;
        if (this.defaultDisplayName == null) {
            Info info = this;
            synchronized (info) {
                if (this.defaultDisplayName == null) {
                    this.displayNames = new HashMap();
                    if (this.id == null) {
                        this.defaultDisplayName = "";
                    } else {
                        this.defaultDisplayName = this.id;
                        this.defaultDisplayName = this.defaultDisplayName.substring(this.defaultDisplayName.lastIndexOf(".") + 1, this.defaultDisplayName.length());
                        this.defaultDisplayName = this.defaultDisplayName.replace('_', ' ');
                        this.defaultDisplayName = eMFrameUtils.replaceWith(this.defaultDisplayName, "\\.", ".");
                    }
                }
            }
        }
        if ((displayName = (String)this.displayNames.get(l = context.getLocale())) == null) {
            Info info = this;
            synchronized (info) {
                if (displayName == null) {
                    displayName = eMFrameUtils.getLocalizedString(this.resourcePropertiesFile, this.displayNameKey, context);
                    if (displayName == null) {
                        displayName = this.defaultDisplayName;
                    }
                    this.displayNames.put(l, displayName);
                }
            }
        }
        return displayName;
    }
}

