/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.emframe.fw.FwAttr;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Browser {
    public static final String AGENT_MSIE = "MSIE";
    public static final String AGENT_NSN = "NSN";
    public static final String AGENT_MOZILLA = "MOZILLA";
    public static final String AGENT_UPBROWSER = "UP.BROWSER";
    public static final String AGENT_PROXINET = "PROXINET";
    public static final String AGENT_AVANTGO = "AVANTGO";
    public static final String AGENT_OPERA = "OPERA";
    public static final String AGENT_UNKNOWN = "UNKNOWN";
    private static final String OS_WIN16 = "Win16";
    private static final String OS_WIN95 = "Win95";
    private static final String OS_WIN98 = "Win98";
    private static final String OS_WINNT = "WinNT";
    private static final String OS_NETWARE = "Netware";
    private static final String OS_MAC = "Mac";
    private static final String OS_UNIX = "Unix";
    private static final String OS_WEBTV = "WebTV";
    private static final String OS_OS2 = "OS2";
    private static final String OS_PALM = "Palm";
    private static final String OS_UNKNOWN = "Unknown";
    private static final int IE_MIN_MAJ = 6;
    private static final int IE_MIN_MINOR = 0;
    private static final int MOZ_MIN_MAJ = 1;
    private static final int MOZ_MIN_MINOR = 7;
    private String m_sName = null;
    private String m_sMajorVer = "0";
    private String m_sMinorVer = "0";
    private String m_sOS = "";
    private String m_sUserAgent = null;
    private boolean m_bSupported = false;

    private Browser(String sUserAgent) {
        if (sUserAgent != null) {
            this.m_sUserAgent = sUserAgent;
            this.AutoDetectName(sUserAgent);
            this.AutoDetectOS(sUserAgent);
        }
    }

    public static Browser getInstance(HttpServletRequest req) {
        HttpSession session = req.getSession();
        Browser browser = (Browser)FwAttr.getFwSessionAttribute("Browser", session);
        if (browser == null) {
            browser = new Browser(req.getHeader("User-Agent"));
            FwAttr.setFwSessionAttribute("Browser", browser, session);
        }
        return browser;
    }

    public boolean isSupported() {
        return this.m_bSupported;
    }

    public String getMajorVersion() {
        return this.m_sMajorVer;
    }

    public int getMajorVersionInt() {
        int majVer = 0;
        try {
            majVer = Integer.parseInt(this.m_sMajorVer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return majVer;
    }

    public String getMinorVersion() {
        return this.m_sMinorVer;
    }

    public int getMinorVersionInt() {
        int minVer = 0;
        try {
            minVer = Integer.parseInt(this.m_sMinorVer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minVer;
    }

    public String getIdString() {
        return this.m_sUserAgent;
    }

    public String getName() {
        return this.m_sName;
    }

    public String getOS() {
        return this.m_sOS;
    }

    private void AutoDetectName(String sUserAgent) {
        if (sUserAgent.indexOf("UP.Browser") != -1) {
            this.m_sName = AGENT_UPBROWSER;
        } else if (sUserAgent.indexOf("ProxiNet") != -1) {
            this.m_sName = AGENT_PROXINET;
        } else if (sUserAgent.indexOf("AvantGo") != -1) {
            this.m_sName = AGENT_AVANTGO;
        } else if (sUserAgent.indexOf("Opera") != -1) {
            this.m_sName = AGENT_OPERA;
            int iVerStart = sUserAgent.indexOf("Opera");
            this.ExtractVersion(sUserAgent, iVerStart += 5);
        } else if (sUserAgent.indexOf("(compatible; MSIE") != -1) {
            this.m_sName = AGENT_MSIE;
            int iVerStart = sUserAgent.indexOf("(compatible; MSIE");
            this.ExtractVersion(sUserAgent, iVerStart += 17);
            int iMajor = this.getMajorVersionInt();
            int iMinor = this.getMinorVersionInt();
            if (iMajor >= 6 && iMinor >= 0) {
                this.m_bSupported = true;
            }
        } else if (sUserAgent.indexOf("Microsoft Internet Explorer") != -1) {
            this.m_sName = AGENT_MSIE;
            int iVerStart = sUserAgent.indexOf("Microsoft Internet Explorer");
            this.ExtractVersion(sUserAgent, iVerStart += 27);
        } else if (sUserAgent.indexOf("Mozilla") != -1 && sUserAgent.indexOf("Netscape/") != -1) {
            this.m_sName = AGENT_NSN;
            int iVerStart = sUserAgent.indexOf("Netscape/");
            this.ExtractVersion(sUserAgent, iVerStart += 9);
        } else if (sUserAgent.indexOf("Mozilla") != -1 && sUserAgent.indexOf("Netscape6/") != -1) {
            this.m_sName = AGENT_NSN;
            int iVerStart = sUserAgent.indexOf("Netscape6/");
            this.ExtractVersion(sUserAgent, iVerStart += 10);
        } else if (sUserAgent.indexOf("Mozilla") != -1 && sUserAgent.indexOf("Netscape") != -1) {
            this.m_sName = AGENT_NSN;
            int iVerStart = sUserAgent.indexOf("Mozilla");
            this.ExtractVersion(sUserAgent, iVerStart += 7);
        } else if (sUserAgent.indexOf("Mozilla") != -1 && sUserAgent.indexOf("[") != -1) {
            this.m_sName = AGENT_NSN;
            int iVerStart = sUserAgent.indexOf("Mozilla");
            this.ExtractVersion(sUserAgent, iVerStart += 7);
        } else if (sUserAgent.indexOf("Mozilla") != -1 && sUserAgent.indexOf(OS_NETWARE) != -1) {
            this.m_sName = AGENT_NSN;
            int iVerStart = sUserAgent.indexOf("Mozilla");
            this.ExtractVersion(sUserAgent, iVerStart += 7);
            if (this.m_sMajorVer.equals("1") && this.m_sMinorVer.equals("0")) {
                this.m_sMajorVer = "7";
            }
        } else if (sUserAgent.indexOf("Mozilla") != -1 && sUserAgent.indexOf("rv:") != -1) {
            this.m_sName = AGENT_MOZILLA;
            int iVerStart = sUserAgent.indexOf("rv:");
            this.ExtractVersion(sUserAgent, iVerStart += 3);
            if (this.getMajorVersionInt() >= 1 && this.getMinorVersionInt() >= 7) {
                this.m_bSupported = true;
            }
        } else if (sUserAgent.indexOf("Mozilla") != -1) {
            this.m_sName = AGENT_MOZILLA;
            int iVerStart = sUserAgent.indexOf("Mozilla");
            this.ExtractVersion(sUserAgent, iVerStart += 7);
        } else {
            this.m_sName = AGENT_UNKNOWN;
        }
    }

    private void ExtractVersion(String sUserAgent, int iVerStart) {
        int iVerStop;
        int iLen = sUserAgent.length();
        while (!Character.isDigit(sUserAgent.charAt(iVerStart)) && iVerStart < iLen) {
            ++iVerStart;
        }
        for (iVerStop = iVerStart + 1; sUserAgent.charAt(iVerStop) != '.' && Character.isDigit(sUserAgent.charAt(iVerStop)) && iVerStop < iLen; ++iVerStop) {
        }
        this.m_sMajorVer = sUserAgent.substring(iVerStart, iVerStop);
        iVerStart = iVerStop + 1;
        if (sUserAgent.charAt(iVerStop) == '.' && iVerStart < iLen && Character.isDigit(sUserAgent.charAt(iVerStart))) {
            for (iVerStop = iVerStart + 1; iVerStop < iLen && Character.isDigit(sUserAgent.charAt(iVerStop)); ++iVerStop) {
            }
            this.m_sMinorVer = sUserAgent.substring(iVerStart, iVerStop);
        } else {
            this.m_sMinorVer = "0";
        }
    }

    private void AutoDetectOS(String sUserAgent) {
        this.m_sOS = sUserAgent.indexOf(OS_WIN16) != -1 || sUserAgent.indexOf("Windows 3.1") != -1 || sUserAgent.indexOf("16bit") != -1 || sUserAgent.indexOf("Windows x86") != -1 ? OS_WIN16 : (sUserAgent.indexOf(OS_WIN95) != -1 || sUserAgent.indexOf("Windows 95") != -1 ? OS_WIN95 : (sUserAgent.indexOf(OS_WIN98) != -1 || sUserAgent.indexOf("Windows 98") != -1 ? OS_WIN98 : (sUserAgent.indexOf(OS_WINNT) != -1 || sUserAgent.indexOf("Win32") != -1 || sUserAgent.indexOf("Windows NT") != -1 ? OS_WINNT : (sUserAgent.indexOf("Mac_") != -1 || sUserAgent.indexOf("Macintosh") != -1 ? OS_MAC : (sUserAgent.indexOf("X11") != -1 ? OS_UNIX : (sUserAgent.indexOf(OS_NETWARE) != -1 ? OS_NETWARE : (sUserAgent.indexOf(OS_WEBTV) != -1 ? OS_WEBTV : (sUserAgent.indexOf("OS/2") != -1 ? OS_OS2 : (this.m_sName.equals(AGENT_PROXINET) ? OS_PALM : (this.m_sName.equals(AGENT_AVANTGO) ? OS_PALM : OS_UNKNOWN))))))))));
    }
}

