/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.Browser;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class I18NLocale
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String VARIANT_ISO = "ISO";
    private static final String VARIANT_ANSI = "ANSI";
    private static final String VARIANT_MAC = "MAC";
    private static final String VARIANT_UNIX = "UNIX";
    private static final String VARIANT_WIN = "WIN";
    public static final int CHARSET_ISO = 1;
    public static final int CHARSET_ANSI = 2;
    public static final int CHARSET_MAC = 3;
    public static final int CHARSET_UNIX = 4;
    public static final int LOCALE_LANGUAGE = 1;
    public static final int LOCALE_COUNTRY = 2;
    public static final int LOCALE_VARIANT = 3;
    private static final String[][] m_tblCharset = new String[][]{{"af", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"sq", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"ar", "ISO-8859-6", "Cp1256", "ISO-8859-6", "ISO-8859-6"}, {"bg", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}, {"be", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}, {"ca", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"zh", "Cp950", "Cp950", "Cp950", "Cp950"}, {"zh_CN", "GBK", "GBK", "GBK", "GBK"}, {"zh_SG", "GBK", "GBK", "GBK", "GBK"}, {"zh_TW", "Cp950", "Cp950", "Cp950", "Cp950"}, {"zh_HK", "Cp950", "Cp950", "Cp950", "Cp950"}, {"hr", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"cs", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"da", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"nl", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"en", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"et", "ISO-8859-4", "Cp1257", "ISO-8859-4", "ISO-8859-4"}, {"fi", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"fr", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"de", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"el", "ISO-8859-7", "Cp1253", "ISO-8859-7", "ISO-8859-7"}, {"iw", "ISO-8859-8", "Cp1255", "ISO-8859-8", "ISO-8859-8"}, {"he", "ISO-8859-8", "Cp1255", "ISO-8859-8", "ISO-8859-8"}, {"hu", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"is", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"it", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"ja", "SJIS", "SJIS", "SJIS", "SJIS"}, {"ko", "Cp949", "Cp949", "Cp949", "Cp949"}, {"lv", "ISO-8859-4", "Cp1257", "ISO-8859-4", "ISO-8859-4"}, {"lt", "ISO-8859-4", "Cp1257", "ISO-8859-4", "ISO-8859-4"}, {"mk", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}, {"no", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"pl", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"pt", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"ro", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"ru", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}, {"sr", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"sk", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"sl", "ISO-8859-2", "Cp1250", "ISO-8859-2", "ISO-8859-2"}, {"es", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"sv", "ISO-8859-1", "Cp1252", "ISO-8859-1", "ISO-8859-1"}, {"th", "Cp874", "Cp874", "Cp874", "Cp874"}, {"tr", "ISO-8859-9", "Cp1254", "ISO-8859-9", "ISO-8859-9"}, {"uk", "ISO-8859-5", "Cp1251", "ISO-8859-5", "ISO-8859-5"}};
    private static final int CHARSET_TABLE_ENTRIES = 44;
    private static Hashtable m_hCharsetMappings = new Hashtable();
    private Locale m_locale = null;
    private String m_sCharset = null;

    void update(I18NLocale loc) {
        this.m_locale = loc.getLocale();
        this.m_sCharset = loc.getCharset();
    }

    public I18NLocale(String sLang, String sCountry, String sVariant) {
        if (sCountry != null) {
            sCountry = sCountry.toUpperCase();
        }
        this.m_locale = I18NLocale.fixupLocale(sLang, sCountry, sVariant);
        this.m_sCharset = I18NLocale.getCharsetForLocale(this.m_locale);
        if (this.m_sCharset == null) {
            this.m_sCharset = DEFAULT_CHARSET;
        }
    }

    public I18NLocale(HttpServletRequest req, boolean bIgnoreEN) {
        this.constructI18NLocale(req, bIgnoreEN);
    }

    public I18NLocale(HttpServletRequest req) {
        this.constructI18NLocale(req, true);
    }

    public I18NLocale(Locale loc) {
        this.m_locale = loc;
        this.initFromLocale(loc);
    }

    public I18NLocale() {
        Locale loc = Locale.getDefault();
        this.initFromLocale(loc);
    }

    private void initFromLocale(Locale loc) {
        this.m_locale = I18NLocale.fixupLocale(loc.getLanguage(), loc.getCountry(), loc.getVariant());
        if (this.m_locale != null) {
            this.m_sCharset = I18NLocale.getCharsetForLocale(this.m_locale);
        }
        if (this.m_sCharset == null) {
            this.m_sCharset = DEFAULT_CHARSET;
        }
    }

    private static Locale fixupLocale(String sLang, String sCountry, String sVariant) {
        if (sLang.equals("zh")) {
            sCountry = sCountry != null && (sCountry.equals("CN") || sCountry.equals("SG")) ? "CN" : "TW";
        }
        return new Locale(sLang, sCountry, sVariant);
    }

    public void constructI18NLocale(HttpServletRequest req, boolean bIgnoreEN) {
        String sContentType = req.getContentType();
        int iCharsetPos = -1;
        if (sContentType != null) {
            iCharsetPos = sContentType.indexOf("; charset=");
        }
        if (iCharsetPos != -1) {
            this.m_sCharset = sContentType.substring(iCharsetPos + 10);
            Browser browser = Browser.getInstance(req);
            this.m_locale = I18NLocale.getLocaleFromHttp(req.getHeader("Accept-Language"), browser.getOS(), bIgnoreEN);
        } else {
            Browser browser = Browser.getInstance(req);
            this.m_locale = I18NLocale.getLocaleFromHttp(req.getHeader("Accept-Language"), browser.getOS(), bIgnoreEN);
            this.m_sCharset = I18NLocale.getCharsetForLocale(this.m_locale);
        }
        if (this.m_sCharset == null) {
            this.m_sCharset = DEFAULT_CHARSET;
        }
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getLocaleIdentifier(int iLocaleType) {
        return this.getLocaleIdentifier(iLocaleType, true);
    }

    public String getLocaleIdentifier(int iLocaleType, boolean bStrict) {
        String sLang = null;
        String sCountry = null;
        String sVariant = null;
        switch (iLocaleType) {
            case 3: {
                sVariant = this.m_locale.getVariant();
                if (sVariant != null && sVariant.length() == 0) {
                    sVariant = null;
                }
            }
            case 2: {
                sCountry = this.m_locale.getCountry();
                if (sCountry != null && sCountry.length() == 0) {
                    sCountry = null;
                }
                if (sCountry == null) {
                    sVariant = null;
                }
            }
            case 1: {
                sLang = this.m_locale.getLanguage();
                if (sLang != null && sLang.length() == 0) {
                    sLang = null;
                }
                if (bStrict || sCountry == null || sLang.equals("zh")) break;
                sCountry = null;
                break;
            }
            default: {
                return null;
            }
        }
        if (sLang == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(sLang);
        if (sCountry != null) {
            sb.append("_").append(sCountry);
            if (sVariant != null) {
                sb.append("_").append(sVariant);
            }
        }
        return sb.toString();
    }

    public void setCharset(String sCharset) {
        this.m_sCharset = sCharset;
    }

    public String getCharset() {
        return this.m_sCharset;
    }

    public String getCharset(int iType) {
        return I18NLocale.getCharsetForLocale(this.m_locale, iType);
    }

    public static Locale getLocaleFromHttp(String sAcceptLanguages, String sOS, boolean bIgnoreEN) {
        Locale loc = null;
        String sVariant = null;
        String sCharset = null;
        if (sAcceptLanguages == null) {
            sAcceptLanguages = DEFAULT_LANGUAGE;
        }
        sVariant = I18NLocale.mapVariant(sOS);
        StringTokenizer tokenizer = new StringTokenizer(sAcceptLanguages, ",");
        while (tokenizer.hasMoreTokens()) {
            String sLang = tokenizer.nextToken();
            loc = I18NLocale.getLocaleForLanguage(sLang, sVariant);
            if (bIgnoreEN && loc.getLanguage().equalsIgnoreCase(DEFAULT_LANGUAGE)) {
                loc = null;
                continue;
            }
            sCharset = I18NLocale.getCharsetForLocale(loc);
            if (sCharset != null) break;
            loc = null;
        }
        if (loc == null) {
            loc = new Locale(DEFAULT_LANGUAGE, "", sVariant);
        }
        return loc;
    }

    private static String mapVariant(String sOS) {
        String s = sOS.toUpperCase();
        s = s.startsWith(VARIANT_WIN) ? VARIANT_WIN : (s.startsWith(VARIANT_MAC) ? VARIANT_MAC : (s.startsWith(VARIANT_UNIX) ? VARIANT_UNIX : VARIANT_ISO));
        return s;
    }

    private static Locale getLocaleForLanguage(String sLang, String sVariant) {
        int dash;
        int semi = sLang.indexOf(59);
        if (semi != -1) {
            sLang = sLang.substring(0, semi);
        }
        Locale locale = (dash = (sLang = sLang.trim()).indexOf(45)) == -1 ? I18NLocale.fixupLocale(sLang.toLowerCase(), "", sVariant) : I18NLocale.fixupLocale(sLang.substring(0, dash).toLowerCase(), sLang.substring(dash + 1).toUpperCase(), sVariant);
        return locale;
    }

    private static String getCharsetForLocale(Locale loc) {
        int iCharsetType = loc.getVariant().equals(VARIANT_WIN) ? 2 : (loc.getVariant().equals(VARIANT_MAC) ? 3 : (loc.getVariant().equals(VARIANT_UNIX) ? 4 : 1));
        return I18NLocale.getCharsetForLocale(loc, iCharsetType);
    }

    private static String getCharsetForLocale(Locale loc, int iCharsetType) {
        String sLang = null;
        sLang = loc.getLanguage().equals("zh") ? (!loc.getCountry().equals("") ? loc.getLanguage() + "_" + loc.getCountry() : loc.getLanguage()) : loc.getLanguage();
        String[] tblCharset = (String[])m_hCharsetMappings.get(sLang);
        if (tblCharset != null) {
            switch (iCharsetType) {
                case 2: {
                    return tblCharset[2];
                }
                case 3: {
                    return tblCharset[3];
                }
                case 4: {
                    return tblCharset[4];
                }
            }
            return tblCharset[1];
        }
        return null;
    }

    static {
        for (int i = 0; i < 44; ++i) {
            m_hCharsetMappings.put(m_tblCharset[i][0], m_tblCharset[i]);
        }
    }
}

