/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eDirAccessService;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.authenticator.AuthLoader;
import com.novell.emframe.fw.config.SystemConfigManager;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.nps.utils.Utils;
import com.novell.webaccess.common.Variable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class JSPConduit
extends Utils {
    private Locale m_locale = null;
    private HttpSession m_session = null;

    public static JSPConduit getJSPConduit(HttpServletRequest req) {
        return new JSPConduit(req);
    }

    public JSPConduit(HttpServletRequest req) {
        super(req);
        this.m_session = req.getSession();
        this.m_locale = FwUtils.getCurrentLocale(this.m_session);
    }

    public void stringTable(String strName) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(strName, this.m_locale);
            this.getResourceBundles().add(bundle);
        }
        catch (MissingResourceException e) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(strName + "_en", this.m_locale);
                this.getResourceBundles().add(bundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    public String string(String sName) {
        ArrayList bundles = this.getResourceBundles();
        for (int i = 0; i < bundles.size(); ++i) {
            try {
                ResourceBundle bundle = (ResourceBundle)bundles.get(i);
                String s = bundle.getString(sName);
                if (s == null) continue;
                return s;
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return "";
    }

    ArrayList getResourceBundles() {
        ArrayList bundles = (ArrayList)FwAttr.getFwRequestAttribute("JSPConduit.ResBundles", this.m_req);
        if (bundles == null) {
            bundles = new ArrayList();
            FwAttr.setFwRequestAttribute("JSPConduit.ResBundles", bundles, this.m_req);
        }
        return bundles;
    }

    public String var(String sName) {
        Object oValue = this.get(sName);
        if (oValue == null) {
            return "";
        }
        return oValue.toString();
    }

    public String varToDisplay(String sName) {
        return JSPConduit.toDisplay((String)this.var(sName));
    }

    public String varToTag(String sName) {
        return JSPConduit.toTag((String)this.var(sName));
    }

    public String varToScript(String sName) {
        return JSPConduit.toScript((String)this.var(sName));
    }

    public String stringToDisplay(String sName) {
        return JSPConduit.toDisplay((String)this.string(sName));
    }

    public String stringToTag(String sName) {
        return JSPConduit.toTag((String)this.string(sName));
    }

    public String stringToScript(String sName) {
        return JSPConduit.toScript((String)this.string(sName));
    }

    public Object get(String sName) {
        Object value = null;
        if (value == null) {
            value = ((FwRequest)this.m_req).getAttribute(sName, true, false);
        }
        if (value == null && (value = this.m_req.getParameter(sName)) == null) {
            iMgrAuthenticatorImpl auth = AuthLoader.getPrimaryAuthenticator(this.m_req);
            if (auth != null) {
                value = auth.getAttribute(sName);
            }
            if (value == null && (value = this.m_session.getAttribute(sName)) == null) {
                if (sName.equals("taskId")) {
                    value = this.m_req.getParameter("GI_ID");
                    if (value == null) {
                        value = this.m_req.getParameter("NPService");
                    }
                } else if (sName.startsWith("eDirRights$")) {
                    value = eDirAccessService.getEdasData(this.m_req, sName);
                } else {
                    value = new SystemConfig().getSetting(sName);
                    if (value == null && sName.equals("WebApp.Home.url")) {
                        value = this.m_req.getContextPath();
                    }
                }
            }
        }
        return value;
    }

    public int toInt(String sName) {
        String sInt = this.var(sName);
        if (sInt == null || sInt.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(sInt);
        }
        catch (NumberFormatException e) {
            D.log("toInt:  var '" + sName + "' does not contain an integer value; value = '" + sInt + "'");
            e.printStackTrace();
            throw e;
        }
    }

    public boolean def(String sName) {
        return !this.var(sName).equals("");
    }

    public boolean notdef(String sName) {
        return !this.def(sName);
    }

    public void set(String sName, String sVal) {
        this.m_req.setAttribute(sName, (Object)sVal);
    }

    public void setGlobal(String sName, String sVal) {
        this.m_session.setAttribute(sName, (Object)sVal);
    }

    public void removeGlobal(String sName) {
        this.m_session.removeAttribute(sName);
    }

    private static void dumpMap(Map map, StringBuffer result) {
        Set set = map.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            result.append(key);
            result.append(" = ");
            result.append(map.get(key).toString());
        }
    }

    public String dumpAllx() {
        String key;
        StringBuffer result = new StringBuffer();
        Enumeration keys = this.m_session.getAttributeNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            result.append(key);
            result.append(" = ");
            result.append(this.m_session.getAttribute(key).toString());
        }
        keys = this.m_req.getAttributeNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            result.append(key);
            result.append(" = ");
            result.append(this.m_req.getAttribute(key).toString());
        }
        JSPConduit.dumpMap(this.m_req.getParameterMap(), result);
        JSPConduit.dumpMap(SystemConfigManager.getSystemConfigAsMap(), result);
        return result.toString();
    }

    public String dumpAll() {
        return this.dumpAll(true);
    }

    public String dumpAll(boolean bShowHeaders) {
        SystemConfig config;
        Object[] settingNames;
        StringBuffer sb = new StringBuffer(500);
        Object k = null;
        Object v = null;
        Vector vKeys = null;
        Enumeration en = null;
        Enumeration vEn = null;
        if (bShowHeaders) {
            sb.append("<pre>\n");
        }
        if ((settingNames = (config = SystemConfig.getSystemConfig(FwUtils.getMContext(this.m_req))).getSettingNames()) != null) {
            if (bShowHeaders) {
                sb.append("\n\n======= Configuration Variables =======\n");
            }
            Arrays.sort(settingNames);
            for (int i = 0; i < settingNames.length; ++i) {
                k = settingNames[i];
                v = config.getSetting((String)k);
                sb.append((String)k + "=" + (String)v + "\n");
            }
        }
        en = this.m_session.getAttributeNames();
        if (bShowHeaders) {
            sb.append("\n\n======= Session Attributes =======\n");
        }
        vKeys = this.EnumToSortedVector(en);
        vEn = vKeys.elements();
        while (vEn.hasMoreElements()) {
            k = (String)vEn.nextElement();
            v = this.m_session.getAttribute((String)k);
            if (v instanceof String) {
                sb.append((String)k + "=" + (String)v + "\n");
                continue;
            }
            sb.append((String)k + " == OBJECT of " + v.getClass().getName() + "\n");
        }
        en = this.m_req.getAttributeNames();
        if (bShowHeaders) {
            sb.append("\n\n======= Request Attributes =======\n");
        }
        vKeys = this.EnumToSortedVector(en);
        vEn = vKeys.elements();
        while (vEn.hasMoreElements()) {
            k = (String)vEn.nextElement();
            v = this.m_req.getAttribute((String)k);
            if (v instanceof String) {
                sb.append((String)k + "=" + (String)v + "\n");
                continue;
            }
            sb.append((String)k + " == OBJECT of " + v.getClass().getName() + "\n");
        }
        en = this.m_req.getParameterNames();
        if (bShowHeaders) {
            sb.append("\n\n======= Request Parameters =======\n");
        }
        vKeys = this.EnumToSortedVector(en);
        vEn = vKeys.elements();
        while (vEn.hasMoreElements()) {
            k = (String)vEn.nextElement();
            v = this.m_req.getParameter((String)k);
            if (v instanceof String) {
                sb.append((String)k + "=" + (String)v + "\n");
                continue;
            }
            sb.append((String)k + " == OBJECT of " + v.getClass().getName() + "\n");
        }
        if (bShowHeaders) {
            sb.append("</pre>\n");
        }
        return sb.toString();
    }

    public Vector EnumToSortedVector(Enumeration en) {
        Vector<String> vKeys = new Vector<String>();
        while (en.hasMoreElements()) {
            String k;
            Object o = en.nextElement();
            if (!(o instanceof String) || (k = (String)o).indexOf("password") != -1 || k.indexOf("Password") != -1 || k.indexOf("PASSWORD") != -1 || k.indexOf("PWD") != -1 || k.indexOf("Pwd") != -1 || k.indexOf("pwd") != -1) continue;
            vKeys.addElement(k);
        }
        JSPConduit.sortStringVector(vKeys);
        return vKeys;
    }

    public static void sortStringVector(Vector v) {
        boolean bChanged;
        String str1 = null;
        String str2 = null;
        int iSize = v.size();
        do {
            bChanged = false;
            for (int j = 0; j < iSize - 1; ++j) {
                str1 = (String)v.elementAt(j);
                if (str1.compareTo(str2 = (String)v.elementAt(j + 1)) <= 0) continue;
                v.setElementAt(str2, j);
                v.setElementAt(str1, j + 1);
                bChanged = true;
            }
        } while (bChanged);
    }

    public void inc(String sName) {
        String value = (String)this.m_session.getAttribute(sName);
        if (value != null) {
            try {
                long l = new Long(value);
                this.m_session.setAttribute(sName, (Object)Long.toString(++l));
            }
            catch (Exception e) {
                D.log(e);
            }
            return;
        }
        value = (String)this.m_req.getAttribute(sName);
        if (value != null) {
            try {
                long l = new Long(value);
                this.m_req.setAttribute(sName, (Object)Long.toString(++l));
            }
            catch (Exception e) {
                D.log(e);
            }
            return;
        }
        value = new SystemConfig().getSetting(sName);
        if (value != null) {
            try {
                long l = new Long(value);
                this.m_session.setAttribute(sName, (Object)Long.toString(++l));
            }
            catch (Exception e) {
                D.log(e);
            }
            return;
        }
        D.log("JSPConduit::Error--could not find variable to inc:" + sName);
    }

    public void dec(String sName) {
        String value = (String)this.m_session.getAttribute(sName);
        if (value != null) {
            try {
                long l = new Long(value);
                this.m_session.setAttribute(sName, (Object)Long.toString(--l));
            }
            catch (Exception e) {
                D.log(e);
            }
            return;
        }
        value = (String)this.m_req.getAttribute(sName);
        if (value != null) {
            try {
                long l = new Long(value);
                this.m_req.setAttribute(sName, (Object)Long.toString(--l));
            }
            catch (Exception e) {
                D.log(e);
            }
            return;
        }
        value = new SystemConfig().getSetting(sName);
        if (value != null) {
            try {
                long l = new Long(value);
                this.m_session.setAttribute(sName, (Object)Long.toString(--l));
            }
            catch (Exception e) {
                D.log(e);
            }
            return;
        }
        D.log("JSPConduit::Error--could not find variable to dec:" + sName);
    }

    public String doMath(String s1, char chOp, String s2) {
        Variable v1 = new Variable(s1);
        Variable v2 = new Variable(s2);
        if (!(chOp != '+' || v1.isNumeric() && v2.isNumeric())) {
            return s1 + s2;
        }
        double dResult = Variable.doArithmetic(v1, chOp, v2);
        long lResult = (long)dResult;
        String sResult = null;
        sResult = dResult != (double)lResult ? String.valueOf(dResult) : String.valueOf(lResult);
        return sResult;
    }

    public String plus(String s1, String s2) {
        return this.doMath(s1, '+', s2);
    }

    public String minus(String s1, String s2) {
        return this.doMath(s1, '-', s2);
    }

    public String mult(String s1, String s2) {
        return this.doMath(s1, '*', s2);
    }

    public String div(String s1, String s2) {
        return this.doMath(s1, '/', s2);
    }

    public String mod(String s1, String s2) {
        return this.doMath(s1, '%', s2);
    }

    public boolean lt(String s1, String s2) {
        Variable v1 = new Variable(s1);
        Variable v2 = new Variable(s2);
        return v1.compare(v2) < 0L;
    }

    public boolean gt(String s1, String s2) {
        Variable v1 = new Variable(s1);
        Variable v2 = new Variable(s2);
        return v1.compare(v2) > 0L;
    }

    public boolean lte(String s1, String s2) {
        Variable v1 = new Variable(s1);
        Variable v2 = new Variable(s2);
        return v1.compare(v2) <= 0L;
    }

    public boolean gte(String s1, String s2) {
        Variable v1 = new Variable(s1);
        Variable v2 = new Variable(s2);
        return v1.compare(v2) >= 0L;
    }

    public String listToArray(String strListText, String strDelim, String strArrayName) {
        StringTokenizer parser = new StringTokenizer(strListText, strDelim);
        String strToken = null;
        int i = 0;
        while (parser.hasMoreTokens()) {
            strToken = (String)parser.nextElement();
            this.set(strArrayName + "." + ++i, strToken);
        }
        this.set(strArrayName + ".count", String.valueOf(i));
        return EMPTY_STRING;
    }

    public String listToSortedArray(String strListText, String strDelim, String strArrayName, String strAscend) {
        int i;
        int iSize;
        Vector<String> vStrings = new Vector<String>();
        StringTokenizer parser = new StringTokenizer(strListText, strDelim);
        String strToken = null;
        while (parser.hasMoreTokens()) {
            String strVString;
            strToken = (String)parser.nextElement();
            iSize = vStrings.size();
            for (i = 0; i < iSize && strToken.compareTo(strVString = (String)vStrings.elementAt(i)) > 0; ++i) {
            }
            vStrings.insertElementAt(strToken, i);
        }
        iSize = vStrings.size();
        i = 0;
        while (i < iSize) {
            strToken = (String)vStrings.elementAt(i);
            this.set(strArrayName + "." + ++i, strToken);
        }
        this.set(strArrayName + ".count", String.valueOf(i));
        return EMPTY_STRING;
    }

    public static String substring(String strVal, String sStartPos, String sLength) {
        if (strVal == null) {
            return EMPTY_STRING;
        }
        return JSPConduit.substring(strVal, Integer.parseInt(sStartPos), Integer.parseInt(sLength));
    }

    public static String substring(String strVal, int iStartPos, int iLength) {
        if (strVal == null) {
            return EMPTY_STRING;
        }
        if (iStartPos > strVal.length()) {
            iStartPos = strVal.length();
        }
        if (iLength > strVal.length()) {
            iLength = strVal.length();
        }
        return strVal.substring(iStartPos, iStartPos + iLength);
    }

    public static String toLower(String strVal) {
        if (strVal == null) {
            return EMPTY_STRING;
        }
        return strVal.toLowerCase();
    }

    public static String toUpper(String strVal) {
        if (strVal == null) {
            return EMPTY_STRING;
        }
        return strVal.toUpperCase();
    }

    public static String length(String strVal) {
        if (strVal == null) {
            return EMPTY_STRING;
        }
        return String.valueOf(strVal.length());
    }

    public static String find(String strSearchIn, String strSearchFor) {
        return JSPConduit.find(strSearchIn, strSearchFor, true);
    }

    public static String findLast(String strSearchIn, String strSearchFor) {
        return JSPConduit.find(strSearchIn, strSearchFor, true);
    }

    public static String find(String strSearchIn, String strSearchFor, boolean bFirst) {
        int iPos = -1;
        iPos = bFirst ? strSearchIn.indexOf(strSearchFor) : strSearchIn.lastIndexOf(strSearchFor);
        return String.valueOf(iPos);
    }

    public static String localeDateTimeString(String gmtMS, Locale locale, String timezoneOffset) {
        try {
            new Date(Long.parseLong(gmtMS));
        }
        catch (NumberFormatException e) {
            return EMPTY_STRING;
        }
        String retVal = null;
        try {
            Calendar calendar = Calendar.getInstance(locale);
            calendar.setTimeInMillis(Long.parseLong(gmtMS) + Long.parseLong(timezoneOffset));
            SimpleDateFormat sdFormat = new SimpleDateFormat("MMMMM d, yyyy hh:mm:ss aaa", locale);
            sdFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            retVal = sdFormat.format(calendar.getTime());
        }
        catch (IllegalArgumentException e1) {
            return EMPTY_STRING;
        }
        return retVal;
    }

    public static String date(String strFormat, String strDate, Locale locale) {
        Date dDate = null;
        try {
            dDate = new Date(Long.parseLong(strDate));
        }
        catch (NumberFormatException e) {
            return EMPTY_STRING;
        }
        StringBuffer sb = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat(strFormat, locale);
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            StringBuffer sbTmp = new StringBuffer();
            FieldPosition fp = new FieldPosition(0);
            sb = df.format(dDate, sbTmp, fp);
        }
        catch (IllegalArgumentException e1) {
            return EMPTY_STRING;
        }
        return sb.toString();
    }

    public static String createDate(String strMonth, String strDay, String strYear) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(cal.getTime());
        if (strMonth != null && strMonth.length() > 0) {
            cal.set(2, Integer.parseInt(strMonth) - 1);
        }
        if (strDay != null && strDay.length() > 0) {
            cal.set(5, Integer.parseInt(strDay));
        }
        if (strYear != null && strYear.length() > 0) {
            cal.set(1, Integer.parseInt(strYear));
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long lTime = cal.getTime().getTime();
        return String.valueOf(lTime);
    }

    public static String firstWeekDayOfMonth(String strDate) {
        Date date = new Date(Long.parseLong(strDate));
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(cal.getTime());
        cal.setTime(date);
        cal.set(5, 1);
        return String.valueOf(cal.get(7));
    }

    public static String firstDayOfWeek(String strDate, String sStartDay) {
        Date date = new Date(Long.parseLong(strDate));
        long lStartDay = Long.parseLong(sStartDay);
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(cal.getTime());
        cal.setTime(date);
        int iDayOfWeek = cal.get(7);
        int iDelta = (int)((long)(iDayOfWeek * -1) + lStartDay);
        cal.add(5, iDelta);
        long lTime = cal.getTime().getTime();
        return String.valueOf(lTime);
    }

    public static String daysInMonth(String strDate) {
        Date date = new Date(Long.parseLong(strDate));
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(cal.getTime());
        cal.setTime(date);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return String.valueOf(cal.get(5));
    }

    public static String today() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        long lTime = cal.getTime().getTime();
        return String.valueOf(lTime);
    }

    public static String todayTZ() {
        Calendar cal = Calendar.getInstance();
        long lTime = cal.getTime().getTime();
        return String.valueOf(lTime);
    }

    public static String addToDate(String strDate, String strField, String strAmount) {
        int iAmount = 0;
        try {
            iAmount = Integer.parseInt(strAmount);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Date date = new Date(Long.parseLong(strDate));
        int iFld = strField.equals("DAYS") ? 5 : (strField.equals("WEEKS") ? 3 : (strField.equals("MONTHS") ? 2 : (strField.equals("YEARS") ? 1 : (strField.equals("HOURS") ? 10 : (strField.equals("MINUTES") ? 12 : (strField.equals("SECONDS") ? 13 : 5))))));
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(cal.getTime());
        cal.setTime(date);
        cal.add(iFld, iAmount);
        long lTime = cal.getTime().getTime();
        return String.valueOf(lTime);
    }

    public static String escape(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        return eMFrameUtils.urlEncode(str, "utf-8");
    }

    public static String startsWith(String strOrig, String strFind) {
        if (strOrig.startsWith(strFind)) {
            return "1";
        }
        return "0";
    }

    public static String endsWith(String strOrig, String strFind) {
        if (strOrig.endsWith(strFind)) {
            return "1";
        }
        return "0";
    }

    public static String linkURLs(String strText, String strProtocol, String strFormat, String strLinkOnly, String strLinkSeparator) {
        int iStartIndex;
        boolean bShowLinksOnly = false;
        if (strLinkOnly.equalsIgnoreCase("true")) {
            bShowLinksOnly = true;
        }
        String strUpperMsg = strText.toUpperCase();
        StringBuffer sbFinalMessage = new StringBuffer(strText.length() + 100);
        int iCopyPos = 0;
        int iEndIndex = 0;
        do {
            int iStartHTTP = strUpperMsg.indexOf("HTTP://", iEndIndex);
            int iStartHTTPS = strUpperMsg.indexOf("HTTPS://", iEndIndex);
            int iStartFTP = strUpperMsg.indexOf("FTP://", iEndIndex);
            int iStartWWW = strUpperMsg.indexOf("WWW.", iEndIndex);
            iStartIndex = iStartHTTP;
            if (iStartHTTPS != -1 && iStartIndex > iStartHTTPS || iStartIndex == -1) {
                iStartIndex = iStartHTTPS;
            }
            if (iStartFTP != -1 && iStartIndex > iStartFTP || iStartIndex == -1) {
                iStartIndex = iStartFTP;
            }
            if (iStartWWW != -1 && iStartIndex > iStartWWW || iStartIndex == -1) {
                iStartIndex = iStartWWW;
            }
            if (iStartIndex == -1) continue;
            iEndIndex = iStartIndex;
            int iEndOfString = strText.length() - 1;
            char checkChar = strText.charAt(iEndIndex + 1);
            while (iEndIndex < iEndOfString && !Character.isWhitespace(checkChar) && checkChar != ')' && checkChar != '<' && checkChar != '{' && checkChar != '[') {
                if (checkChar == '&' && iEndIndex + 5 < iEndOfString && strText.charAt(iEndIndex + 2) == 'a' && strText.charAt(iEndIndex + 3) == 'm' && strText.charAt(iEndIndex + 4) == 'p' && strText.charAt(iEndIndex + 5) == ';') {
                    iEndIndex += 4;
                }
                if (++iEndIndex >= iEndOfString) continue;
                checkChar = strText.charAt(iEndIndex + 1);
            }
            while (!Character.isLetterOrDigit(strText.charAt(iEndIndex)) && strText.charAt(iEndIndex) != '/' && iEndIndex > iStartIndex) {
                --iEndIndex;
            }
            String strURL = strText.substring(iStartIndex, iEndIndex + 1);
            String[] strArray = new String[3];
            strArray[1] = strURL;
            if (iStartIndex == iStartWWW) {
                strURL = "http://" + strURL;
            }
            int amper = strURL.indexOf("&amp;");
            while (amper != -1) {
                strURL = strURL.substring(0, amper + 1) + strURL.substring(amper + 5);
                amper = strURL.indexOf("&amp;");
            }
            strArray[0] = strURL;
            String strHref = MessageFormat.format(strFormat, strArray);
            if (!bShowLinksOnly) {
                sbFinalMessage.append(strText.substring(iCopyPos, iStartIndex));
                if (iCopyPos > 0 && strLinkSeparator != null) {
                    sbFinalMessage.append(strLinkSeparator);
                }
            }
            sbFinalMessage.append(strHref);
            iCopyPos = iEndIndex + 1;
        } while (iStartIndex != -1);
        if (!bShowLinksOnly) {
            sbFinalMessage.append(strText.substring(iCopyPos));
        }
        return sbFinalMessage.toString();
    }

    public static String toHTML(String strText) {
        return JSPConduit.stringToHTML(strText, true);
    }

    public static String toHTMLExt(String strText) {
        return eMFrameUtils.stringToHTMLExt(strText);
    }

    public static String toWMLExt(String strText) {
        return JSPConduit.stringToWMLExt(strText);
    }

    public static String trim(String strText) {
        if (strText == null) {
            return EMPTY_STRING;
        }
        return strText.trim();
    }

    public static String toSpellerText(String strText, String hardReturnString) {
        return JSPConduit.stringToSpellerText(strText, hardReturnString);
    }

    static String stringToHTML(String str, boolean bStripLineFeed) {
        if (str == null) {
            return EMPTY_STRING;
        }
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        boolean bPrevWasWhite = false;
        int iLinePos = 0;
        block11: for (int idx = 0; idx < len; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\n': 
                case '\r': {
                    sb.append("<BR>");
                    char nextch = '\u0000';
                    if (idx < len - 1) {
                        nextch = str.charAt(idx + 1);
                    }
                    if (ch == '\n' && nextch == '\r' || ch == '\r' && nextch == '\n') {
                        ++idx;
                        if (!bStripLineFeed) {
                            sb.append(ch);
                            sb.append(nextch);
                        }
                    } else if (!bStripLineFeed) {
                        sb.append(ch);
                    }
                    iLinePos = 0;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '<': {
                    sb.append("&lt;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '>': {
                    sb.append("&gt;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '$': {
                    sb.append("&#36;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '\u001b': {
                    sb.append("&#27;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '&': {
                    sb.append("&amp;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '\t': {
                    sb.append("&nbsp;");
                    ++iLinePos;
                    while (iLinePos % 4 != 0) {
                        sb.append("&nbsp;");
                        ++iLinePos;
                    }
                    bPrevWasWhite = true;
                    continue block11;
                }
                case ' ': {
                    if (bPrevWasWhite) {
                        sb.append("&nbsp;");
                    } else {
                        sb.append(' ');
                    }
                    ++iLinePos;
                    bPrevWasWhite = true;
                    continue block11;
                }
                case '\"': {
                    sb.append("&quot;");
                    ++iLinePos;
                    continue block11;
                }
                default: {
                    sb.append(ch);
                    bPrevWasWhite = false;
                    ++iLinePos;
                }
            }
        }
        return sb.toString();
    }

    static String stringToWMLExt(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        boolean bPrevWasWhite = false;
        int iLinePos = 0;
        block11: for (int idx = 0; idx < len; ++idx) {
            char ch = str.charAt(idx);
            if (ch >= '\u0080') {
                sb.append("&#");
                sb.append(Integer.toString(ch));
                sb.append(';');
                ++iLinePos;
                bPrevWasWhite = false;
                continue;
            }
            switch (ch) {
                case '\n': 
                case '\r': {
                    sb.append("<BR>");
                    char nextch = '\u0000';
                    if (idx < len - 1) {
                        nextch = str.charAt(idx + 1);
                    }
                    if (ch == '\n' && nextch == '\r' || ch == '\r' && nextch == '\n') {
                        ++idx;
                    }
                    iLinePos = 0;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '<': {
                    sb.append("&lt;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '>': {
                    sb.append("&gt;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '$': {
                    sb.append("$$");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '\u001b': {
                    sb.append("&#27;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '&': {
                    sb.append("&amp;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '\t': {
                    sb.append("&nbsp;");
                    ++iLinePos;
                    while (iLinePos % 4 != 0) {
                        sb.append("&nbsp;");
                        ++iLinePos;
                    }
                    bPrevWasWhite = true;
                    continue block11;
                }
                case ' ': {
                    if (bPrevWasWhite) {
                        sb.append("&nbsp;");
                    } else {
                        sb.append(' ');
                    }
                    ++iLinePos;
                    bPrevWasWhite = true;
                    continue block11;
                }
                case '\"': {
                    sb.append("&quot;");
                    ++iLinePos;
                    continue block11;
                }
                default: {
                    sb.append(ch);
                    bPrevWasWhite = false;
                    ++iLinePos;
                }
            }
        }
        return sb.toString();
    }

    public static String toXML(String strText) {
        return XmlUtils.stringToXML(strText);
    }

    static String stringToSpellerText(String str, String hardReturnString) {
        if (str == null) {
            return EMPTY_STRING;
        }
        String hrTagCode = '<' + hardReturnString + '>';
        int hrTagLength = hrTagCode.length();
        StringBuffer sb = new StringBuffer(str);
        int iLinePos = 0;
        block8: for (int idx = 0; idx < sb.length(); ++idx) {
            switch (sb.charAt(idx)) {
                case '\n': 
                case '\r': {
                    sb.insert(idx, hrTagCode);
                    if ((idx += hrTagLength) < sb.length() - 1 && (sb.charAt(idx) == '\n' && sb.charAt(idx + 1) == '\r' || sb.charAt(idx) == '\r' && sb.charAt(idx + 1) == '\n')) {
                        ++idx;
                    }
                    iLinePos = 0;
                    continue block8;
                }
                case '<': {
                    sb.setCharAt(idx++, '&');
                    sb.insert(idx, "lt;");
                    idx += 2;
                    ++iLinePos;
                    continue block8;
                }
                case '>': {
                    sb.setCharAt(idx++, '&');
                    sb.insert(idx, "gt;");
                    idx += 2;
                    ++iLinePos;
                    continue block8;
                }
                case '&': {
                    sb.setCharAt(idx++, '&');
                    sb.insert(idx, "amp;");
                    idx += 3;
                    ++iLinePos;
                    continue block8;
                }
                case '\t': {
                    boolean firstTimeThru = true;
                    while (iLinePos == 0 || iLinePos % 4 != 0) {
                        if (firstTimeThru) {
                            sb.setCharAt(idx, ' ');
                            firstTimeThru = false;
                        } else {
                            sb.insert(++idx, " ");
                        }
                        ++iLinePos;
                    }
                    continue block8;
                }
                case '\"': {
                    sb.setCharAt(idx++, '&');
                    sb.insert(idx, "quot;");
                    idx += 4;
                    ++iLinePos;
                    continue block8;
                }
                default: {
                    ++iLinePos;
                }
            }
        }
        return sb.toString();
    }
}

