/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.security.asn1;

import com.novell.naudit.security.asn1.ASN1InputStream;
import com.novell.naudit.security.asn1.DEREncodable;
import com.novell.naudit.security.asn1.DERObject;
import com.novell.naudit.security.asn1.DEROutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends DERObject {
    private int tag;
    private byte[] octets;

    public DERApplicationSpecific(int n, byte[] byArray) {
        this.tag = n;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this.tag = n | 0x20;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dEREncodable);
        this.octets = byteArrayOutputStream.toByteArray();
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(new ByteArrayInputStream(this.getContents())).readObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(0x40 | this.tag, this.octets);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)object;
        if (this.tag != dERApplicationSpecific.tag) {
            return false;
        }
        if (this.octets.length != dERApplicationSpecific.octets.length) {
            return false;
        }
        int n = 0;
        while (n < this.octets.length) {
            if (this.octets[n] != dERApplicationSpecific.octets[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        byte[] byArray = this.getContents();
        int n = 0;
        int n2 = 0;
        while (n2 != byArray.length) {
            n ^= (byArray[n2] & 0xFF) << n2 % 4;
            ++n2;
        }
        return n ^ this.getApplicationTag();
    }
}

