/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.security.asn1;

import com.novell.naudit.security.asn1.ASN1OctetString;
import com.novell.naudit.security.asn1.ASN1TaggedObject;
import com.novell.naudit.security.asn1.DERObject;
import com.novell.naudit.security.asn1.DEROutputStream;
import com.novell.naudit.security.asn1.DERString;
import java.io.IOException;

public class DERBMPString
extends DERObject
implements DERString {
    String string;

    public static DERBMPString getInstance(Object object) {
        if (object == null || object instanceof DERBMPString) {
            return (DERBMPString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERBMPString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERBMPString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERBMPString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERBMPString(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        int n = 0;
        while (n != cArray.length) {
            cArray[n] = (char)(byArray[2 * n] << 8 | byArray[2 * n + 1] & 0xFF);
            ++n;
        }
        this.string = new String(cArray);
    }

    public DERBMPString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERBMPString)) {
            return false;
        }
        DERBMPString dERBMPString = (DERBMPString)object;
        return this.getString().equals(dERBMPString.getString());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        while (n != cArray.length) {
            byArray[2 * n] = (byte)(cArray[n] >> 8);
            byArray[2 * n + 1] = (byte)cArray[n];
            ++n;
        }
        dEROutputStream.writeEncoded(30, byArray);
    }
}

