/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.security.asn1;

import com.novell.naudit.security.asn1.ASN1OctetString;
import com.novell.naudit.security.asn1.ASN1TaggedObject;
import com.novell.naudit.security.asn1.DERObject;
import com.novell.naudit.security.asn1.DEROutputStream;
import java.io.IOException;

public class DERBoolean
extends DERObject {
    byte value;
    public static final DERBoolean FALSE = new DERBoolean(false);
    public static final DERBoolean TRUE = new DERBoolean(true);

    public static DERBoolean getInstance(Object object) {
        if (object == null || object instanceof DERBoolean) {
            return (DERBoolean)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERBoolean(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERBoolean.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBoolean getInstance(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static DERBoolean getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERBoolean.getInstance(aSN1TaggedObject.getObject());
    }

    public DERBoolean(byte[] byArray) {
        this.value = byArray[0];
    }

    public DERBoolean(boolean bl) {
        this.value = (byte)(bl ? -1 : 0);
    }

    public boolean isTrue() {
        return this.value != 0;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        byte[] byArray = new byte[]{this.value};
        dEROutputStream.writeEncoded(1, byArray);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERBoolean)) {
            return false;
        }
        return this.value == ((DERBoolean)object).value;
    }

    public int hashCode() {
        return this.value;
    }
}

