/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.security.asn1;

import com.novell.naudit.security.asn1.ASN1OctetString;
import com.novell.naudit.security.asn1.ASN1OutputStream;
import com.novell.naudit.security.asn1.ASN1TaggedObject;
import com.novell.naudit.security.asn1.DERObject;
import com.novell.naudit.security.asn1.DEROutputStream;
import com.novell.naudit.security.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERUniversalString
extends DERObject
implements DERString {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] string;

    public static DERUniversalString getInstance(Object object) {
        if (object == null || object instanceof DERUniversalString) {
            return (DERUniversalString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUniversalString(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUniversalString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERUniversalString(byte[] byArray) {
        this.string = byArray;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = 0;
        while (n != byArray.length) {
            stringBuffer.append(table[(byArray[n] >>> 4) % 15]);
            stringBuffer.append(table[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public byte[] getOctets() {
        return this.string;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(28, this.getOctets());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)object).getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

