/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.Authenticator;
import com.novell.webaccess.common.Config;
import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NMultipartParser;
import com.novell.webaccess.common.I18NPropertyBundle;
import com.novell.webaccess.common.I18NServletRequest;
import com.novell.webaccess.common.JSPConduit;
import com.novell.webaccess.common.LockNotHeld;
import com.novell.webaccess.common.Log;
import com.novell.webaccess.common.Provider;
import com.novell.webaccess.common.ProviderLoader;
import com.novell.webaccess.common.RWLock;
import com.novell.webaccess.common.Session;
import com.novell.webaccess.common.SessionManager;
import com.novell.webaccess.common.TemplateInterface;
import com.novell.webaccess.common.TemplateManager;
import com.novell.webaccess.common.UpgradeNotAllowed;
import com.novell.webaccess.common.UserInfo;
import com.novell.webaccess.common.XSLRenderer;
import com.novell.webaccess.common.njFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public class BaseServlet
extends HttpServlet
implements Runnable {
    private static final String AUTHENTICATION_REALM = "Novell WebAccess";
    private static final String VARIANT_ANSI = "ANSI";
    private static final String VARIANT_MAC = "MAC";
    private static final String VARIANT_UNIX = "UNIX";
    private static final String VARIANT_WIN = "WIN";
    private static final long DEFAULT_BKGRND_INTERVAL = 60000L;
    private static final long DEFAULT_UPLOAD_INTERVAL = 60L;
    private static final long DEFAULT_UPLOAD_LIFE = 86400000L;
    private static final String UPLOAD_FILE_EXTENSION = ".mpf";
    private static final String UPLOAD_FILTER = "*.mpf";
    protected static int sm_iServletMajorVersion = 0;
    protected static int sm_iServletMinorVersion = 0;
    protected SessionManager m_sessionManager = null;
    protected ProviderLoader m_providerLoader = null;
    protected XSLRenderer m_xslRenderer = null;
    protected I18NLocale m_locale = new I18NLocale();
    protected Config m_Config = null;
    private String m_sConfigFile = null;
    protected Log m_log = null;
    protected TemplateManager m_mgrTemplate = null;
    protected TemplateInterface m_templateInterface = null;
    protected String m_sTemplateDir = null;
    protected String m_sXslDir = null;
    protected String m_sJspRoot = null;
    protected String m_sServletRoot = null;
    protected boolean m_bRenderHTT = true;
    private String m_sTemplateDefault = "login";
    protected String m_strUploadDir = null;
    protected String m_sDefaultProvider = null;
    protected String m_sDefaultAuthenticator = null;
    private static Hashtable m_classes = new Hashtable();
    protected ServletContext m_servletContext = null;
    private Thread m_bkgrndThread = null;
    private boolean m_bCheckThreadStarted = false;
    private String m_sUpdateCheck = null;
    private RWLock m_cfgLock = new RWLock();
    protected long m_lStartTime = 0L;
    protected String m_TrustedServer = null;
    protected String m_sTrustedServerStartPage = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.m_servletContext = servletConfig.getServletContext();
        this.m_lStartTime = System.currentTimeMillis();
        this.initSettings();
    }

    protected void initSettings() throws ServletException {
        String string;
        try {
            this.m_cfgLock.lockWrite();
        }
        catch (UpgradeNotAllowed upgradeNotAllowed) {
            upgradeNotAllowed.printStackTrace();
            return;
        }
        this.setServletVersion();
        this.loadConfig();
        this.initLog(this.m_Config, null);
        String string2 = this.m_Config.getProperty("Jsdk.showVersion");
        if (string2 != null && string2.equals("true")) {
            System.out.println("JSDK " + sm_iServletMajorVersion + '.' + sm_iServletMinorVersion);
        }
        if ((string2 = (String)((Hashtable)this.m_Config).get("Servlet.Debug.enable")) != null && string2.equals("true")) {
            this.dumpSystem();
        }
        if (this.m_templateInterface == null) {
            this.m_templateInterface = new TemplateInterface("frames", "text/html");
        }
        this.m_templateInterface.load(this.m_Config);
        string2 = (String)((Hashtable)this.m_Config).get("Templates.path");
        if (string2 != null) {
            this.m_sTemplateDir = string2 + "/";
        }
        this.m_sJspRoot = this.m_Config.getProperty("JSP.root");
        if (this.m_sJspRoot == null || this.m_sJspRoot == null) {
            this.m_sJspRoot = "/";
        }
        this.m_bRenderHTT = (string = this.m_Config.getProperty("Render.format")) == null || !string.equalsIgnoreCase("jsp");
        this.m_sServletRoot = this.m_Config.getProperty("Servlet.rootURL");
        if (this.m_sServletRoot == null) {
            // empty if block
        }
        if ((string2 = (String)((Hashtable)this.m_Config).get("Xsl.path")) != null) {
            this.m_sXslDir = string2 + "/";
        }
        if ((string2 = (String)((Hashtable)this.m_Config).get("File.Upload.path")) != null) {
            this.m_strUploadDir = string2;
        }
        this.m_sDefaultProvider = (String)((Hashtable)this.m_Config).get("Provider.default");
        this.m_sDefaultAuthenticator = (String)((Hashtable)this.m_Config).get("Authenticator.default");
        this.m_TrustedServer = (String)((Hashtable)this.m_Config).get("Security.Authenticate.header");
        this.m_sTrustedServerStartPage = (String)((Hashtable)this.m_Config).get("Security.Authenticate.Header.start");
        this.m_sUpdateCheck = (String)((Hashtable)this.m_Config).get("Config.Update.check");
        if (this.m_mgrTemplate == null) {
            this.m_mgrTemplate = new TemplateManager();
            this.m_mgrTemplate.setLog(this.m_log);
        }
        this.m_mgrTemplate.init(this.m_Config);
        if (this.m_sessionManager == null) {
            this.m_sessionManager = new SessionManager();
            this.m_sessionManager.init(this.m_Config);
            this.m_sessionManager.start();
        } else {
            this.m_sessionManager.init(this.m_Config);
        }
        if (this.m_providerLoader == null) {
            this.m_providerLoader = new ProviderLoader();
        }
        this.m_providerLoader.init(this.m_Config, this.m_log, this.m_servletContext, this);
        if (!this.m_bCheckThreadStarted) {
            this.start();
            this.m_bCheckThreadStarted = true;
        }
        try {
            this.m_cfgLock.unlock();
        }
        catch (LockNotHeld lockNotHeld) {
            // empty catch block
        }
    }

    protected void setServletVersion() {
        if (sm_iServletMajorVersion != 0) {
            return;
        }
        Class<?> clazz = null;
        Class[] classArray = new Class[]{};
        try {
            clazz = Class.forName("javax.servlet.http.HttpServletRequest");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return;
        }
        try {
            Method method = clazz.getMethod("getContextPath", classArray);
            sm_iServletMajorVersion = 2;
            sm_iServletMinorVersion = 2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Method method = clazz.getMethod("getSession", classArray);
                sm_iServletMajorVersion = 2;
                sm_iServletMinorVersion = 1;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    Method method = clazz.getMethod("getCookies", classArray);
                    sm_iServletMajorVersion = 2;
                    sm_iServletMinorVersion = 0;
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    sm_iServletMajorVersion = 1;
                    sm_iServletMinorVersion = 0;
                }
            }
        }
    }

    public void start() {
        this.m_bkgrndThread = new Thread(this);
        this.m_bkgrndThread.start();
    }

    public void stop() {
        this.m_bkgrndThread.stop();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        File file = null;
        long l4 = 60L;
        if (this.m_sUpdateCheck != null && this.m_sConfigFile != null) {
            try {
                l3 = Long.parseLong(this.m_sUpdateCheck);
                if (l3 > 0L) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                l3 = 0L;
            }
            njFile njFile2 = new njFile(this.m_sConfigFile);
            file = njFile2.toFile();
            l = file.lastModified();
        }
        while (true) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Exception exception) {
                return;
            }
            if (bl && --l3 <= 0L && (l2 = file.lastModified()) > l) {
                l = l2;
                try {
                    this.initSettings();
                }
                catch (ServletException servletException) {
                    servletException.printStackTrace();
                    continue;
                }
                bl = false;
                try {
                    l3 = Long.parseLong(this.m_sUpdateCheck);
                    if (l3 > 0L) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    l3 = 0L;
                }
            }
            if (this.m_strUploadDir == null || --l4 > 0L) continue;
            l4 = 60L;
            this.cleanUploadPath(86400000L);
        }
    }

    private void cleanUploadPath(long l) {
        block10: {
            if (this.m_strUploadDir != null) {
                String string = null;
                njFile njFile2 = new njFile(this.m_strUploadDir);
                try {
                    string = njFile2.getCanonicalPath();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                String[] stringArray = null;
                try {
                    File file = new File(string);
                    stringArray = file.list();
                    if (stringArray == null) break block10;
                    int n = stringArray.length;
                    long l2 = System.currentTimeMillis();
                    int n2 = 0;
                    while (n2 < n) {
                        if (stringArray[n2].endsWith(UPLOAD_FILE_EXTENSION)) {
                            try {
                                File file2 = new File(string, stringArray[n2]);
                                if (l2 - file2.lastModified() > l) {
                                    file2.delete();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public ProviderLoader getProviderLoader() {
        return this.m_providerLoader;
    }

    public void destroy() {
        this.m_sessionManager.stop();
        this.m_sessionManager.destroy();
        this.m_mgrTemplate.destroy();
        this.destroyLog();
        this.stop();
        super.destroy();
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            I18NMultipartParser i18NMultipartParser = new I18NMultipartParser((HttpServletRequest)servletRequest, this.m_strUploadDir, this.m_log);
            i18NMultipartParser.setSessionManager(this.m_sessionManager);
            super.service((ServletRequest)i18NMultipartParser, servletResponse);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Session session;
        block15: {
            block14: {
                block13: {
                    String string = httpServletRequest.getParameter("action");
                    session = this.getSession(httpServletRequest, httpServletResponse);
                    if (session == null) {
                        return;
                    }
                    String string2 = httpServletRequest.getParameter("User.lang");
                    if (string2 != null && string2.length() > 0) {
                        this.detectUILocale(httpServletRequest, session);
                    }
                    I18NServletRequest i18NServletRequest = (I18NServletRequest)httpServletRequest;
                    i18NServletRequest.setI18NSession(session);
                    session.startInService();
                    try {
                        if (string != null) {
                            if (string.equals("User.Login")) {
                                this.onLogin(httpServletRequest, httpServletResponse, session);
                                Object var15_7 = null;
                                session.stopInService();
                                return;
                            }
                            if (string.equals("User.Logout")) {
                                this.onLogout(httpServletRequest, httpServletResponse, session);
                                break block13;
                            }
                        }
                        Properties properties = new Properties();
                        boolean bl = true;
                        if (!session.getLoggedIn() && this.m_TrustedServer != null) {
                            String string3 = httpServletRequest.getRemoteAddr();
                            String string4 = httpServletRequest.getRemoteHost();
                            if (this.m_TrustedServer.charAt(0) == '*' || this.m_TrustedServer.indexOf(string4) != -1 || this.m_TrustedServer.indexOf(string3) != -1) {
                                bl = false;
                                boolean bl2 = false;
                                String string5 = httpServletRequest.getHeader("Authorization");
                                if (string5 != null) {
                                    if (this.m_sTrustedServerStartPage != null && httpServletRequest.getParameter("merge") == null) {
                                        ((I18NServletRequest)httpServletRequest).setParameter("merge", this.m_sTrustedServerStartPage);
                                    }
                                    ((I18NServletRequest)httpServletRequest).setParameter("renderOnFail", "false");
                                    bl2 = this.doBasicAuthentication(httpServletRequest, httpServletResponse, session, properties, string5);
                                }
                                if (!bl2) {
                                    httpServletResponse.setStatus(401);
                                    httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"NovellWebApplication\"");
                                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                                    servletOutputStream.write(new String("401: Authentication Required").getBytes());
                                    servletOutputStream.flush();
                                    servletOutputStream.close();
                                    break block14;
                                }
                            }
                        }
                        if (bl) {
                            this.callProvider(httpServletRequest, httpServletResponse, session, properties);
                            super.service(httpServletRequest, httpServletResponse);
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var15_11 = null;
                        session.stopInService();
                        throw throwable;
                    }
                }
                Object var15_8 = null;
                session.stopInService();
                return;
            }
            Object var15_9 = null;
            session.stopInService();
            return;
        }
        Object var15_10 = null;
        session.stopInService();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    protected boolean doBasicAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Session session, Properties properties, String string) throws ServletException {
        if (string.toUpperCase().startsWith("BASIC")) {
            String string2 = string.substring(6);
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            String string3 = null;
            StringTokenizer stringTokenizer = null;
            String string4 = null;
            String string5 = null;
            try {
                string3 = new String(bASE64Decoder.decodeBuffer(string2));
                stringTokenizer = new StringTokenizer(string3, ":");
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
            }
            catch (Exception exception) {
                string4 = "";
                string5 = "";
            }
            ((I18NServletRequest)httpServletRequest).setParameter("action", "User.Login");
            ((I18NServletRequest)httpServletRequest).setParameter("User.id", string4);
            ((I18NServletRequest)httpServletRequest).setParameter("User.password", string5);
            httpServletResponse.setHeader("Expires", "Tues, 01 Jan 1980 00:00:00 GMT");
            httpServletResponse.setHeader("Pragma", "no-cache");
            return this.onLogin(httpServletRequest, httpServletResponse, session);
        }
        return false;
    }

    protected boolean callProvider(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Session session, Properties properties) throws ServletException {
        Provider provider = this.loadProvider(httpServletRequest, session);
        if (provider == null) {
            return false;
        }
        boolean bl = false;
        String string = httpServletRequest.getParameter("action");
        try {
            if (provider.preService(httpServletRequest, httpServletResponse, properties) != -1) {
                Object object;
                if (string != null) {
                    object = (UserInfo)session.getValue("USER");
                    bl = provider.service(httpServletRequest, (UserInfo)object, properties);
                    ((Hashtable)properties).put("Provider.name", this.getProviderName(httpServletRequest));
                    if (string.equals("User.Login") && bl) {
                        session.setLoggedIn(true);
                    }
                }
                if ((object = httpServletRequest.getParameter("renderOnFail")) == null || bl || !((String)object).startsWith("f")) {
                    this.render(httpServletRequest, httpServletResponse, session, properties, bl, false, true);
                }
                if (provider != null) {
                    provider.postService(httpServletRequest, properties, bl);
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            throw throwable;
        }
        return bl;
    }

    public final void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.service(httpServletRequest, httpServletResponse);
    }

    public Session getSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        Session session = this.m_sessionManager.getSession(httpServletRequest, "User.context");
        if (session == null) {
            try {
                httpServletResponse.sendRedirect(this.m_sessionManager.getRedirectURL());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (session.isNew()) {
            this.onNewSession(httpServletRequest, httpServletResponse, session);
        }
        if ((session.getFlags() & 0x18) != 0) {
            this.onForceAuthentication(httpServletRequest, httpServletResponse, session);
            session.setFlags(session.getFlags() & 0xFFFFFFE7);
            return null;
        }
        if ((session.getFlags() & 1) != 0) {
            Provider provider;
            Object object;
            String string;
            String string2;
            Object object2;
            Object object3;
            Object object4;
            String string3;
            String string4 = httpServletRequest.getParameter("action");
            if (string4 != null && string4.equals("User.Logout")) {
                int n = 2;
                session.setFlags(session.getFlags() & ~n);
                return session;
            }
            String string5 = httpServletRequest.getHeader("Authorization");
            boolean bl = false;
            if ((session.getFlags() & 2) == 0 && string5 != null && string5.toUpperCase().startsWith("BASIC")) {
                string3 = string5.substring(6);
                object4 = new BASE64Decoder();
                object3 = null;
                object2 = null;
                string2 = null;
                string = null;
                try {
                    object3 = new String(object4.decodeBuffer(string3));
                    object2 = new StringTokenizer((String)object3, ":");
                    string2 = ((StringTokenizer)object2).nextToken();
                    string = ((StringTokenizer)object2).nextToken();
                }
                catch (Exception exception) {
                    string2 = "";
                    string = "";
                }
                if (this.authenticate(session, string2, string)) {
                    this.m_sessionManager.RemoveSessionTimeoutFile(session);
                    int n = 3;
                    bl = true;
                    session.setFlags(session.getFlags() & ~n);
                    session.setLoggedIn(true);
                    object = null;
                    provider = null;
                    Enumeration enumeration = session.getProviderNames();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        provider = session.getProvider((String)object);
                        this.m_providerLoader.initProvider((String)object, provider, session, httpServletRequest, this.m_log);
                    }
                }
            }
            if (!bl) {
                string3 = httpServletRequest.getContentType();
                if (string3 != null && string3.toLowerCase().startsWith("multipart/form-data") && (object4 = httpServletRequest.getParameter("Item.Attachment.name")) != null) {
                    try {
                        object3 = new File(httpServletRequest.getParameter((String)object4));
                        if (((File)object3).exists()) {
                            ((File)object3).delete();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    httpServletResponse.setStatus(401);
                    httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"Novell WebAccess (" + System.currentTimeMillis() + ")\"");
                    httpServletResponse.setContentType("text/html");
                    object4 = (I18NLocale)session.getValue("UILocale");
                    object3 = (I18NLocale)session.getValue("BrowserLocale");
                    object2 = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.BaseServletResources", (I18NLocale)object4);
                    string2 = ((Properties)object2).getProperty("Error.Servlet.html");
                    string = ((Properties)object2).getProperty("Error.Http.401.title");
                    String string6 = ((Properties)object2).getProperty("Error.Http.401.text");
                    object = new String[]{String.valueOf(401), string, string6};
                    string2 = MessageFormat.format(string2, object);
                    provider = httpServletResponse.getOutputStream();
                    ((OutputStream)((Object)provider)).write(string2.getBytes(((I18NLocale)object3).getCharset()));
                    ((OutputStream)((Object)provider)).flush();
                    ((OutputStream)((Object)provider)).close();
                    session.setFlags(session.getFlags() & 0xFFFFFFFD);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
        return session;
    }

    protected boolean authenticate(Session session, String string, String string2) {
        Provider provider = session.getProvider(this.m_providerLoader.getDefaultProviderName());
        if (provider instanceof Authenticator) {
            Authenticator authenticator = (Authenticator)provider;
            return authenticator.authenticate(string, string2);
        }
        return false;
    }

    protected boolean onLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Session session) throws ServletException {
        boolean bl;
        Serializable serializable;
        if (session.getLoggedIn()) {
            session = this.m_sessionManager.createSession(httpServletRequest, null);
            session.setFlags(session.getFlags() & 4);
            this.onNewSession(httpServletRequest, httpServletResponse, session);
            this.onForceAuthentication(httpServletRequest, httpServletResponse, session);
            return false;
        }
        UserInfo userInfo = (UserInfo)session.getValue("USER");
        String string = null;
        string = httpServletRequest.getParameter("User.lang");
        if (string != null && string.length() != 0) {
            this.detectUILocale(httpServletRequest, session);
        }
        if ((string = httpServletRequest.getParameter("User.charset")) == null) {
            string = (String)((Hashtable)this.m_Config).get("Charset.default");
        }
        if (string != null && string.length() != 0) {
            serializable = (I18NLocale)session.getValue("BrowserLocale");
            serializable.setCharset(string);
        }
        if ((string = httpServletRequest.getParameter("User.interface")) != null) {
            this.detectInterface(httpServletRequest, session);
        }
        if (bl = this.callProvider(httpServletRequest, httpServletResponse, session, (Properties)(serializable = new Properties()))) {
            session.setLoggedIn(true);
        }
        return bl;
    }

    protected void onLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Session session) throws ServletException {
        String string;
        Serializable serializable;
        boolean bl = false;
        Properties properties = new Properties();
        UserInfo userInfo = (UserInfo)session.getValue("USER");
        Enumeration enumeration = session.getProviders();
        while (enumeration.hasMoreElements()) {
            serializable = (Provider)enumeration.nextElement();
            bl = serializable.service(httpServletRequest, userInfo, properties);
        }
        serializable = (I18NLocale)session.getValue("UILocale");
        I18NLocale i18NLocale = (I18NLocale)session.getValue("BrowserLocale");
        this.m_sessionManager.invalidate(session);
        String string2 = httpServletRequest.getRemoteAddr();
        String string3 = httpServletRequest.getRemoteHost();
        String string4 = httpServletRequest.getParameter("SSOAware");
        if (string4 == null || string4.equals("1")) {
            string = this.m_Config.getProperty("Security.Logout.Url." + string2);
            if (string == null) {
                string = this.m_Config.getProperty("Security.Logout.Url." + string3);
            }
            if (string != null) {
                try {
                    httpServletResponse.sendRedirect(string);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        string = userInfo.getHtmlDirectory();
        String string5 = (String)((Hashtable)this.m_Config).get("Logout.Url." + string);
        if (string5 == null) {
            string5 = (String)((Hashtable)this.m_Config).get("Logout.url");
        }
        if (string5 != null && string5.length() != 0) {
            try {
                httpServletResponse.sendRedirect(string5);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        session = this.m_sessionManager.createSession(httpServletRequest, null);
        this.onNewSession(httpServletRequest, httpServletResponse, session);
        userInfo.setContext(session.getId());
        session.putValue("UILocale", serializable);
        session.putValue("BrowserLocale", i18NLocale);
        ((Hashtable)properties).put("User.context", session.getId());
        this.render(httpServletRequest, httpServletResponse, session, properties, bl, false, true);
    }

    protected void onForceAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Session session) throws ServletException {
        Properties properties = new Properties();
        I18NLocale i18NLocale = (I18NLocale)session.getValue("UILocale");
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.BaseServletResources", i18NLocale);
        ((Hashtable)properties).put("Error.text", i18NPropertyBundle.getProperty("Error.Login.notCurrent"));
        if ((session.getFlags() & 0x10) != 0 && ((I18NServletRequest)httpServletRequest).getSessionCookie() == null) {
            ((Hashtable)properties).put("Error.name", "Cookie.missing");
        }
        ((Hashtable)properties).put("User.context", session.getId());
        this.render(httpServletRequest, httpServletResponse, session, properties, true, true, true);
        int n = 28;
        session.setFlags(session.getFlags() & ~n);
    }

    protected void loadConfig() throws UnavailableException {
        Object object;
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.BaseServletResources", this.m_locale);
        String string = this.getInitParameter("Config");
        if (string == null) {
            object = this.getServletContext();
            string = object.getInitParameter("Config");
        }
        if (this.m_Config == null) {
            this.m_Config = new Config();
        } else {
            ((Hashtable)this.m_Config).clear();
        }
        if (string != null) {
            object = this.m_servletContext.getRealPath("/");
            if (object != null) {
                if (((String)object).endsWith("/") || ((String)object).endsWith("\\")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                ((Hashtable)this.m_Config).put("WebApp.Home.path", ((String)object).replace('/', File.separatorChar));
            }
            if (object != null) {
                string = this.replaceWith(string, "$(WebApp.Home.path)", (String)object);
            }
            this.m_sConfigFile = string;
            if (!this.m_Config.LoadConfig(string)) {
                Object[] objectArray = new String[]{string};
                String string2 = MessageFormat.format(i18NPropertyBundle.getProperty("Error.Config.unableToLoad"), objectArray);
                System.out.println(string2);
                System.out.println(i18NPropertyBundle.getProperty("Application.shutdown"));
                throw new UnavailableException((Servlet)this, null);
            }
            String string3 = System.getProperty("cfgAddendum");
            if (string3 != null) {
                this.m_Config.LoadConfig(string3);
            }
        } else {
            System.out.println(i18NPropertyBundle.getProperty("Error.Config.notSpecified"));
            System.out.println(i18NPropertyBundle.getProperty("Application.shutdown"));
            throw new UnavailableException((Servlet)this, null);
        }
    }

    private String replaceWith(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string2.length();
        int n3 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n3, n));
            if (string3.length() > 0) {
                stringBuffer.append(string3);
            }
            n3 = n + n2;
            n = string.indexOf(string2, n3);
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    private void setHttpExpiration() {
    }

    private Provider loadAuthenticator(HttpServletRequest httpServletRequest, Session session) {
        String string = this.getAuthenticatorName(httpServletRequest);
        if (string == null) {
            return null;
        }
        return this.m_providerLoader.loadProvider(string, session, httpServletRequest);
    }

    public String getAuthenticatorName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("Authenticator.name");
        if (string == null || string.length() == 0) {
            String string2 = httpServletRequest.getPathInfo();
            if (string2 != null) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
                    stringTokenizer.nextToken();
                    string = stringTokenizer.nextToken();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string == null) {
                string = this.m_sDefaultAuthenticator;
            }
        }
        return string;
    }

    protected Provider loadProvider(HttpServletRequest httpServletRequest, Session session) {
        String string = this.getProviderName(httpServletRequest);
        if (string == null) {
            return null;
        }
        return this.m_providerLoader.loadProvider(string, session, httpServletRequest);
    }

    public String getProviderName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("Provider.name");
        if (string == null || string.length() == 0) {
            String string2 = httpServletRequest.getPathInfo();
            if (string2 != null) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
                    stringTokenizer.nextToken();
                    string = stringTokenizer.nextToken();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string == null || string.length() == 0) {
                string = this.m_sDefaultProvider;
            }
        }
        return string;
    }

    protected void detectInterface(HttpServletRequest httpServletRequest, Session session) {
        UserInfo userInfo = (UserInfo)session.getValue("USER");
        I18NLocale i18NLocale = (I18NLocale)session.getValue("BrowserLocale");
        String string = null;
        String string2 = null;
        String string3 = httpServletRequest.getParameter("User.interface");
        if (string3 == null) {
            string3 = httpServletRequest.getParameter("User.html");
        }
        this.m_cfgLock.lockRead();
        String string4 = null;
        if (string3 == null) {
            string3 = this.m_templateInterface.getInterface(httpServletRequest);
        } else {
            string2 = this.m_templateInterface.getInterface(httpServletRequest);
        }
        string4 = this.m_templateInterface.getInterfaceId(string3);
        if (string4 != null) {
            userInfo.setProperty("User.Interface.index", string4);
            int n = this.m_templateInterface.getCount();
            userInfo.setProperty("User.Interface.count", new Integer(n).toString());
        }
        if (string2 != null) {
            string4 = this.m_templateInterface.getInterfaceId(string2);
            userInfo.setProperty("User.Interface.Device.index", string4);
        }
        userInfo.setHtmlDirectory(string3);
        string = this.m_templateInterface.getContentType(string3);
        userInfo.setContentType(string);
        session.setUseCookie(this.m_templateInterface.useCookie(string3));
        try {
            this.m_cfgLock.unlock();
        }
        catch (LockNotHeld lockNotHeld) {
            // empty catch block
        }
    }

    protected void onNewSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Session session) {
        Serializable serializable;
        String string;
        UserInfo userInfo = (UserInfo)session.getValue("USER");
        String string2 = null;
        Properties properties = null;
        if (userInfo == null) {
            userInfo = new UserInfo(httpServletRequest);
            string = (String)((Hashtable)this.m_Config).get("Security.UseClientCookie.enable");
            if (string != null) {
                userInfo.setProperty("Security.Session.UseClientCookie.enable", string);
            }
            session.putValue("USER", userInfo);
            properties = userInfo.getProperties();
            serializable = this.detectUILocale(httpServletRequest, session);
            I18NLocale i18NLocale = new I18NLocale(httpServletRequest);
            session.putValue("BrowserLocale", i18NLocale);
            string2 = i18NLocale.getLocaleIdentifier(2);
            ((Hashtable)properties).put("Browser.lang", string2);
            string2 = httpServletRequest.getParameter("User.charset");
            if (string2 == null) {
                string2 = (String)((Hashtable)this.m_Config).get("Charset.default");
            }
            if (string2 != null && string2.length() != 0) {
                i18NLocale = (I18NLocale)session.getValue("BrowserLocale");
                i18NLocale.setCharset(string2);
                session.setCharacterEncoding(string2);
            }
            ((Hashtable)properties).put("Browser.charset", i18NLocale.getCharset());
            this.detectInterface(httpServletRequest, session);
            string2 = httpServletRequest.getServletPath();
            if (string2 != null) {
                ((Hashtable)properties).put("Home.url", string2);
            }
            ((Hashtable)properties).put("Request.scheme", httpServletRequest.getScheme());
            this.loadUserRights(properties);
        }
        if (session.useCookie()) {
            string = ((I18NServletRequest)httpServletRequest).getSessionCookie();
            if (string != null && (serializable = this.m_sessionManager.getSessionByCookie(string)) != null && !serializable.getLoggedIn()) {
                serializable.invalidate();
            }
            this.setCookie(session, httpServletRequest, httpServletResponse);
        }
        userInfo.setContext(session.getId());
        session.setNew(false);
    }

    protected void setCookie(Session session, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = session.getSessionCookie();
        String[] stringArray = ((I18NServletRequest)httpServletRequest).getCookieValues();
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string2 != null && this.m_sessionManager.getSessionByCookie(string2) != null) {
                    string = string + "#" + string2;
                }
                ++n2;
            }
        }
        Cookie cookie = new Cookie("NJSCN", string);
        cookie.setMaxAge(-1);
        httpServletResponse.addCookie(cookie);
        if (((I18NServletRequest)httpServletRequest).getSessionCookie() != null) {
            ((I18NServletRequest)httpServletRequest).setSessionCookie(string);
        }
    }

    protected I18NLocale detectUILocale(HttpServletRequest httpServletRequest, Session session) {
        int n;
        String string = null;
        String string2 = null;
        Object var5_5 = null;
        I18NLocale i18NLocale = null;
        string = httpServletRequest.getParameter("User.lang");
        if (string == null) {
            Locale locale;
            string = httpServletRequest.getHeader("Accept-Language") != null ? (!(locale = (i18NLocale = new I18NLocale(httpServletRequest, false)).getLocale()).getCountry().equals("") ? locale.getLanguage() + "_" + locale.getCountry() : locale.getLanguage()) : (String)((Hashtable)this.m_Config).get("Language.default");
            if (string == null) {
                string = "en";
            }
        }
        if ((n = (string = string.toLowerCase()).indexOf(95)) != -1) {
            string2 = string.substring(n + 1).trim().toUpperCase();
            string = string.substring(0, n).trim();
        } else {
            string2 = "";
            string = string.trim();
        }
        i18NLocale = new I18NLocale(string, string2, "");
        if (session != null) {
            UserInfo userInfo = (UserInfo)session.getValue("USER");
            if (string.equals("zh")) {
                string = i18NLocale.getLocaleIdentifier(2, false);
                if (httpServletRequest.getParameter("User.lang") != null) {
                    ((I18NServletRequest)httpServletRequest).setParameter("User.lang", string);
                }
            }
            userInfo.setLanguage(string);
            session.putValue("UILocale", i18NLocale);
        }
        return i18NLocale;
    }

    private void loadUserRights(Properties properties) {
        String string = (String)((Hashtable)this.m_Config).get("User.Access.mail");
        if (string != null && string.equalsIgnoreCase("true")) {
            ((Hashtable)properties).put("User.Access.mail", "true");
        }
        if ((string = (String)((Hashtable)this.m_Config).get("User.Access.calendar")) != null && string.equalsIgnoreCase("true")) {
            ((Hashtable)properties).put("User.Access.calendar", "true");
        }
        if ((string = (String)((Hashtable)this.m_Config).get("User.Access.document")) != null && string.equalsIgnoreCase("true")) {
            ((Hashtable)properties).put("User.Access.document", "true");
        }
        if ((string = (String)((Hashtable)this.m_Config).get("User.Access.speller")) != null && string.equalsIgnoreCase("true")) {
            ((Hashtable)properties).put("User.Access.speller", "true");
        }
        if ((string = (String)((Hashtable)this.m_Config).get("User.Access.security")) != null && string.equalsIgnoreCase("true")) {
            ((Hashtable)properties).put("User.Access.security", "true");
        }
        if ((string = (String)((Hashtable)this.m_Config).get("User.Access.internet")) != null && string.equalsIgnoreCase("true")) {
            ((Hashtable)properties).put("User.Access.internet", "true");
        }
        if ((string = (String)((Hashtable)this.m_Config).get("User.Access.LDAP")) != null && string.equalsIgnoreCase("true")) {
            ((Hashtable)properties).put("User.Access.LDAP", "true");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void render(HttpServletRequest var1_1, HttpServletResponse var2_2, Session var3_3, Properties var4_4, boolean var5_5, boolean var6_6, boolean var7_7) throws ServletException {
        var8_8 = null;
        var9_9 = null;
        var10_10 = false;
        if (!var5_5) {
            var8_8 = var1_1.getParameter("error");
        }
        if (var8_8 == null) {
            var8_8 = var1_1.getParameter("merge");
        }
        if (var1_1.getParameter("merge_xml") != null) {
            var10_10 = true;
        }
        if (var8_8 == null || var6_6) {
            var8_8 = this.m_sTemplateDefault;
        }
        var11_11 = (UserInfo)var3_3.getValue("USER");
        var12_12 = new StringBuffer(128);
        var13_13 = var1_1.getParameter("User.interface");
        if (var13_13 != null) {
            this.detectInterface(var1_1, var3_3);
        }
        var12_12.append(var8_8);
        var8_8 = var12_12.toString();
        if (!this.m_bRenderHTT) {
            try {
                var12_12 = new StringBuffer(128);
                var12_12.append(this.m_sJspRoot).append("/").append(var11_11.getHtmlDirectory()).append("/").append(var8_8).append(".jsp");
                if (this.launchJSP(var1_1, var2_2, var3_3, var4_4, var12_12.toString())) {
                    return;
                }
            }
            catch (ServletException var14_14) {
                var14_14.printStackTrace();
            }
            catch (IOException var15_16) {
                var15_16.printStackTrace();
            }
        }
        var14_15 = (I18NLocale)var3_3.getValue("UILocale");
        var15_17 = (I18NLocale)var3_3.getValue("BrowserLocale");
        if (var4_4 == null) {
            var4_4 = var11_11.getProperties();
        }
        try {
            try {
                var16_18 = var11_11.getContentType();
                var2_2.setContentType(var16_18);
                var9_9 = var2_2.getOutputStream();
                var17_20 = ((I18NServletRequest)var1_1).getXmlInputStream();
                if (var17_20 == null && var10_10 || ((I18NServletRequest)var1_1).isSoap()) {
                    this.m_mgrTemplate.outputXml(var9_9, var15_17, var11_11.getProperties(), var4_4, this.getProviderName(var1_1), var1_1, var2_2);
                } else if (var17_20 != null) {
                    if (var10_10) {
                        var2_2.setContentType("text/xml");
                        while (true) {
                            if ((var18_21 = var17_20.read()) == -1) break;
                            var9_9.write((byte)var18_21);
                        }
                        var21_23 = null;
                        try {
                            var9_9.close();
                            return;
                        }
                        catch (Exception var22_27) {
                            // empty catch block
                        }
                        return;
                    }
                    var18_22 = this.m_sServletRoot;
                    if (this.m_sServletRoot == null) {
                        var18_22 = var1_1.getContextPath();
                    }
                    var12_12 = new StringBuffer(128);
                    var12_12.append(this.m_sXslDir).append(var11_11.getHtmlDirectory()).append("/").append(var8_8).append(".xsl");
                    var19_31 = var12_12.toString().replace('\\', '/');
                    if (this.m_xslRenderer == null) {
                        this.m_xslRenderer = new XSLRenderer();
                    }
                    this.m_xslRenderer.render(var19_31, var17_20, var9_9);
                } else {
                    var12_12 = new StringBuffer(128);
                    var12_12.append(this.m_sTemplateDir).append(var11_11.getHtmlDirectory()).append("/").append(var8_8).append(".htt");
                    var8_8 = var12_12.toString();
                    this.m_mgrTemplate.mergeDoc(var8_8, var9_9, var15_17, var14_15, var11_11.getProperties(), var4_4, (ServletRequest)var1_1, var2_2, var7_7);
                }
                var9_9.flush();
            }
            catch (IOException var16_19) {
                var21_25 = null;
                try {}
                catch (Exception var22_29) {
                    return;
                }
                var9_9.close();
                return;
            }
        }
        catch (Throwable var20_32) {
            var21_26 = null;
            ** try [egrp 3[TRYBLOCK] [4 : 611->619)] { 
lbl91:
            // 1 sources

            var9_9.close();
            throw var20_32;
lbl93:
            // 1 sources

            catch (Exception var22_30) {
                // empty catch block
            }
            throw var20_32;
        }
        var21_24 = null;
        try {}
        catch (Exception var22_28) {}
        var9_9.close();
        return;
    }

    private boolean launchJSP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Session session, Properties properties, String string) throws ServletException, IOException {
        I18NLocale i18NLocale = (I18NLocale)session.getValue("UILocale");
        JSPConduit jSPConduit = new JSPConduit(((I18NServletRequest)httpServletRequest).getWebAppSession(), httpServletRequest, session, properties, this.m_Config, i18NLocale, this.m_log, true);
        if (BaseServlet.isServletVersionAbove(2, 1)) {
            RequestDispatcher requestDispatcher = this.getServletContext().getRequestDispatcher(string);
            httpServletRequest.setAttribute("JSPConduit", (Object)jSPConduit);
            httpServletRequest.setAttribute("isI18NServletRequest", (Object)"true");
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return true;
        }
        return false;
    }

    public static boolean isServletVersionAbove(int n, int n2) {
        if (sm_iServletMajorVersion > n) {
            return true;
        }
        if (sm_iServletMajorVersion < n) {
            return false;
        }
        return sm_iServletMinorVersion > n2;
    }

    protected void setTemplateDefault(String string) {
        if (string != null && string.length() != 0) {
            this.m_sTemplateDefault = string;
        }
    }

    protected void initLog(Properties properties, String string) {
        if (string == null) {
            string = "WAS";
        }
        if (this.m_log == null) {
            this.m_log = new Log(string);
        }
        this.m_log.init(properties);
    }

    private void destroyLog() {
        this.m_log.stop();
        this.m_log = null;
    }

    private void dumpSystem() {
        if (this.m_log != null) {
            Properties properties = System.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.m_log.logMessage(string + "=" + (String)((Hashtable)properties).get(string), "INFO", null);
            }
        }
    }
}

