/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

class SymbolTableEntry {
    static final int SYM_FLAG_VAR = 1;
    static final int SYM_FLAG_CMPLR_VAR = 2;
    static final int SYM_FLAG_STRING_NAME = 4;
    static final int SYM_FLAG_LITERAL = 8;
    static final int SYM_FLAG_CONSTANT = 16;
    static final int SYM_FLAG_ISNUMERIC = 32;
    static final int SYM_FLAG_RUNTIME_VAR = 64;
    protected String m_sName = null;
    protected int m_flags = 0;
    protected String m_sValue = null;
    protected byte m_byRefCount = 0;

    SymbolTableEntry() {
    }

    SymbolTableEntry(String string, int n, String string2) {
        this.m_sName = string;
        this.m_flags = n;
        this.m_sValue = string2;
    }

    void setName(String string) {
        this.m_sName = string;
    }

    String getName() {
        return this.m_sName;
    }

    void setValue(String string) {
        this.m_sValue = string;
    }

    String getValue() {
        return this.m_sValue;
    }

    void setFlags(int n) {
        this.m_flags = n;
    }

    int getFlags() {
        return this.m_flags;
    }

    void addFlags(int n) {
        this.m_flags |= n;
    }

    void clearFlags(int n) {
        this.m_flags ^= n;
    }

    void addReference() {
        if (this.m_byRefCount < 255) {
            this.m_byRefCount = (byte)(this.m_byRefCount + 1);
        }
    }

    void removeReference() {
        if (this.m_byRefCount < 255 && this.m_byRefCount > 0) {
            this.m_byRefCount = (byte)(this.m_byRefCount - 1);
        }
    }

    boolean hasReferences() {
        return this.m_byRefCount > 0;
    }

    int getRefCount() {
        return this.m_byRefCount;
    }
}

