/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NPropertyBundle;
import com.novell.webaccess.common.I18NServletRequest;
import com.novell.webaccess.common.IntStack;
import com.novell.webaccess.common.Log;
import com.novell.webaccess.common.StringTable;
import com.novell.webaccess.common.SymbolTableEntry;
import com.novell.webaccess.common.TemplateAbortException;
import com.novell.webaccess.common.TemplateCompiler;
import com.novell.webaccess.common.TemplateDebugger;
import com.novell.webaccess.common.TemplateManager;
import com.novell.webaccess.common.TemplateSource;
import com.novell.webaccess.common.URLCoder;
import com.novell.webaccess.common.Variable;
import com.novell.webaccess.common.VariableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

class Template {
    private static final String MISSING_TEMPLATE = "MISSING_TEMPLATE";
    private static final String MALFORMED = "MALFORMED";
    private static final String MISSING_STRING_TABLE = "MISSING_STRING_TABLE";
    private static final int SYM_TAB_TEMPLATE_NAME = 4;
    static final int OPCODE_NOP = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_NOP);
    static final int OPCODE_OUT = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_OUT);
    static final int OPCODE_PUSH = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_PUSH);
    static final int OPCODE_ADD = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_ADD);
    static final int OPCODE_SUB = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_SUB);
    static final int OPCODE_MULT = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_MULT);
    static final int OPCODE_DIV = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DIV);
    static final int OPCODE_MOD = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_MOD);
    static final int OPCODE_SET = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_SET);
    static final int OPCODE_SETG = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_SETG);
    static final int OPCODE_PRN = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_PRN);
    static final int OPCODE_CAT = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_CAT);
    static final int OPCODE_LINE = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_LINE);
    static final int OPCODE_INCL = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_INCL);
    static final int OPCODE_OEIN = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_EOIN);
    static final int OPCODE_QUIT = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_QUIT);
    static final int OPCODE_FLSH = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_FLSH);
    static final int OPCODE_DUMP = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DUMP);
    static final int OPCODE_REPL = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_REPL);
    static final int OPCODE_INC = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_INC);
    static final int OPCODE_DEC = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DEC);
    static final int OPCODE_STAB = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_STAB);
    static final int OPCODE_DEF = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DEF);
    static final int OPCODE_JZ = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_JZ);
    static final int OPCODE_JNZ = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_JNZ);
    static final int OPCODE_JMP = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_JMP);
    static final int OPCODE_CMP = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_CMP);
    static final int OPCODE_BAND = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_BAND);
    static final int OPCODE_BOR = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_BOR);
    static final int OPCODE_FNC = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_FNC);
    static final int OPCODE_IDXV = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_IDXV);
    static final int OPCODE_NOT = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_NOT);
    static final int OPCODE_TST = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_TST);
    static final int OPCODE_DREF = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_DREF);
    static final int OPCODE_HDR = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_HDR);
    static final int OPCODE_COOK = TemplateCompiler.fourByteToInt(TemplateCompiler.OP_COOK);
    static final byte[] s_hexTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final String EMPTY_STRING = new String("");
    static final String DEFAULT_LANG_ID = new String("en");
    static final String SY_TAB_DUMMY = "*|Dummy";
    static final String SY_TAB_ASTERISK = "*";
    static final String SY_TAB_ARITH = "*|Arith";
    static final String SY_TAB_CAT = "*|Cat";
    static final String SY_TAB_REPL = "*|Repl";
    static final String SY_TAB_DREF = "*|Dref";
    static final String SY_TAB_FUNC = "*|Func";
    static final String SY_TAB_SSVAR = "*|SSVar";
    static final int INTEGERPOOLSIZE = 1000;
    private static Integer[] sm_IntegerPool = null;
    byte[] m_rawIntBytes = new byte[4];
    byte[] m_rawLongBytes = new byte[4];
    byte[] m_rawDataBytes = new byte[2048];
    int m_ip;
    byte[] m_byteCode = null;
    SymbolTableEntry[] m_rgSymbolTable = null;
    Vector m_vRTSymbolTable = new Vector();
    Hashtable m_hRTSymbolHash = new Hashtable();
    int m_iRTSymbolMaxSize = 0;
    int m_iCleanedUpSymbols = 0;
    OutputStream m_os = null;
    HttpServletResponse m_res = null;
    private boolean m_bQuit = false;
    private int m_iLineNumber = -1;
    private I18NLocale m_BrowserLocale = null;
    private I18NLocale m_UILocale = null;
    private String m_strTemplatePkg = null;
    private boolean m_bCacheTemplate = true;
    IntStack m_stack = null;
    private Properties m_cfgProperties = null;
    private VariableList m_variables = null;
    private StringTable m_stringTable = null;
    private Properties m_properties;
    private Log m_log = null;
    private TemplateManager m_tpltMgr = null;
    private TemplateDebugger m_dbg = null;
    private Vector m_vSrcFiles = null;

    public Template(OutputStream outputStream, I18NLocale i18NLocale, I18NLocale i18NLocale2, boolean bl, String string, Properties properties, Log log) {
        this.m_os = outputStream;
        this.m_log = log;
        this.m_BrowserLocale = i18NLocale;
        this.m_UILocale = i18NLocale2;
        if (i18NLocale == null) {
            this.m_BrowserLocale = new I18NLocale(DEFAULT_LANG_ID, EMPTY_STRING, EMPTY_STRING);
        }
        if (i18NLocale2 == null) {
            this.m_UILocale = new I18NLocale(DEFAULT_LANG_ID, EMPTY_STRING, EMPTY_STRING);
        }
        this.m_strTemplatePkg = string;
        this.m_cfgProperties = properties;
        this.m_bCacheTemplate = bl;
        SymbolTableEntry symbolTableEntry = new SymbolTableEntry(SY_TAB_DUMMY, 64, EMPTY_STRING);
        this.m_vRTSymbolTable.addElement(symbolTableEntry);
        symbolTableEntry.addReference();
        this.m_ip = 0;
    }

    void setRTSymbolMaxCount(int n) {
        this.m_iRTSymbolMaxSize = n;
    }

    public void mergeDoc(String string, Properties properties, Properties properties2, ServletRequest servletRequest, HttpServletResponse httpServletResponse, TemplateManager templateManager, boolean bl, boolean bl2) {
        this.m_tpltMgr = templateManager;
        InputStream inputStream = null;
        this.m_res = httpServletResponse;
        try {
            this.m_variables = new VariableList(properties, properties2, servletRequest, this.m_cfgProperties);
            this.m_stringTable = new StringTable();
            inputStream = ((I18NServletRequest)servletRequest).getTemplateStream();
            if (inputStream != null) {
                this.processTemplate(inputStream, string);
            } else {
                this.processTemplate(string, bl, bl2);
            }
        }
        catch (TemplateAbortException templateAbortException) {
        }
        catch (SocketException socketException) {
        }
        catch (Exception exception) {
            String string2 = null;
            string2 = exception.getMessage() == null ? EMPTY_STRING : exception.getMessage();
            this.templateError("Error.Merge.exception", string2, null, null, null, null, null);
            exception.printStackTrace();
        }
    }

    protected void processTemplate(InputStream inputStream, String string) throws IOException, TemplateAbortException {
        TemplateSource templateSource = null;
        templateSource = TemplateSource.getTemplateSource(inputStream, string, this.m_bCacheTemplate, this.m_os, this.m_UILocale, this.m_log, this.m_tpltMgr, this.m_cfgProperties);
        if (templateSource == null) {
            this.templateError("Error.Merge.Template.missing", "", null, null, null, null, null);
            return;
        }
        this.m_byteCode = templateSource.getByteCode();
        this.m_rgSymbolTable = templateSource.getSymbolTable();
        this.m_stack = new IntStack(templateSource);
        this.execute();
    }

    protected void processTemplate(String string, boolean bl, boolean bl2) throws IOException, TemplateAbortException {
        int n;
        TemplateSource templateSource;
        block8: {
            templateSource = null;
            try {
                templateSource = TemplateSource.getTemplateSource(string, this.m_bCacheTemplate, this.m_os, this.m_UILocale, this.m_log, this.m_tpltMgr, this.m_cfgProperties, bl, bl2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                n = 0;
                if (string.endsWith(".htt")) {
                    String string2 = string.substring(0, string.length() - 4);
                    try {
                        templateSource = TemplateSource.getTemplateSource(string2, this.m_bCacheTemplate, this.m_os, this.m_UILocale, this.m_log, this.m_tpltMgr, this.m_cfgProperties, bl, bl2);
                    }
                    catch (FileNotFoundException fileNotFoundException2) {
                        templateSource = null;
                    }
                }
                if (n == 0) break block8;
                templateSource = null;
            }
        }
        if (templateSource == null) {
            String string3 = new String(string);
            n = string3.lastIndexOf(47);
            if (n < 0) {
                n = string3.lastIndexOf(92);
            }
            if (n > 0) {
                string3 = string3.substring(n + 1);
            }
            this.templateError("Error.Merge.Template.missing", string3, null, null, null, null, null);
            return;
        }
        this.m_byteCode = templateSource.getByteCode();
        this.m_rgSymbolTable = templateSource.getSymbolTable();
        this.m_stack = new IntStack(templateSource);
        this.execute();
    }

    protected int getRTSymbolId(String string) {
        Integer n = (Integer)this.m_hRTSymbolHash.get(string);
        if (n == null) {
            return 0;
        }
        return n * -1;
    }

    protected void addRTSymbolId(int n, String string) {
        int n2 = n * -1;
        if (n2 < 1000) {
            this.m_hRTSymbolHash.put(string, sm_IntegerPool[n2]);
        } else {
            this.m_hRTSymbolHash.put(string, new Integer(n2));
        }
    }

    public void execute() {
        int n;
        do {
            n = this.readInt();
            switch (n) {
                case 2: {
                    this.op_push();
                    break;
                }
                case 1: {
                    this.op_out();
                    break;
                }
                case 10: {
                    this.op_prn();
                    break;
                }
                case 32: {
                    this.op_tst();
                    break;
                }
                case 26: {
                    this.op_cmp();
                    break;
                }
                case 23: {
                    this.op_jz();
                    break;
                }
                case 30: {
                    this.op_idxv();
                    break;
                }
                case 8: {
                    this.op_set();
                    break;
                }
                case 25: {
                    this.op_jmp();
                    break;
                }
                case 31: {
                    this.op_not();
                    break;
                }
                case 29: {
                    this.op_fnc();
                    break;
                }
                case 19: {
                    this.op_inc();
                    break;
                }
                case 27: {
                    this.op_band();
                    break;
                }
                case 28: {
                    this.op_bor();
                    break;
                }
                case 3: {
                    this.op_add();
                    break;
                }
                case 22: {
                    this.op_def();
                    break;
                }
                case 11: {
                    this.op_cat();
                    break;
                }
                case -1: {
                    break;
                }
                case 21: {
                    this.op_stab();
                    break;
                }
                case 20: {
                    this.op_dec();
                    break;
                }
                case 4: {
                    this.op_sub();
                    break;
                }
                case 18: {
                    this.op_repl();
                    break;
                }
                case 9: {
                    this.op_setg();
                    break;
                }
                case 15: {
                    this.op_quit();
                    this.m_bQuit = true;
                    break;
                }
                case 5: {
                    this.op_mult();
                    break;
                }
                case 6: {
                    this.op_div();
                    break;
                }
                case 7: {
                    this.op_mod();
                    break;
                }
                case 33: {
                    this.op_dref();
                    break;
                }
                case 34: {
                    this.op_hdr();
                    break;
                }
                case 35: {
                    this.op_cook();
                    break;
                }
                case 16: {
                    this.op_flsh();
                    break;
                }
                case 24: {
                    this.op_jnz();
                    break;
                }
                case 17: {
                    this.op_dump();
                    break;
                }
                case 12: {
                    this.op_line();
                    break;
                }
                case 13: {
                    this.op_incl();
                    break;
                }
                case 14: {
                    this.op_eoin();
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.op_bad();
                }
            }
            if (this.m_iRTSymbolMaxSize <= 0 || this.m_vRTSymbolTable.size() - this.m_iCleanedUpSymbols < this.m_iRTSymbolMaxSize) continue;
            this.discardUnusedRTSymbols();
        } while (n != -1 && !this.m_bQuit);
    }

    private void discardUnusedRTSymbols() {
        String string;
        Object object;
        int n = 0;
        int n2 = this.m_vRTSymbolTable.size();
        int n3 = 0;
        while (n3 < n2) {
            object = (SymbolTableEntry)this.m_vRTSymbolTable.elementAt(n3);
            if (object != null && !((SymbolTableEntry)object).hasReferences()) {
                string = ((SymbolTableEntry)object).getValue();
                this.m_vRTSymbolTable.setElementAt(null, n3);
                Integer n4 = (Integer)this.m_hRTSymbolHash.get(string);
                if ((n4 == null || n4 != n3 * -1) && (n4 = (Integer)this.m_hRTSymbolHash.get(SY_TAB_ASTERISK + string)) == n3 * -1) {
                    string = SY_TAB_ASTERISK + string;
                }
                this.m_hRTSymbolHash.remove(string);
                ++n;
            }
            ++n3;
        }
        if (this.m_log != null && this.m_log.getLevel() == 3) {
            object = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.TemplateResources", this.m_UILocale);
            string = ((Properties)object).getProperty("Template.Merge.cleanup");
            this.m_log.logMessage(string, "MERGE", null, 3);
        }
        this.m_iCleanedUpSymbols += n;
    }

    SymbolTableEntry getSymbol(int n) {
        if (n < 0) {
            int n2 = ~n + 1;
            SymbolTableEntry symbolTableEntry = (SymbolTableEntry)this.m_vRTSymbolTable.elementAt(n2);
            symbolTableEntry.removeReference();
            return symbolTableEntry;
        }
        return this.m_rgSymbolTable[n];
    }

    Variable popVariable() {
        int n = this.m_stack.pop();
        SymbolTableEntry symbolTableEntry = this.getSymbol(n);
        int n2 = symbolTableEntry.getFlags();
        String string = null;
        Variable variable = null;
        if ((n2 & 0x3A) != 0) {
            string = symbolTableEntry.getValue();
            return new Variable(string);
        }
        if ((n2 & 4) != 0) {
            string = symbolTableEntry.getValue();
            String string2 = this.m_stringTable.getString(string);
            if (string2 == null) {
                string2 = EMPTY_STRING;
            }
            return new Variable(string2);
        }
        if ((n2 & 1) != 0) {
            string = symbolTableEntry.getValue();
            variable = this.m_variables.get(string);
            if (variable == null) {
                variable = new Variable(EMPTY_STRING);
            }
            return variable;
        }
        return new Variable(EMPTY_STRING);
    }

    String popVariableValue() {
        int n = this.m_stack.pop();
        SymbolTableEntry symbolTableEntry = this.getSymbol(n);
        int n2 = symbolTableEntry.getFlags();
        String string = null;
        Variable variable = null;
        if ((n2 & 0x3A) != 0) {
            return symbolTableEntry.getValue();
        }
        if ((n2 & 4) != 0) {
            string = symbolTableEntry.getValue();
            String string2 = this.m_stringTable.getString(string);
            if (string2 == null) {
                string2 = EMPTY_STRING;
            }
            return string2;
        }
        if ((n2 & 1) != 0) {
            string = symbolTableEntry.getValue();
            variable = this.m_variables.get(string);
            if (variable == null) {
                return EMPTY_STRING;
            }
            return variable.getStringValue();
        }
        return EMPTY_STRING;
    }

    String popVariableName() {
        int n = this.m_stack.pop();
        SymbolTableEntry symbolTableEntry = this.getSymbol(n);
        if ((symbolTableEntry.getFlags() & 1) == 0) {
            this.templateError("Error.Merge.invalidVariable", symbolTableEntry.getValue(), null, null, null, null, null);
            return EMPTY_STRING;
        }
        return symbolTableEntry.getValue();
    }

    void arithmetic(char c) {
        Variable variable = this.popVariable();
        Variable variable2 = this.popVariable();
        double d = Variable.doArithmetic(variable2, c, variable);
        long l = (long)d;
        String string = null;
        string = d != (double)l ? String.valueOf(d) : String.valueOf(l);
        int n = this.getRTSymbolId(string);
        SymbolTableEntry symbolTableEntry = null;
        if (n == 0) {
            symbolTableEntry = new SymbolTableEntry(SY_TAB_ARITH, 97, string);
            this.m_vRTSymbolTable.addElement(symbolTableEntry);
            n = this.m_vRTSymbolTable.size() - 1;
            this.addRTSymbolId(n *= -1, string);
        } else {
            symbolTableEntry = (SymbolTableEntry)this.m_vRTSymbolTable.elementAt(n * -1);
        }
        symbolTableEntry.addReference();
        this.m_stack.push(n);
    }

    void op_out() {
        int n = this.readInt();
        while (n > 0) {
            if (n > this.m_rawDataBytes.length) {
                this.readBytes(this.m_rawDataBytes, this.m_rawDataBytes.length);
                this.output(this.m_rawDataBytes, this.m_rawDataBytes.length);
                n -= this.m_rawDataBytes.length;
                continue;
            }
            this.readBytes(this.m_rawDataBytes, n);
            this.output(this.m_rawDataBytes, n);
            n -= n;
        }
    }

    void op_push() {
        int n = this.readInt();
        this.m_stack.push(n);
    }

    void op_add() {
        this.arithmetic('+');
    }

    void op_sub() {
        this.arithmetic('-');
    }

    void op_mult() {
        this.arithmetic('*');
    }

    void op_div() {
        this.arithmetic('/');
    }

    void op_mod() {
        this.arithmetic('%');
    }

    void setVar(boolean bl) {
        String string = this.popVariableName();
        int n = this.m_stack.pop();
        SymbolTableEntry symbolTableEntry = this.getSymbol(n);
        int n2 = symbolTableEntry.getFlags();
        String string2 = null;
        if ((n2 & 0x38) != 0) {
            string2 = symbolTableEntry.getValue();
            if (bl) {
                this.m_variables.putGlobal(string, new Variable(string2));
            } else {
                this.m_variables.put(string, new Variable(string2));
            }
        } else if ((n2 & 4) != 0) {
            string2 = symbolTableEntry.getValue();
            String string3 = this.m_stringTable.getString(string2);
            if (string3 == null) {
                string3 = EMPTY_STRING;
            }
            if (bl) {
                this.m_variables.putGlobal(string, new Variable(string3));
            } else {
                this.m_variables.put(string, new Variable(string3));
            }
        } else if ((n2 & 1) != 0) {
            string2 = symbolTableEntry.getValue();
            Variable variable = this.m_variables.get(string2);
            if (variable == null) {
                variable = new Variable(EMPTY_STRING);
            }
            if (bl) {
                this.m_variables.putGlobal(string, new Variable(variable.getStringValue()));
            } else {
                this.m_variables.put(string, new Variable(variable.getStringValue()));
            }
        }
    }

    void op_set() {
        this.setVar(false);
    }

    void op_setg() {
        this.setVar(true);
    }

    void op_prn() {
        Variable variable;
        int n = this.m_stack.pop();
        SymbolTableEntry symbolTableEntry = this.getSymbol(n);
        int n2 = symbolTableEntry.getFlags();
        String string = null;
        if ((n2 & 0x38) != 0) {
            string = symbolTableEntry.getValue();
            this.output(string);
        } else if ((n2 & 4) != 0) {
            string = symbolTableEntry.getValue();
            String string2 = this.m_stringTable.getString(string);
            if (string2 != null) {
                this.output(string2);
            }
        } else if ((n2 & 1) != 0 && (variable = this.m_variables.get(string = symbolTableEntry.getValue())) != null) {
            this.output(variable.getStringValue());
        }
    }

    void op_cat() {
        Object object;
        Object object2 = null;
        StringBuffer stringBuffer = null;
        int n = this.m_stack.pop();
        SymbolTableEntry symbolTableEntry = this.getSymbol(n);
        int n2 = symbolTableEntry.getFlags();
        if ((n2 & 1) != 0) {
            object = null;
            object = this.m_variables.get(symbolTableEntry.getValue());
            object2 = object == null ? EMPTY_STRING : ((Variable)object).getStringValue();
        } else if ((n2 & 4) != 0) {
            object = null;
            object = this.m_stringTable.getString(symbolTableEntry.getValue());
            object2 = object == null ? EMPTY_STRING : object;
        } else if ((n2 & 8) != 0) {
            object2 = new String(symbolTableEntry.getValue());
        }
        n = this.m_stack.pop();
        symbolTableEntry = this.getSymbol(n);
        n2 = symbolTableEntry.getFlags();
        if ((n2 & 1) != 0) {
            object = null;
            object = this.m_variables.get(symbolTableEntry.getValue());
            stringBuffer = object != null ? new StringBuffer(((Variable)object).getStringValue()) : new StringBuffer();
        } else if ((n2 & 4) != 0) {
            object = null;
            object = this.m_stringTable.getString(symbolTableEntry.getValue());
            stringBuffer = object != null ? new StringBuffer((String)object) : new StringBuffer();
        } else if ((n2 & 8) != 0) {
            stringBuffer = new StringBuffer(symbolTableEntry.getValue());
        }
        stringBuffer.append((String)object2);
        object = stringBuffer.toString();
        int n3 = this.getRTSymbolId((String)object);
        SymbolTableEntry symbolTableEntry2 = null;
        if (n3 == 0) {
            symbolTableEntry2 = new SymbolTableEntry(SY_TAB_CAT, 72, stringBuffer.toString());
            this.m_vRTSymbolTable.addElement(symbolTableEntry2);
            n3 = this.m_vRTSymbolTable.size() - 1;
            this.addRTSymbolId(n3 *= -1, (String)object);
        } else {
            symbolTableEntry2 = (SymbolTableEntry)this.m_vRTSymbolTable.elementAt(n3 * -1);
        }
        symbolTableEntry2.addReference();
        this.m_stack.push(n3);
    }

    void op_quit() {
    }

    void op_flsh() {
    }

    void op_repl() {
        int n = this.readInt();
        Object[] objectArray = new String[n];
        Object var3_3 = null;
        int n2 = n - 1;
        while (n2 >= 0) {
            objectArray[n2] = this.popVariableValue();
            --n2;
        }
        String string = this.popVariableValue();
        StringBuffer stringBuffer = this.replaceSubstrings(string, "'", "''");
        String string2 = MessageFormat.format(stringBuffer.toString(), objectArray);
        int n3 = this.getRTSymbolId(string2);
        SymbolTableEntry symbolTableEntry = null;
        if (n3 == 0) {
            symbolTableEntry = new SymbolTableEntry(SY_TAB_REPL, 72, string2);
            this.m_vRTSymbolTable.addElement(symbolTableEntry);
            n3 = this.m_vRTSymbolTable.size() - 1;
            this.addRTSymbolId(n3 *= -1, string2);
        } else {
            symbolTableEntry = (SymbolTableEntry)this.m_vRTSymbolTable.elementAt(n3 * -1);
        }
        symbolTableEntry.addReference();
        this.m_stack.push(n3);
    }

    void op_inc() {
        String string = this.popVariableName();
        Variable variable = this.m_variables.get(string);
        if (variable == null) {
            this.templateError("Error.Merge.INC.noVar", string, "INC", null, null, null, null);
            return;
        }
        long l = variable.getLongValue();
        variable.setStringValue(Long.toString(++l));
        this.m_variables.put(string, variable);
    }

    void op_dec() {
        String string = this.popVariableName();
        Variable variable = this.m_variables.get(string);
        if (variable == null) {
            this.templateError("Error.Merge.DEC.noVar", string, "INC", null, null, null, null);
            return;
        }
        long l = variable.getLongValue();
        variable.setStringValue(Long.toString(--l));
        this.m_variables.put(string, variable);
    }

    void op_stab() {
        int n = this.m_stack.pop();
        SymbolTableEntry symbolTableEntry = this.getSymbol(n);
        if ((symbolTableEntry.getFlags() & 8) == 0) {
            this.templateError("Error.Merge.invalidVariable", symbolTableEntry.getValue(), null, null, null, null, null);
        }
        String string = symbolTableEntry.getValue();
        boolean bl = false;
        try {
            try {
                Locale locale = this.m_UILocale.getLocale();
                String string2 = locale.getCountry();
                String string3 = locale.getVariant();
                if (string2.length() == 0) {
                    string2 = null;
                }
                if (string3.length() == 0) {
                    string3 = null;
                }
                bl = this.m_stringTable.addStringTable(string, locale.getLanguage(), string2, string3, this.m_strTemplatePkg, this.m_UILocale.getCharset(2), this.m_bCacheTemplate);
            }
            catch (MissingResourceException missingResourceException) {
                Object var9_10 = null;
                if (!bl) {
                    this.templateError("Error.Merge.StringTable.missing", string, null, null, null, null, null);
                }
            }
            Object var9_9 = null;
            if (!bl) {
                this.templateError("Error.Merge.StringTable.missing", string, null, null, null, null, null);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!bl) {
                this.templateError("Error.Merge.StringTable.missing", string, null, null, null, null, null);
            }
            throw throwable;
        }
    }

    void op_def() {
        String string = this.popVariableName();
        if (this.m_variables.get(string) == null) {
            this.m_stack.push(0);
        } else {
            this.m_stack.push(1);
        }
    }

    void op_jz() {
        int n = this.readInt();
        int n2 = this.m_stack.pop();
        if (n2 == 0) {
            this.m_ip = n;
        }
    }

    void op_jnz() {
        int n = this.readInt();
        int n2 = this.m_stack.pop();
        if (n2 != 0) {
            this.m_ip = n;
        }
    }

    void op_jmp() {
        int n;
        this.m_ip = n = this.readInt();
    }

    void op_cmp() {
        Variable variable = this.popVariable();
        Variable variable2 = this.popVariable();
        int n = 0;
        long l = variable.compare(variable2);
        n = l == 0L ? 1 : (l > 0L ? 3 : 2);
        this.m_stack.push(n);
    }

    void op_tst() {
        int n;
        int n2 = this.readInt();
        if (n2 == (n = this.m_stack.pop())) {
            this.m_stack.push(1);
        } else {
            this.m_stack.push(0);
        }
    }

    void op_hdr() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        if (this.m_res != null) {
            if (string2.equalsIgnoreCase("Location")) {
                try {
                    this.m_res.sendRedirect(string);
                }
                catch (IOException iOException) {}
            } else {
                this.m_res.setHeader(string2, string);
            }
        }
    }

    void op_cook() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        String string3 = this.popVariableValue();
        String string4 = this.popVariableValue();
        String string5 = this.popVariableValue();
        String string6 = this.popVariableValue();
        int n = -1;
        boolean bl = false;
        if (string2.length() > 0) {
            n = Integer.parseInt(string2);
        }
        if (string.length() > 0) {
            if (string.equalsIgnoreCase("true")) {
                bl = true;
            } else if (string.equalsIgnoreCase("yes")) {
                bl = true;
            } else if (string.equalsIgnoreCase("1")) {
                bl = true;
            }
        }
        Cookie cookie = new Cookie(string6, string5);
        cookie.setMaxAge(n);
        cookie.setSecure(bl);
        if (string3.length() > 0) {
            cookie.setPath(string3);
        }
        if (string4.length() > 0) {
            cookie.setDomain(string4);
        }
        if (this.m_res != null) {
            this.m_res.addCookie(cookie);
        }
    }

    void op_dref() {
        int n = this.readInt();
        String string = this.popVariableValue();
        String string2 = null;
        if (n == 1) {
            string2 = this.m_stringTable.getString(string);
            if (string2 == null) {
                string2 = EMPTY_STRING;
            }
        } else {
            Variable variable = this.m_variables.get(string);
            string2 = variable == null ? EMPTY_STRING : variable.getStringValue();
        }
        int n2 = this.getRTSymbolId(string2);
        SymbolTableEntry symbolTableEntry = null;
        if (n2 == 0) {
            symbolTableEntry = new SymbolTableEntry(SY_TAB_DREF, 72, string2);
            this.m_vRTSymbolTable.addElement(symbolTableEntry);
            n2 = this.m_vRTSymbolTable.size() - 1;
            this.addRTSymbolId(n2 *= -1, string2);
        } else {
            symbolTableEntry = (SymbolTableEntry)this.m_vRTSymbolTable.elementAt(n2 * -1);
        }
        symbolTableEntry.addReference();
        this.m_stack.push(n2);
    }

    void op_band() {
        int n = this.m_stack.pop();
        int n2 = this.m_stack.pop();
        if (n != 0 && n2 != 0) {
            this.m_stack.push(1);
        } else {
            this.m_stack.push(0);
        }
    }

    void op_bor() {
        int n = this.m_stack.pop();
        int n2 = this.m_stack.pop();
        if (n == 1 || n2 == 1) {
            this.m_stack.push(1);
        } else {
            this.m_stack.push(0);
        }
    }

    void op_fnc() {
        int n = this.readInt();
        String string = null;
        switch (n) {
            case 0: {
                string = this.getSubstring();
                break;
            }
            case 1: {
                string = this.toLower();
                break;
            }
            case 2: {
                string = this.toUpper();
                break;
            }
            case 3: {
                string = this.length();
                break;
            }
            case 4: {
                string = this.find(false);
                break;
            }
            case 5: {
                string = this.find(true);
                break;
            }
            case 6: {
                string = this.date();
                break;
            }
            case 7: {
                string = this.createDate();
                break;
            }
            case 8: {
                string = this.firstWeekDayOfMonth();
                break;
            }
            case 9: {
                string = this.firstDayOfWeek();
                break;
            }
            case 10: {
                string = this.daysInMonth();
                break;
            }
            case 11: {
                string = this.today();
                break;
            }
            case 12: {
                string = this.todayTZ();
                break;
            }
            case 13: {
                string = this.addToDate();
                break;
            }
            case 14: {
                string = this.escape();
                break;
            }
            case 15: {
                string = this.replaceWith();
                break;
            }
            case 16: {
                string = this.linkURLs();
                break;
            }
            case 17: {
                string = this.linkEncodedURLs();
                break;
            }
            case 18: {
                string = this.toHTML();
                break;
            }
            case 19: {
                string = this.toScript();
                break;
            }
            case 20: {
                string = this.urlEncode();
                break;
            }
            case 21: {
                string = this.urlEncodePath();
                break;
            }
            case 22: {
                string = this.listToArray();
                break;
            }
            case 23: {
                string = this.trim();
                break;
            }
            case 24: {
                string = this.startsWith();
                break;
            }
            case 25: {
                string = this.endsWith();
                break;
            }
            case 26: {
                string = this.toSpellerText();
                break;
            }
            case 27: {
                string = this.getHeader();
                break;
            }
            case 28: {
                string = this.toHTMLExt();
                break;
            }
            case 29: {
                string = this.listToSortedArray();
                break;
            }
            case 30: {
                string = this.toDisplay();
                break;
            }
            case 31: {
                string = this.toXML();
                break;
            }
            case 32: {
                string = this.toXML();
                break;
            }
            case 33: {
                string = this.xmlDecode();
                break;
            }
            case 34: {
                string = this.formatMessage();
                break;
            }
            case 35: {
                string = this.toXML();
                break;
            }
            case 36: {
                string = this.toWMLExt();
                break;
            }
            case 37: {
                string = this.toQuote();
                break;
            }
            default: {
                string = EMPTY_STRING;
            }
        }
        int n2 = this.getRTSymbolId(string);
        SymbolTableEntry symbolTableEntry = null;
        if (n2 == 0) {
            symbolTableEntry = new SymbolTableEntry(SY_TAB_FUNC, 72, string);
            this.m_vRTSymbolTable.addElement(symbolTableEntry);
            n2 = this.m_vRTSymbolTable.size() - 1;
            this.addRTSymbolId(n2 *= -1, string);
        } else {
            symbolTableEntry = (SymbolTableEntry)this.m_vRTSymbolTable.elementAt(n2 * -1);
        }
        symbolTableEntry.addReference();
        this.m_stack.push(n2);
    }

    void op_idxv() {
        Object object;
        int n = this.readInt();
        SymbolTableEntry symbolTableEntry = this.getSymbol(n);
        int n2 = symbolTableEntry.getFlags();
        String string = symbolTableEntry.getValue();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = this.m_stack.pop();
        int n4 = 0;
        while (n4 < n3) {
            object = this.popVariable();
            String string2 = this.popVariableValue();
            int n5 = (int)((Variable)object).getLongValue();
            stringBuffer.insert(n5, '.');
            stringBuffer.insert(n5 + 1, string2);
            ++n4;
        }
        object = stringBuffer.toString();
        SymbolTableEntry symbolTableEntry2 = null;
        int n6 = (n2 & 4) != 0 ? this.getRTSymbolId(SY_TAB_ASTERISK + (String)object) : this.getRTSymbolId((String)object);
        if (n6 == 0) {
            symbolTableEntry2 = new SymbolTableEntry(SY_TAB_SSVAR, 64, stringBuffer.toString());
            if ((n2 & 4) != 0) {
                symbolTableEntry2.addFlags(4);
            } else {
                symbolTableEntry2.addFlags(1);
            }
            this.m_vRTSymbolTable.addElement(symbolTableEntry2);
            n6 = this.m_vRTSymbolTable.size() - 1;
            n6 *= -1;
            if ((n2 & 4) != 0) {
                this.addRTSymbolId(n6, SY_TAB_ASTERISK + (String)object);
            } else {
                this.addRTSymbolId(n6, (String)object);
            }
        } else {
            symbolTableEntry2 = (SymbolTableEntry)this.m_vRTSymbolTable.elementAt(n6 * -1);
        }
        symbolTableEntry2.addReference();
        this.m_stack.push(n6);
    }

    void op_not() {
        int n = this.m_stack.pop();
        int n2 = 0;
        if (n == 0) {
            n2 = 1;
        }
        this.m_stack.push(n2);
    }

    void op_dump() {
        this.doDumpAll();
    }

    void op_line() {
        int n = this.readInt();
        int n2 = this.readInt();
        String string = EMPTY_STRING;
        this.m_iLineNumber = n;
        byte[] byArray = new byte[]{60, 33, 45, 45};
        byte[] byArray2 = new byte[]{45, 45, 62};
        while (n2 > 0) {
            if (n2 > this.m_rawDataBytes.length) {
                this.readBytes(this.m_rawDataBytes, this.m_rawDataBytes.length);
                string = string + new String(this.m_rawDataBytes, 0, this.m_rawDataBytes.length);
                n2 -= this.m_rawDataBytes.length;
                continue;
            }
            this.readBytes(this.m_rawDataBytes, n2);
            string = string + new String(this.m_rawDataBytes, 0, n2);
            n2 -= n2;
        }
        try {
            if (this.m_dbg == null) {
                SymbolTableEntry symbolTableEntry = this.getSymbol(4);
                String string2 = symbolTableEntry.getValue();
                this.m_dbg = new TemplateDebugger(this, string2, this.m_os, this.m_rgSymbolTable, this.m_variables, this.m_stringTable);
            }
            this.m_dbg.debug(n, string);
        }
        catch (TemplateAbortException templateAbortException) {
            this.m_bQuit = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void op_incl() {
        int n = this.readInt();
        this.readBytes(this.m_rawDataBytes, n);
        String string = new String(this.m_rawDataBytes, 0, n);
        try {
            String string2 = null;
            if (this.m_vSrcFiles == null) {
                this.m_vSrcFiles = new Vector();
            }
            string2 = this.m_dbg.getTemplateName();
            this.m_vSrcFiles.addElement(string2);
            this.m_dbg.setTemplateName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void op_eoin() {
        String string = null;
        try {
            int n = this.m_vSrcFiles.size();
            string = (String)this.m_vSrcFiles.elementAt(--n);
            this.m_vSrcFiles.setSize(n);
            this.m_dbg.setTemplateName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void op_bad() {
    }

    String getSubstring() {
        String string;
        int n = (int)this.popVariable().getLongValue();
        int n2 = (int)this.popVariable().getLongValue();
        if (n2 > (string = this.popVariableValue()).length()) {
            n2 = string.length();
        }
        if (n > string.length()) {
            n = string.length();
        }
        return string.substring(n2, n2 + n);
    }

    String toLower() {
        String string = this.popVariableValue();
        return string.toLowerCase();
    }

    String toUpper() {
        String string = this.popVariableValue();
        return string.toUpperCase();
    }

    String length() {
        String string = this.popVariableValue();
        return String.valueOf(string.length());
    }

    String find(boolean bl) {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        int n = -1;
        n = bl ? string2.indexOf(string) : string2.lastIndexOf(string);
        return String.valueOf(n);
    }

    String formatMessage() {
        String string = this.popVariableValue();
        int n = Integer.parseInt(string);
        Object[] objectArray = new String[--n];
        while (n > 0) {
            objectArray[--n] = this.popVariableValue();
        }
        String string2 = this.popVariableValue();
        StringBuffer stringBuffer = this.replaceSubstrings(string2, "'", "''");
        String string3 = MessageFormat.format(stringBuffer.toString(), objectArray);
        return string3;
    }

    String date() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        Date date = null;
        try {
            date = new Date(Long.parseLong(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, this.m_UILocale.getLocale());
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            StringBuffer stringBuffer2 = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            stringBuffer = simpleDateFormat.format(date, stringBuffer2, fieldPosition);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.templateError("Error.Merge.badStatement", string, null, null, null, null, null);
            return EMPTY_STRING;
        }
        return stringBuffer.toString();
    }

    String createDate() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        String string3 = this.popVariableValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        if (string3 != null && string3.length() > 0) {
            calendar.set(2, Integer.parseInt(string3) - 1);
        }
        if (string2 != null && string2.length() > 0) {
            calendar.set(5, Integer.parseInt(string2));
        }
        if (string != null && string.length() > 0) {
            calendar.set(1, Integer.parseInt(string));
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        return String.valueOf(l);
    }

    String firstWeekDayOfMonth() {
        String string = this.popVariableValue();
        Date date = new Date(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        calendar.setTime(date);
        calendar.set(5, 1);
        return String.valueOf(calendar.get(7));
    }

    String firstDayOfWeek() {
        long l = this.popVariable().getLongValue();
        String string = this.popVariableValue();
        Date date = new Date(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        calendar.setTime(date);
        int n = calendar.get(7);
        int n2 = (int)((long)(n * -1) + l);
        calendar.add(5, n2);
        long l2 = calendar.getTime().getTime();
        return String.valueOf(l2);
    }

    String daysInMonth() {
        String string = this.popVariableValue();
        Date date = new Date(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        return String.valueOf(calendar.get(5));
    }

    String today() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        long l = calendar.getTime().getTime();
        return String.valueOf(l);
    }

    String todayTZ() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTime().getTime();
        return String.valueOf(l);
    }

    String addToDate() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        String string3 = this.popVariableValue();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Date date = new Date(Long.parseLong(string3));
        int n2 = string2.equals("DAYS") ? 5 : (string2.equals("WEEKS") ? 3 : (string2.equals("MONTHS") ? 2 : (string2.equals("YEARS") ? 1 : (string2.equals("HOURS") ? 10 : (string2.equals("MINUTES") ? 12 : (string2.equals("SECONDS") ? 13 : 5))))));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        calendar.setTime(date);
        calendar.add(n2, n);
        long l = calendar.getTime().getTime();
        return String.valueOf(l);
    }

    String escape() {
        String string = this.popVariableValue();
        return URLCoder.encode(string);
    }

    String replaceWith() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        String string3 = this.popVariableValue();
        StringBuffer stringBuffer = this.replaceSubstrings(string3, string2, string);
        return stringBuffer.toString();
    }

    private StringBuffer replaceSubstrings(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        int n = string2.length();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        while (n3 != -1) {
            stringBuffer.append(string.substring(n2, n3));
            if (string3.length() > 0) {
                stringBuffer.append(string3);
            }
            n2 = n3 + n;
            n3 = string.indexOf(string2, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer;
    }

    String startsWith() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        if (string2.startsWith(string)) {
            return "1";
        }
        return "0";
    }

    String endsWith() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        if (string2.endsWith(string)) {
            return "1";
        }
        return "0";
    }

    String linkURLs() {
        return this.linkURLs(false);
    }

    String linkEncodedURLs() {
        return this.linkURLs(true);
    }

    String linkURLs(boolean bl) {
        int n;
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        String string3 = this.popVariableValue();
        String string4 = this.popVariableValue();
        String string5 = this.popVariableValue();
        boolean bl2 = false;
        if (string2.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        String string6 = string5.toUpperCase();
        Object var9_9 = null;
        StringBuffer stringBuffer = new StringBuffer(string5.length() + 100);
        int n2 = 0;
        int n3 = 0;
        do {
            int n4 = string6.indexOf("HTTP://", n3);
            int n5 = string6.indexOf("HTTPS://", n3);
            int n6 = string6.indexOf("FTP://", n3);
            int n7 = string6.indexOf("WWW.", n3);
            n = n4;
            if (n5 != -1 && n > n5 || n == -1) {
                n = n5;
            }
            if (n6 != -1 && n > n6 || n == -1) {
                n = n6;
            }
            if (n7 != -1 && n > n7 || n == -1) {
                n = n7;
            }
            if (n == -1) continue;
            n3 = n;
            int n8 = string5.length() - 1;
            boolean bl3 = false;
            char c = string5.charAt(n3 + 1);
            while (n3 < n8 && !Character.isWhitespace(c) && c != ')' && c != '<' && c != '{' && c != '[') {
                if (c == '&' && n3 + 5 < n8 && string5.charAt(n3 + 2) == 'a' && string5.charAt(n3 + 3) == 'm' && string5.charAt(n3 + 4) == 'p' && string5.charAt(n3 + 5) == ';') {
                    n3 += 4;
                    bl3 = true;
                }
                if (++n3 >= n8) continue;
                c = string5.charAt(n3 + 1);
            }
            while (!Character.isLetterOrDigit(string5.charAt(n3)) && string5.charAt(n3) != '/' && n3 > n) {
                --n3;
            }
            String string7 = string5.substring(n, n3 + 1);
            Object[] objectArray = new String[3];
            objectArray[1] = string7;
            if (n == n7) {
                string7 = "http://" + string7;
            }
            int n9 = string7.indexOf("&amp;");
            while (n9 != -1) {
                string7 = string7.substring(0, n9 + 1) + string7.substring(n9 + 5);
                n9 = string7.indexOf("&amp;");
            }
            if (bl) {
                string7 = this.urlEncodeString(string7);
            }
            objectArray[0] = string7;
            String string8 = MessageFormat.format(string3, objectArray);
            if (!bl2) {
                stringBuffer.append(string5.substring(n2, n));
                if (n2 > 0 && string != null) {
                    stringBuffer.append(string);
                }
            }
            stringBuffer.append(string8);
            n2 = n3 + 1;
        } while (n != -1);
        if (!bl2) {
            stringBuffer.append(string5.substring(n2));
        }
        return stringBuffer.toString();
    }

    String toHTML() {
        String string = this.popVariableValue();
        return this.stringToHTML(string, true);
    }

    String toHTMLExt() {
        String string = this.popVariableValue();
        return this.stringToHTMLExt(string);
    }

    String toWMLExt() {
        String string = this.popVariableValue();
        return this.stringToWMLExt(string);
    }

    String toDisplay() {
        String string = this.popVariableValue();
        return this.stringToHTMLExt(string);
    }

    String toXML() {
        String string = this.popVariableValue();
        return this.stringToXML(string);
    }

    String xmlDecode() {
        String string = this.popVariableValue();
        return this.stringFromXML(string);
    }

    String toQuote() {
        String string = this.popVariableValue();
        return this.stringToQuoted(string);
    }

    String toScript() {
        StringBuffer stringBuffer = new StringBuffer(this.popVariableValue());
        try {
            int n = stringBuffer.length();
            int n2 = 0;
            do {
                char c = stringBuffer.charAt(n2);
                switch (c) {
                    case '\n': {
                        stringBuffer.insert(n2++, '\\');
                        stringBuffer.setCharAt(n2, 'n');
                        ++n;
                        break;
                    }
                    case '\r': {
                        stringBuffer.insert(n2++, '\\');
                        stringBuffer.setCharAt(n2, 'r');
                        ++n;
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        stringBuffer.insert(n2, '\\');
                        ++n2;
                        ++n;
                    }
                }
            } while (++n2 < n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    String toSpellerText() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        return this.stringToSpellerText(string2, string);
    }

    String getHeader() {
        String string = this.popVariableValue();
        String string2 = this.m_variables.getHeader(string);
        if (string2 == null) {
            string2 = EMPTY_STRING;
        }
        return string2;
    }

    String urlEncode() {
        String string = this.popVariableValue();
        return this.urlEncodeString(string);
    }

    String urlEncodeString(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes(this.m_BrowserLocale.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byArray = string.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                byArray = string.getBytes();
            }
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 3];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (by >= 48 && by <= 57 || by >= 65 && by <= 90 || by >= 97 && by <= 122) {
                byArray2[n3++] = by;
            } else if (by == 32) {
                byArray2[n3++] = 43;
            } else {
                byArray2[n3++] = 37;
                int n4 = by >> 4 & 0xF;
                byArray2[n3++] = s_hexTable[n4];
                n4 = by & 0xF;
                byArray2[n3++] = s_hexTable[n4];
            }
            ++n2;
        }
        try {
            return new String(byArray2, 0, n3, this.m_BrowserLocale.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return new String(byArray2, 0, n3, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException3) {
                return new String(byArray2, 0, n3);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new String(byArray2, 0, n3);
        }
    }

    String urlEncodePath() {
        byte[] byArray;
        String string = this.popVariableValue();
        try {
            byArray = string.getBytes(this.m_BrowserLocale.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byArray = string.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                byArray = string.getBytes();
            }
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 3];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (by >= 48 && by <= 57 || by >= 65 && by <= 90 || by >= 97 && by <= 122 || by == 47 || by == 46 || by == 95 || by == 45) {
                byArray2[n3++] = by;
            } else if (by == 32) {
                byArray2[n3++] = 43;
            } else {
                byArray2[n3++] = 37;
                int n4 = by >> 4 & 0xF;
                byArray2[n3++] = s_hexTable[n4];
                n4 = by & 0xF;
                byArray2[n3++] = s_hexTable[n4];
            }
            ++n2;
        }
        try {
            return new String(byArray2, 0, n3, this.m_BrowserLocale.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return new String(byArray2, 0, n3, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException3) {
                return new String(byArray2, 0, n3);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new String(byArray2, 0, n3);
        }
    }

    String listToArray() {
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        String string3 = this.popVariableValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        String string4 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = (String)stringTokenizer.nextElement();
            this.m_variables.put(string + "." + ++n, new Variable(string4));
        }
        this.m_variables.put(string + ".count", new Variable(String.valueOf(n)));
        return EMPTY_STRING;
    }

    String listToSortedArray() {
        int n;
        int n2;
        String string = this.popVariableValue();
        String string2 = this.popVariableValue();
        String string3 = this.popVariableValue();
        String string4 = this.popVariableValue();
        boolean bl = string.equals("1");
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, string3);
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string5 = (String)stringTokenizer.nextElement();
            n2 = vector.size();
            n = 0;
            while (n < n2) {
                String string6 = (String)vector.elementAt(n);
                if (string5.compareTo(string6) <= 0) break;
                ++n;
            }
            vector.insertElementAt(string5, n);
        }
        n2 = vector.size();
        n = 0;
        while (n < n2) {
            string5 = (String)vector.elementAt(n);
            this.m_variables.put(string2 + "." + ++n, new Variable(string5));
        }
        this.m_variables.put(string2 + ".count", new Variable(String.valueOf(n)));
        return EMPTY_STRING;
    }

    String trim() {
        String string = this.popVariableValue();
        return string.trim();
    }

    private String stringToHTML(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            switch (stringBuffer.charAt(n2)) {
                case '\n': 
                case '\r': {
                    if (bl) {
                        if (n2 < stringBuffer.length() - 1 && (stringBuffer.charAt(n2) == '\n' && stringBuffer.charAt(n2 + 1) == '\r' || stringBuffer.charAt(n2) == '\r' && stringBuffer.charAt(n2 + 1) == '\n')) {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.setCharAt(n2++, 'B');
                            stringBuffer.insert(n2, "R>");
                            ++n2;
                        } else {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.insert(n2, "BR>");
                            n2 += 2;
                        }
                    } else {
                        stringBuffer.insert(n2, "<BR>");
                        if ((n2 += 4) < stringBuffer.length() - 1 && (stringBuffer.charAt(n2) == '\n' && stringBuffer.charAt(n2 + 1) == '\r' || stringBuffer.charAt(n2) == '\r' && stringBuffer.charAt(n2 + 1) == '\n')) {
                            ++n2;
                        }
                    }
                    n = 0;
                    bl2 = false;
                    break;
                }
                case '<': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "lt;");
                    n2 += 2;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '>': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "gt;");
                    n2 += 2;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '$': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#36;");
                    n2 += 3;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '\u001b': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#27;");
                    n2 += 3;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '&': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "amp;");
                    n2 += 3;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '\t': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "nbsp;");
                    n2 += 5;
                    ++n;
                    while (n == 0 || n % 4 != 0) {
                        stringBuffer.insert(n2, "&nbsp;");
                        n2 += 6;
                        ++n;
                    }
                    --n2;
                    bl2 = true;
                    break;
                }
                case ' ': {
                    if (bl2) {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "nbsp;");
                        n2 += 4;
                    }
                    ++n;
                    bl2 = true;
                    break;
                }
                case '\"': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "quot;");
                    n2 += 4;
                    ++n;
                    break;
                }
                default: {
                    bl2 = false;
                    ++n;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String stringToXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            switch (stringBuffer.charAt(n2)) {
                case '<': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#60;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '>': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#62;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '&': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#38;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '\'': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#39;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '\"': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#34;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '\u001b': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#27;");
                    n2 += 3;
                    ++n;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String stringFromXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(10);
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(string);
        int n2 = string.length();
        StringBuffer stringBuffer3 = new StringBuffer(n2);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n2) {
            char c;
            if ((c = stringBuffer2.charAt(n3++)) == '#') {
                n5 = 0;
                c = stringBuffer2.charAt(n3++);
                while (c != ';' && n5 < n) {
                    stringBuffer.append(c);
                    ++n5;
                    c = stringBuffer2.charAt(n3++);
                }
                c = (char)Integer.parseInt(stringBuffer.toString());
                stringBuffer.setLength(0);
            }
            stringBuffer3.insert(n4++, c);
        }
        return stringBuffer2.toString();
    }

    private String stringToHTMLExt(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        char c = '\u0000';
        while (n2 < stringBuffer.length()) {
            c = stringBuffer.charAt(n2);
            if (c >= '\u0080') {
                String string2 = Integer.toString(stringBuffer.charAt(n2));
                int n3 = string2.length();
                stringBuffer.setCharAt(n2++, '&');
                stringBuffer.insert(n2, "#" + string2 + ";");
                n2 += n3 + 1;
                ++n;
                bl = false;
            } else {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if (n2 < stringBuffer.length() - 1 && (stringBuffer.charAt(n2) == '\n' && stringBuffer.charAt(n2 + 1) == '\r' || stringBuffer.charAt(n2) == '\r' && stringBuffer.charAt(n2 + 1) == '\n')) {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.setCharAt(n2++, 'B');
                            stringBuffer.insert(n2, "R>");
                            ++n2;
                        } else {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.insert(n2, "BR>");
                            n2 += 2;
                        }
                        n = 0;
                        bl = false;
                        break;
                    }
                    case '<': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "lt;");
                        n2 += 2;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '>': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "gt;");
                        n2 += 2;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '$': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "#36;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '\u001b': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "#27;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '&': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "amp;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '\t': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "nbsp;");
                        n2 += 5;
                        ++n;
                        while (n == 0 || n % 4 != 0) {
                            stringBuffer.insert(n2, "&nbsp;");
                            n2 += 6;
                            ++n;
                        }
                        --n2;
                        bl = true;
                        break;
                    }
                    case ' ': {
                        if (bl) {
                            stringBuffer.setCharAt(n2++, '&');
                            stringBuffer.insert(n2, "nbsp;");
                            n2 += 4;
                        }
                        ++n;
                        bl = true;
                        break;
                    }
                    case '\"': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "quot;");
                        n2 += 4;
                        ++n;
                        break;
                    }
                    default: {
                        bl = false;
                        ++n;
                    }
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String stringToWMLExt(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        char c = '\u0000';
        while (n2 < stringBuffer.length()) {
            c = stringBuffer.charAt(n2);
            if (c >= '\u0080') {
                String string2 = Integer.toString(stringBuffer.charAt(n2));
                int n3 = string2.length();
                stringBuffer.setCharAt(n2++, '&');
                stringBuffer.insert(n2, "#" + string2 + ";");
                n2 += n3 + 1;
                ++n;
                bl = false;
            } else {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if (n2 < stringBuffer.length() - 1 && (stringBuffer.charAt(n2) == '\n' && stringBuffer.charAt(n2 + 1) == '\r' || stringBuffer.charAt(n2) == '\r' && stringBuffer.charAt(n2 + 1) == '\n')) {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.setCharAt(n2++, 'B');
                            stringBuffer.insert(n2, "R>");
                            ++n2;
                        } else {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.insert(n2, "BR>");
                            n2 += 2;
                        }
                        n = 0;
                        bl = false;
                        break;
                    }
                    case '<': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "lt;");
                        n2 += 2;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '>': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "gt;");
                        n2 += 2;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '$': {
                        stringBuffer.insert(++n2, '$');
                        ++n;
                        bl = false;
                        break;
                    }
                    case '\u001b': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "#27;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '&': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "amp;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '\t': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "nbsp;");
                        n2 += 5;
                        ++n;
                        while (n == 0 || n % 4 != 0) {
                            stringBuffer.insert(n2, "&nbsp;");
                            n2 += 6;
                            ++n;
                        }
                        --n2;
                        bl = true;
                        break;
                    }
                    case ' ': {
                        if (bl) {
                            stringBuffer.setCharAt(n2++, '&');
                            stringBuffer.insert(n2, "nbsp;");
                            n2 += 4;
                        }
                        ++n;
                        bl = true;
                        break;
                    }
                    case '\"': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "quot;");
                        n2 += 4;
                        ++n;
                        break;
                    }
                    default: {
                        bl = false;
                        ++n;
                    }
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String stringToQuoted(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            switch (stringBuffer.charAt(n2)) {
                case '\'': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#39;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '\"': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#34;");
                    n2 += 3;
                    ++n;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String stringToSpellerText(String string, String string2) {
        String string3 = '<' + string2 + '>';
        int n = string3.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            switch (stringBuffer.charAt(n3)) {
                case '\n': 
                case '\r': {
                    stringBuffer.insert(n3, string3);
                    if ((n3 += n) < stringBuffer.length() - 1 && (stringBuffer.charAt(n3) == '\n' && stringBuffer.charAt(n3 + 1) == '\r' || stringBuffer.charAt(n3) == '\r' && stringBuffer.charAt(n3 + 1) == '\n')) {
                        ++n3;
                    }
                    n2 = 0;
                    break;
                }
                case '<': {
                    stringBuffer.setCharAt(n3++, '&');
                    stringBuffer.insert(n3, "lt;");
                    n3 += 2;
                    ++n2;
                    break;
                }
                case '>': {
                    stringBuffer.setCharAt(n3++, '&');
                    stringBuffer.insert(n3, "gt;");
                    n3 += 2;
                    ++n2;
                    break;
                }
                case '&': {
                    stringBuffer.setCharAt(n3++, '&');
                    stringBuffer.insert(n3, "amp;");
                    n3 += 3;
                    ++n2;
                    break;
                }
                case '\t': {
                    boolean bl = true;
                    while (n2 == 0 || n2 % 4 != 0) {
                        if (bl) {
                            stringBuffer.setCharAt(n3, ' ');
                            bl = false;
                        } else {
                            stringBuffer.insert(++n3, " ");
                        }
                        ++n2;
                    }
                    break;
                }
                case '\"': {
                    stringBuffer.setCharAt(n3++, '&');
                    stringBuffer.insert(n3, "quot;");
                    n3 += 4;
                    ++n2;
                    break;
                }
                default: {
                    ++n2;
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    String doDumpAll() {
        boolean bl = true;
        try {
            if (bl) {
                this.output("<TABLE border=1 bgcolor=#ffffff><TR><TD><FONT face='courier' size=2>\n");
            }
            if (bl) {
                this.output(this.stringToHTML(this.m_variables.toString(), false));
            } else {
                this.output(this.m_variables.toString());
            }
            if (bl) {
                this.output(this.stringToHTML(this.m_stringTable.toString(), false));
            } else {
                this.output(this.m_stringTable.toString());
            }
            if (bl) {
                this.output("</FONT></TD></TR></TABLE>\n");
            }
        }
        catch (ClassCastException classCastException) {
            if (this.m_log != null) {
                I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.TemplateResources", this.m_UILocale);
                String string = i18NPropertyBundle.getProperty("Template.Merge.nonString");
                this.m_log.logMessage(string, "MERGE", null, 1);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return null;
    }

    int readBytes(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.m_byteCode[this.m_ip++];
            ++n2;
        }
        return n;
    }

    int readInt() {
        if (this.m_byteCode.length > this.m_ip + 3) {
            System.arraycopy(this.m_byteCode, this.m_ip, this.m_rawIntBytes, 0, 4);
            this.m_ip += 4;
        } else {
            return -1;
        }
        return TemplateCompiler.fourByteToInt(this.m_rawIntBytes);
    }

    int readLong() {
        if (this.m_byteCode.length <= this.m_ip + 7) {
            return -1;
        }
        this.m_rawLongBytes[0] = this.m_byteCode[this.m_ip++];
        this.m_rawLongBytes[1] = this.m_byteCode[this.m_ip++];
        this.m_rawLongBytes[2] = this.m_byteCode[this.m_ip++];
        this.m_rawLongBytes[3] = this.m_byteCode[this.m_ip++];
        this.m_rawLongBytes[4] = this.m_byteCode[this.m_ip++];
        this.m_rawLongBytes[5] = this.m_byteCode[this.m_ip++];
        this.m_rawLongBytes[6] = this.m_byteCode[this.m_ip++];
        this.m_rawLongBytes[7] = this.m_byteCode[this.m_ip++];
        return TemplateCompiler.eightByteToLong(this.m_rawLongBytes);
    }

    void output(byte[] byArray, int n) {
        this.output(this.m_os, byArray, n);
    }

    void output(OutputStream outputStream, byte[] byArray, int n) {
        try {
            outputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            this.m_bQuit = true;
        }
    }

    void output(String string) {
        try {
            byte[] byArray = string.getBytes(this.m_BrowserLocale.getCharset());
            this.output(this.m_os, byArray, byArray.length);
        }
        catch (IOException iOException) {
            this.m_bQuit = true;
        }
    }

    private void templateError(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7};
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.TemplateResources", this.m_UILocale);
        String string8 = i18NPropertyBundle.getProperty(string);
        string8 = MessageFormat.format(string8, objectArray);
        this.templateError(string8);
    }

    private void templateError(String string) {
        if (this.m_iLineNumber != -1) {
            string = EMPTY_STRING + this.m_iLineNumber + ": " + string;
        }
        try {
            this.m_os.write(string.getBytes(this.m_BrowserLocale.getCharset()));
            if (this.m_log != null) {
                this.m_log.logMessage(string, "MERGE", null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        sm_IntegerPool = new Integer[1000];
        int n = 0;
        while (n < 1000) {
            Template.sm_IntegerPool[n] = new Integer(n);
            ++n;
        }
    }
}

