/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.StringTable;
import com.novell.webaccess.common.SymbolTableEntry;
import com.novell.webaccess.common.Template;
import com.novell.webaccess.common.TemplateAbortException;
import com.novell.webaccess.common.Variable;
import com.novell.webaccess.common.VariableList;
import java.io.File;
import java.io.OutputStream;
import java.util.Hashtable;

class TemplateDebugger {
    Hashtable m_hBreakPoints = new Hashtable();
    boolean m_bNextBreak = true;
    String m_sTemplatePath = null;
    String m_sTemplate = null;
    OutputStream m_os = null;
    SymbolTableEntry[] m_rgSymbolTable = null;
    Hashtable m_hSymbolHash = new Hashtable();
    Template m_template = null;
    StringTable m_stringTable = null;
    VariableList m_variables = null;
    int m_iLastLineBreak = -1;
    StringBuffer m_sbListing = new StringBuffer();

    TemplateDebugger(Template template, String string, OutputStream outputStream, SymbolTableEntry[] symbolTableEntryArray, VariableList variableList, StringTable stringTable) {
        this.m_variables = variableList;
        this.m_stringTable = stringTable;
        this.m_rgSymbolTable = symbolTableEntryArray;
        this.m_template = template;
        this.m_os = outputStream;
        this.setTemplateName(string);
        System.out.print("\n >>>>> Debugging \"" + this.m_sTemplatePath + "\" >>>>>");
        System.out.print("\nLoading symbols");
        SymbolTableEntry symbolTableEntry = null;
        int n = this.m_rgSymbolTable.length;
        int n2 = 0;
        while (n2 < n) {
            symbolTableEntry = this.m_rgSymbolTable[n2];
            this.m_hSymbolHash.put(symbolTableEntry.getValue(), new Integer(n2));
            ++n2;
        }
    }

    void setTemplateName(String string) {
        this.m_sTemplatePath = string;
        File file = new File(this.m_sTemplatePath);
        this.m_sTemplate = file.getName();
    }

    String getTemplateName() {
        return this.m_sTemplatePath;
    }

    String getResponse() throws Exception {
        byte[] byArray = new byte[200];
        String string = null;
        int n = 0;
        System.out.flush();
        System.out.print("\nDbg Template>");
        n = System.in.read(byArray);
        while (n > 0 && (byArray[n - 1] == 13 || byArray[n - 1] == 10)) {
            --n;
        }
        string = new String(byArray, 0, n);
        return string;
    }

    boolean debug(int n, String string) throws Exception {
        String string2 = null;
        boolean bl = false;
        this.m_sbListing.append(string);
        if (this.isBreak(n)) {
            System.out.flush();
            System.out.print("\n >>>>> Debugging " + this.m_sTemplate + " Line " + n + ": >>>>>\n" + string);
            while (!bl) {
                try {
                    string2 = this.getResponse();
                    bl = this.handleCommand(n, string2);
                }
                catch (TemplateAbortException templateAbortException) {
                    throw templateAbortException;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return true;
    }

    boolean handleCommand(int n, String string) throws TemplateAbortException {
        boolean bl = false;
        this.m_bNextBreak = false;
        if (string.equals("next")) {
            this.m_bNextBreak = true;
            bl = true;
        } else if (string.equals("go")) {
            bl = true;
        } else if (string.equals("exit")) {
            System.exit(0);
            bl = true;
        } else if (string.startsWith("stop at")) {
            this.setBreakPoint(string);
            bl = false;
        } else if (string.startsWith("clear")) {
            this.clearBreakPoint(string);
            bl = false;
        } else if (string.startsWith("flush")) {
            this.flush();
            bl = false;
        } else if (string.startsWith("abort")) {
            this.abort();
            bl = true;
        } else if (string.startsWith("print")) {
            this.print(string);
            bl = false;
        } else if (string.startsWith("list")) {
            System.out.println(this.m_sbListing.toString());
            bl = false;
        } else if (string.startsWith("help")) {
            this.help(string);
            bl = false;
        } else if (string.length() == 0) {
            bl = false;
        } else {
            this.print("print " + string);
            bl = false;
        }
        return bl;
    }

    void help(String string) {
        System.out.print("\n Template Debugger Help\n Commands (commands are case sensitive):\n abort     Stop processing the template.\n clear     Followed by a line number. Clears a breakpoint on the\n           line indicated.\n exit      Stop the servlet.\n flush     Flush the data generated by the template thus far back\n           to the user agent\n go        Run until a break point is encountetered or until\n           template processing has completed.\n help      Show this screen.\n list      Shows the template text processed so far.\n next      Execute the next instruction, then stop again.\n print     Followed by the name of a VARiable or STRING. Displays\n           the value of the VARiable or STRING\n stop at   Followed by a line number. Sets a breakpoint on the\n           line indicated: Example\n               stop at 110\n           will cause the debugger to stop on line 110 of the template\n           (If an include file is encountered, the debugger will also\n           stop on the same line number in the include file.)\n           NOTE: Breaks will NOT occur on lines without keywords\n\t\t\t(such as {VAR...})\n\n For best results, set\n     Log.immediate=true\n in the servlet's config file. This will help prevent logged message\n from being displayed at the debugger prompt.\n To prevent run-time messages from being displayed in the debugger window,\n set\n     Log.Console.enable=false\n");
    }

    void print(String string) {
        int n = 6;
        String string2 = null;
        if (string.length() >= n) {
            string2 = string.substring(n);
        }
        if (string2 == null || string2.length() == 0) {
            SymbolTableEntry symbolTableEntry = null;
            int n2 = this.m_rgSymbolTable.length;
            int n3 = 0;
            while (n3 < n2) {
                symbolTableEntry = this.m_rgSymbolTable[n3];
                this.printVariable(new Integer(n3));
                ++n3;
            }
        } else {
            Integer n4 = (Integer)this.m_hSymbolHash.get(string2);
            if (!this.printVariable(n4)) {
                System.out.println(string2 + " is not a variable.");
            }
        }
    }

    boolean printVariable(Integer n) {
        if (n != null) {
            int n2 = n;
            Variable variable = null;
            SymbolTableEntry symbolTableEntry = this.m_template.getSymbol(n2);
            if (symbolTableEntry != null) {
                boolean bl = false;
                if ((symbolTableEntry.getFlags() & 1) != 0) {
                    variable = this.m_variables.get(symbolTableEntry.getValue());
                    if (variable == null) {
                        variable = new Variable("");
                    }
                } else if ((symbolTableEntry.getFlags() & 0x20) != 0 || (symbolTableEntry.getFlags() & 8) != 0 || (symbolTableEntry.getFlags() & 0x10) != 0 || (symbolTableEntry.getFlags() & 2) != 0) {
                    variable = new Variable(symbolTableEntry.getValue());
                } else if ((symbolTableEntry.getFlags() & 4) != 0) {
                    String string = this.m_stringTable.getString(symbolTableEntry.getValue());
                    if (string == null) {
                        string = "";
                    }
                    variable = new Variable(string);
                    bl = true;
                }
                if (bl) {
                    System.out.println("{STRING " + symbolTableEntry.getValue() + "} = \"" + variable.getStringValue() + "\"");
                } else {
                    System.out.println("{VAR " + symbolTableEntry.getValue() + "} = \"" + variable.getStringValue() + "\"");
                }
                return true;
            }
        }
        return false;
    }

    void abort() throws TemplateAbortException {
        throw new TemplateAbortException("Abort Template");
    }

    void flush() {
        try {
            this.m_os.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isBreak(int n) {
        if (this.m_iLastLineBreak == n) {
            return false;
        }
        if (this.m_bNextBreak) {
            this.m_iLastLineBreak = n;
            return true;
        }
        Integer n2 = new Integer(n);
        if (this.m_hBreakPoints.get(n2) != null) {
            this.m_iLastLineBreak = n;
            return true;
        }
        return false;
    }

    void setBreakPoint(String string) {
        int n = 8;
        Integer n2 = this.getIntFromCommand(n, string);
        this.m_hBreakPoints.put(n2, n2);
    }

    void clearBreakPoint(String string) {
        int n = 6;
        Integer n2 = this.getIntFromCommand(n, string);
        this.m_hBreakPoints.remove(n2);
    }

    Integer getIntFromCommand(int n, String string) {
        int n2 = 0;
        int n3 = string.length();
        String string2 = null;
        Integer n4 = new Integer(-1);
        while (!Character.isDigit(string.charAt(n))) {
            if (n == n3) {
                System.out.print("\nCommand requires a number");
                return n4;
            }
            ++n;
        }
        n2 = n;
        while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
            if (n2 == n3) break;
            ++n2;
        }
        string2 = string.substring(n, n2);
        System.out.print("\nStop at " + string2 + " OK");
        n4 = new Integer(string2);
        return n4;
    }
}

