/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NServletRequest;
import com.novell.webaccess.common.Log;
import com.novell.webaccess.common.Template;
import com.novell.webaccess.common.TemplateSource;
import com.novell.webaccess.common.XmlProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateManager {
    private boolean m_bCaching = true;
    private boolean m_bDebug = false;
    private boolean m_bDisassemble = false;
    private String m_TemplatePkg = "";
    private Log m_log = null;
    private int m_iRTSymbolMaxSize = 0;
    private long m_lCacheSize = 0x100000L;
    private long m_lCacheInUse = 0L;
    Properties m_cfgProperties = null;

    public void init(Properties properties) {
        String string;
        String string2 = properties.getProperty("Templates.Cache.enable");
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true")) {
                this.m_bCaching = true;
            } else {
                this.m_bCaching = false;
                TemplateSource.flushTemplateCache(this);
            }
        }
        if ((string2 = properties.getProperty("Templates.Cache.size")) != null) {
            this.m_lCacheSize = Long.parseLong(string2) * 1024L;
        }
        this.m_TemplatePkg = (String)((Hashtable)properties).get("Templates.Java.package");
        if (this.m_TemplatePkg == null) {
            this.m_TemplatePkg = (String)((Hashtable)properties).get("Templates.path");
            if (this.m_TemplatePkg == null) {
                this.m_TemplatePkg = "";
            }
        }
        if ((string2 = properties.getProperty("Templates.Debug.enable")) != null) {
            this.m_bDebug = string2.equals("true");
        }
        if ((string2 = properties.getProperty("Templates.Debug.Disassemble.enable")) != null) {
            this.m_bDisassemble = string2.equals("true");
        }
        if ((string = properties.getProperty("Templates.Merge.workSpace")) != null) {
            try {
                this.m_iRTSymbolMaxSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_cfgProperties = properties;
    }

    long getCacheSize() {
        return this.m_lCacheSize;
    }

    long getCacheInUse() {
        return this.m_lCacheInUse;
    }

    void growCache(long l) {
        this.m_lCacheInUse += l;
    }

    void shrinkCache(long l) {
        this.m_lCacheInUse -= l;
    }

    public void destroy() {
    }

    public void setLog(Log log) {
        this.m_log = log;
    }

    public void mergeDoc(String string, OutputStream outputStream, I18NLocale i18NLocale, I18NLocale i18NLocale2, Properties properties, Properties properties2, ServletRequest servletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        boolean bl2 = this.m_bCaching;
        if (!bl && this.m_bCaching) {
            bl2 = false;
        }
        Template template = new Template(outputStream, i18NLocale, i18NLocale2, bl2, this.m_TemplatePkg, this.m_cfgProperties, this.m_log);
        if (this.m_iRTSymbolMaxSize > 0) {
            template.setRTSymbolMaxCount(this.m_iRTSymbolMaxSize);
        }
        template.mergeDoc(string, properties, properties2, servletRequest, httpServletResponse, this, this.m_bDebug, this.m_bDisassemble);
    }

    public void mergeDoc(String string, OutputStream outputStream, I18NLocale i18NLocale, I18NLocale i18NLocale2, Properties properties, Properties properties2, ServletRequest servletRequest) throws IOException {
        this.mergeDoc(string, outputStream, i18NLocale, i18NLocale2, properties, properties2, servletRequest, null, true);
    }

    public void outputXml(OutputStream outputStream, I18NLocale i18NLocale, Properties properties, Properties properties2, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string2 = "utf-8";
        boolean bl = ((I18NServletRequest)httpServletRequest).isSoap();
        byte[] byArray = null;
        StringBuffer stringBuffer = new StringBuffer(1024);
        httpServletResponse.setContentType("text/xml; charset=utf-8");
        String string3 = httpServletRequest.getParameter("action");
        InputStream inputStream = ((I18NServletRequest)httpServletRequest).getXmlInputStream();
        if (bl) {
            stringBuffer.append("<env:Envelope xmlns:env=\"http://www.w3.org/2000/06/soap-envelope\"\r\n              xmlns:req=\"http://www.novell.com.wse." + string + "\">\r\n  <env:Header>\r\n");
            stringBuffer.append("    <req:RequestWas>\r\n");
            TemplateManager.xmlOutputURLData(outputStream, string, string3, string2, httpServletRequest, stringBuffer);
            stringBuffer.append("    </req:RequestWas>\r\n");
            stringBuffer.append("    <ses:SessionData>\r\n");
            TemplateManager.xmlOutputSessionData(outputStream, string, string3, string2, properties, stringBuffer);
            stringBuffer.append("    </ses:SessionData>\r\n");
            stringBuffer.append("  </env:Header>\r\n  <env:Body>\r\n");
            try {
                byArray = stringBuffer.toString().getBytes(string2);
                outputStream.write(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.setLength(0);
        } else {
            if (string3 == null) {
                string3 = "";
            }
            if (inputStream == null) {
                stringBuffer.append("<?xml version=\"1.0\"?>\r\n<Novell>\r\n<WebAccess>\r\n");
            }
            try {
                byArray = stringBuffer.toString().getBytes(string2);
                outputStream.write(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.setLength(0);
        }
        if (inputStream == null) {
            TemplateManager.xmlOutputProviderData(outputStream, string, string3, string2, properties2, stringBuffer);
        } else {
            this.xmlOutputXmlStream(outputStream, inputStream);
        }
        if (!bl) {
            TemplateManager.xmlOutputURLData(outputStream, string, string3, string2, httpServletRequest, stringBuffer);
            TemplateManager.xmlOutputSessionData(outputStream, string, string3, string2, properties, stringBuffer);
            TemplateManager.xmlOutputConfigData(outputStream, string, string3, string2, this.m_cfgProperties, stringBuffer);
        }
        if (bl) {
            stringBuffer.append("  </env:Body>\r\n</env:Envelope>");
        } else if (inputStream == null) {
            stringBuffer.append("</WebAccess>\r\n</Novell>\r\n");
        }
        try {
            byArray = stringBuffer.toString().getBytes(string2);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void xmlOutputXmlStream(OutputStream outputStream, InputStream inputStream) {
        byte[] byArray = new byte[1024];
        int n = 0;
        do {
            try {
                n = inputStream.read(byArray);
                outputStream.write(byArray, 0, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (n == 1024);
    }

    public static void xmlOutputProviderData(OutputStream outputStream, String string, String string2, String string3, Properties properties, StringBuffer stringBuffer) {
        byte[] byArray = null;
        stringBuffer.append("<Provider_");
        stringBuffer.append(string).append(" action=\"").append(string2).append("\">\r\n");
        try {
            byArray = stringBuffer.toString().getBytes(string3);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.setLength(0);
        XmlProperties.propertiesToXml(outputStream, properties, null, string3);
        stringBuffer.append("</Provider_").append(string).append(">\r\n");
        try {
            byArray = stringBuffer.toString().getBytes(string3);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.setLength(0);
    }

    public static void xmlOutputURLData(OutputStream outputStream, String string, String string2, String string3, HttpServletRequest httpServletRequest, StringBuffer stringBuffer) {
        byte[] byArray = null;
        Properties properties = new Properties();
        String string4 = null;
        stringBuffer.append("<URLParameters servlet=\"").append(httpServletRequest.getServletPath()).append('\"');
        String string5 = httpServletRequest.getPathInfo();
        if (string5 != null) {
            stringBuffer.append(" pathInfo=\"").append(string5).append('\"');
        }
        stringBuffer.append(">\r\n");
        try {
            byArray = stringBuffer.toString().getBytes(string3);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.setLength(0);
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            ((Hashtable)properties).put(string4, httpServletRequest.getParameter(string4));
        }
        XmlProperties.propertiesToXml(outputStream, properties, null, string3);
        stringBuffer.append("</URLParameters>\r\n");
        try {
            byArray = stringBuffer.toString().getBytes(string3);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.setLength(0);
    }

    public static void xmlOutputSessionData(OutputStream outputStream, String string, String string2, String string3, Properties properties, StringBuffer stringBuffer) {
        byte[] byArray = null;
        stringBuffer.append("<Session");
        String string4 = properties.getProperty("User.context");
        if (string4 != null) {
            stringBuffer.append(" id=\"").append(string4).append('\"');
        }
        stringBuffer.append(">\r\n");
        try {
            byArray = stringBuffer.toString().getBytes(string3);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.setLength(0);
        XmlProperties.propertiesToXml(outputStream, properties, null, string3);
        stringBuffer.append("</Session>\r\n");
        try {
            byArray = stringBuffer.toString().getBytes(string3);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.setLength(0);
    }

    public static void xmlOutputConfigData(OutputStream outputStream, String string, String string2, String string3, Properties properties, StringBuffer stringBuffer) {
        byte[] byArray = null;
        stringBuffer.append("<Config>\r\n");
        try {
            byArray = stringBuffer.toString().getBytes(string3);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.setLength(0);
        XmlProperties.propertiesToXml(outputStream, properties, null, string3);
        stringBuffer.append("</Config>\r\n");
        try {
            byArray = stringBuffer.toString().getBytes(string3);
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.setLength(0);
    }
}

