/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

public class Variable {
    public static final int VT_NUMERIC = 0;
    public static final int VT_STRING = 1;
    public static final int VT_DATE = 2;
    private String m_strValue;

    public Variable(String string) {
        this.m_strValue = string;
    }

    public void setStringValue(String string) {
        this.m_strValue = string;
    }

    public String getStringValue() {
        return this.m_strValue;
    }

    public String toString() {
        return this.getStringValue();
    }

    public long getLongValue() {
        Long l = new Long(this.m_strValue);
        return l;
    }

    public double getDoubleValue() {
        Double d = new Double(this.m_strValue);
        return d;
    }

    public boolean isDouble() {
        if (!this.isNumeric()) {
            return false;
        }
        return this.m_strValue.indexOf(46) != -1;
    }

    public boolean isNumeric() {
        boolean bl = false;
        int n = this.m_strValue.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = this.m_strValue.charAt(n2);
            if (n2 != 0 || c != '-') {
                if (c == '.') {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                } else {
                    if (c != 'E' && c != 'e' || n2 == n - 2) {
                        // empty if block
                    }
                    if (c > '9' || c < '0') {
                        return false;
                    }
                }
            }
            ++n2;
        }
        return !bl || n != 1;
    }

    public long compare(Variable variable) {
        if (this.isNumeric() && variable.isNumeric()) {
            try {
                return this.getLongValue() - variable.getLongValue();
            }
            catch (NumberFormatException numberFormatException) {
                double d = this.getDoubleValue();
                double d2 = variable.getDoubleValue();
                if (d < d2) {
                    return -1L;
                }
                if (d > d2) {
                    return 1L;
                }
                return 0L;
            }
        }
        return this.m_strValue.compareTo(variable.getStringValue());
    }

    public static double doArithmetic(Variable variable, char c, Variable variable2) {
        double d = 0.0;
        if (variable == null) {
            variable = new Variable("0");
        }
        if (variable2 == null) {
            variable2 = new Variable("0");
        }
        if (variable.isNumeric() && variable2.isNumeric()) {
            if (c == '+') {
                d = variable.getDoubleValue() + variable2.getDoubleValue();
            } else if (c == '-') {
                d = variable.getDoubleValue() - variable2.getDoubleValue();
            }
            if (c == '*') {
                d = variable.getDoubleValue() * variable2.getDoubleValue();
            } else if (c == '/') {
                double d2 = variable.getDoubleValue();
                double d3 = variable2.getDoubleValue();
                long l = (long)d2;
                long l2 = (long)d3;
                d = (double)l == d2 && (double)l2 == d3 ? (double)(l / l2) : d2 / d3;
            } else if (c == '%') {
                d = variable.getDoubleValue() % variable2.getDoubleValue();
            }
        }
        return d;
    }
}

