/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.beans.PropertyVetoException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class AddAttributeTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    private Properties m_resultStrings = null;
    private ObjectEntry m_treeOE = null;
    private NDSNamespace m_ns = null;
    private NDSSchemaDefinition m_schemaDef = null;
    private DirUtils m_dirUtils = null;
    private Locale m_locale = null;
    private Collator m_localeCollator = null;

    public boolean execute(TaskContext m_context, Properties m_resultStrings) {
        this.m_context = m_context;
        this.m_resultStrings = m_resultStrings;
        this.m_req = m_context.getRequest();
        AuthenticationBroker broker = m_context.getAuthenticationBroker();
        this.m_treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        String selectedButton = this.m_req.getParameter("Task.SelectedButton");
        this.m_locale = m_context.getLocale();
        this.m_localeCollator = Collator.getInstance(this.m_locale);
        this.m_dirUtils = m_context.getDirUtils();
        this.m_dirUtils.reinitialize();
        this.getSchemaClasses();
        if (nextState == null || "initialState".equalsIgnoreCase(nextState)) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("getSelectedClass")) {
            return this.getSelectedClass(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getSelectedAttribute")) {
            return this.getSelectedAttribute(selectedButton);
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private void getSchemaClasses() {
        String[] sortedClasses = this.m_dirUtils.getSortedClasses();
        ArrayList<String> classNames = new ArrayList<String>();
        for (int j = 0; j < sortedClasses.length; ++j) {
            if (sortedClasses[j].equals("[Anything]") || sortedClasses[j].equals("[Nothing]")) continue;
            classNames.add(sortedClasses[j]);
        }
        this.m_resultStrings.put("AvailableClassList.Count", Integer.toString(classNames.size()));
        for (int i = 0; i < classNames.size(); ++i) {
            this.m_resultStrings.put("AvailableClassList.Element." + i, classNames.get(i));
        }
    }

    private boolean getSelectedClass(String selectedButton) {
        Vector<String> availAttrVector = new Vector<String>();
        Vector<String> existingManAttrsVector = new Vector<String>();
        Vector<String> existingOptAttrsVector = new Vector<String>();
        Vector<String> removeVector = new Vector<String>();
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            int j;
            String strSelectedClass = eMFrameUtils.replaceNonAsciiWithAscii((String)this.m_req.getParameter("SelectedClass"), (String)"&#160;", (String)" ");
            this.m_resultStrings.put("SelectedClass", strSelectedClass);
            try {
                int i;
                this.m_schemaDef = (NDSSchemaDefinition)this.m_ns.getSchemaDefinition(this.m_treeOE);
                NDSClassDefinition classDef = this.m_schemaDef.getUnexpandedClassDefinition(strSelectedClass);
                AttributeDefinition[] attribs = this.m_schemaDef.getAttributeDefinitions();
                AttributeDefinition[] mandatory = this.m_schemaDef.getMandatoryAttributes(classDef.getName());
                for (int i2 = 0; i2 < mandatory.length; ++i2) {
                    existingManAttrsVector.addElement(mandatory[i2].getName());
                }
                AttributeDefinition[] optional = this.m_schemaDef.getOptionalAttributes(classDef.getName());
                for (i = 0; i < optional.length; ++i) {
                    existingOptAttrsVector.addElement(optional[i].getName());
                }
                for (i = 0; i < attribs.length; ++i) {
                    AttributeDefinition attrDef = attribs[i];
                    if (null == attrDef) continue;
                    String strName = attrDef.getName();
                    availAttrVector.addElement(strName);
                }
                removeVector.addAll(existingManAttrsVector);
                removeVector.addAll(existingOptAttrsVector);
                removeVector.addElement("[Anything]");
                removeVector.addElement("[Nothing]");
                availAttrVector.removeAll(removeVector);
                this.FindDupSort(availAttrVector);
                this.FindDupSort(existingManAttrsVector);
                this.FindDupSort(existingOptAttrsVector);
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            this.m_resultStrings.put("AvailableOptAttrList.Count", Integer.toString(availAttrVector.size()));
            for (int i = 0; i < availAttrVector.size(); ++i) {
                this.m_resultStrings.put("AvailableOptAttrList.Element." + i, (String)availAttrVector.get(i));
            }
            this.m_resultStrings.put("ExistingAttr.Count", Integer.toString(existingManAttrsVector.size()));
            for (j = 0; j < existingManAttrsVector.size(); ++j) {
                this.m_resultStrings.put("ExistingAttr.Element." + j, (String)existingManAttrsVector.elementAt(j));
            }
            this.m_resultStrings.put("OptAttrList.Count", Integer.toString(existingOptAttrsVector.size()));
            for (j = 0; j < existingOptAttrsVector.size(); ++j) {
                this.m_resultStrings.put("OptAttrList.Element." + j, (String)existingOptAttrsVector.elementAt(j));
            }
        }
        return true;
    }

    private boolean getSelectedAttribute(String selectedButton) {
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String strSelectedClass = this.m_req.getParameter("SelectedClass");
            String strSelectedAttr = this.m_req.getParameter("SelectedAttribute");
            Vector<AttributeDefinition> optionalVector = new Vector<AttributeDefinition>(5, 5);
            String[] selectedAttrArray = eMFrameUtils.replaceNonAsciiWithAsciiForArray((String[])this.spliceJavaScriptString(strSelectedAttr, ","), (String)"&#160;", (String)" ");
            String strSuccess = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"AddAttr.Success", (MContext)this.m_context);
            String strSuccessLong = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"AddAttr.SuccessLong", (MContext)this.m_context);
            try {
                NDSClassDefinition classDef = this.m_schemaDef.getUnexpandedClassDefinition(strSelectedClass);
                for (int i = 0; i < selectedAttrArray.length; ++i) {
                    optionalVector.addElement(this.m_schemaDef.getAttributeDefinition(selectedAttrArray[i]));
                }
                Object[] newOptional = new NDSAttributeDefinition[optionalVector.size()];
                optionalVector.copyInto(newOptional);
                classDef = new NDSClassDefinition(classDef.getName(), classDef.getClassFlags(), classDef.getContainmentClasses(), classDef.getSuperClasses(), classDef.getMandatoryAttributes(), classDef.getNamingAttributes(), (AttributeDefinition[])newOptional, classDef.getASN1Data());
                this.m_schemaDef.putClassDefinition((ClassDefinition)classDef);
            }
            catch (PropertyVetoException pex) {
                D.log((Throwable)pex);
                eMFrameUtils.setErrorMessage((Throwable)pex, (MContext)this.m_context);
                return false;
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                return false;
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                return false;
            }
            this.m_resultStrings.put("GeneralMsg.MsgTitle", strSuccess);
            this.m_resultStrings.put("GeneralMsg.MsgBody", strSuccessLong);
        }
        return true;
    }

    private String[] spliceJavaScriptString(String joinedString, String delimiter) {
        StringTokenizer izer = new StringTokenizer(joinedString, delimiter, false);
        String[] stringArray = new String[izer.countTokens()];
        int tokenCount = 0;
        while (izer.hasMoreTokens()) {
            stringArray[tokenCount] = izer.nextToken();
            ++tokenCount;
        }
        return stringArray;
    }

    private void FindDupSort(Vector vector) {
        HashSet s = new HashSet(vector);
        vector.clear();
        vector.addAll(0, s);
        Collections.sort(vector, this.m_localeCollator);
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

