/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.base.CreateClassTaskInfo;
import com.novell.emframe.dev.ASNOne;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.iManager;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class CreateClassTask
extends Task {
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    private Properties m_resultStrings = null;
    private ObjectEntry m_treeOE = null;
    private NDSNamespace m_ns = null;
    private NDSSchemaDefinition m_schemaDef = null;
    private String[] m_sortedSchemaClasses = null;
    private String[] m_sortedSchemaAttrs = null;
    private Locale m_locale = null;
    private Collator m_localeCollator = null;
    private Hashtable m_oidHash = new Hashtable();
    private boolean getClasses = true;
    private String m_baseImgDir = null;
    private DirUtils m_dirUtils = null;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        this.m_treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        this.m_req = this.m_context.getRequest();
        this.m_locale = this.m_context.getLocale();
        this.m_localeCollator = Collator.getInstance(this.m_locale);
        this.m_dirUtils = this.m_context.getDirUtils();
        this.m_dirUtils.reinitialize();
        this.m_sortedSchemaClasses = this.m_dirUtils.getSortedClasses();
        this.m_sortedSchemaAttrs = this.m_dirUtils.getSortedAttrs();
        String nextState = this.m_req.getParameter("nextState");
        String selectedButton = this.m_req.getParameter("Task.SelectedButton");
        if (this.getClasses) {
            try {
                this.m_schemaDef = (NDSSchemaDefinition)this.m_ns.getSchemaDefinition(this.m_treeOE);
                for (int x = 0; x < this.m_sortedSchemaClasses.length; ++x) {
                    ASNOne asn1;
                    String strID;
                    NDSClassDefinition classDef = this.m_schemaDef.getUnexpandedClassDefinition(this.m_sortedSchemaClasses[x]);
                    if (classDef == null || (strID = (asn1 = new ASNOne(classDef.getASN1Data())).getOid()) == null || strID.length() <= 0) continue;
                    this.m_oidHash.put(strID, classDef.getName());
                }
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
            String strClasses = this.m_sortedSchemaClasses[0] + ",";
            for (int i = 1; i < this.m_sortedSchemaClasses.length; ++i) {
                strClasses = strClasses + this.m_sortedSchemaClasses[i] + ",";
            }
            this.m_resultStrings.put("ClassCount", Integer.toString(this.m_sortedSchemaClasses.length));
            this.m_resultStrings.put("ClassNames", strClasses);
            this.getClasses = false;
        }
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("getNewClassName")) {
            return this.getNewClassName(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getClassFlags")) {
            return this.getClassFlags(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getClassParent")) {
            return this.getClassParent(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getManAttributes")) {
            return this.getManAttributes(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getOptAttributes")) {
            return this.getOptAttributes(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getNamingAttributes")) {
            return this.getNamingAttributes(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getClassContainer")) {
            return this.getClassContainer(selectedButton);
        }
        if (nextState.equalsIgnoreCase("getClassSummary")) {
            return this.getClassSummary(selectedButton);
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean getASN1ID(String strAsn1ID) {
        byte[] asn1Array;
        String ASNError = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Asn1IdError", (MContext)this.m_context);
        String Wrongasn = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.OidAlreadyChosen", (MContext)this.m_context);
        CreateClassTaskInfo newClass = (CreateClassTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewClassInfo");
        boolean isValid = true;
        ASNOne asn1ID = new ASNOne(strAsn1ID);
        if (strAsn1ID.length() > 0) {
            if (this.m_oidHash.containsKey(strAsn1ID)) {
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Asn1IdError", (MContext)this.m_context));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.OidAlreadyChosen", (MContext)this.m_context));
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
            if (null == (asn1Array = asn1ID.getAsn1())) {
                isValid = false;
            } else {
                ASNOne asnOne = new ASNOne(asn1Array);
                String oid = asnOne.getOid();
                if (oid.length() == 0) {
                    isValid = false;
                    String noId = null;
                    newClass.setID(noId);
                } else {
                    newClass.setID(oid);
                }
            }
            if (!isValid) {
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Asn1IdError", (MContext)this.m_context));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.InvalidAsn1Id", (MContext)this.m_context));
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
        } else {
            asn1Array = asn1ID.getNullAsn1();
        }
        newClass.setASN1ID(asn1Array);
        return isValid;
    }

    private boolean getNewClassName(String selectedButton) {
        CreateClassTaskInfo newClassInfo = new CreateClassTaskInfo(this.m_treeOE);
        this.m_context.setAuthAttribute((Object)"baseNewClassInfo", (Object)newClassInfo);
        CreateClassTaskInfo newClass = (CreateClassTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewClassInfo");
        String ClassName = newClass.getName();
        String ClassID = newClass.getID();
        this.m_resultStrings.put("EnteredClassName", ClassName);
        this.m_resultStrings.put("EnteredClassID", ClassID);
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String strNewClassName = this.m_req.getParameter("EnteredClassName");
            String strASN1ID = this.m_req.getParameter("EnteredClassID");
            if (!this.getASN1ID(strASN1ID)) {
                return false;
            }
            newClass.setName(strNewClassName);
            String newName = newClass.getName();
            String newID = newClass.getID();
            if (newID == null) {
                newID = "";
            }
            this.m_resultStrings.put("EnteredClassName", newName);
            this.m_resultStrings.put("EnteredClassID", newID);
        }
        return true;
    }

    private boolean getClassFlags(String selectedButton) {
        CreateClassTaskInfo newClass = (CreateClassTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewClassInfo");
        ArrayList<String> classNames = new ArrayList<String>();
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String whichRadio = this.m_req.getParameter("whichButton");
            newClass.setFlags(whichRadio);
            String newRadio = newClass.getFlags();
            this.m_resultStrings.put("SelectedFlag", newRadio);
            String containerFlag = this.m_req.getParameter("ContainerFlag");
            newClass.setContainerFlag(containerFlag);
            String strCont = newClass.getContainerFlag();
            this.m_resultStrings.put("ContainerFlag", strCont);
            newClass.setAvailSuperClasses(this.m_sortedSchemaClasses);
            this.m_resultStrings.put("AvailableClassList.Count", Integer.toString(this.m_sortedSchemaClasses.length));
            for (int i = 0; i < this.m_sortedSchemaClasses.length; ++i) {
                classNames.add(this.m_sortedSchemaClasses[i]);
                this.m_resultStrings.put("AvailableClassList.Element." + i, this.m_sortedSchemaClasses[i]);
            }
            this.m_resultStrings.put("AvailableClassList", classNames);
        }
        if (selectedButton.equals("previousSelected")) {
            String newName = newClass.getName();
            this.m_resultStrings.put("EnteredClassName", newName);
            String newID = newClass.getID();
            if (newID != null && newID.length() > 0) {
                this.m_resultStrings.put("EnteredClassID", newID);
            }
        }
        return true;
    }

    private boolean getClassParent(String selectedButton) {
        CreateClassTaskInfo newClass = (CreateClassTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewClassInfo");
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String strParentClass = this.m_req.getParameter("SelectedParents");
            this.m_resultStrings.put("SelectedParents", strParentClass);
            String strAvailParents = this.m_req.getParameter("AvailParents");
            String[] AvailParents = this.spliceJavaScriptString(strAvailParents, ",");
            newClass.setAvailSuperClasses(AvailParents);
            if (strParentClass == "" || strParentClass.length() == 0) {
                String[] manAttr1;
                String[] nullParent = null;
                newClass.setClassParent(nullParent);
                newClass.setAvailManAttributes(this.m_sortedSchemaAttrs);
                newClass.setAvailOptAttributes(this.m_sortedSchemaAttrs);
                this.m_resultStrings.put("AvailManAttrList.Count", Integer.toString(this.m_sortedSchemaAttrs.length));
                this.m_resultStrings.put("AvailOptAttrList.Count", Integer.toString(this.m_sortedSchemaAttrs.length));
                for (int a = 0; a < this.m_sortedSchemaAttrs.length; ++a) {
                    this.m_resultStrings.put("AvailManAttrList.Element." + a, this.m_sortedSchemaAttrs[a]);
                    this.m_resultStrings.put("AvailOptAttrList.Element." + a, this.m_sortedSchemaAttrs[a]);
                }
                this.m_resultStrings.put("InheritedMan", "false");
                this.m_resultStrings.put("InheritedOpt", "false");
                this.m_resultStrings.put("InheritedName", "false");
                this.m_resultStrings.put("InheritedCont", "false");
                String[] availMan1 = newClass.getAvailManAttributes();
                if (availMan1 != null && availMan1.length > 0) {
                    this.m_resultStrings.put("AvailManAttrList.Count", Integer.toString(availMan1.length));
                    for (int r = 0; r < availMan1.length; ++r) {
                        this.m_resultStrings.put("AvailManAttrList.Element." + r, availMan1[r]);
                    }
                }
                if ((manAttr1 = newClass.getManAttributes()) != null && manAttr1.length > 0) {
                    this.m_resultStrings.put("InheritedManAttr.Count", Integer.toString(manAttr1.length));
                    for (int r = 0; r < manAttr1.length; ++r) {
                        this.m_resultStrings.put("InheritedManAttr.Element." + r, manAttr1[r]);
                    }
                }
            } else if (strParentClass != "" && strParentClass.length() > 0) {
                String[] manAttr;
                Object strException = null;
                String[] ParentClassArray = eMFrameUtils.replaceNonAsciiWithAsciiForArray((String[])this.spliceJavaScriptString(strParentClass, ","), (String)"&#160;", (String)" ");
                newClass.setClassParent(eMFrameUtils.replaceNonAsciiWithAsciiForArray((String[])ParentClassArray, (String)"&#160;", (String)" "));
                Vector<String> inheritedNaming = new Vector<String>();
                Vector<String> inheritedMandatory = new Vector<String>();
                Vector<String> inheritedOptional = new Vector<String>();
                Vector<String> inheritedContainment = new Vector<String>();
                for (int i = 0; i < ParentClassArray.length; ++i) {
                    try {
                        AttributeDefinition[] naming = this.m_schemaDef.getNamingAttributes(ParentClassArray[i]);
                        for (int j = 0; j < naming.length; ++j) {
                            inheritedNaming.addElement(naming[j].getName());
                        }
                        AttributeDefinition[] mandatory = this.m_schemaDef.getMandatoryAttributes(ParentClassArray[i]);
                        for (int k = 0; k < mandatory.length; ++k) {
                            inheritedMandatory.addElement(mandatory[k].getName());
                        }
                        AttributeDefinition[] optional = this.m_schemaDef.getOptionalAttributes(ParentClassArray[i]);
                        for (int l = 0; l < optional.length; ++l) {
                            inheritedOptional.addElement(optional[l].getName());
                        }
                        ClassDefinition[] containment = this.m_schemaDef.getContainmentClasses(ParentClassArray[i]);
                        for (int m = 0; m < containment.length; ++m) {
                            inheritedContainment.addElement(containment[m].getName());
                        }
                        continue;
                    }
                    catch (NamespaceException nex) {
                        D.log((Throwable)nex);
                        eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                        ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                        return false;
                    }
                }
                this.FindDupSort(inheritedNaming);
                this.FindDupSort(inheritedMandatory);
                this.FindDupSort(inheritedOptional);
                this.FindDupSort(inheritedContainment);
                newClass.setInheritedManAttr(inheritedMandatory);
                newClass.setInheritedOptAttr(inheritedOptional);
                newClass.setInheritedNameAttr(inheritedNaming);
                newClass.setInheritedCont(inheritedContainment);
                Vector<String> availManAttrVector = new Vector<String>();
                Vector<String> availOptAttrVector = new Vector<String>();
                String[] availMan = newClass.getAvailManAttributes();
                if (availMan != null && availMan.length > 0) {
                    this.m_resultStrings.put("AvailManAttrList.Count", Integer.toString(availMan.length));
                    for (int r = 0; r < availMan.length; ++r) {
                        this.m_resultStrings.put("AvailManAttrList.Element." + r, availMan[r]);
                    }
                } else {
                    for (int p = 0; p < this.m_sortedSchemaAttrs.length; ++p) {
                        if (inheritedOptional.contains(this.m_sortedSchemaAttrs[p]) || inheritedMandatory.contains(this.m_sortedSchemaAttrs[p])) continue;
                        availManAttrVector.addElement(this.m_sortedSchemaAttrs[p]);
                        availOptAttrVector.addElement(this.m_sortedSchemaAttrs[p]);
                    }
                    Collections.sort(availManAttrVector, this.m_localeCollator);
                    Collections.sort(availOptAttrVector, this.m_localeCollator);
                    Object[] availManArray = new String[availManAttrVector.size()];
                    availManAttrVector.copyInto(availManArray);
                    Object[] availOptsArray = new String[availOptAttrVector.size()];
                    availOptAttrVector.copyInto(availOptsArray);
                    newClass.setAvailManAttributes((String[])availManArray);
                    newClass.setAvailOptAttributes((String[])availOptsArray);
                    this.m_resultStrings.put("AvailManAttrList.Count", Integer.toString(availManAttrVector.size()));
                    for (int r = 0; r < availManAttrVector.size(); ++r) {
                        this.m_resultStrings.put("AvailManAttrList.Element." + r, availManAttrVector.elementAt(r).toString());
                    }
                }
                if (inheritedMandatory != null && inheritedMandatory.size() > 0) {
                    this.m_resultStrings.put("InheritedMan.Count", Integer.toString(inheritedMandatory.size()));
                    for (int n = 0; n < inheritedMandatory.size(); ++n) {
                        this.m_resultStrings.put("InheritedMan.Element." + n, inheritedMandatory.elementAt(n).toString());
                    }
                    this.m_resultStrings.put("InheritedMan", "true");
                }
                if ((manAttr = newClass.getManAttributes()) != null && manAttr.length > 0) {
                    this.m_resultStrings.put("InheritedManAttr.Count", Integer.toString(manAttr.length));
                    for (int r = 0; r < manAttr.length; ++r) {
                        this.m_resultStrings.put("InheritedManAttr.Element." + r, manAttr[r]);
                    }
                }
            }
        }
        if (selectedButton.equalsIgnoreCase("previousSelected")) {
            String containerFlag = newClass.getContainerFlag();
            String classFlag = newClass.getFlags();
            this.m_resultStrings.put("ContainerFlag", containerFlag);
            this.m_resultStrings.put("SelectedFlag", classFlag);
        }
        return true;
    }

    private boolean getManAttributes(String selectedButton) {
        CreateClassTaskInfo newClass = (CreateClassTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewClassInfo");
        Vector availManVector = new Vector();
        Vector<String> availOptsVector = new Vector<String>();
        Vector inheritedOptionalVector = newClass.getInheritedOptAttr();
        Vector inheritedManVector = newClass.getInheritedManAttr();
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            Vector selectedManVector = new Vector();
            String strMandatoryAttr = this.m_req.getParameter("SelectedManAttr");
            this.m_resultStrings.put("SelectedManAttr", strMandatoryAttr);
            String strAvailManAttrs = this.m_req.getParameter("AvailManAttrs");
            String[] AvailManAttrs = this.spliceJavaScriptString(strAvailManAttrs, ",");
            newClass.setAvailManAttributes(AvailManAttrs);
            if (strMandatoryAttr == "" || strMandatoryAttr.length() == 0) {
                int s;
                String[] nullMan = null;
                newClass.setManAttributes(nullMan);
                String[] selectOpt1 = newClass.getOptAttributes();
                if (selectOpt1 != null && selectOpt1.length > 0) {
                    this.m_resultStrings.put("AvailOptAttrList.Count", Integer.toString(AvailManAttrs.length));
                    for (s = 0; s < AvailManAttrs.length; ++s) {
                        this.m_resultStrings.put("AvailOptAttrList.Element." + s, AvailManAttrs[s]);
                    }
                    this.m_resultStrings.put("InheritedOptAttr.Count", Integer.toString(selectOpt1.length));
                    for (s = 0; s < selectOpt1.length; ++s) {
                        this.m_resultStrings.put("InheritedOptAttr.Element." + s, selectOpt1[s]);
                    }
                } else {
                    this.m_resultStrings.put("AvailOptAttrList.Count", Integer.toString(AvailManAttrs.length));
                    for (s = 0; s < AvailManAttrs.length; ++s) {
                        this.m_resultStrings.put("AvailOptAttrList.Element." + s, AvailManAttrs[s]);
                    }
                }
            }
            if (strMandatoryAttr != "" && strMandatoryAttr.length() > 0) {
                Object[] ManAttrArray = this.spliceJavaScriptString(strMandatoryAttr, ",");
                newClass.setManAttributes((String[])ManAttrArray);
                String[] availOpts = AvailManAttrs;
                String[] selectOpt = newClass.getOptAttributes();
                if (selectOpt != null && selectOpt.length > 0) {
                    int s;
                    this.m_resultStrings.put("AvailOptAttrList.Count", Integer.toString(availOpts.length));
                    for (s = 0; s < availOpts.length; ++s) {
                        this.m_resultStrings.put("AvailOptAttrList.Element." + s, availOpts[s]);
                    }
                    this.m_resultStrings.put("InheritedOptAttr.Count", Integer.toString(selectOpt.length));
                    for (s = 0; s < selectOpt.length; ++s) {
                        this.m_resultStrings.put("InheritedOptAttr.Element." + s, selectOpt[s]);
                    }
                } else {
                    for (int z = 0; z < availOpts.length; ++z) {
                        if (this.arrayContains(ManAttrArray, availOpts[z])) continue;
                        availOptsVector.addElement(availOpts[z]);
                    }
                    Object[] updatedAvailOpts = new String[availOptsVector.size()];
                    availOptsVector.copyInto(updatedAvailOpts);
                    newClass.setAvailOptAttributes((String[])updatedAvailOpts);
                    this.m_resultStrings.put("AvailOptAttrList.Count", Integer.toString(updatedAvailOpts.length));
                    for (int s = 0; s < updatedAvailOpts.length; ++s) {
                        this.m_resultStrings.put("AvailOptAttrList.Element." + s, updatedAvailOpts[s]);
                    }
                }
            }
            if (inheritedOptionalVector != null && inheritedOptionalVector.size() > 0) {
                this.m_resultStrings.put("InheritedOpt.Count", Integer.toString(inheritedOptionalVector.size()));
                for (int p = 0; p < inheritedOptionalVector.size(); ++p) {
                    this.m_resultStrings.put("InheritedOpt.Element." + p, inheritedOptionalVector.elementAt(p).toString());
                }
                this.m_resultStrings.put("InheritedOpt", "true");
            }
        }
        if (selectedButton.equalsIgnoreCase("previousSelected")) {
            String[] availParentCls = newClass.getAvailSuperClasses();
            this.m_resultStrings.put("AvailableClassList.Count", Integer.toString(availParentCls.length));
            for (int i = 0; i < availParentCls.length; ++i) {
                this.m_resultStrings.put("AvailableClassList.Element." + i, availParentCls[i]);
            }
            String classParentList = null;
            String[] classParent = newClass.getClassParent();
            if (classParent != null && classParent.length > 0) {
                this.m_resultStrings.put("AddedParentClass.Count", Integer.toString(classParent.length));
                classParentList = classParent[0] + ",";
                this.m_resultStrings.put("AddedParentClass.Element.0", classParent[0]);
                for (int i = 1; i < classParent.length; ++i) {
                    classParentList = classParentList + classParent[i] + ",";
                    this.m_resultStrings.put("AddedParentClass.Element." + i, classParent[i]);
                }
                this.m_resultStrings.put("AddedParentClass.Count", Integer.toString(classParent.length));
                this.m_resultStrings.put("SelectedParents", classParentList);
            }
        }
        return true;
    }

    private boolean getOptAttributes(String selectedButton) {
        String[] OptAttrArray;
        String[] nullOpt;
        String[] AvailOptAttrs;
        String strAvailOptAttrs;
        String strOptionalAttr;
        Vector selectedOptVector;
        CreateClassTaskInfo newClass = (CreateClassTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewClassInfo");
        Object strMandatoryAttr = null;
        Object strException = null;
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            selectedOptVector = new Vector();
            strOptionalAttr = this.m_req.getParameter("SelectedOptAttr");
            this.m_resultStrings.put("SelectedOptAttr", strOptionalAttr);
            strAvailOptAttrs = this.m_req.getParameter("AvailOptAttrs");
            AvailOptAttrs = this.spliceJavaScriptString(strAvailOptAttrs, ",");
            newClass.setAvailOptAttributes(AvailOptAttrs);
            if (strOptionalAttr == "" || strOptionalAttr.length() == 0) {
                nullOpt = null;
                newClass.setOptAttributes(nullOpt);
            }
            if (strOptionalAttr != null && strOptionalAttr.length() > 0) {
                OptAttrArray = this.spliceJavaScriptString(strOptionalAttr, ",");
                newClass.setOptAttributes(OptAttrArray);
            }
            Object[] selectedManAttr = newClass.getManAttributes();
            Object[] selectedOptAttr = newClass.getOptAttributes();
            String[] selectedParent = newClass.getClassParent();
            Vector inheritedMandatory = newClass.getInheritedManAttr();
            Vector inheritedOptional = newClass.getInheritedOptAttr();
            Vector inheritedNaming = newClass.getInheritedNameAttr();
            Vector<String> availNamingVector = new Vector<String>();
            Vector<String> addNamingVector = new Vector<String>();
            try {
                NDSSchemaDefinition schemaDef = (NDSSchemaDefinition)this.m_ns.getSchemaDefinition(this.m_treeOE);
                AttributeDefinition[] attribs = schemaDef.getAttributeDefinitions();
                for (int a = 0; a < attribs.length; ++a) {
                    NDSAttributeDefinition ndsAttrDef = (NDSAttributeDefinition)attribs[a];
                    if (!((NDSSyntax)ndsAttrDef.getSyntax()).isNaming()) continue;
                    String strName = ndsAttrDef.getName();
                    if (selectedParent != null && selectedParent.length > 0) {
                        if (inheritedNaming.contains(strName)) {
                            addNamingVector.addElement(strName);
                        } else if (inheritedMandatory.contains(strName) || inheritedOptional.contains(strName)) {
                            availNamingVector.addElement(strName);
                        }
                    }
                    if (this.arrayContains(selectedManAttr, strName)) {
                        availNamingVector.addElement(strName);
                        continue;
                    }
                    if (!this.arrayContains(selectedOptAttr, strName)) continue;
                    availNamingVector.addElement(strName);
                }
                if (availNamingVector.isEmpty()) {
                    newClass.setNameAttributes(null);
                }
                Collections.sort(availNamingVector, this.m_localeCollator);
                Collections.sort(addNamingVector, this.m_localeCollator);
                Object[] availNamesArray = new String[availNamingVector.size()];
                availNamingVector.copyInto(availNamesArray);
                newClass.setAvailNameAttributes((String[])availNamesArray);
                Object[] addNamesArray = new String[addNamingVector.size()];
                addNamingVector.copyInto(addNamesArray);
                newClass.setAddNamingAttribute((String[])addNamesArray);
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
            }
            if (availNamingVector != null && availNamingVector.size() > 0) {
                this.m_resultStrings.put("AvailableNameAttrList.Count", Integer.toString(availNamingVector.size()));
                for (int b = 0; b < availNamingVector.size(); ++b) {
                    this.m_resultStrings.put("AvailableNameAttrList.Element." + b, availNamingVector.elementAt(b).toString());
                }
                if (addNamingVector != null && addNamingVector.size() > 0) {
                    String strInheritedNameAttr = addNamingVector.elementAt(0).toString() + ",";
                    this.m_resultStrings.put("InheritedName.Count", Integer.toString(addNamingVector.size()));
                    this.m_resultStrings.put("InheritedName.Element.0", addNamingVector.elementAt(0).toString());
                    this.m_resultStrings.put("InheritedAddNameAttrList.Count", Integer.toString(addNamingVector.size()));
                    this.m_resultStrings.put("InheritedAddNameAttrList.Element.0", addNamingVector.elementAt(0).toString());
                    for (int c = 1; c < addNamingVector.size(); ++c) {
                        strInheritedNameAttr = strInheritedNameAttr + addNamingVector.elementAt(c).toString() + ",";
                        this.m_resultStrings.put("InheritedName.Element." + c, addNamingVector.elementAt(c).toString());
                        this.m_resultStrings.put("InheritedAddNameAttrList.Element." + c, addNamingVector.elementAt(c).toString());
                    }
                    strInheritedNameAttr = strInheritedNameAttr.substring(0, strInheritedNameAttr.length() - 1);
                    this.m_resultStrings.put("strInheritedNameAttr", strInheritedNameAttr);
                    this.m_resultStrings.put("InheritedName", "true");
                }
                this.m_resultStrings.put("AvailContainsNaming", "true");
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateClsNameAttr");
            } else {
                int a;
                this.m_resultStrings.put("AvailContainsNaming", "false");
                String name = newClass.getName();
                String id = newClass.getID();
                String flag = newClass.getFlags();
                String contFlag = newClass.getContainerFlag();
                String[] superArray = newClass.getClassParent();
                String[] manArray = newClass.getManAttributes();
                String[] optArray = newClass.getOptAttributes();
                if (flag.equalsIgnoreCase("effective")) {
                    this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Message", (MContext)this.m_context));
                    this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.MustHaveNamingAttr", (MContext)this.m_context));
                    ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                    return false;
                }
                if (superArray != null && superArray.length > 0) {
                    this.m_resultStrings.put("SummaryParents.Count", Integer.toString(superArray.length));
                    for (a = 0; a < superArray.length; ++a) {
                        this.m_resultStrings.put("SummaryParents.Element." + a, superArray[a]);
                    }
                }
                if (manArray != null && manArray.length > 0) {
                    this.m_resultStrings.put("SummaryMan.Count", Integer.toString(manArray.length));
                    for (a = 0; a < manArray.length; ++a) {
                        this.m_resultStrings.put("SummaryMan.Element." + a, manArray[a]);
                    }
                }
                if (optArray != null && optArray.length > 0) {
                    this.m_resultStrings.put("SummaryOpt.Count", Integer.toString(optArray.length));
                    for (a = 0; a < optArray.length; ++a) {
                        this.m_resultStrings.put("SummaryOpt.Element." + a, optArray[a]);
                    }
                }
                this.m_resultStrings.put("ClassName", name);
                if (id != null && id.length() > 0) {
                    this.m_resultStrings.put("ClassID", id);
                }
                String strFlags = null;
                if (flag.equalsIgnoreCase("effective")) {
                    strFlags = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Effective", (MContext)this.m_context);
                }
                if (flag.equalsIgnoreCase("non")) {
                    strFlags = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Non", (MContext)this.m_context);
                }
                if (flag.equalsIgnoreCase("auxiliary")) {
                    strFlags = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Aux", (MContext)this.m_context);
                }
                this.m_resultStrings.put("SelectedFlagNames", strFlags);
                if (contFlag.equalsIgnoreCase("yes")) {
                    this.m_resultStrings.put("SelectedContFlag", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Cont", (MContext)this.m_context));
                }
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateClsSummary");
            }
        }
        if (selectedButton.equalsIgnoreCase("previousSelected")) {
            selectedOptVector = new Vector();
            strOptionalAttr = this.m_req.getParameter("SelectedOptAttr");
            strAvailOptAttrs = this.m_req.getParameter("AvailOptAttrs");
            AvailOptAttrs = this.spliceJavaScriptString(strAvailOptAttrs, ",");
            newClass.setAvailManAttributes(AvailOptAttrs);
            if (strOptionalAttr == "" || strOptionalAttr.length() == 0) {
                nullOpt = null;
                newClass.setOptAttributes(nullOpt);
            }
            if (strOptionalAttr != null && strOptionalAttr.length() > 0) {
                OptAttrArray = this.spliceJavaScriptString(strOptionalAttr, ",");
                newClass.setOptAttributes(OptAttrArray);
            }
            String[] availManAttr = newClass.getAvailManAttributes();
            this.m_resultStrings.put("AvailManAttrList.Count", Integer.toString(availManAttr.length));
            for (int a = 0; a < availManAttr.length; ++a) {
                this.m_resultStrings.put("AvailManAttrList.Element." + a, availManAttr[a]);
            }
            String[] parentArray = newClass.getClassParent();
            String[] manAttr = newClass.getManAttributes();
            Vector inheritedMan = new Vector();
            if (parentArray != null && parentArray.length > 0) {
                inheritedMan = newClass.getInheritedManAttr();
            }
            if (inheritedMan != null && inheritedMan.size() > 0) {
                this.m_resultStrings.put("InheritedMan.Count", Integer.toString(inheritedMan.size()));
                this.m_resultStrings.put("InheritedMan.Element.0", inheritedMan.elementAt(0).toString());
                for (int n = 1; n < inheritedMan.size(); ++n) {
                    this.m_resultStrings.put("InheritedMan.Element." + n, inheritedMan.elementAt(n).toString());
                }
                this.m_resultStrings.put("InheritedMan", "true");
            } else {
                this.m_resultStrings.put("InheritedMan", "false");
            }
            if (manAttr != null && manAttr.length > 0) {
                Object strSelectedManAttr = null;
                this.m_resultStrings.put("InheritedManAttr.Count", Integer.toString(manAttr.length));
                for (int b = 0; b < manAttr.length; ++b) {
                    this.m_resultStrings.put("InheritedManAttr.Element." + b, manAttr[b]);
                }
            } else {
                this.m_resultStrings.put("SelectedManAttr", "");
            }
        }
        return true;
    }

    private boolean getNamingAttributes(String selectedButton) {
        Vector selectedNameVector = new Vector();
        CreateClassTaskInfo newClass = (CreateClassTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewClassInfo");
        Object strMandatoryAttr = null;
        Object strOptional = null;
        this.m_resultStrings.put("ClassName", newClass.getName());
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            String flag;
            String strNamingAttr = this.m_req.getParameter("SelectedNameAttr");
            this.m_resultStrings.put("SelectedNameAttr", strNamingAttr);
            String strAvailNameAttr = this.m_req.getParameter("AvailNameAttr");
            String[] AvailNameAttr = this.spliceJavaScriptString(strAvailNameAttr, ",");
            newClass.setAvailNameAttributes(AvailNameAttr);
            if (strNamingAttr == "" || strNamingAttr.length() == 0) {
                String[] nullNaming = null;
                newClass.setNameAttributes(nullNaming);
            }
            if (strNamingAttr != null && strNamingAttr.length() > 0) {
                Object[] NamingAttrArray = this.spliceJavaScriptString(strNamingAttr, ",");
                String[] availNames = newClass.getAvailNameAttributes();
                Vector<String> availNamesVect = new Vector<String>();
                for (int z = 0; z < availNames.length; ++z) {
                    if (this.arrayContains(NamingAttrArray, availNames[z])) continue;
                    availNamesVect.addElement(availNames[z]);
                }
                Collections.sort(availNamesVect, this.m_localeCollator);
                Object[] availNamesArray = new String[availNamesVect.size()];
                availNamesVect.copyInto(availNamesArray);
                newClass.setAvailNameAttributes((String[])availNamesArray);
                newClass.setNameAttributes((String[])NamingAttrArray);
            }
            if ((flag = newClass.getFlags()).equalsIgnoreCase("effective") || flag.equalsIgnoreCase("non")) {
                Vector inheritedContainment = newClass.getInheritedCont();
                Vector<String> availContainerVector = new Vector<String>();
                Vector<String> addContainerVector = new Vector<String>();
                ClassDefinition[] classes = this.m_schemaDef.getClassDefinitions();
                for (int a = 0; a < classes.length; ++a) {
                    NDSClassDefinition classDef = (NDSClassDefinition)classes[a];
                    if (!classDef.getClassFlags().isFlagSet(2) || !classDef.getClassFlags().isFlagSet(1)) continue;
                    String strName = classDef.getName();
                    if (inheritedContainment.contains(strName)) {
                        addContainerVector.addElement(strName);
                        continue;
                    }
                    availContainerVector.addElement(strName);
                }
                Collections.sort(availContainerVector, this.m_localeCollator);
                Collections.sort(addContainerVector, this.m_localeCollator);
                Object[] availContArray = new String[availContainerVector.size()];
                Object[] addContArray = new String[addContainerVector.size()];
                availContainerVector.copyInto(availContArray);
                addContainerVector.copyInto(addContArray);
                newClass.setAvailContClass((String[])availContArray);
                newClass.setAddContClass((String[])addContArray);
                if (availContArray != null && availContArray.length > 0) {
                    this.m_resultStrings.put("AvailableContList.Count", Integer.toString(availContArray.length));
                    for (int b = 0; b < availContArray.length; ++b) {
                        this.m_resultStrings.put("AvailableContList.Element." + b, availContArray[b]);
                    }
                    if (addContArray != null && addContArray.length > 0) {
                        String strInheritedContCls = (String)addContArray[0] + ",";
                        this.m_resultStrings.put("InheritedAddContList.Count", Integer.toString(addContArray.length));
                        this.m_resultStrings.put("InheritedAddContList.Element.0", addContArray[0]);
                        for (int c = 1; c < addContArray.length; ++c) {
                            strInheritedContCls = strInheritedContCls + (String)addContArray[c] + ",";
                            this.m_resultStrings.put("InheritedAddContList.Element." + c, addContArray[c]);
                        }
                        strInheritedContCls = strInheritedContCls.substring(0, strInheritedContCls.length() - 1);
                        this.m_resultStrings.put("strInheritedContCls", strInheritedContCls);
                        this.m_resultStrings.put("InheritedCont", "true");
                    }
                    ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateClsContainer");
                }
            } else {
                int a;
                String name = newClass.getName();
                String id = newClass.getID();
                String flags = newClass.getFlags();
                String contFlag = newClass.getContainerFlag();
                String[] superArray = newClass.getClassParent();
                String[] manArray = newClass.getManAttributes();
                String[] optArray = newClass.getOptAttributes();
                String[] nameArray = newClass.getNameAttributes();
                if (superArray != null && superArray.length > 0) {
                    this.m_resultStrings.put("SummaryParents.Count", Integer.toString(superArray.length));
                    for (a = 0; a < superArray.length; ++a) {
                        this.m_resultStrings.put("SummaryParents.Element." + a, superArray[a]);
                    }
                }
                if (manArray != null && manArray.length > 0) {
                    this.m_resultStrings.put("SummaryMan.Count", Integer.toString(manArray.length));
                    for (a = 0; a < manArray.length; ++a) {
                        this.m_resultStrings.put("SummaryMan.Element." + a, manArray[a]);
                    }
                }
                if (optArray != null && optArray.length > 0) {
                    this.m_resultStrings.put("SummaryOpt.Count", Integer.toString(optArray.length));
                    for (a = 0; a < optArray.length; ++a) {
                        this.m_resultStrings.put("SummaryOpt.Element." + a, optArray[a]);
                    }
                }
                if (nameArray != null && nameArray.length > 0) {
                    this.m_resultStrings.put("SummaryName.Count", Integer.toString(nameArray.length));
                    for (a = 0; a < nameArray.length; ++a) {
                        this.m_resultStrings.put("SummaryName.Element." + a, nameArray[a]);
                    }
                }
                this.m_resultStrings.put("ClassName", name);
                if (id != null && id.length() > 0) {
                    this.m_resultStrings.put("ClassID", id);
                }
                String strFlags = null;
                if (flags.equalsIgnoreCase("effective")) {
                    strFlags = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Effective", (MContext)this.m_context);
                }
                if (flags.equalsIgnoreCase("non")) {
                    strFlags = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Non", (MContext)this.m_context);
                }
                if (flags.equalsIgnoreCase("auxiliary")) {
                    strFlags = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Aux", (MContext)this.m_context);
                }
                this.m_resultStrings.put("SelectedFlagNames", strFlags);
                if (contFlag.equalsIgnoreCase("yes")) {
                    this.m_resultStrings.put("SelectedContFlag", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Cont", (MContext)this.m_context));
                }
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateClsSummary");
            }
        }
        if (selectedButton.equalsIgnoreCase("previousSelected")) {
            String[] availOptAttr = newClass.getAvailOptAttributes();
            this.m_resultStrings.put("AvailOptAttrList.Count", Integer.toString(availOptAttr.length));
            for (int a = 0; a < availOptAttr.length; ++a) {
                this.m_resultStrings.put("AvailOptAttrList.Element." + a, availOptAttr[a]);
            }
            String[] parentArray = newClass.getClassParent();
            Vector inheritedOpt = new Vector();
            String[] optAttr = newClass.getOptAttributes();
            if (parentArray != null && parentArray.length > 0) {
                inheritedOpt = newClass.getInheritedOptAttr();
            }
            if (inheritedOpt != null && inheritedOpt.size() > 0) {
                this.m_resultStrings.put("InheritedOpt", "true");
                this.m_resultStrings.put("InheritedOpt.Count", Integer.toString(inheritedOpt.size()));
                this.m_resultStrings.put("InheritedOpt.Element.0", inheritedOpt.elementAt(0).toString());
                for (int p = 1; p < inheritedOpt.size(); ++p) {
                    this.m_resultStrings.put("InheritedOpt.Element." + p, inheritedOpt.elementAt(p).toString());
                }
            } else {
                this.m_resultStrings.put("InheritedOpt", "false");
            }
            if (optAttr != null && optAttr.length > 0) {
                this.m_resultStrings.put("InheritedOptAttr.Count", Integer.toString(optAttr.length));
                for (int b = 0; b < optAttr.length; ++b) {
                    this.m_resultStrings.put("InheritedOptAttr.Element." + b, optAttr[b]);
                }
            } else {
                this.m_resultStrings.put("SelectedOptAttr", "");
            }
        }
        return true;
    }

    private boolean getClassContainer(String selectedButton) {
        CreateClassTaskInfo newClass = (CreateClassTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewClassInfo");
        if (selectedButton.equalsIgnoreCase("nextSelected")) {
            int a;
            String strclassContainer = this.m_req.getParameter("SelectedContainers");
            this.m_resultStrings.put("SelectedContainers", strclassContainer);
            String strAvailContainers = this.m_req.getParameter("AvailContainers");
            String[] availContainers = this.spliceJavaScriptString(strAvailContainers, ",");
            newClass.setAvailContClass(availContainers);
            if (strclassContainer == "" && strclassContainer.length() == 0) {
                String[] nullCont = null;
                newClass.setContainerNames(nullCont);
            }
            if (strclassContainer != null && strclassContainer.length() > 0) {
                Object[] classContainerArray = eMFrameUtils.replaceNonAsciiWithAsciiForArray((String[])this.spliceJavaScriptString(strclassContainer, ","), (String)"&#160;", (String)" ");
                String[] availContCls = newClass.getAvailContClass();
                Vector<String> availContVect = new Vector<String>();
                for (int z = 0; z < availContCls.length; ++z) {
                    if (this.arrayContains(classContainerArray, availContCls[z])) continue;
                    availContVect.addElement(availContCls[z]);
                }
                Object[] availContsArray = new String[availContVect.size()];
                availContVect.copyInto(availContsArray);
                newClass.setAvailContClass((String[])availContsArray);
                newClass.setContainerNames((String[])classContainerArray);
            }
            String name = newClass.getName();
            String id = newClass.getID();
            String flag = newClass.getFlags();
            String contFlag = newClass.getContainerFlag();
            String[] superArray = newClass.getClassParent();
            String[] manArray = newClass.getManAttributes();
            String[] optArray = newClass.getOptAttributes();
            String[] nameArray = newClass.getNameAttributes();
            String[] contArray = newClass.getContainerNames();
            if (superArray != null && superArray.length > 0) {
                this.m_resultStrings.put("SummaryParents.Count", Integer.toString(superArray.length));
                for (a = 0; a < superArray.length; ++a) {
                    this.m_resultStrings.put("SummaryParents.Element." + a, superArray[a]);
                }
            }
            if (manArray != null && manArray.length > 0) {
                this.m_resultStrings.put("SummaryMan.Count", Integer.toString(manArray.length));
                for (a = 0; a < manArray.length; ++a) {
                    this.m_resultStrings.put("SummaryMan.Element." + a, manArray[a]);
                }
            }
            if (optArray != null && optArray.length > 0) {
                this.m_resultStrings.put("SummaryOpt.Count", Integer.toString(optArray.length));
                for (a = 0; a < optArray.length; ++a) {
                    this.m_resultStrings.put("SummaryOpt.Element." + a, optArray[a]);
                }
            }
            if (nameArray != null && nameArray.length > 0) {
                this.m_resultStrings.put("SummaryName.Count", Integer.toString(nameArray.length));
                for (a = 0; a < nameArray.length; ++a) {
                    this.m_resultStrings.put("SummaryName.Element." + a, nameArray[a]);
                }
            }
            if (contArray != null && contArray.length > 0) {
                this.m_resultStrings.put("SummaryCont.Count", Integer.toString(contArray.length));
                for (a = 0; a < contArray.length; ++a) {
                    this.m_resultStrings.put("SummaryCont.Element." + a, contArray[a]);
                }
            }
            this.m_resultStrings.put("ClassName", name);
            if (id != null && id.length() > 0) {
                this.m_resultStrings.put("ClassID", id);
            }
            String strFlags = null;
            if (flag.equalsIgnoreCase("effective")) {
                strFlags = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Effective", (MContext)this.m_context);
            }
            if (flag.equalsIgnoreCase("non")) {
                strFlags = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Non", (MContext)this.m_context);
            }
            if (flag.equalsIgnoreCase("auxiliary")) {
                strFlags = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Aux", (MContext)this.m_context);
            }
            this.m_resultStrings.put("SelectedFlagNames", strFlags);
            if (contFlag.equalsIgnoreCase("yes")) {
                this.m_resultStrings.put("SelectedContFlag", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Flags.Cont", (MContext)this.m_context));
            }
        }
        if (selectedButton.equalsIgnoreCase("previousSelected")) {
            String[] availNamingAttr = newClass.getAvailNameAttributes();
            this.m_resultStrings.put("AvailableNameAttrList.Count", Integer.toString(availNamingAttr.length));
            for (int a = 0; a < availNamingAttr.length; ++a) {
                this.m_resultStrings.put("AvailableNameAttrList.Element." + a, availNamingAttr[a]);
            }
            Object nameAttrList = null;
            String[] parentArray = newClass.getClassParent();
            Vector inheritedName = new Vector();
            String[] nameAttr = newClass.getNameAttributes();
            if (parentArray != null && parentArray.length > 0) {
                inheritedName = newClass.getInheritedNameAttr();
            }
            if (inheritedName != null && inheritedName.size() > 0) {
                this.m_resultStrings.put("InheritedName.Count", Integer.toString(inheritedName.size()));
                this.m_resultStrings.put("InheritedName.Element.0", inheritedName.elementAt(0).toString());
                String strInheritedNameAttr = inheritedName.elementAt(0) + ",";
                for (int c = 1; c < inheritedName.size(); ++c) {
                    strInheritedNameAttr = strInheritedNameAttr + inheritedName.elementAt(c) + ",";
                    this.m_resultStrings.put("InheritedName.Element." + c, inheritedName.elementAt(c).toString());
                }
                strInheritedNameAttr = strInheritedNameAttr.substring(0, strInheritedNameAttr.length() - 1);
                this.m_resultStrings.put("strInheritedNameAttr", strInheritedNameAttr);
                this.m_resultStrings.put("InheritedName", "true");
            }
            if (nameAttr != null && nameAttr.length > 0) {
                this.m_resultStrings.put("InheritedAddNameAttrList.Count", Integer.toString(nameAttr.length));
                for (int b = 0; b < nameAttr.length; ++b) {
                    this.m_resultStrings.put("InheritedAddNameAttrList.Element." + b, nameAttr[b]);
                }
            } else {
                this.m_resultStrings.put("SelectedNameAttr", "");
            }
        }
        return true;
    }

    private boolean getClassSummary(String selectedButton) {
        CreateClassTaskInfo newClass = (CreateClassTaskInfo)this.m_context.getAuthAttribute((Object)"baseNewClassInfo");
        if (selectedButton.equalsIgnoreCase("finishSelected")) {
            String strSuccess = null;
            String strSuccessLong = null;
            String strFailure = null;
            String register = null;
            strSuccess = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Success", (MContext)this.m_context);
            strSuccessLong = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.SuccessLong", (MContext)this.m_context);
            strFailure = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"CreateClass.Failure", (MContext)this.m_context);
            register = this.m_req.getParameter("Register");
            if (!newClass.convertFlag()) {
                String convertFlags = CreateClassTaskInfo.convertFlags;
            }
            try {
                newClass.convertManAttr();
                newClass.convertOptAttr();
                newClass.convertNamingAttr();
                newClass.sendToDS();
                this.m_dirUtils.reinitialize();
            }
            catch (SPIException spie) {
                D.log((Throwable)spie);
                eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            catch (NamespaceException nex) {
                D.log((Throwable)nex);
                eMFrameUtils.setErrorMessage((Throwable)nex, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            catch (Exception e) {
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenErr");
                return false;
            }
            if (register.equalsIgnoreCase("true")) {
                String clsName = newClass.getName();
                this.registerClass(clsName);
            }
            this.m_resultStrings.put("GeneralMsg.MsgTitle", strSuccess);
            this.m_resultStrings.put("GeneralMsg.MsgBody", strSuccessLong);
            ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "dev.GenConf");
        }
        if (selectedButton.equalsIgnoreCase("previousSelected")) {
            String[] availNames = newClass.getAvailNameAttributes();
            String[] nameAttr = newClass.getNameAttributes();
            String[] containers = newClass.getContainerNames();
            String[] availConts = newClass.getAvailContClass();
            String[] parentClass = newClass.getClassParent();
            String flag = newClass.getFlags();
            Vector inheritedName = new Vector();
            Vector inheritedCont = new Vector();
            this.m_resultStrings.put("SelectedFlg", flag);
            if (!flag.equalsIgnoreCase("auxiliary")) {
                if (availConts != null && availConts.length > 0) {
                    this.m_resultStrings.put("AvailableContList.Count", Integer.toString(availConts.length));
                    for (int a = 0; a < availConts.length; ++a) {
                        this.m_resultStrings.put("AvailableContList.Element." + a, availConts[a]);
                    }
                }
                String[] addConts = newClass.getContainerNames();
                if (parentClass != null && parentClass.length > 0) {
                    inheritedCont = newClass.getInheritedCont();
                }
                if (inheritedCont != null && inheritedCont.size() > 0) {
                    String strInheritedContCls = inheritedCont.elementAt(0) + ",";
                    this.m_resultStrings.put("InheritedContCls.Count", Integer.toString(inheritedCont.size()));
                    this.m_resultStrings.put("InheritedContCls.Element.0", inheritedCont.elementAt(0).toString());
                    for (int c = 1; c < inheritedCont.size(); ++c) {
                        strInheritedContCls = strInheritedContCls + inheritedCont.elementAt(c) + ",";
                        this.m_resultStrings.put("InheritedContCls.Element." + c, inheritedCont.elementAt(c).toString());
                    }
                    strInheritedContCls = strInheritedContCls.substring(0, strInheritedContCls.length() - 1);
                    this.m_resultStrings.put("strInheritedContCls", strInheritedContCls);
                    this.m_resultStrings.put("InheritedCont", "true");
                }
                if (addConts != null && addConts.length > 0) {
                    this.m_resultStrings.put("InheritedAddContList.Count", Integer.toString(addConts.length));
                    for (int b = 0; b < addConts.length; ++b) {
                        this.m_resultStrings.put("InheritedAddContList.Element." + b, addConts[b]);
                    }
                } else {
                    this.m_resultStrings.put("SelectedContainers", "");
                }
                ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateClsContainer");
            } else if (flag.equalsIgnoreCase("auxiliary")) {
                if (availNames != null && availNames.length > 0 || nameAttr != null && nameAttr.length > 0) {
                    this.m_resultStrings.put("AvailableNameAttrList.Count", Integer.toString(availNames.length));
                    for (int a = 0; a < availNames.length; ++a) {
                        this.m_resultStrings.put("AvailableNameAttrList.Element." + a, availNames[a]);
                    }
                    Object nameAttrList = null;
                    if (parentClass != null && parentClass.length > 0) {
                        inheritedName = newClass.getInheritedNameAttr();
                    }
                    if (inheritedName != null && inheritedName.size() > 0) {
                        String strInheritedNameAttr = inheritedName.elementAt(0) + ",";
                        this.m_resultStrings.put("InheritedName.Count", Integer.toString(inheritedName.size()));
                        for (int c = 0; c < inheritedName.size(); ++c) {
                            strInheritedNameAttr = inheritedName.elementAt(c) + ",";
                            this.m_resultStrings.put("InheritedName.Element." + c, inheritedName.elementAt(c).toString());
                        }
                        strInheritedNameAttr = strInheritedNameAttr.substring(0, strInheritedNameAttr.length() - 1);
                        this.m_resultStrings.put("strInheirtedNameAttr", strInheritedNameAttr);
                        this.m_resultStrings.put("InheritedName", "true");
                    }
                    if (nameAttr != null && nameAttr.length > 0) {
                        this.m_resultStrings.put("InheritedAddNameAttrList.Count", Integer.toString(nameAttr.length));
                        for (int b = 0; b < nameAttr.length; ++b) {
                            this.m_resultStrings.put("InheritedAddNameAttrList.Element." + b, nameAttr[b]);
                        }
                    } else {
                        this.m_resultStrings.put("SelectedNameAttr", "");
                    }
                    ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateClsNameAttr");
                } else {
                    String[] availOptAttr = newClass.getAvailOptAttributes();
                    this.m_resultStrings.put("AvailOptAttrList.Count", Integer.toString(availOptAttr.length));
                    for (int a = 0; a < availOptAttr.length; ++a) {
                        this.m_resultStrings.put("AvailOptAttrList.Element." + a, availOptAttr[a]);
                    }
                    String[] parentArray = newClass.getClassParent();
                    Vector inheritedOpt = new Vector();
                    String[] optAttr = newClass.getOptAttributes();
                    if (parentArray != null && parentArray.length > 0) {
                        inheritedOpt = newClass.getInheritedOptAttr();
                    }
                    if (inheritedOpt != null && inheritedOpt.size() > 0) {
                        this.m_resultStrings.put("InheritedOpt.Count", Integer.toString(inheritedOpt.size()));
                        for (int p = 0; p < inheritedOpt.size(); ++p) {
                            this.m_resultStrings.put("InheritedOpt.Element." + p, inheritedOpt.elementAt(p).toString());
                        }
                        this.m_resultStrings.put("InheritedOpt", "true");
                    } else {
                        this.m_resultStrings.put("InheritedOpt", "false");
                    }
                    if (optAttr != null && optAttr.length > 0) {
                        this.m_resultStrings.put("InheritedOptAttr.Count", Integer.toString(optAttr.length));
                        for (int b = 0; b < optAttr.length; ++b) {
                            this.m_resultStrings.put("InheritedOptAttr.Element." + b, optAttr[b]);
                        }
                    } else {
                        this.m_resultStrings.put("SelectedOptAttr", "");
                    }
                    ((I18NServletRequest)this.m_context.getRequest()).setParameter("merge", "base.CreateClsOptAttr");
                }
            }
        }
        return true;
    }

    private boolean registerClass(String className) {
        Document doc = null;
        doc = this.createXMLContent(className);
        String xmlDirPath = iManager.sm_sWebappRootPath + "/portal/modules" + "/custom/plugins";
        File xmlDirectory = new File(xmlDirPath);
        File xmlFile = null;
        try {
            if (!xmlDirectory.exists()) {
                xmlDirectory.mkdirs();
            }
            xmlFile = new File(xmlDirectory, "creator" + this.m_context.getDirUtils().getSafeName(className) + ".xml");
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
            return false;
        }
        boolean success = this.outputXMLFile(doc, xmlFile);
        if (!success) {
            return false;
        }
        List list = doc.getRootElement().getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                Element element = (Element)iterator.next();
                Document newDoc = new Document((Element)element.clone());
                GlobalRegistry.addNode((Document)newDoc, (File)xmlFile);
            }
            catch (Throwable t) {
                D.log((Throwable)t);
            }
        }
        return true;
    }

    private Document createXMLContent(String className) {
        Element objectCreator = new Element("object-creator");
        objectCreator.addContent(new Element("id").setText("base.CreateCustom" + this.m_context.getDirUtils().getSafeName(className)));
        objectCreator.addContent(new Element("object-type-name").setText(className));
        objectCreator.addContent(new Element("version").setText("1.0"));
        objectCreator.addContent(new Element("required-version").setText("1.0"));
        objectCreator.addContent(new Element("class-name").setText("com.novell.emframe.fw.GenericCreator"));
        Element root = new Element("plugins");
        root.addContent(objectCreator);
        return new Document(root);
    }

    private boolean outputXMLFile(Document doc, File xmlFile) {
        XMLOutputter outputter = new XMLOutputter("   ", true);
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(xmlFile));
            outputter.output(doc, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
            return false;
        }
        catch (IOException e) {
            D.log((Throwable)e);
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.m_context);
            return false;
        }
        return true;
    }

    private void FindDupSort(Vector vector) {
        HashSet s = new HashSet(vector);
        vector.clear();
        vector.addAll(0, s);
        Collections.sort(vector, this.m_localeCollator);
    }

    private String[] spliceJavaScriptString(String joinedString, String delimiter) {
        StringTokenizer izer = new StringTokenizer(joinedString, delimiter, false);
        String[] stringArray = new String[izer.countTokens()];
        int tokenCount = 0;
        while (izer.hasMoreTokens()) {
            stringArray[tokenCount] = izer.nextToken();
            ++tokenCount;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean arrayContains(Object[] array, Object o) {
        if (null == array) return false;
        Object[] objectArray = array;
        synchronized (array) {
            int index = array.length;
            while (--index >= 0) {
                if (!array[index].equals(o)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    private Vector convertToVector(String[] array) {
        Vector<String> v = new Vector<String>();
        for (int x = 0; x < array.length; ++x) {
            v.addElement(array[x]);
        }
        return v;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

