/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NetAddressFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class LaunchRemoteManagerTask
extends Task {
    boolean serverSupportsRM = false;
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    String strServer;
    String urlString;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("check")) {
            this.strServer = this.req.getParameter("single");
            return this.check();
        }
        if (nextState.equalsIgnoreCase("launch")) {
            return this.launch();
        }
        throw new RuntimeException("Task received invalid nextState:" + nextState);
    }

    private boolean showInitialForm() {
        eMFrameUtils.setupTargetChooser((String[])new String[]{"NCP Server"}, (MContext)this.context);
        return true;
    }

    private boolean check() {
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry rootOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)rootOE.getNamespace();
        ObjectEntry serverOE = null;
        try {
            serverOE = ns.getObjectEntry(rootOE, this.strServer);
        }
        catch (SPIException e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)this.context);
            return false;
        }
        if (!DirUtils.isOfType((ObjectType)serverOE.getObjectType(), (String)"NCP Server", (boolean)true)) {
            String strFailure = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"RemoteManager.Failure", (MContext)this.context);
            String strNotAUser = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.NotAServer", (MContext)this.context);
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage((String)strNotAUser, (Object[])new String[]{this.strServer}));
            this.resultStrings.put("GeneralMsg.MsgTitle", strFailure);
            return false;
        }
        try {
            ObjectAttribute networkAddressAttrib = ns.getAttribute(serverOE, "Network Address");
            if (networkAddressAttrib != null) {
                Enumeration valueSet = networkAddressAttrib.getValueComponents();
                this.urlString = null;
                while (valueSet.hasMoreElements()) {
                    NetAddressFacade netAddressFacade = (NetAddressFacade)((ValueList)valueSet.nextElement()).createFacade();
                    this.urlString = netAddressFacade.getAddressString();
                    if (this.urlString == null || !this.urlString.startsWith("https") || !this.urlString.endsWith("portal")) continue;
                    this.context.addToHistory(serverOE);
                    this.serverSupportsRM = true;
                    int portStart = this.urlString.lastIndexOf(58);
                    if (portStart <= 5) continue;
                    this.urlString = this.urlString.substring(0, portStart) + ":8009/_LOGIN_SERVER_";
                    return true;
                }
            }
        }
        catch (SPIException spie) {
            eMFrameUtils.setErrorMessage((Throwable)spie, (MContext)this.context);
            return false;
        }
        String strFailure = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"RemoteManager.Failure", (MContext)this.context);
        String strNotAUser = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"RemoteManager.NotSupported", (MContext)this.context);
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage((String)strNotAUser, (Object[])new String[]{this.strServer}));
        this.resultStrings.put("GeneralMsg.MsgTitle", strFailure);
        return false;
    }

    private boolean launch() {
        if (!this.serverSupportsRM) {
            throw new RuntimeException("Launch Novell Remote Manager Task in unexpected state.");
        }
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        this.resultStrings.put("LaunchRemoteManager.Url", this.urlString);
        this.resultStrings.put("LaunchRemoteManager.Val1", broker.getIdentity()[0]);
        this.resultStrings.put("LaunchRemoteManager.Val2", broker.getIdentity()[1]);
        this.resultStrings.put("LaunchRemoteManager.Tree", this.context.getAuthAttribute((Object)"User.tree"));
        return true;
    }
}

