/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.base.NGUtilities;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBook;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PropertyBookPage;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BackLinkUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public final class NGGroupMemberPage
extends DirPropertyBookPage {
    public static final String JSP_GROUPMEMBERS = "GroupMembersHiddenField";
    public static final String JSP_NESTED_GROUPMEMBERS = "NestedGroupMembersHiddenField";
    private static final String DT = "NGGroupMemberPage";
    ArrayList m_initialValues = new ArrayList();
    ArrayList m_currentValues = new ArrayList();
    String m_attributeName = "groupMember";
    String m_targetObjectTypeName = "nestedGroupAux";
    String m_backLinkAttributeName = null;
    String m_backLinkObjectTypeName = "nestedGroupAux";
    String m_secondaryAttributeName = null;
    String m_secondaryBackLinkAttributeName = null;
    NSObject m_nsObj = null;
    private static final String GROUP_MEMBERS_LIST = "GROUP_MEMBERS_LIST";
    private static final String GROUP_NESTEDMEMBERS_LIST = "GROUP_NESTED_MEMBERS_LIST";

    public void show(PropertyPageContext context) throws PageException {
        if (!this.getDirPropertyBook().isMoo()) {
            String displayName = context.getDirUtils().getAttributeDisplayName(this.m_attributeName, (MContext)context);
            context.getResultStrings().put("attributeDisplayName", displayName);
            boolean isNested = NGUtilities.outputCommonSettings(this.getDirPropertyBook(), context);
            this.read_from_cache(context, this.getDirPropertyBook().getNSObject());
            this.m_nsObj = this.getDirPropertyBook().getNSObject();
        }
        super.show(context);
        if (this.getDirPropertyBook().isMoo()) {
            eMFrameUtils.setMergeTemplate((MContext)context, (String)"base.NGGroupMemberPage");
            this.m_template = new String("base.NGGroupMemberPage");
        }
    }

    public void cache(PropertyPageContext context) throws PageException {
        super.cache(context);
        if (!this.getDirPropertyBook().isMoo()) {
            D.log((String)"NGGroupMemberPage.cache() called");
            if (NGUtilities.isGroupNested(this.getDirPropertyBook(), context)) {
                HttpServletRequest req = context.getRequest();
                String pack = req.getParameter(JSP_GROUPMEMBERS);
                if (pack.equals("empty")) {
                    pack = null;
                }
                String[] groupNames = eMFrameUtils.unpack((String)pack, (MContext)context);
                ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
                NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
                String namenotree = DirUtils.removeTreeFromFullName((ObjectEntry)treeOE, (String)this.m_nsObj.getObjectEntry().getFullName());
                ObjectAttribute attrib = this.m_nsObj.getAttribute(this.m_attributeName);
                ObjectAttribute secondaryAttrib = null;
                if (this.m_secondaryAttributeName != null) {
                    secondaryAttrib = this.m_nsObj.getAttribute(this.m_secondaryAttributeName);
                }
                boolean needToAdd = false;
                boolean needToAddSecondary = false;
                try {
                    NDSAttributeDefinition ad;
                    if (attrib == null) {
                        ad = (NDSAttributeDefinition)ns.getAttributeDefinition(treeOE, this.m_attributeName);
                        attrib = new NDSObjectAttribute(ad);
                        boolean bl = needToAdd = groupNames.length > 0;
                    }
                    if (this.m_secondaryAttributeName != null && secondaryAttrib == null) {
                        ad = (NDSAttributeDefinition)ns.getAttributeDefinition(treeOE, this.m_secondaryAttributeName);
                        secondaryAttrib = new NDSObjectAttribute(ad);
                        needToAddSecondary = groupNames.length > 0;
                    }
                    for (int i = 0; i < groupNames.length; ++i) {
                        boolean userAdded;
                        boolean bl = userAdded = !this.m_initialValues.contains(groupNames[i]);
                        if (!userAdded) continue;
                        ObjectEntry oe = ns.getObjectEntry(groupNames[i]);
                        if (context.getDirUtils().isOfAuxClass(this.m_nsobj.getObjectEntry(), "nestedGroupAux") && context.getDirUtils().isOfAuxClass(oe, this.m_backLinkObjectTypeName)) continue;
                        String header = eMFrameUtils.getLocalizedString((String)"DevResources", (String)"GeneralMsg.Error", (MContext)context);
                        String pattern = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"MultiDNPage.incorrectObjectType", (MContext)context);
                        String name = DirUtils.removeTreeFromFullName((ObjectEntry)treeOE, (String)oe.getFullName());
                        String body = eMFrameUtils.formatMessage((String)pattern, (Object[])new String[]{name, this.m_backLinkObjectTypeName});
                        throw new PageException(header, body);
                    }
                    attrib.removeAllComponents();
                    ArrayList oldValues = (ArrayList)this.m_currentValues.clone();
                    this.m_currentValues.clear();
                    for (int i = 0; i < groupNames.length; ++i) {
                        if (groupNames[i].equals(namenotree)) continue;
                        ValueComponent vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)groupNames[i]);
                        attrib.addComponent(vc);
                        this.m_currentValues.add(groupNames[i]);
                    }
                    if (this.m_secondaryAttributeName != null) {
                        ValueComponent vc;
                        String value;
                        ArrayList addList = NGUtilities.difference(this.m_currentValues, oldValues);
                        ArrayList removeList = NGUtilities.difference(oldValues, this.m_currentValues);
                        if (addList.size() == 0) {
                            needToAddSecondary = false;
                        }
                        Iterator iter = addList.iterator();
                        while (iter.hasNext()) {
                            value = (String)iter.next();
                            vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)value);
                            secondaryAttrib.addComponent(vc);
                            context.addToHistory(ns.getObjectEntry(value));
                        }
                        iter = removeList.iterator();
                        while (iter.hasNext()) {
                            value = (String)iter.next();
                            vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)value);
                            secondaryAttrib.removeComponent(vc);
                        }
                    }
                    if (needToAdd && this.m_currentValues.size() > 0) {
                        this.m_nsObj.addAttribute(attrib);
                    }
                    if (this.m_secondaryAttributeName != null && needToAddSecondary && this.m_currentValues.size() > 0) {
                        this.m_nsObj.addAttribute(secondaryAttrib);
                    }
                    Vector valvector = new Vector(this.m_currentValues);
                    this.getDirPropertyBook().getCache().put(GROUP_MEMBERS_LIST, valvector);
                }
                catch (Exception e) {
                    throw new PageException(e);
                }
            }
        }
    }

    public void commit(PropertyPageContext context) throws PageException {
        if (!this.getDirPropertyBook().isMoo()) {
            ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            String fullname = this.m_nsObj.getObjectEntry().getFullName();
            String name = DirUtils.removeTreeFromFullName((ObjectEntry)treeOE, (String)fullname);
            boolean isNested = NGUtilities.isGroupNested(this.getDirPropertyBook(), context);
            ArrayList addList = NGUtilities.difference(this.m_currentValues, this.m_initialValues);
            ArrayList removeList = NGUtilities.difference(this.m_initialValues, this.m_currentValues);
            Iterator iter = addList.iterator();
            while (iter.hasNext()) {
                try {
                    String groupName = (String)iter.next();
                    ObjectEntry memberOE = ns.getObjectEntry(groupName);
                    context.addToHistory(memberOE);
                }
                catch (SPIException e) {}
            }
            if (isNested) {
                Vector Nested = (Vector)this.getDirPropertyBook().getCache().get(GROUP_NESTEDMEMBERS_LIST);
                ArrayList differencelist = new ArrayList(Nested);
                ObjectEntry grpoe = this.m_nsObj.getObjectEntry();
                ArrayList additions = new ArrayList();
                if (addList.size() > 0) {
                    Iterator addIter = addList.iterator();
                    while (addIter.hasNext()) {
                        Object item = addIter.next();
                        if (!differencelist.contains(item)) continue;
                        additions.add(item);
                    }
                    if (additions.size() > 0) {
                        Iterator additionIter = additions.iterator();
                        ArrayList<String> grpObj = new ArrayList<String>();
                        grpObj.add(fullname);
                        while (additionIter.hasNext()) {
                            try {
                                ObjectEntry targetoe = ns.getObjectEntry((String)additionIter.next());
                                String namewithouttree = DirUtils.removeTreeFromFullName((ObjectEntry)treeOE, (String)targetoe.getFullName());
                                BackLinkUtils.updateBacklinks(grpObj, (String)SchemaUtil.translateNDAPAttr((ObjectEntry)grpoe, (String)"groupMember"), (String)namewithouttree, (int)1, (ObjectEntry)treeOE);
                            }
                            catch (SPIException e) {
                                D.log((Throwable)e);
                            }
                        }
                        BackLinkUtils.updateBacklinks(additions, (String)SchemaUtil.translateNDAPAttr((ObjectEntry)grpoe, (String)"Group Membership"), (String)name, (int)1, (ObjectEntry)treeOE);
                    }
                }
            }
            this.m_initialValues = new ArrayList();
            NGGroupMemberPage.readMembers(context, this.getDirPropertyBook().getNSObject(), this.getDirPropertyBook(), this);
        }
        super.commit(context);
    }

    public static void resetMemberList(DirPropertyBook propertyBook, PropertyPageContext context) {
        NGGroupMemberPage membersPage;
        propertyBook.getCache().remove(GROUP_MEMBERS_LIST);
        propertyBook.getCache().remove(GROUP_NESTEDMEMBERS_LIST);
        if (NGUtilities.isGroupNested(propertyBook, context) && (membersPage = (NGGroupMemberPage)propertyBook.getPageById("base.NGGroupMemberPage")) != null) {
            membersPage.m_initialValues = new ArrayList();
        }
    }

    private static void outputMemberData(PropertyPageContext context, DirPropertyBook propertyBook, Vector vStaticMember, Vector vNestedMember) {
        String[] array;
        Properties results = context.getResultStrings();
        results.put("GroupMembersParam", "");
        results.put("GroupMembersParamCount", "0");
        results.put("GroupMembersNestedParam", "");
        results.put("GroupMembersNestedParamCount", "0");
        Locale loc = context.getLocale();
        if (vStaticMember != null) {
            array = null;
            array = vStaticMember.toArray(new String[vStaticMember.size()]);
            results.put("GroupMembersParam", eMFrameUtils.pack((String[])array, (MContext)context));
            results.put("GroupMembersParamCount", "" + array.length);
            D.log((String)("GroupMembers static param count is " + array.length));
        }
        if (vNestedMember != null) {
            if (vNestedMember.size() > 0) {
                Collections.sort(vNestedMember, Collator.getInstance(loc));
            }
            array = null;
            array = vNestedMember.toArray(new String[vNestedMember.size()]);
            results.put("GroupMembersNestedParam", eMFrameUtils.pack((String[])array, (MContext)context));
            results.put("GroupMembersNestedParamCount", "" + array.length);
            D.log((String)("GroupMembers nested param count is " + array.length));
        }
    }

    private static void readMembers(PropertyPageContext context, NSObject nsObj, DirPropertyBook propertyBook, NGGroupMemberPage membersPage) {
        Vector<String> vGroupStaticMember = new Vector<String>();
        Vector<String> vGroupNestedMember = new Vector<String>();
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        try {
            Enumeration enumMember;
            ObjectAttribute oaMember = ns.getAttribute(nsObj.getObjectEntry(), "groupMember");
            if (oaMember != null && (enumMember = oaMember.getValueComponents()) != null) {
                while (enumMember.hasMoreElements()) {
                    String s = enumMember.nextElement().toString();
                    vGroupNestedMember.add(s);
                    System.out.println("Nested GroupMembers element is " + s);
                }
                System.out.println("Nested GroupMembers element count is " + vGroupNestedMember.size());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<String> arrayListAll = new ArrayList<String>();
        try {
            Enumeration enumMember;
            ObjectAttribute[] oaMember = ns.getAttributes(nsObj.getObjectEntry(), new String[]{"groupMember"}, 1, null, null);
            if (oaMember != null && oaMember[0] != null && (enumMember = oaMember[0].getValueComponents()) != null) {
                while (enumMember.hasMoreElements()) {
                    String s = enumMember.nextElement().toString();
                    vGroupStaticMember.add(s);
                    arrayListAll.add(s);
                    System.out.println("Static GroupMembers element is " + s);
                }
                System.out.println("Static GroupMembers element count is " + vGroupStaticMember.size());
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
        if (membersPage != null) {
            membersPage.m_initialValues = (ArrayList)arrayListAll.clone();
            membersPage.m_currentValues = (ArrayList)arrayListAll.clone();
        }
        propertyBook.getCache().put(GROUP_MEMBERS_LIST, vGroupStaticMember);
        propertyBook.getCache().put(GROUP_NESTEDMEMBERS_LIST, vGroupNestedMember);
        NGGroupMemberPage.outputMemberData(context, propertyBook, vGroupStaticMember, vGroupNestedMember);
    }

    private void read(PropertyPageContext context, NSObject nsObj) {
        NGGroupMemberPage.readMembers(context, nsObj, this.getDirPropertyBook(), this);
    }

    private void read_from_cache(PropertyPageContext context, NSObject nsObj) {
        Vector vGroupStaticMember = (Vector)this.getDirPropertyBook().getCache().get(GROUP_MEMBERS_LIST);
        Vector vGroupNestedMember = (Vector)this.getDirPropertyBook().getCache().get(GROUP_NESTEDMEMBERS_LIST);
        if (vGroupStaticMember == null || vGroupNestedMember == null) {
            this.read(context, nsObj);
        } else {
            NGGroupMemberPage.outputMemberData(context, this.getDirPropertyBook(), vGroupStaticMember, vGroupNestedMember);
        }
    }

    public static void setRemoveStaticBacklinks(PropertyPageContext context, NSObject nsObj, DirPropertyBook dirPropertyBook) {
        dirPropertyBook.getCache().put("removeBackLinks", "true");
        PropertyBookPage membersPage = dirPropertyBook.getPageById("base.NGGroupMemberPage");
        if (membersPage != null && !membersPage.m_IsDirty) {
            NGGroupMemberPage.readMembers(context, nsObj, dirPropertyBook, (NGGroupMemberPage)membersPage);
            ((NGGroupMemberPage)membersPage).m_nsObj = dirPropertyBook.getNSObject();
            membersPage.m_IsDirty = true;
        }
    }

    public static void clearRemoveStaticBacklinks(PropertyPageContext context, NSObject nsObj, DirPropertyBook dirPropertyBook) {
        dirPropertyBook.getCache().remove("removeBackLinks");
        PropertyBookPage membersPage = dirPropertyBook.getPageById("base.NGGroupMemberPage");
        if (membersPage != null && !membersPage.m_IsDirty) {
            NGGroupMemberPage.readMembers(context, nsObj, dirPropertyBook, (NGGroupMemberPage)membersPage);
            ((NGGroupMemberPage)membersPage).m_initialValues = new ArrayList();
            ((NGGroupMemberPage)membersPage).m_nsObj = dirPropertyBook.getNSObject();
            membersPage.m_IsDirty = true;
        }
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun((HttpServletRequest)req, (String)sServiceName);
    }
}

