/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class AbortNamingContextOperationRequest
implements ExtendedRequest {
    private int flag;
    private String partitionDN;

    public AbortNamingContextOperationRequest() {
    }

    public AbortNamingContextOperationRequest(String partitionDN, int flag) {
        this.partitionDN = partitionDN;
        this.flag = flag;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.30")) {
            throw new NamingException("Request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeInt(this.flag);
            ber.encodeString(this.partitionDN, true);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error:" + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public int getFlag() {
        return this.flag;
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.29";
    }

    public String getPartitionDN() {
        return this.partitionDN;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public void setPartitionDN(String partitionDN) {
        this.partitionDN = partitionDN;
    }
}

