/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class SendAllUpdatesRequest
implements ExtendedRequest {
    private String partitionDN;
    private String originatingServerDN;

    public SendAllUpdatesRequest() {
    }

    public SendAllUpdatesRequest(String partitionDN, String originatingServerDN) {
        this.partitionDN = partitionDN;
        this.originatingServerDN = originatingServerDN;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.24")) {
            throw new NamingException("Request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeString(this.partitionDN, true);
            ber.encodeString(this.originatingServerDN, true);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error:" + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.23";
    }

    public String getOriginatingServerDN() {
        return this.originatingServerDN;
    }

    public String getPartitionDN() {
        return this.partitionDN;
    }

    public void setOriginatingServerDN(String originatingServerDN) {
        this.originatingServerDN = originatingServerDN;
    }

    public void setPartitionDN(String partitionDN) {
        this.partitionDN = partitionDN;
    }
}

