/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class TriggerBackgroundProcessRequest
implements ExtendedRequest {
    private int processID;
    private String requestOID;
    private String responseOID;
    private String backgroundProcessName;
    public static final int BACKGROUND_PROCESS_BKLINKER = 1;
    public static final int BACKGROUND_PROCESS_JANITOR = 2;
    public static final int BACKGROUND_PROCESS_LIMBER = 3;
    public static final int BACKGROUND_PROCESS_PART_PURGE = 4;
    public static final int BACKGROUND_PROCESS_SCHEMA_SYNC = 5;
    public static final int BACKGROUND_PROCESS_SKULKER = 6;

    public TriggerBackgroundProcessRequest() {
    }

    public TriggerBackgroundProcessRequest(int processID) throws NamingException {
        this.processID = processID;
        this.setProcessIDAndOIDs(this.processID);
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals(this.responseOID)) {
            throw new NamingException("TriggerBackgroundProcessRequest request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public String getBackgroundProcessName() {
        return this.backgroundProcessName;
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        return ber.getTrimmedBuf();
    }

    public String getID() {
        return this.requestOID;
    }

    public int getProcessID() {
        return this.processID;
    }

    public void setProcessIDAndOIDs(int processID) throws NamingException {
        this.processID = processID;
        switch (processID) {
            case 1: {
                this.requestOID = "2.16.840.1.113719.1.27.100.43";
                this.responseOID = "2.16.840.1.113719.1.27.100.44";
                this.backgroundProcessName = " 'back linker' ";
                break;
            }
            case 2: {
                this.requestOID = "2.16.840.1.113719.1.27.100.47";
                this.responseOID = "2.16.840.1.113719.1.27.100.48";
                this.backgroundProcessName = " 'janitor' ";
                break;
            }
            case 3: {
                this.requestOID = "2.16.840.1.113719.1.27.100.49";
                this.responseOID = "2.16.840.1.113719.1.27.100.50";
                this.backgroundProcessName = " 'limber' ";
                break;
            }
            case 4: {
                this.requestOID = "2.16.840.1.113719.1.27.100.55";
                this.responseOID = "2.16.840.1.113719.1.27.100.56";
                this.backgroundProcessName = " 'partition purge' ";
                break;
            }
            case 5: {
                this.requestOID = "2.16.840.1.113719.1.27.100.53";
                this.responseOID = "2.16.840.1.113719.1.27.100.54";
                this.backgroundProcessName = " 'schema sync' ";
                break;
            }
            case 6: {
                this.requestOID = "2.16.840.1.113719.1.27.100.51";
                this.responseOID = "2.16.840.1.113719.1.27.100.52";
                this.backgroundProcessName = " 'skulker' ";
                break;
            }
            default: {
                throw new NamingException("Invalid processID.");
            }
        }
    }
}

