/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkColorSelectionDialog;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell shell) {
        this(shell, 0);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        boolean bl;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n = OS.gtk_color_selection_dialog_new(byArray);
        if (this.parent != null) {
            int n2 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(n, n2);
            int n3 = OS.gtk_window_get_icon_list(n2);
            if (n3 != 0) {
                OS.gtk_window_set_icon_list(n, n3);
                OS.g_list_free(n3);
            }
        }
        GtkColorSelectionDialog gtkColorSelectionDialog = new GtkColorSelectionDialog();
        OS.memmove(gtkColorSelectionDialog, n);
        GdkColor gdkColor = new GdkColor();
        if (this.rgb != null) {
            gdkColor.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
            gdkColor.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
            gdkColor.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
            OS.gtk_color_selection_set_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
        }
        OS.gtk_color_selection_set_has_palette(gtkColorSelectionDialog.colorsel, true);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        int n4 = OS.gtk_dialog_run(n);
        boolean bl2 = bl = n4 == -5;
        if (bl) {
            OS.gtk_color_selection_get_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
            int n5 = gdkColor.red >> 8 & 0xFF;
            int n6 = gdkColor.green >> 8 & 0xFF;
            int n7 = gdkColor.blue >> 8 & 0xFF;
            this.rgb = new RGB(n5, n6, n7);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(n);
        if (!bl) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

