/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class Decorations
extends Canvas {
    String text;
    Image image;
    Image[] images = new Image[0];
    boolean minimized;
    boolean maximized;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int accelGroup;
    int vboxHandle;

    Decorations() {
    }

    public Decorations(Composite composite, int n) {
        super(composite, Decorations.checkStyle(n));
    }

    static int checkStyle(int n) {
        if ((n & 8) != 0) {
            n &= 0xFFFFF30F;
        }
        if ((n & 0x4C0) != 0) {
            n |= 0x20;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void _setImages(Image[] imageArray) {
        if (imageArray != null && imageArray.length > 1) {
            Image[] imageArray2 = new Image[imageArray.length];
            System.arraycopy(imageArray, 0, imageArray2, 0, imageArray.length);
            this.sort(imageArray2);
            imageArray = imageArray2;
        }
        int n = 0;
        if (imageArray != null) {
            int n2 = 0;
            while (n2 < imageArray.length) {
                Image image = imageArray[n2];
                int n3 = Display.createPixbuf(image);
                n = OS.g_list_append(n, n3);
                ++n2;
            }
        }
        OS.gtk_window_set_icon_list(this.topHandle(), n);
        int[] nArray = new int[1];
        int n4 = n;
        while (n4 != 0) {
            OS.memmove(nArray, n4, OS.PTR_SIZEOF);
            OS.g_object_unref(nArray[0]);
            n4 = OS.g_list_next(n4);
        }
        if (n != 0) {
            OS.g_list_free(n);
        }
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int n = 0;
        while (n < this.menus.length) {
            if (this.menus[n] == null) {
                this.menus[n] = menu;
                return;
            }
            ++n;
        }
        Menu[] menuArray = new Menu[this.menus.length + 4];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    int compare(ImageData imageData, ImageData imageData2) {
        if (imageData.width == imageData2.width && imageData.height == imageData2.height) {
            int n = imageData.getTransparencyType();
            int n2 = imageData2.getTransparencyType();
            if (n == 1) {
                return -1;
            }
            if (n2 == 1) {
                return 1;
            }
            if (n == 2) {
                return -1;
            }
            if (n2 == 2) {
                return 1;
            }
            if (n == 4) {
                return -1;
            }
            if (n2 == 4) {
                return 1;
            }
            return 0;
        }
        return imageData.width > imageData2.width || imageData.height > imageData2.height ? -1 : 1;
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    void createAccelGroup() {
        if (this.accelGroup != 0) {
            return;
        }
        this.accelGroup = OS.gtk_accel_group_new();
        if (this.accelGroup == 0) {
            SWT.error(2);
        }
        int n = this.topHandle();
        OS.gtk_window_add_accel_group(n, this.accelGroup);
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
    }

    void destroyAccelGroup() {
        if (this.accelGroup == 0) {
            return;
        }
        int n = this.topHandle();
        OS.gtk_window_remove_accel_group(n, this.accelGroup);
        this.accelGroup = 0;
    }

    void fixAccelGroup() {
        if (this.menuBar == null) {
            return;
        }
        this.destroyAccelGroup();
        this.createAccelGroup();
        this.menuBar.addAccelerators(this.accelGroup);
    }

    void fixDecorations(Decorations decorations, Control control, Menu[] menuArray) {
        if (this == decorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menuArray == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            int n = 0;
            while (n < menuArray.length) {
                if (menuArray[n] == menu) {
                    control.setMenu(null);
                    return;
                }
                ++n;
            }
            menu.fixMenus(decorations);
        }
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton != null ? this.defaultButton : this.saveDefault;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] imageArray = new Image[this.images.length];
        System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
        return imageArray;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int n = 0;
        while (n < this.menus.length) {
            if (this.menus[n] == menu) {
                this.menus[n] = null;
                return;
            }
            ++n;
        }
    }

    void releaseChildren(boolean bl) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(bl);
        if (this.menus != null) {
            int n = 0;
            while (n < this.menus.length) {
                Menu menu = this.menus[n];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++n;
            }
            this.menus = null;
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.vboxHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean bl = this.savedFocus != null && this.savedFocus.setFocus();
        this.savedFocus = null;
        return bl;
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        int n = 0;
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
            n = button.handle;
        }
        this.saveDefault = this.defaultButton = button;
        OS.gtk_window_set_default(this.topHandle(), n);
    }

    public void setImage(Image image) {
        Image[] imageArray;
        this.checkWidget();
        this.image = image;
        if (image != null) {
            Image[] imageArray2 = new Image[1];
            imageArray = imageArray2;
            imageArray2[0] = image;
        } else {
            imageArray = null;
        }
        this._setImages(imageArray);
    }

    public void setImages(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(5);
        }
        int n = 0;
        while (n < imageArray.length) {
            if (imageArray[n] == null || imageArray[n].isDisposed()) {
                this.error(5);
            }
            ++n;
        }
        this.images = imageArray;
        this._setImages(imageArray);
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        this.maximized = bl;
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        this.menuBar = menu;
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        this.minimized = bl;
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            return;
        }
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    void sort(Image[] imageArray) {
        int n = imageArray.length;
        if (n <= 1) {
            return;
        }
        ImageData[] imageDataArray = new ImageData[n];
        int n2 = 0;
        while (n2 < n) {
            imageDataArray[n2] = imageArray[n2].getImageData();
            ++n2;
        }
        n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (this.compare(imageDataArray[n4], imageDataArray[n4 + n2]) >= 0) {
                        Image image = imageArray[n4];
                        imageArray[n4] = imageArray[n4 + n2];
                        imageArray[n4 + n2] = image;
                        ImageData imageData = imageDataArray[n4];
                        imageDataArray[n4] = imageDataArray[n4 + n2];
                        imageDataArray[n4 + n2] = imageData;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    boolean traverseItem(boolean bl) {
        return false;
    }

    boolean traverseReturn() {
        Button button;
        Button button2 = button = this.defaultButton != null ? this.defaultButton : this.saveDefault;
        if (button == null || button.isDisposed()) {
            return false;
        }
        if (!button.isVisible() || !button.isEnabled()) {
            return true;
        }
        int n = this._getShell().topHandle();
        return OS.gtk_window_activate_default(n);
    }
}

