/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 32768);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        int n;
        int n2;
        int n3;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n4 = OS.gtk_font_selection_dialog_new(byArray);
        if (this.parent != null) {
            int n5 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(n4, n5);
            n3 = OS.gtk_window_get_icon_list(n5);
            if (n3 != 0) {
                OS.gtk_window_set_icon_list(n4, n3);
                OS.g_list_free(n3);
            }
        }
        if (this.fontData != null) {
            Display display = this.parent != null ? this.parent.display : Display.getCurrent();
            Font font = new Font((Device)display, this.fontData);
            n2 = OS.pango_font_description_to_string(font.handle);
            n = OS.strlen(n2);
            byte[] byArray2 = new byte[n + 1];
            OS.memmove(byArray2, n2, n);
            font.dispose();
            OS.g_free(n2);
            OS.gtk_font_selection_dialog_set_font_name(n4, byArray2);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        n3 = OS.gtk_dialog_run(n4);
        int n6 = n2 = n3 == -5 ? 1 : 0;
        if (n2 != 0) {
            n = OS.gtk_font_selection_dialog_get_font_name(n4);
            int n7 = OS.strlen(n);
            byte[] byArray3 = new byte[n7 + 1];
            OS.memmove(byArray3, n, n7);
            OS.g_free(n);
            int n8 = OS.pango_font_description_from_string(byArray3);
            Font font = Font.gtk_new(display, n8);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(n8);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(n4);
        if (n2 == 0) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

