/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.math.BigInteger;
import javax.wbem.cim.UnsignedInt;

public class UnsignedInt64
extends UnsignedInt
implements Serializable,
Comparable {
    static final long serialVersionUID = 200L;
    public static final BigInteger MAX_VALUE = new BigInteger("18446744073709551615");
    public static final BigInteger MIN_VALUE = new BigInteger("0");

    public UnsignedInt64(String sval) throws NumberFormatException {
        BigInteger bigInt = new BigInteger(sval);
        if (bigInt.compareTo(MIN_VALUE) < 0 || bigInt.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
        this.value = bigInt;
    }

    public UnsignedInt64(byte[] bval) throws NumberFormatException {
        BigInteger bigInt = new BigInteger(bval);
        if (bigInt.compareTo(MIN_VALUE) < 0 || bigInt.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
        this.value = bigInt;
    }

    public UnsignedInt64(BigInteger input) {
        BigInteger bigInt = new BigInteger(input.toString());
        if (bigInt.compareTo(MIN_VALUE) < 0 || bigInt.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
        this.value = bigInt;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnsignedInt64)) {
            return false;
        }
        return ((UnsignedInt64)o).value.equals(this.value);
    }

    public BigInteger bigIntValue() {
        return (BigInteger)this.value;
    }

    public int compareTo(Object val) {
        return ((BigInteger)this.value).compareTo((BigInteger)((UnsignedInt64)val).value);
    }
}

