/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public final class HttpSettings {
    private Properties props;

    public static HttpSettings getHttpSettings() {
        return (HttpSettings)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new HttpSettings(System.getProperties());
            }
        });
    }

    private HttpSettings(Properties props) {
        this.props = props;
    }

    public String getHttpProxyHost(String def) {
        String str = this.props.getProperty("http.proxyHost");
        return str != null || (str = this.props.getProperty("proxyHost")) != null ? str : def;
    }

    public int getHttpProxyPort(int def) {
        String str = this.props.getProperty("http.proxyPort");
        if (str != null) {
            try {
                return Integer.parseInt(str);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((str = this.props.getProperty("proxyPort")) != null) {
            try {
                return Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public String getHttpsProxyHost(String def) {
        return this.props.getProperty("https.proxyHost", def);
    }

    public int getHttpsProxyPort(int def) {
        String str = this.props.getProperty("https.proxyPort");
        if (str != null) {
            try {
                return Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public long getResponseAckTimeout(long def) {
        String str = this.props.getProperty("sun.rmi.transport.http.ackTimeout");
        if (str != null) {
            try {
                return Long.parseLong(str);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return def;
    }

    public long getConnectionTimeout(long def) {
        String str = this.props.getProperty("sun.rmi.transport.http.connectionTimeout");
        if (str != null) {
            try {
                return Long.parseLong(str);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return def;
    }

    public boolean nonProxied(String host, boolean def) {
        return false;
    }
}

