/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import java.util.StringTokenizer;
import java.util.Vector;

class ASNOne {
    static final int FIRST_OCTET_MULTIPLIER = 40;
    static final int RADIX = 128;
    static final byte OID_TAG_BYTE = 6;
    static final int MAX_ASN1_NAME = 32;
    static final int ERR_INVALID_IDENTITY = -677;
    static final int ERR_INSUFFICIENT_BUFFER = -649;
    byte[] asn1 = null;
    String ldapString = null;

    public ASNOne(String ldapString) {
        this.ldapString = ldapString;
        if (null != this.ldapString) {
            this.asn1 = this.getASN1ID();
        }
    }

    public ASNOne(byte[] oidArray) {
        this.asn1 = oidArray;
        if (null == this.asn1 || 0 != this.Asn1IDToLdapOdi()) {
            this.ldapString = new String("");
        }
    }

    private int Asn1IDToLdapOdi() {
        long value;
        int length = 0;
        int i = 0;
        StringBuffer tempStr = new StringBuffer();
        if (null == this.asn1 || this.asn1[i] == 0) {
            return -677;
        }
        if (6L != (value = (long)this.asn1[i++])) {
            return -677;
        }
        if (127 < (length = this.asn1[i++]) || 2 > length) {
            return -677;
        }
        value = (long)this.asn1[i] / 40L;
        tempStr.append(value);
        value = (long)this.asn1[i++] % 40L;
        tempStr.append("." + value);
        length = length + i - 1;
        while (i < length) {
            value = 0L;
            while ((this.asn1[i] & 0x80) == 128) {
                value = 128L * value + ((long)this.asn1[i++] & 0x7FL);
            }
            value = 128L * value + (long)this.asn1[i++];
            tempStr.append("." + value);
        }
        this.ldapString = new String(tempStr.toString());
        return 0;
    }

    public String getOid() {
        return this.ldapString;
    }

    public byte[] getAsn1() {
        return this.asn1;
    }

    public byte[] getNullAsn1() {
        return new byte[32];
    }

    private byte[] getASN1ID() {
        if (null == this.asn1) {
            Vector<Byte> asn1Bytes = null;
            if (null != this.ldapString) {
                Byte firstByte;
                StringTokenizer tok = new StringTokenizer(this.ldapString, ".");
                String[] tokens = new String[tok.countTokens()];
                if (0 == tokens.length) {
                    return null;
                }
                for (int i = 0; i < tokens.length; ++i) {
                    tokens[i] = tok.nextToken();
                }
                String firstComp = tokens[0];
                String secondComp = null;
                if (tokens.length > 2) {
                    secondComp = tokens[1];
                }
                if (null != (firstByte = this.firstOctetEncoder(firstComp, secondComp))) {
                    if (null == asn1Bytes) {
                        asn1Bytes = new Vector<Byte>();
                    }
                    asn1Bytes.addElement(firstByte);
                    for (int i = 2; i < tokens.length; ++i) {
                        byte[] compResult = this.parseLDAPComponent(tokens[i]);
                        if (null == compResult) {
                            asn1Bytes = null;
                            break;
                        }
                        for (int index = 0; index < compResult.length; ++index) {
                            asn1Bytes.addElement(new Byte(compResult[index]));
                        }
                    }
                    if (null != asn1Bytes) {
                        Object[] byteArray = new Byte[asn1Bytes.size()];
                        asn1Bytes.copyInto(byteArray);
                        this.asn1 = new byte[32];
                        this.asn1[0] = 6;
                        this.asn1[1] = (byte)byteArray.length;
                        int x = 2;
                        for (int y = 0; x < this.asn1.length && y < byteArray.length; ++x, ++y) {
                            this.asn1[x] = (Byte)byteArray[y];
                        }
                    }
                }
            }
        }
        return this.asn1;
    }

    protected Byte firstOctetEncoder(String firstComp, String secondComp) {
        byte secondVal = 0;
        Byte retVal = null;
        boolean invalid = false;
        try {
            byte firstVal = Byte.valueOf(firstComp);
            if (firstVal >= 0 && firstVal < 3) {
                if (null != secondComp && ((secondVal = Byte.valueOf(secondComp).byteValue()) < 0 || secondVal > 39)) {
                    invalid = true;
                }
                if (!invalid) {
                    retVal = new Byte((byte)(40 * firstVal + secondVal));
                }
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return retVal;
    }

    public byte[] parseLDAPComponent(String ldapComponent) {
        byte[] retVal = null;
        Vector<Byte> accumulator = null;
        try {
            long balance = Long.parseLong(ldapComponent);
            do {
                byte remainder = (byte)(balance % 128L);
                balance /= 128L;
                if (null == accumulator) {
                    accumulator = new Vector<Byte>();
                }
                accumulator.addElement(new Byte(remainder));
            } while (0L != balance);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (null != accumulator) {
            retVal = new byte[accumulator.size()];
            int index = retVal.length - 1;
            int x = 0;
            while (index > 0) {
                retVal[x] = (byte)((Byte)accumulator.elementAt(index) | 0x80);
                --index;
                ++x;
            }
            retVal[x] = (Byte)accumulator.elementAt(0);
        }
        return retVal;
    }

    public String toString() {
        return this.ldapString;
    }
}

