/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.application.console.snapin.ObjectEntry;
import java.util.Enumeration;
import java.util.Vector;

public class NSModel {
    public static Enumeration getAttribute(ObjectEntry oe, NSObject nsObj, String attrName) throws SPIException {
        ObjectAttribute attrib = null;
        AdminNamespace ns = oe.getAdminNamespace();
        attrib = nsObj != null ? nsObj.getAttribute(attrName) : ns.getAttribute(oe, attrName);
        if (attrib != null) {
            return attrib.getValueComponents();
        }
        return null;
    }

    public static void setValueComponents(ObjectEntry oe, NSObject nsObj, String attrName, ValueComponent[] values) throws NamespaceException, SPIException {
        ObjectAttribute attrib = null;
        AdminNamespace ns = oe.getAdminNamespace();
        attrib = nsObj != null ? nsObj.getAttribute(attrName) : ns.getAttribute(oe, attrName);
        if (values == null && attrib != null) {
            attrib.removeAllComponents();
            return;
        }
        if (values == null) {
            return;
        }
        if (attrib != null) {
            attrib.removeAllComponents();
            for (int i = 0; i < values.length; ++i) {
                attrib.addComponent(values[i]);
            }
            if (nsObj == null) {
                ns.setAttribute(oe, attrib);
            }
        } else {
            AttributeDefinition attrDef = ns.getAttributeDefinition(oe, attrName);
            attrib = new ObjectAttribute(attrDef);
            for (int i = 0; i < values.length; ++i) {
                attrib.addComponent(values[i]);
            }
            if (nsObj != null) {
                nsObj.addAttribute(attrib);
            } else {
                ns.setAttribute(oe, attrib);
            }
        }
    }

    public static void addValueComponents(ObjectEntry oe, NSObject nsObj, String attrName, ValueComponent[] values) throws SPIException, NamespaceException {
        if (values == null) {
            return;
        }
        ObjectAttribute attrib = null;
        AdminNamespace ns = oe.getAdminNamespace();
        attrib = nsObj != null ? nsObj.getAttribute(attrName) : ns.getAttribute(oe, attrName);
        if (attrib != null) {
            for (int i = 0; i < values.length; ++i) {
                attrib.addComponent(values[i]);
            }
            if (nsObj == null) {
                ns.setAttribute(oe, attrib);
            }
        } else {
            AttributeDefinition attrDef = ns.getAttributeDefinition(oe, attrName);
            attrib = new ObjectAttribute(attrDef);
            for (int i = 0; i < values.length; ++i) {
                attrib.addComponent(values[i]);
            }
            if (nsObj != null) {
                nsObj.addAttribute(attrib);
            } else {
                ns.setAttribute(oe, attrib);
            }
        }
    }

    public static void deleteValueComponents(ObjectEntry oe, NSObject nsObj, String attrName, ValueComponent[] values) throws SPIException {
        if (values == null) {
            return;
        }
        ObjectAttribute attrib = null;
        AdminNamespace ns = oe.getAdminNamespace();
        attrib = nsObj != null ? nsObj.getAttribute(attrName) : ns.getAttribute(oe, attrName);
        if (attrib != null) {
            for (int i = 0; i < values.length; ++i) {
                attrib.removeComponent(values[i]);
            }
            if (nsObj == null) {
                ns.setAttribute(oe, attrib);
            }
        }
    }

    public static void modifyValueComponents(ObjectEntry oe, NSObject nsObj, String attrName, ValueComponent[] newValues, ValueComponent[] oldValues) throws SPIException, NamespaceException {
        if (newValues == null || oldValues == null) {
            return;
        }
        ObjectAttribute attrib = null;
        AdminNamespace ns = oe.getAdminNamespace();
        attrib = nsObj != null ? nsObj.getAttribute(attrName) : ns.getAttribute(oe, attrName);
        if (attrib != null) {
            for (int i = 0; i < newValues.length; ++i) {
                attrib.replaceComponent(oldValues[i], newValues[i]);
            }
            if (nsObj == null) {
                ns.setAttribute(oe, attrib);
            }
        }
    }

    public static String[] getStrings(ObjectEntry oe, NSObject nsObj, String attrName) throws SPIException {
        Vector<String> v = new Vector<String>(10);
        Enumeration myenum = NSModel.getAttribute(oe, nsObj, attrName);
        if (myenum != null) {
            while (myenum.hasMoreElements()) {
                StringValue sv = (StringValue)myenum.nextElement();
                v.addElement(sv.getValue());
            }
            Object[] strings = new String[v.size()];
            v.copyInto(strings);
            return strings;
        }
        return null;
    }

    public static void setStrings(ObjectEntry oe, NSObject nsObj, String attrName, String[] values) throws SPIException, NamespaceException, ComponentCreationException {
        if (values == null) {
            NSModel.setValueComponents(oe, nsObj, attrName, null);
            return;
        }
        AdminNamespace ns = oe.getAdminNamespace();
        Syntax syntax = ns.getAttributeDefinition(oe, attrName).getSyntax();
        ValueComponent[] vc = new ValueComponent[values.length];
        for (int i = 0; i < values.length; ++i) {
            vc[i] = syntax.createValueComponent((Object)values[i]);
        }
        NSModel.setValueComponents(oe, nsObj, attrName, vc);
    }

    public static void addStrings(ObjectEntry oe, NSObject nsObj, String attrName, String[] values) throws SPIException, NamespaceException, ComponentCreationException {
        if (values == null) {
            return;
        }
        Syntax syntax = oe.getAdminNamespace().getAttributeDefinition(oe, attrName).getSyntax();
        ValueComponent[] vc = new ValueComponent[values.length];
        for (int i = 0; i < values.length; ++i) {
            vc[i] = syntax.createValueComponent((Object)values[i]);
        }
        NSModel.addValueComponents(oe, nsObj, attrName, vc);
    }

    public static void deleteStrings(ObjectEntry oe, NSObject nsObj, String attrName, String[] values) throws SPIException, NamespaceException, ComponentCreationException {
        if (values == null) {
            return;
        }
        Syntax syntax = oe.getAdminNamespace().getAttributeDefinition(oe, attrName).getSyntax();
        ValueComponent[] vc = new ValueComponent[values.length];
        for (int i = 0; i < values.length; ++i) {
            vc[i] = syntax.createValueComponent((Object)values[i]);
        }
        NSModel.deleteValueComponents(oe, nsObj, attrName, vc);
    }

    public static ObjectEntry[] getDN(ObjectEntry oe, NSObject nsObj, String attrName) throws SPIException {
        Vector<ObjectEntry> v = new Vector<ObjectEntry>(10);
        Enumeration myenum = null;
        Object[] oeArray = null;
        AdminNamespace ns = oe.getAdminNamespace();
        myenum = NSModel.getAttribute(oe, nsObj, attrName);
        if (myenum != null) {
            while (myenum.hasMoreElements()) {
                String dn = myenum.nextElement().toString();
                v.addElement(ns.getObjectEntry(oe.getRoot(), dn));
            }
            oeArray = new ObjectEntry[v.size()];
            v.copyInto(oeArray);
            return oeArray;
        }
        return null;
    }

    public static void setDN(ObjectEntry oe, NSObject nsObj, String attrName, ObjectEntry[] values) throws SPIException, NamespaceException, ComponentCreationException {
        if (values == null) {
            NSModel.setValueComponents(oe, nsObj, attrName, null);
            return;
        }
        AdminNamespace ns = oe.getAdminNamespace();
        Syntax syntax = ns.getSchemaDefinition(oe).getAttributeDefinition(attrName).getSyntax();
        ValueComponent[] dnValues = new ValueComponent[values.length];
        for (int i = 0; i < values.length; ++i) {
            dnValues[i] = values[i].getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)values[i], (String)"Top")) ? syntax.createValueComponent((Object)values[i].getName()) : syntax.createValueComponent((Object)ns.getUnrootedName(values[i]));
        }
        NSModel.setValueComponents(oe, nsObj, attrName, dnValues);
    }

    public static void addDN(ObjectEntry oe, NSObject nsObj, String attrName, ObjectEntry[] values) throws NamespaceException, SPIException, ComponentCreationException {
        if (values == null) {
            return;
        }
        AdminNamespace ns = oe.getAdminNamespace();
        Syntax syntax = ns.getSchemaDefinition(oe).getAttributeDefinition(attrName).getSyntax();
        ValueComponent[] dnValues = new ValueComponent[values.length];
        for (int i = 0; i < values.length; ++i) {
            dnValues[i] = values[i].getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)values[i], (String)"Top")) ? syntax.createValueComponent((Object)values[i].getName()) : syntax.createValueComponent((Object)ns.getUnrootedName(values[i]));
        }
        NSModel.addValueComponents(oe, nsObj, attrName, dnValues);
    }

    public static void deleteDN(ObjectEntry oe, NSObject nsObj, String attrName, ObjectEntry[] values) throws SPIException, ComponentCreationException, NamespaceException {
        if (values == null) {
            return;
        }
        AdminNamespace ns = oe.getAdminNamespace();
        Syntax syntax = ns.getSchemaDefinition(oe).getAttributeDefinition(attrName).getSyntax();
        ValueComponent[] dnValues = new ValueComponent[values.length];
        for (int i = 0; i < values.length; ++i) {
            dnValues[i] = values[i].getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)values[i], (String)"Top")) ? syntax.createValueComponent((Object)values[i].getName()) : syntax.createValueComponent((Object)ns.getUnrootedName(values[i]));
        }
        NSModel.deleteValueComponents(oe, nsObj, attrName, dnValues);
    }

    public static void makeDNRelation(NSObject aObj, NSObject bObj, String aAttrName, String bAttrName) throws SPIException, NamespaceException, ComponentCreationException {
        ValueComponent vc;
        ValueComponent vc2;
        Enumeration myenum;
        ObjectEntry aOE = aObj.getObjectEntry();
        ObjectEntry bOE = bObj.getObjectEntry();
        AdminNamespace ns = aOE.getAdminNamespace();
        Syntax aSyntax = ns.getSchemaDefinition(aOE).getAttributeDefinition(aAttrName).getSyntax();
        Syntax bSyntax = ns.getSchemaDefinition(bOE).getAttributeDefinition(bAttrName).getSyntax();
        String aName = ns.getUnrootedName(aOE);
        String bName = ns.getUnrootedName(bOE);
        ObjectAttribute aAttrib = aObj.getAttribute(aAttrName);
        ObjectAttribute bAttrib = bObj.getAttribute(bAttrName);
        if (aAttrib != null) {
            boolean found = false;
            myenum = aAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                if (!bName.equalsIgnoreCase(myenum.nextElement().toString())) continue;
                found = true;
                break;
            }
            if (!found) {
                vc2 = bSyntax.createValueComponent((Object)bName);
                aAttrib.addComponent(vc2);
            }
        } else {
            AttributeDefinition def = ns.getAttributeDefinition(aOE, aAttrName);
            aAttrib = new ObjectAttribute(def);
            vc = bSyntax.createValueComponent((Object)bName);
            aAttrib.addComponent(vc);
            aObj.addAttribute(aAttrib);
        }
        if (bAttrib != null) {
            boolean found = false;
            myenum = bAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                if (!aName.equalsIgnoreCase(myenum.nextElement().toString())) continue;
                found = true;
                break;
            }
            if (!found) {
                vc2 = aSyntax.createValueComponent((Object)aName);
                bAttrib.addComponent(vc2);
            }
        } else {
            AttributeDefinition def = ns.getAttributeDefinition(bOE, bAttrName);
            bAttrib = new ObjectAttribute(def);
            vc = aSyntax.createValueComponent((Object)aName);
            bAttrib.addComponent(vc);
            bObj.addAttribute(bAttrib);
        }
    }

    public static void removeDNRelation(NSObject aObj, NSObject bObj, String aAttrName, String bAttrName) {
        boolean found;
        ObjectEntry aOE = aObj.getObjectEntry();
        ObjectEntry bOE = bObj.getObjectEntry();
        AdminNamespace ns = aOE.getAdminNamespace();
        String aName = ns.getUnrootedName(aOE);
        String bName = ns.getUnrootedName(bOE);
        ObjectAttribute aAttrib = aObj.getAttribute(aAttrName);
        ObjectAttribute bAttrib = bObj.getAttribute(bAttrName);
        if (aAttrib != null) {
            found = false;
            Enumeration myenum = aAttrib.getValueComponents();
            ValueComponent vc = null;
            while (myenum.hasMoreElements()) {
                vc = (ValueComponent)myenum.nextElement();
                if (!bName.equalsIgnoreCase(vc.toString())) continue;
                found = true;
                break;
            }
            if (found && vc != null) {
                aAttrib.removeComponent(vc);
            }
        }
        if (bAttrib != null) {
            found = false;
            ValueComponent vc = null;
            Enumeration myenum = bAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                vc = (ValueComponent)myenum.nextElement();
                if (!aName.equalsIgnoreCase(vc.toString())) continue;
                found = true;
                break;
            }
            if (found && vc != null) {
                bAttrib.removeComponent(vc);
            }
        }
    }

    public static void makeTypedNameRelation(NSObject aObj, NSObject bObj, String aAttrName, String bAttrName, long aLevel, long aInterval, long bLevel, long bInterval) throws SPIException, NamespaceException {
        ValueList vl;
        ValueList vl2;
        AttributeDefinition def;
        TypedNameFacade facade;
        Enumeration myenum;
        ObjectEntry aOE = aObj.getObjectEntry();
        ObjectEntry bOE = bObj.getObjectEntry();
        AdminNamespace ns = aOE.getAdminNamespace();
        String aName = ns.getUnrootedName(aOE);
        String bName = ns.getUnrootedName(bOE);
        ObjectAttribute aAttrib = aObj.getAttribute(aAttrName);
        ObjectAttribute bAttrib = bObj.getAttribute(bAttrName);
        if (aAttrib != null) {
            boolean found = false;
            myenum = aAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                facade = (TypedNameFacade)((ValueList)myenum.nextElement()).createFacade();
                if (!bName.equalsIgnoreCase(facade.getObject()) || bLevel != facade.getLevel() || bInterval != facade.getInterval()) continue;
                found = true;
                break;
            }
            if (!found) {
                def = ns.getAttributeDefinition(aOE, aAttrName);
                vl2 = TypedNameFacade.createValueList((String)bName, (long)bLevel, (long)bInterval, (Syntax)def.getSyntax());
                aAttrib.addComponent((ValueComponent)vl2);
            }
        } else {
            AttributeDefinition def2 = ns.getAttributeDefinition(aOE, aAttrName);
            aAttrib = new ObjectAttribute(def2);
            vl = TypedNameFacade.createValueList((String)bName, (long)bLevel, (long)bInterval, (Syntax)def2.getSyntax());
            aAttrib.addComponent((ValueComponent)vl);
            aObj.addAttribute(aAttrib);
        }
        if (bAttrib != null) {
            boolean found = false;
            myenum = bAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                facade = (TypedNameFacade)((ValueList)myenum.nextElement()).createFacade();
                if (!aName.equalsIgnoreCase(facade.getObject()) || aLevel != facade.getLevel() || aInterval != facade.getInterval()) continue;
                found = true;
                break;
            }
            if (!found) {
                def = ns.getAttributeDefinition(bOE, bAttrName);
                vl2 = TypedNameFacade.createValueList((String)aName, (long)aLevel, (long)aInterval, (Syntax)def.getSyntax());
                bAttrib.addComponent((ValueComponent)vl2);
            }
        } else {
            AttributeDefinition def3 = ns.getAttributeDefinition(bOE, bAttrName);
            bAttrib = new ObjectAttribute(def3);
            vl = TypedNameFacade.createValueList((String)aName, (long)aLevel, (long)aInterval, (Syntax)def3.getSyntax());
            bAttrib.addComponent((ValueComponent)vl);
            bObj.addAttribute(bAttrib);
        }
    }

    public static void removeTypedNameRelation(NSObject aObj, NSObject bObj, String aAttrName, String bAttrName, long aLevel, long aInterval, long bLevel, long bInterval) {
        TypedNameFacade facade;
        boolean found;
        ObjectEntry aOE = aObj.getObjectEntry();
        ObjectEntry bOE = bObj.getObjectEntry();
        AdminNamespace ns = aOE.getAdminNamespace();
        String aName = ns.getUnrootedName(aOE);
        String bName = ns.getUnrootedName(bOE);
        ObjectAttribute aAttrib = aObj.getAttribute(aAttrName);
        ObjectAttribute bAttrib = bObj.getAttribute(bAttrName);
        if (aAttrib != null) {
            found = false;
            Enumeration myenum = aAttrib.getValueComponents();
            ValueList vl = null;
            while (myenum.hasMoreElements()) {
                vl = (ValueList)myenum.nextElement();
                facade = (TypedNameFacade)vl.createFacade();
                if (!bName.equalsIgnoreCase(facade.getObject()) || bLevel != facade.getLevel() || bInterval != facade.getInterval()) continue;
                found = true;
                break;
            }
            if (found && vl != null) {
                aAttrib.removeComponent((ValueComponent)vl);
            }
        }
        if (bAttrib != null) {
            found = false;
            ValueList vl = null;
            Enumeration myenum = bAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                vl = (ValueList)myenum.nextElement();
                facade = (TypedNameFacade)vl.createFacade();
                if (!aName.equalsIgnoreCase(facade.getObject()) || aLevel != facade.getLevel() || aInterval != facade.getInterval()) continue;
                found = true;
                break;
            }
            if (found && vl != null) {
                bAttrib.removeComponent((ValueComponent)vl);
            }
        }
    }

    public static boolean compareAttribute(ObjectEntry oe, String attrName, String distName) throws SPIException, NamespaceException, ComponentCreationException {
        boolean flag = false;
        AdminNamespace ns = oe.getAdminNamespace();
        Syntax syntax = ns.getSchemaDefinition(oe).getAttributeDefinition(attrName).getSyntax();
        AttributeDefinition attrDef = ns.getAttributeDefinition(oe, attrName);
        ValueComponent[] vc = new ValueComponent[]{syntax.createValueComponent((Object)distName)};
        ObjectAttribute objAttr = new ObjectAttribute(attrDef, vc);
        flag = ns.compareAttribute(oe, objAttr);
        return flag;
    }

    public static String[] getDNStrings(ObjectEntry oe, NSObject nsObj, String attrName) throws SPIException {
        Vector<String> v = new Vector<String>(10);
        Enumeration myenum = null;
        Object[] strArray = null;
        myenum = NSModel.getAttribute(oe, nsObj, attrName);
        if (myenum != null) {
            while (myenum.hasMoreElements()) {
                String dn = myenum.nextElement().toString();
                v.addElement(dn);
            }
            strArray = new String[v.size()];
            v.copyInto(strArray);
            return strArray;
        }
        return null;
    }
}

