/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSObject;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.JDOMException;

public class RBACRole
extends RBSObject {
    Document doc = null;

    public RBACRole(ObjectEntry objectOE) {
        super(objectOE);
    }

    public RBACRole(NSObject obj) {
        super(obj);
    }

    public String getContext() throws SPIException {
        this.verifyNSObject();
        String[] context = NSModel.getDNStrings(this.oe, this.nsObj, "rbsContext");
        if (context != null) {
            return context[0];
        }
        return null;
    }

    public void setContext(ObjectEntry context) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.verifyNSObject();
        if (context == null) {
            NSModel.setDN(this.oe, this.nsObj, "rbsContext", null);
        } else {
            ObjectEntry[] entries = new ObjectEntry[]{context};
            NSModel.setDN(this.oe, this.nsObj, "rbsContext", entries);
        }
    }

    public ObjectEntry[] getStaticRoleMembers() throws SPIException {
        this.verifyNSObject();
        ObjectEntry[] members = NSModel.getDN(this.oe, this.nsObj, "rbacStaticRoleMember");
        if (members != null) {
            return members;
        }
        return null;
    }

    public void addStaticRoleMember(ObjectEntry member) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.verifyNSObject();
        NSModel.addDN(this.oe, this.nsObj, "rbacStaticRoleMember", new ObjectEntry[]{member});
    }

    public void deleteStaticRoleMember(ObjectEntry member) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.verifyNSObject();
        NSModel.deleteDN(this.oe, this.nsObj, "rbacStaticRoleMember", new ObjectEntry[]{member});
    }

    public String getInheritable() throws SPIException, JDOMException, IOException {
        if (this.doc == null) {
            this.doc = this.getrbsXMLInfo();
        }
        if (this.doc == null) {
            return "";
        }
        String text = this.doc.getRootElement().getChild("rbs-Inheritable").getTextTrim();
        return text;
    }

    public void addRoleMember(ObjectEntry member) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.verifyNSObject();
        NSModel.addDN(this.oe, this.nsObj, "rbsRoleMember", new ObjectEntry[]{member});
    }

    public ObjectEntry[] getRoleMember() throws SPIException {
        return NSModel.getDN(this.oe, this.nsObj, "rbsRoleMember");
    }
}

