/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSTask;
import com.novell.rbs.RBSUtil;
import java.util.Enumeration;
import java.util.Vector;

public class RBSModule
extends RBSObject {
    public RBSModule(ObjectEntry objectOE) {
        super(objectOE);
    }

    public RBSModule(NSObject obj) {
        super(obj);
    }

    public ValueList[] getPath() throws SPIException {
        this.verifyNSObject();
        Enumeration valueSet = NSModel.getAttribute(this.oe, this.nsObj, "rbsPath");
        if (valueSet != null) {
            Vector vect = new Vector(10);
            while (valueSet.hasMoreElements()) {
                vect.addElement(valueSet.nextElement());
            }
            Object[] vl = new ValueList[vect.size()];
            vect.copyInto(vl);
            return vl;
        }
        return null;
    }

    public void setPath(ValueList[] valueList) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        NSModel.setValueComponents(this.oe, this.nsObj, "rbsPath", (ValueComponent[])valueList);
    }

    public String getType() throws SPIException, NamespaceException {
        this.verifyNSObject();
        String[] values = NSModel.getStrings(this.oe, this.nsObj, "rbsType");
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public void setType(String type) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (type == null || type.length() == 0) {
            NSModel.setStrings(this.oe, this.nsObj, "rbsType", null);
        } else {
            String[] values = new String[]{type};
            NSModel.setStrings(this.oe, this.nsObj, "rbsType", values);
        }
    }

    public RBSObject[] getTasks() throws SPIException {
        ResultModifier rm = new ResultModifier("");
        if (this.objectClassName.equalsIgnoreCase("rbsModule2")) {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsTask2", "rbsBook2"}));
        } else {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsTask", "rbsBook"}));
        }
        Vector<Object> entries = new Vector<Object>(10);
        ObjectEntryEnumeration children = this.ns.getChildren(this.getObjectEntry(), rm);
        while (children.hasMoreElements()) {
            entries.addElement(children.nextElement());
        }
        if (entries.size() == 0) {
            return null;
        }
        RBSObject[] tasks = new RBSObject[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            ObjectEntry oe = (ObjectEntry)entries.elementAt(i);
            tasks[i] = oe.getObjectType().getName().equalsIgnoreCase("rbsTask2") || oe.getObjectType().getName().equalsIgnoreCase("rbsTask") ? new RBSTask(oe) : new RBSBook(oe);
        }
        return tasks;
    }

    public RBSObject[] getSpecifiedTasks(String[] types) throws SPIException {
        String[] theTypes = types;
        if (theTypes == null) {
            theTypes = new String[]{"iManager"};
        }
        ResultModifier rm = new ResultModifier("");
        if (this.objectClassName.equalsIgnoreCase("rbsModule2")) {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsTask2", "rbsBook2"}));
        } else {
            rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsTask", "rbsBook"}));
        }
        ObjectEntryEnumeration children = null;
        children = this.ns.getChildren(this.getObjectEntry(), rm);
        Vector<ObjectEntry> entries = new Vector<ObjectEntry>(10);
        block0: while (children.hasMoreElements()) {
            ObjectEntry oe = (ObjectEntry)children.nextElement();
            String type = RBSUtil.getTypeFromParameters(oe);
            for (int j = 0; j < theTypes.length; ++j) {
                if (!type.equalsIgnoreCase(theTypes[j])) continue;
                entries.addElement(oe);
                continue block0;
            }
        }
        if (entries.size() == 0) {
            return null;
        }
        RBSObject[] tasks = new RBSObject[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            ObjectEntry oe = (ObjectEntry)entries.elementAt(i);
            tasks[i] = oe.getObjectType().getName().equalsIgnoreCase("rbsTask") || oe.getObjectType().getName().equalsIgnoreCase("rbsTask2") ? new RBSTask(oe) : new RBSBook(oe);
        }
        return tasks;
    }
}

