/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.ns.nds.ObjectACLFacade;
import java.util.Vector;

public class RBSRights {
    protected String subjectName;
    protected String protectedAttrName;
    protected long priv;

    public RBSRights() {
        this.subjectName = null;
        this.protectedAttrName = null;
        this.priv = 0L;
    }

    public RBSRights(String subject, String attr, long privileges) {
        this.subjectName = subject;
        this.protectedAttrName = attr;
        this.priv = privileges;
    }

    public RBSRights(ObjectACLFacade facade) {
        this.subjectName = facade.getSubjectName();
        this.protectedAttrName = facade.getProtectedAttrName();
        this.priv = facade.getPrivileges();
    }

    public RBSRights(String subject, String attr, String[] privilegeStrings) {
        this.subjectName = subject;
        this.protectedAttrName = attr;
        this.priv = this.convertPrivilegeStringsToLong(privilegeStrings);
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String name) {
        this.subjectName = name;
    }

    public String getProtectedAttrName() {
        return this.protectedAttrName;
    }

    public void setProtectedAttrName(String name) {
        this.protectedAttrName = name;
    }

    public long getPrivileges() {
        return this.priv;
    }

    public void setPrivileges(long privileges) {
        this.priv = privileges;
    }

    public boolean equals(RBSRights rights) {
        return this.subjectName.equalsIgnoreCase(rights.getSubjectName()) && this.protectedAttrName.equalsIgnoreCase(rights.getProtectedAttrName()) && this.priv == rights.getPrivileges();
    }

    public boolean equals(RBSRights rights, boolean trustee, boolean attr, boolean privledge) {
        if (trustee && !this.subjectName.equalsIgnoreCase(rights.getSubjectName())) {
            return false;
        }
        if (attr && !this.protectedAttrName.equalsIgnoreCase(rights.getProtectedAttrName())) {
            return false;
        }
        return !privledge || this.priv == rights.getPrivileges();
    }

    private long convertPrivilegeStringsToLong(String[] privilegeStrings) {
        long prvlg = 0L;
        if (this.protectedAttrName.equalsIgnoreCase("[Entry Rights]")) {
            for (int i = 0; i < privilegeStrings.length; ++i) {
                String privilege = privilegeStrings[i];
                if (privilege.equalsIgnoreCase("Supervisor")) {
                    prvlg |= 0x10L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Browse")) {
                    prvlg |= 1L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Create")) {
                    prvlg |= 2L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Delete")) {
                    prvlg |= 4L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Rename")) {
                    prvlg |= 8L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Self")) {
                    prvlg |= Integer.MIN_VALUE;
                    continue;
                }
                if (!privilege.equalsIgnoreCase("Inheritable")) continue;
                prvlg |= 0x40L;
            }
        } else {
            for (int i = 0; i < privilegeStrings.length; ++i) {
                String privilege = privilegeStrings[i];
                if (privilege.equalsIgnoreCase("Supervisor")) {
                    prvlg |= 0x20L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Compare")) {
                    prvlg |= 1L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Read")) {
                    prvlg |= 2L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Write")) {
                    prvlg |= 4L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Add Self")) {
                    prvlg |= 8L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Self")) {
                    prvlg |= Integer.MIN_VALUE;
                    continue;
                }
                if (!privilege.equalsIgnoreCase("Inheritable")) continue;
                prvlg |= 0x40L;
            }
        }
        return prvlg;
    }

    public String[] convertLongToPrivilegeStrings() {
        Vector<String> privilegeStrings = new Vector<String>();
        if (this.protectedAttrName.equalsIgnoreCase("[Entry Rights]")) {
            if ((this.priv & 0x10L) == 16L) {
                privilegeStrings.add("Supervisor");
            }
            if ((this.priv & 1L) == 1L) {
                privilegeStrings.add("Browse");
            }
            if ((this.priv & 2L) == 2L) {
                privilegeStrings.add("Create");
            }
            if ((this.priv & 4L) == 4L) {
                privilegeStrings.add("Delete");
            }
            if ((this.priv & 8L) == 8L) {
                privilegeStrings.add("Rename");
            }
            if ((this.priv & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                privilegeStrings.add("Self");
            }
            if ((this.priv & 0x40L) == 64L) {
                privilegeStrings.add("Inheritable");
            }
        } else {
            if ((this.priv & 0x20L) == 32L) {
                privilegeStrings.add("Supervisor");
            }
            if ((this.priv & 1L) == 1L) {
                privilegeStrings.add("Compare");
            }
            if ((this.priv & 2L) == 2L) {
                privilegeStrings.add("Read");
            }
            if ((this.priv & 4L) == 4L) {
                privilegeStrings.add("Write");
            }
            if ((this.priv & 8L) == 8L) {
                privilegeStrings.add("Add Self");
            }
            if ((this.priv & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                privilegeStrings.add("Self");
            }
            if ((this.priv & 0x40L) == 64L) {
                privilegeStrings.add("Inheritable");
            }
        }
        if (privilegeStrings.size() == 0) {
            return null;
        }
        Object[] strings = new String[privilegeStrings.size()];
        privilegeStrings.copyInto(strings);
        return strings;
    }
}

