/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.obj;

import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.obj.GroupOfURLs;
import com.sun.jndi.ldap.obj.LdapPrincipal;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.NamingManager;

public class GroupOfNames
implements Group {
    private static final boolean debug = false;
    private static final String OBJECT_CLASS = "groupOfNames";
    private static final String MEMBER_ATTR_ID = "member";
    private static final String MEMBER_FILTER_EXPR = "(member={0})";
    private static final String EXPAND_GROUP = "com.sun.jndi.ldap.obj.expandGroup";
    private static final Attribute OBJECT_CLASS_ATTR = new BasicAttribute("objectClass", "top");
    private static final SearchControls BASE_SEARCH_NO_ATTRS;
    private boolean objectIsBound;
    private boolean expandGroup = true;
    private Attributes attributes = null;
    private Attribute memberAttr = null;
    private String memberAttrId;
    private String memberFilterExpr;
    private Object[] filterArgs = new Object[1];
    private ModificationItem[] modification = new ModificationItem[1];
    private String groupDN = null;
    private String bindDN = null;
    private DirContext rootCtx = null;
    private DirContext ctx = null;
    private DirContext bindCtx = null;
    private Name name = null;
    private Name bindName = null;
    private Hashtable env = null;

    public GroupOfNames() {
        this.initializeState(OBJECT_CLASS_ATTR, MEMBER_ATTR_ID, MEMBER_FILTER_EXPR, null);
    }

    public GroupOfNames(Set set) {
        this.initializeState(OBJECT_CLASS_ATTR, MEMBER_ATTR_ID, MEMBER_FILTER_EXPR, set);
    }

    GroupOfNames(Attribute attribute, String string, String string2, Set set) {
        this.initializeState(attribute, string, string2, set);
    }

    GroupOfNames(Attribute attribute, String string, String string2, Set set, String string3, DirContext dirContext, Name name, Hashtable hashtable, Attributes attributes) {
        this.initializeState(attribute, string, string2, set);
        this.initializeBoundState(string3, dirContext, name, hashtable, attributes);
    }

    static Object getObjectInstance(String string, DirContext dirContext, Name name, Hashtable hashtable, Attributes attributes) {
        return new GroupOfNames(OBJECT_CLASS_ATTR, MEMBER_ATTR_ID, MEMBER_FILTER_EXPR, null, string, dirContext, name, hashtable, attributes);
    }

    public boolean addMember(Principal principal) {
        try {
            return this.addMember(principal.getName());
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public boolean addMember(String string) throws NamingException {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        return this.modifyMember(string, 1);
    }

    public boolean isMember(Principal principal) {
        try {
            return this.isMember(principal.getName());
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public boolean isMember(String string) throws NamingException {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        if (this.memberAttr != null && this.memberAttr.contains(string)) {
            return true;
        }
        this.filterArgs[0] = string;
        NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search(this.name, this.memberFilterExpr, this.filterArgs, BASE_SEARCH_NO_ATTRS);
        if (namingEnumeration != null && namingEnumeration.hasMore()) {
            namingEnumeration.close();
            return true;
        }
        if (this.expandGroup) {
            return this.isSubgroupMember(string);
        }
        return false;
    }

    public Enumeration members() {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        try {
            if (this.memberAttr != null || (this.memberAttr = this.ctx.getAttributes(this.name, new String[]{this.memberAttrId}).get(this.memberAttrId)) != null) {
                return new Members(this.memberAttr.getAll());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return new Members();
    }

    public boolean removeMember(Principal principal) {
        try {
            return this.removeMember(principal.getName());
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public boolean removeMember(String string) throws NamingException {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        return this.modifyMember(string, 3);
    }

    public String getName() {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        return this.groupDN;
    }

    void setName(String string, DirContext dirContext, Name name) {
        this.bindDN = string;
        this.bindCtx = dirContext;
        this.bindName = name;
    }

    public String toString() {
        this.isBound();
        if (this.groupDN != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{name: ").append(this.groupDN).append("}");
            if (this.attributes != null) {
                stringBuffer.append(this.attributes.toString());
            }
            return stringBuffer.toString();
        }
        return this.attributes == null ? null : this.attributes.toString();
    }

    Attributes getAttributes() {
        return this.attributes;
    }

    static boolean matches(Attribute attribute) {
        try {
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                if (!OBJECT_CLASS.equalsIgnoreCase((String)namingEnumeration.nextElement())) continue;
                return true;
            }
        }
        catch (NamingException namingException) {}
        return false;
    }

    private boolean isBound() {
        if (this.objectIsBound) {
            return true;
        }
        if (this.bindCtx != null && this.bindName != null && this.attributes != null) {
            try {
                Attributes attributes = this.bindCtx.getAttributes(this.bindName);
                Attribute attribute = attributes.get("objectClass");
                if (attribute != null && attribute.equals(this.attributes.get("objectClass"))) {
                    this.initializeBoundState(this.bindDN, this.bindCtx, this.bindName, this.env, attributes);
                    return true;
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.bindDN = null;
            this.bindCtx = null;
            this.bindName = null;
        }
        return false;
    }

    public void close() throws NamingException {
        if (this.rootCtx != null && this.rootCtx != this.ctx) {
            this.rootCtx.close();
            this.rootCtx = null;
        }
    }

    private void initializeState(Attribute attribute, String string, String string2, Set set) {
        this.objectIsBound = false;
        this.memberAttrId = string;
        this.memberFilterExpr = string2;
        this.attributes = new BasicAttributes(true);
        this.attributes.put(attribute);
        if (set != null && !set.isEmpty()) {
            this.memberAttr = new BasicAttribute(string);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Principal) {
                    this.memberAttr.add(((Principal)e).getName());
                    continue;
                }
                this.memberAttr.add(e);
            }
            this.attributes.put(this.memberAttr);
        }
    }

    private void initializeBoundState(String string, DirContext dirContext, Name name, Hashtable hashtable, Attributes attributes) {
        String string2;
        this.objectIsBound = true;
        this.groupDN = string;
        this.ctx = dirContext;
        this.name = name;
        this.env = hashtable;
        if (hashtable == null && dirContext != null) {
            try {
                this.env = dirContext.getEnvironment();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (hashtable != null && "false".equalsIgnoreCase(string2 = (String)hashtable.get(EXPAND_GROUP))) {
            this.expandGroup = false;
        }
        if (attributes != null) {
            this.attributes = attributes;
            this.memberAttr = attributes.get(this.memberAttrId);
        }
    }

    private boolean modifyMember(String string, int n) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(this.memberAttrId, string);
        this.modification[0] = new ModificationItem(n, basicAttribute);
        this.ctx.modifyAttributes(this.name, this.modification);
        this.memberAttr = null;
        return true;
    }

    private boolean isSubgroupMember(String string) throws NamingException {
        NamingEnumeration namingEnumeration = (NamingEnumeration)this.members();
        while (namingEnumeration.hasMore()) {
            Object t = namingEnumeration.next();
            if (t instanceof GroupOfNames && ((GroupOfNames)t).isMember(string)) {
                namingEnumeration.close();
                return true;
            }
            if (!(t instanceof GroupOfURLs) || !((GroupOfURLs)t).isMember(string)) continue;
            namingEnumeration.close();
            return true;
        }
        return false;
    }

    static Hashtable generateRootContextProperties(Hashtable hashtable) {
        String string = null;
        if (hashtable != null) {
            string = (String)hashtable.get("java.naming.provider.url");
            if (string != null) {
                try {
                    LdapURL ldapURL = new LdapURL(string);
                    String string2 = ldapURL.getDN();
                    if (string2 != null && string2.length() > 0) {
                        String string3 = ldapURL.getHost();
                        int n = ldapURL.getPort();
                        string = "ldap://" + (string3 != null ? string3 : "") + (n != -1 ? ":" + n : "");
                    } else {
                        string = null;
                    }
                }
                catch (NamingException namingException) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (string != null) {
                hashtable = (Hashtable)hashtable.clone();
                hashtable.put("java.naming.provider.url", string);
            }
        }
        return hashtable;
    }

    static {
        OBJECT_CLASS_ATTR.add(OBJECT_CLASS);
        BASE_SEARCH_NO_ATTRS = new SearchControls();
        BASE_SEARCH_NO_ATTRS.setSearchScope(0);
        BASE_SEARCH_NO_ATTRS.setReturningAttributes(new String[0]);
    }

    class Members
    implements NamingEnumeration {
        private NamingEnumeration memberDNs = null;
        private boolean expandSubgroups;
        private ArrayList subgroups = null;
        private NamingEnumeration subgroupMembers = null;

        Members() {
            this.expandSubgroups = GroupOfNames.this.expandGroup;
        }

        Members(NamingEnumeration namingEnumeration) {
            this.memberDNs = namingEnumeration;
            this.expandSubgroups = GroupOfNames.this.expandGroup;
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException namingException) {
                return false;
            }
        }

        public boolean hasMore() throws NamingException {
            if (this.memberDNs == null) {
                return false;
            }
            if (this.memberDNs.hasMore()) {
                return true;
            }
            if (this.expandSubgroups && this.subgroups != null) {
                if (this.subgroupMembers == null && !this.subgroups.isEmpty()) {
                    this.subgroupMembers = (NamingEnumeration)((Group)this.subgroups.remove(0)).members();
                }
                if (this.subgroupMembers.hasMore()) {
                    return true;
                }
                if (!this.subgroups.isEmpty()) {
                    this.subgroupMembers = (NamingEnumeration)((Group)this.subgroups.remove(0)).members();
                    return this.subgroupMembers.hasMore();
                }
            }
            return false;
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException(namingException.toString());
            }
        }

        public Object next() throws NamingException {
            if (this.memberDNs == null) {
                throw new NoSuchElementException();
            }
            String string = null;
            try {
                if (this.memberDNs.hasMore()) {
                    Object object;
                    string = (String)this.memberDNs.next();
                    if (!GroupOfNames.this.expandGroup) {
                        return new LdapPrincipal(string);
                    }
                    if (GroupOfNames.this.rootCtx == null) {
                        GroupOfNames.this.rootCtx = this.getRootContext();
                    }
                    if ((object = GroupOfNames.this.rootCtx.lookup(new CompositeName().add(string))) instanceof Group) {
                        if (this.expandSubgroups) {
                            if (this.subgroups == null) {
                                this.subgroups = new ArrayList();
                            }
                            this.subgroups.add(object);
                        }
                        return (Group)object;
                    }
                    if (object instanceof DirContext) {
                        ((DirContext)object).close();
                        return new LdapPrincipal(string);
                    }
                    return object;
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                return new LdapPrincipal(string);
            }
            if (this.expandSubgroups && this.subgroups != null) {
                if (this.subgroupMembers == null && !this.subgroups.isEmpty()) {
                    this.subgroupMembers = (NamingEnumeration)((Group)this.subgroups.remove(0)).members();
                }
                if (this.subgroupMembers.hasMore()) {
                    return this.subgroupMembers.next();
                }
                if (!this.subgroups.isEmpty()) {
                    this.subgroupMembers = (NamingEnumeration)((Group)this.subgroups.remove(0)).members();
                    return this.subgroupMembers.next();
                }
            }
            throw new NoSuchElementException();
        }

        public void close() throws NamingException {
            if (this.subgroupMembers != null) {
                this.subgroupMembers.close();
            }
        }

        private DirContext getRootContext() throws NamingException {
            DirContext dirContext = null;
            if (GroupOfNames.this.ctx.getNameInNamespace().length() == 0) {
                dirContext = GroupOfNames.this.ctx;
            } else {
                GroupOfNames.this.env = GroupOfNames.generateRootContextProperties(GroupOfNames.this.env);
                dirContext = (DirContext)NamingManager.getInitialContext(GroupOfNames.this.env);
                if (GroupOfNames.this.ctx instanceof LdapContext) {
                    ((LdapContext)dirContext).setRequestControls(((LdapContext)GroupOfNames.this.ctx).getRequestControls());
                }
            }
            return dirContext;
        }
    }
}

