/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTreeConnectAndX;
import jcifs.smb.SmbComTreeConnectAndXResponse;
import jcifs.smb.SmbComTreeDisconnect;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;
import jcifs.util.LogStream;

class SmbTree {
    private static int tree_conn_counter;
    private int tid;
    private String share;
    String service = "?????";
    SmbSession session;
    boolean treeConnected;
    boolean inDfs;
    int tree_num;

    SmbTree(SmbSession session, String share, String service) {
        this.session = session;
        this.share = share.toUpperCase();
        if (service != null && !service.startsWith("??")) {
            this.service = service;
        }
    }

    boolean matches(String share, String service) {
        return this.share.equalsIgnoreCase(share) && (service == null || service.startsWith("??") || this.service.equalsIgnoreCase(service));
    }

    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        if (response != null) {
            response.received = false;
        }
        this.treeConnect(request, response);
        if (request == null || response != null && response.received) {
            return;
        }
        if (!this.service.equals("A:")) {
            block1 : switch (request.command) {
                case -94: 
                case 4: 
                case 45: 
                case 46: 
                case 47: 
                case 113: {
                    break;
                }
                case 37: 
                case 50: {
                    switch (((SmbComTransaction)request).subCommand & 0xFF) {
                        case 0: 
                        case 16: 
                        case 35: 
                        case 38: 
                        case 83: 
                        case 84: 
                        case 104: 
                        case 215: {
                            break block1;
                        }
                    }
                    throw new SmbException("Invalid operation for " + this.service + " service");
                }
                default: {
                    throw new SmbException("Invalid operation for " + this.service + " service" + request);
                }
            }
        }
        request.tid = this.tid;
        if (this.inDfs && request.path != null && request.path.length() > 0) {
            request.flags2 = 4096;
            request.path = '\\' + this.session.transport().tconHostName + '\\' + this.share + request.path;
        }
        try {
            this.session.send(request, response);
        }
        catch (SmbException se) {
            if (se.getNtStatus() == -1073741623) {
                this.treeDisconnect(true);
            }
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void treeConnect(ServerMessageBlock andx, ServerMessageBlock andxResponse) throws SmbException {
        SmbTransport transport = this.session.transport();
        Object object = transport.setupDiscoLock;
        synchronized (object) {
            SmbTransport smbTransport = transport;
            synchronized (smbTransport) {
                if (this.treeConnected) {
                    return;
                }
                this.session.transport.connect();
                String unc = "\\\\" + this.session.transport.tconHostName + '\\' + this.share;
                SmbTransport cfr_ignored_0 = this.session.transport;
                if (LogStream.level > 2) {
                    SmbTransport cfr_ignored_1 = this.session.transport;
                    SmbTransport.log.println("treeConnect: unc=" + unc + ",service=" + this.service);
                }
                SmbComTreeConnectAndXResponse response = new SmbComTreeConnectAndXResponse(andxResponse);
                SmbComTreeConnectAndX request = new SmbComTreeConnectAndX(this.session, unc, this.service, andx);
                this.session.send(request, response);
                this.tid = response.tid;
                this.service = response.service;
                this.inDfs = response.shareIsInDfs;
                this.treeConnected = true;
                this.tree_num = tree_conn_counter++;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void treeDisconnect(boolean inError) {
        SmbTransport smbTransport = this.session.transport;
        synchronized (smbTransport) {
            block6: {
                if (this.treeConnected && !inError) {
                    try {
                        this.send(new SmbComTreeDisconnect(), null);
                    }
                    catch (SmbException se) {
                        SmbTransport cfr_ignored_0 = this.session.transport;
                        if (LogStream.level <= 1) break block6;
                        SmbTransport cfr_ignored_1 = this.session.transport;
                        se.printStackTrace(SmbTransport.log);
                    }
                }
            }
            this.treeConnected = false;
        }
    }

    public String toString() {
        return "SmbTree[share=" + this.share + ",service=" + this.service + ",tid=" + this.tid + ",inDfs=" + this.inDfs + ",treeConnected=" + this.treeConnected + "]";
    }
}

