/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.MibException;
import Snmp2.SnmpCounter;
import Snmp2.SnmpCounter64;
import Snmp2.SnmpException;
import Snmp2.SnmpGauge;
import Snmp2.SnmpInt;
import Snmp2.SnmpIpAddress;
import Snmp2.SnmpOID;
import Snmp2.SnmpOpaque;
import Snmp2.SnmpString;
import Snmp2.SnmpTimeticks;
import Snmp2.SnmpVar;
import java.util.Enumeration;
import java.util.Vector;

public class LeafSyntax {
    public String name;
    public String description;
    public byte type;
    public String equivName;
    public String[] enumLabel;
    public int[] enumInt;
    public int size = Integer.MAX_VALUE;
    public long MIN = Integer.MIN_VALUE;
    public long MAX = Integer.MAX_VALUE;

    public LeafSyntax(String nam, byte Type) {
        this.name = nam;
        this.type = Type;
        if (Type == 64) {
            this.size = 4;
        } else if (Type == 66) {
            this.MIN = 0L;
            this.MAX = -1L;
        } else if (Type == 65) {
            this.MIN = 0L;
            this.MAX = -1L;
        } else if (Type == 67) {
            this.MIN = 0L;
            this.MAX = -1L;
        } else if (Type == 71) {
            this.MIN = 0L;
            this.MAX = -1L;
        } else if (Type == 70) {
            this.MIN = 0L;
            this.MAX = -1L;
        }
        if (nam != null && nam.equals("RowStatus")) {
            String[] enumlabel_ = new String[]{"active", "notInService", "notReady", "createAndGo", "createAndWait", "destroy"};
            this.enumLabel = enumlabel_;
            int[] enumInt_ = new int[]{1, 2, 3, 4, 5, 6};
            this.enumInt = enumInt_;
        }
    }

    public LeafSyntax(String nam, Vector toks, LeafSyntax syntax) throws MibException {
        String str;
        Enumeration e;
        if (nam.equals("Node")) {
            StringBuffer s = new StringBuffer();
            e = toks.elements();
            while (e.hasMoreElements()) {
                str = (String)e.nextElement();
                if (str.startsWith("0.")) {
                    s.append(".." + str.substring(2) + " ");
                    continue;
                }
                s.append(String.valueOf(str) + " ");
            }
            this.name = s.toString();
        } else {
            this.name = nam;
        }
        if (syntax == null) {
            return;
        }
        this.equivName = syntax.name;
        this.type = syntax.type;
        this.size = syntax.size;
        this.MIN = syntax.MIN;
        this.MAX = syntax.MAX;
        this.enumLabel = syntax.enumLabel;
        this.enumInt = syntax.enumInt;
        if (toks.size() <= 1) {
            return;
        }
        e = toks.elements();
        e.nextElement();
        if (((String)e.nextElement()).equals("{")) {
            Vector<String> labels = new Vector<String>();
            Vector<Integer> ints = new Vector<Integer>();
            block13: while ((str = this.nextUsefulToken(e)) != null) {
                labels.addElement(str);
                while ((str = this.nextUsefulToken(e)) != null) {
                    try {
                        ints.addElement(new Integer(new Double(str).intValue()));
                        continue block13;
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            ints.addElement(new Integer(this.parseHexToInt(str)));
                            continue block13;
                        }
                        catch (NumberFormatException numberFormatException2) {
                            labels.setElementAt(String.valueOf((String)labels.lastElement()) + str, labels.size() - 1);
                        }
                    }
                }
                throw new MibException("Cannot parse enumerated: " + this.name);
            }
            this.enumInt = new int[ints.size()];
            this.enumLabel = new String[labels.size()];
            int j = 0;
            while (j < ints.size()) {
                this.enumInt[j] = (Integer)ints.elementAt(j);
                this.enumLabel[j] = (String)labels.elementAt(j);
                ++j;
            }
        } else {
            str = this.nextUsefulToken(e);
            if (str == null) {
                throw new MibException("Cannot parse Size (?): " + this.name);
            }
            if ((str.equals("SIZE") || str.equals("size")) && (str = this.nextUsefulToken(e)) == null) {
                throw new MibException("Cannot parse Size SIZE(?): " + this.name);
            }
            try {
                this.MIN = Long.parseLong(str);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.MIN = this.parseHexToLong(str);
                }
                catch (NumberFormatException ex) {
                    System.err.println("Cannot parse MIN value: " + ex);
                }
            }
            if (this.type == 4 || this.type == 68 || this.type == 64) {
                this.size = (int)this.MIN;
            }
            if ((str = this.nextUsefulToken(e)) == null) {
                this.MAX = this.MIN;
                this.MIN = Integer.MIN_VALUE;
                this.size = (int)this.MAX;
            } else {
                if (str.startsWith("0.")) {
                    str = str.substring(2);
                }
                try {
                    this.MAX = Long.parseLong(str);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        this.MAX = this.parseHexToLong(str);
                    }
                    catch (NumberFormatException ex) {
                        System.err.println("Cannot parse MAX value: " + ex);
                    }
                }
                if (this.type == 4 || this.type == 68 || this.type == 64) {
                    this.size = (int)this.MAX;
                }
            }
        }
    }

    public SnmpVar createVariable(String value) throws SnmpException {
        if (this.type == 4) {
            return new SnmpString(value);
        }
        if (this.type == 64) {
            return new SnmpIpAddress(value);
        }
        if (this.type == 68) {
            return new SnmpOpaque(value);
        }
        if (this.type == 6) {
            return new SnmpOID(value);
        }
        if (this.type == 2) {
            int val;
            try {
                val = new Integer(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException("Invalid format for : " + value);
            }
            return new SnmpInt(val);
        }
        if (this.type == 67) {
            long val;
            try {
                val = new Long(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException("Invalid format for : " + value);
            }
            return new SnmpTimeticks(val);
        }
        if (this.type == 65) {
            long val;
            try {
                val = new Long(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException("Invalid format for : " + value);
            }
            return new SnmpCounter(val);
        }
        if (this.type == 70) {
            long[] val = new long[2];
            try {
                val[0] = new Long(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException("Invalid format for : " + value);
            }
            val[1] = val[0] >> 32;
            val[0] = val[0] & 0xFFFFFFFFL;
            return new SnmpCounter64(val);
        }
        if (this.type == 66) {
            long val;
            try {
                val = new Long(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException("Invalid format for : " + value);
            }
            return new SnmpGauge(val);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String toTagString() {
        return this.description;
    }

    public String getLabel(int val) {
        if (this.enumInt == null) {
            return null;
        }
        int i = 0;
        while (i < this.enumInt.length) {
            if (this.enumInt[i] == val) {
                return this.enumLabel[i];
            }
            ++i;
        }
        return null;
    }

    public int getInt(String s) {
        if (this.enumInt == null) {
            return -1;
        }
        int i = 0;
        while (i < this.enumInt.length) {
            if (this.enumLabel[i].equals(s)) {
                return this.enumInt[i];
            }
            ++i;
        }
        return -1;
    }

    public boolean checkValue(int i) {
        if (this.enumInt != null) {
            int j = 0;
            while (j < this.enumInt.length) {
                if (this.enumInt[j] == i) {
                    return true;
                }
                ++j;
            }
            return false;
        }
        if ((long)i < this.MIN) {
            return false;
        }
        return (long)i <= this.MAX;
    }

    public boolean checkValue(String s) {
        if (this.enumLabel != null) {
            int j = 0;
            while (j < this.enumInt.length) {
                if (s.equals(this.enumLabel[j])) {
                    return true;
                }
                ++j;
            }
            return false;
        }
        return s.length() <= this.size;
    }

    String nextUsefulToken(Enumeration e) {
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.equals("{") || s.equals("}") || s.equals("(") || s.equals(")") || s.equals(",") || s.equals("|") || s.equals(".")) continue;
            return s;
        }
        return null;
    }

    long parseHexToLong(String str) throws NumberFormatException {
        if (str.charAt(0) == '\'' && (str.substring(str.length() - 2).equals("'h") || str.substring(str.length() - 2) == "'H")) {
            str = str.substring(1, str.length() - 2);
            return Long.parseLong(str, 16);
        }
        throw new NumberFormatException();
    }

    int parseHexToInt(String str) throws NumberFormatException {
        if (str.charAt(0) == '\'' && (str.substring(str.length() - 2).equals("'h") || str.substring(str.length() - 2) == "'H")) {
            str = str.substring(1, str.length() - 2);
            return Integer.parseInt(str, 16);
        }
        throw new NumberFormatException();
    }
}

