/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.LeafSyntax;
import java.util.Enumeration;
import java.util.Vector;

public class MibNode {
    public String moduleName;
    public String macroType;
    public String label;
    public long subid;
    public Vector childList = new Vector();
    public MibNode parent;
    public LeafSyntax syntax;
    public int access;
    public String status;
    public String description;
    public String reference;
    public Vector indexNames;
    public String defval;
    public String tableSequence;
    public String rowName;
    public Vector tableItems;
    public String units;
    public String lastupdated;
    public String organization;
    public String contactinfo;
    public String revision;
    public String revdescription;
    public Vector moduleCompliance = new Vector();
    public String objectNames;
    public String notificationsNames;
    public String productrelease;
    public Vector supports;
    public Vector includes;
    public Vector variation;
    public Vector acSyntax;
    public Vector acWriteSyntax;
    public Vector acAccess;
    public Vector creation;
    public Vector acDefval;
    public Vector acDescription;

    public String toString() {
        return this.label;
    }

    public String toTagString() {
        StringBuffer s = new StringBuffer();
        s.append("Node OID: " + this.getOIDString());
        s.append("\nSyntax: " + this.syntax);
        if (this.access == 43690) {
            s.append(", Access: read-only");
        } else if (this.access == 43691) {
            s.append(", Access: write-only");
        } else if (this.access == 43706) {
            s.append(", Access: read-write");
        } else if (this.access == 0) {
            s.append(", Access: not-accessible");
        } else if (this.access == 43708) {
            s.append(",Access: read-create");
        } else if (this.access == 1) {
            s.append(",Access: accessible-for-notify");
        }
        s.append(", Status: " + this.status);
        s.append("\nDescription: " + this.description + "\n");
        s.append("Reference: " + this.reference);
        s.append(", Index: " + this.indexNames);
        s.append("\nTableItems: ");
        if (this.tableItems != null) {
            Enumeration e = this.tableItems.elements();
            while (e.hasMoreElements()) {
                s.append(" " + (String)e.nextElement());
            }
        }
        return s.toString();
    }

    public long[] getOID() {
        Vector v = this.getOIDVectorIds();
        long[] oid = new long[v.size()];
        int i = 0;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            oid[i++] = (Long)e.nextElement();
        }
        return oid;
    }

    public String getOIDString() {
        StringBuffer s = new StringBuffer();
        Enumeration e = this.getOIDVector().elements();
        while (e.hasMoreElements()) {
            s.append("." + e.nextElement());
        }
        return s.toString();
    }

    public String getNumberedOIDString() {
        StringBuffer s = new StringBuffer();
        Enumeration e = this.getOIDVectorIds().elements();
        while (e.hasMoreElements()) {
            s.append("." + e.nextElement());
        }
        return s.toString();
    }

    public Vector getOIDVector() {
        Vector<String> ret = new Vector<String>();
        MibNode node = this;
        while (node != null) {
            ret.insertElementAt(node.label, 0);
            node = node.parent;
        }
        return ret;
    }

    public Vector getOIDVectorIds() {
        Vector<Long> ret = new Vector<Long>();
        MibNode node = this;
        while (node != null) {
            ret.insertElementAt(new Long(node.subid), 0);
            node = node.parent;
        }
        return ret;
    }

    public String printAccess() {
        if (this.access == 43690) {
            return "read-only";
        }
        if (this.access == 43691) {
            return "write-only";
        }
        if (this.access == 43706) {
            return "read-write";
        }
        if (this.access == 0) {
            return "not-accessible";
        }
        if (this.access == 43708) {
            return "read-create";
        }
        if (this.access == 1) {
            return "accessible-for-notify";
        }
        return null;
    }

    public String printStatus() {
        return this.status;
    }

    public String printDescription() {
        return this.description;
    }

    public String printReference() {
        return this.reference;
    }

    public Vector printIndex() {
        return this.indexNames;
    }

    public MibNode getNextLeafNode() {
        MibNode node = this;
        do {
            MibNode parent;
            if (node.childList.size() != 0) {
                node = (MibNode)node.childList.firstElement();
                continue;
            }
            do {
                if ((parent = node.parent) == null) {
                    return null;
                }
                Enumeration e = parent.childList.elements();
                while (e.hasMoreElements()) {
                    if (((MibNode)e.nextElement()).label.equals(node.label)) break;
                }
                if (e.hasMoreElements()) {
                    node = (MibNode)e.nextElement();
                    continue;
                }
                node = parent;
                parent = null;
            } while (parent == null);
        } while (node.syntax == null);
        return node;
    }
}

