/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SnmpVar;

public class SnmpBitstring
extends SnmpVar {
    protected static final byte[] s_emptyString = new byte[0];
    protected String value;
    protected byte[] byteValue = s_emptyString;

    static SnmpVar newInstance(byte[] b) {
        SnmpBitstring v = new SnmpBitstring();
        v.Type = (byte)3;
        v.byteValue = b;
        return v;
    }

    protected SnmpBitstring() {
    }

    public SnmpBitstring(String val) {
        this.Type = (byte)3;
        if (val == null) {
            return;
        }
        this.value = val;
        int n = this.value.length();
        this.byteValue = new byte[n];
        this.value.getBytes(0, n, this.byteValue, 0);
    }

    public SnmpBitstring(byte[] b) {
        this.Type = (byte)3;
        if (b == null) {
            return;
        }
        this.byteValue = new byte[b.length];
        System.arraycopy(b, 0, this.byteValue, 0, b.length);
    }

    public Object toValue() {
        return this.toString();
    }

    public String toString() {
        if (this.value == null) {
            this.value = new String(this.byteValue, 0);
        }
        return this.value;
    }

    public String toTagString() {
        return "BITSTRING: " + this.toString();
    }

    public byte[] toBytes() {
        byte[] b = new byte[this.byteValue.length];
        System.arraycopy(this.byteValue, 0, b, 0, this.byteValue.length);
        return b;
    }

    int encode(byte[] buff, int space) throws ArrayIndexOutOfBoundsException {
        if (this.byteValue.length < 1 || this.byteValue[0] < 0 || this.byteValue[0] > 7) {
            System.err.println("Invalid Bitsting: Cannot encode");
        }
        return ASNTypes.encodeOctets(buff, space, this.byteValue, 0, this.byteValue.length, 3);
    }
}

