/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SnmpOID;
import Snmp2.SnmpVar;

public class SnmpInt
extends SnmpVar {
    protected int value;
    protected byte[] byteValue;

    public SnmpInt(int i) {
        this.value = i;
        this.Type = (byte)2;
    }

    public Object toValue() {
        return new Integer(this.value);
    }

    public int intValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public String toTagString() {
        return "INTEGER: " + Integer.toString(this.value);
    }

    public String toEnumString(SnmpOID oid) {
        String s = null;
        if (oid.API != null && SnmpOID.getNodeLookup() && oid.node == null) {
            oid.getNode(oid.API);
        }
        if (oid.node != null && oid.node.syntax != null) {
            s = oid.node.syntax.getLabel(this.value);
        }
        s = s == null ? Integer.toString(this.value) : String.valueOf(s) + " (" + Integer.toString(this.value) + ")";
        return s;
    }

    public String toEnumTagString(SnmpOID oid) {
        return "INTEGER: " + this.toEnumString(oid);
    }

    public byte[] toBytes() {
        if (this.byteValue == null) {
            this.byteValue = new byte[4];
            int v = this.value;
            int i = this.byteValue.length;
            while (v != 0) {
                this.byteValue[--i] = (byte)(v & 0xFF);
                v >>>= 8;
            }
        }
        return this.byteValue;
    }

    int encode(byte[] buff, int space) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeInt(buff, space, this.value, 2);
    }
}

