/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SnmpString;
import Snmp2.SnmpVar;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpIpAddress
extends SnmpString {
    String ipAddr;
    private static final char[] digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    static SnmpVar newInstance(byte[] b) {
        SnmpIpAddress v = new SnmpIpAddress();
        v.Type = (byte)64;
        v.byteValue = b;
        return v;
    }

    protected SnmpIpAddress() {
    }

    public SnmpIpAddress(String s) {
        this.Type = (byte)64;
        if (s != null && !s.equals("0.0.0.0")) {
            try {
                InetAddress addr = InetAddress.getByName(s);
                this.byteValue = addr.getAddress();
            }
            catch (SecurityException e) {
                System.err.println("Security error creating SnmpIpAddress instance." + e);
            }
            catch (UnknownHostException e) {
                System.err.println("Error creating SnmpIpAddress: invalid String arg." + e);
            }
        } else {
            this.byteValue = new byte[4];
        }
    }

    public SnmpIpAddress(byte[] b) {
        this.Type = (byte)64;
        this.byteValue = new byte[4];
        if (b != null && b.length == 4) {
            System.arraycopy(b, 0, this.byteValue, 0, b.length);
        } else {
            System.err.println("Error creating SnmpIpAddress: invalid byte arg.");
        }
    }

    public Object toValue() {
        return super.toString();
    }

    public String toString() {
        if (this.ipAddr == null) {
            this.ipAddr = SnmpIpAddress.netbToString(this.byteValue);
        }
        return this.ipAddr;
    }

    public String toTagString() {
        return "IpAddress: " + this.toString();
    }

    public String toHostName() {
        String s = this.toString();
        try {
            s = InetAddress.getByName(s).getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        return s;
    }

    int encode(byte[] buff, int space) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeOctets(buff, space, this.byteValue, 0, this.byteValue.length, 64);
    }

    public static String netbToString(byte[] rawIpAddr) {
        char[] c = new char[rawIpAddr.length * 4];
        int j = 0;
        int d = 0;
        int i = 0;
        while (i < rawIpAddr.length) {
            d = rawIpAddr[i] & 0xFF;
            if (d > 99) {
                c[j++] = digit[d / 100];
                c[j++] = digit[(d %= 100) / 10];
                d %= 10;
            } else if (d > 9) {
                c[j++] = digit[d / 10];
                d %= 10;
            }
            c[j++] = digit[d];
            c[j++] = 46;
            ++i;
        }
        return new String(c, 0, j - 1);
    }
}

