/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SnmpAPI;
import Snmp2.SnmpBitstring;
import Snmp2.SnmpCounter;
import Snmp2.SnmpCounter64;
import Snmp2.SnmpException;
import Snmp2.SnmpGauge;
import Snmp2.SnmpInt;
import Snmp2.SnmpIpAddress;
import Snmp2.SnmpNsap;
import Snmp2.SnmpNull;
import Snmp2.SnmpOID;
import Snmp2.SnmpOpaque;
import Snmp2.SnmpString;
import Snmp2.SnmpTimeticks;
import Snmp2.SnmpUnsignedInt;
import Snmp2.SnmpVar;
import Snmp2.SnmpVarBind;
import com.novell.net.IpxAddress;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpPDU {
    public InetAddress address;
    public IpxAddress ipxAddress;
    public String remoteHost;
    public int remotePort;
    public byte command;
    public int reqid;
    public int errstat;
    public int errindex;
    public SnmpOID enterprise;
    public InetAddress agent_addr;
    public IpxAddress ipx_agent_addr;
    public int trap_type;
    public int specific_type;
    public long time;
    boolean useWriteValidate = false;
    public Vector variables;
    public String community;
    public String writeCommunity;
    public int timeout;
    public int retries;
    public byte[] data;
    public int version = SnmpAPI.SNMP_VERSION_1;
    public String communityEnc;
    public boolean cloneFlag = true;
    public boolean alwaysEncode = true;
    SnmpAPI API;
    long time_sent;
    long time_expires;
    long time_received;
    private byte[] m_msg;
    private int m_idx;
    private int prefferredBufferSize;

    public SnmpPDU(SnmpAPI api) {
        this.API = api;
        this.variables = new Vector();
        this.enterprise = new SnmpOID(SnmpAPI.Standard_Prefix);
    }

    public void addNull(SnmpOID oid) {
        SnmpVarBind varbind = new SnmpVarBind();
        varbind.oid = oid;
        varbind.variable = new SnmpNull();
        this.variables.addElement(varbind);
    }

    public void fix() {
        if (this.errindex > 0) {
            this.variables.removeElementAt(this.errindex - 1);
        }
    }

    public long round_trip_delay() {
        if (this.time_received > 0L) {
            return this.time_received - this.time_sent;
        }
        return -1L;
    }

    public String printVarBinds() {
        StringBuffer s = new StringBuffer();
        Enumeration e = this.variables.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind varbind = (SnmpVarBind)e.nextElement();
            s.append(varbind.toTagString());
            s.append("\n");
        }
        return s.toString();
    }

    public int get_encoded_length() {
        this.encode(1000);
        if (this.data != null) {
            return this.data.length;
        }
        return -1;
    }

    public SnmpPDU copy() {
        SnmpPDU pdu = new SnmpPDU(this.API);
        pdu.remoteHost = this.remoteHost;
        pdu.remotePort = this.remotePort;
        pdu.time_sent = this.time_sent;
        pdu.time_expires = this.time_expires;
        pdu.time_received = this.time_received;
        pdu.timeout = this.timeout;
        pdu.retries = this.retries;
        if (this.address != null) {
            try {
                pdu.address = InetAddress.getByName(SnmpIpAddress.netbToString(this.address.getAddress()));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if (this.data != null) {
            pdu.data = new byte[this.data.length];
            System.arraycopy(this.data, 0, pdu.data, 0, this.data.length);
        }
        pdu.command = this.command;
        pdu.reqid = this.reqid;
        pdu.errstat = this.errstat;
        pdu.errindex = this.errindex;
        pdu.enterprise = this.enterprise;
        if (this.agent_addr != null) {
            try {
                pdu.agent_addr = InetAddress.getByName(this.agent_addr.getHostName());
            }
            catch (UnknownHostException unknownHostException) {}
        }
        pdu.trap_type = this.trap_type;
        pdu.specific_type = this.specific_type;
        pdu.time = this.time;
        if (this.variables != null) {
            pdu.variables = (Vector)this.variables.clone();
        }
        pdu.community = this.community;
        pdu.writeCommunity = this.writeCommunity;
        return pdu;
    }

    private boolean error(String s) {
        System.err.println(s);
        return false;
    }

    public SnmpPDU(SnmpAPI api, byte[] message) throws SnmpException {
        this.API = api;
        this.variables = new Vector();
        this.data = message;
        this.m_idx = 0;
        try {
            if (this.data == null) {
                throw new SnmpException("Parse\tError: No data to decode.");
            }
            if (this.data[this.m_idx++] != 48) {
                throw new SnmpException("Parse\tAuth: Incorrect\tASN\theader");
            }
            this.decodeLength();
            if (this.data[this.m_idx++] != 2) {
                throw new SnmpException("Parse\tVersion: Incorrect ASN header");
            }
            this.version = this.decodeInteger();
            if (this.version != SnmpAPI.SNMP_VERSION_1 && this.version != SnmpAPI.SNMP_VERSION_2C && this.version != SnmpAPI.SNMP_VERSION_2) {
                System.err.println("Parse Error: Wrong\tSNMP Version: " + this.version);
                System.err.println("Continuing\tAnyway");
            }
            if (this.data[this.m_idx++] != 4) {
                throw new SnmpException("Parse\tCommunity: Incorrect ASN header");
            }
            try {
                this.community = this.communityEnc == null ? new String(this.decodeOctetString(), 0) : new String(this.decodeOctetString(), this.communityEnc);
            }
            catch (UnsupportedEncodingException e) {
                this.community = new String(this.decodeOctetString());
                System.err.println("Error for encoding scheme : " + this.communityEnc + " " + e.getMessage() + " Used default");
            }
            this.command = this.data[this.m_idx++];
            this.decodeLength();
            if (this.command != -92) {
                if (this.data[this.m_idx++] != 2) {
                    throw new SnmpException("Parse\tError: Decoding\treqid.");
                }
                this.reqid = this.decodeInteger();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpException("Parse\tError: unrecognized\tSNMP message");
        }
    }

    public boolean decode() throws SnmpException {
        try {
            if (this.data == null) {
                return this.error("Parse Error:\tNo data\tto decode.");
            }
            if (this.command != -92) {
                if (this.data[this.m_idx++] != 2) {
                    return this.error("Parse Error:\tDecoding errstat.");
                }
                this.errstat = this.decodeInteger();
                if (this.data[this.m_idx++] != 2) {
                    return this.error("Parse Error:\tDecoding errindex.");
                }
                this.errindex = this.decodeInteger();
            } else {
                if (this.data[this.m_idx++] != 6) {
                    return this.error("Parse Error:\tDecoding enterprise.");
                }
                this.enterprise = SnmpOID.newInstance(this.decodeOID(), this.API);
                if (this.data[this.m_idx++] != 64) {
                    return this.error("Parse Error:\tDecoding agent_address.");
                }
                byte[] ipaddr = this.decodeOctetString();
                String ipaddrString = SnmpIpAddress.netbToString(ipaddr);
                try {
                    this.agent_addr = InetAddress.getByName(ipaddrString);
                }
                catch (UnknownHostException unknownHostException) {
                    this.API.client.debugPrint("Unknown\tHost: " + ipaddrString);
                }
                catch (SecurityException securityException) {
                    System.err.println("Security error\tdecoding agent address.");
                }
                if (this.data[this.m_idx++] != 2) {
                    return this.error("Parse Error:\tDecoding trap_type.");
                }
                this.trap_type = this.decodeInteger();
                if (this.data[this.m_idx++] != 2) {
                    return this.error("Parse Error:\tDecoding specific_type.");
                }
                this.specific_type = this.decodeInteger();
                if (this.data[this.m_idx++] != 67) {
                    return this.error("Parse Error:\tDecoding uptime.");
                }
                this.time = (long)this.decodeInteger() & 0xFFFFFFFFL;
            }
            if (this.data[this.m_idx++] != 48) {
                throw new SnmpException("Parse\tAuth: Incorrect\tVarBindList");
            }
            int varBindListLen = this.decodeLength();
            int varBindListEnd = this.m_idx + varBindListLen;
            while (this.m_idx < varBindListEnd) {
                if (this.data[this.m_idx++] != 48) {
                    throw new SnmpException("Parse\tAuth: Incorrect\tVarBind");
                }
                this.decodeLength();
                SnmpVarBind varbind = new SnmpVarBind();
                if (this.data[this.m_idx++] != 6) {
                    return this.error("Parse Error:\tDecoding enterprise.");
                }
                varbind.oid = SnmpOID.newInstance(this.decodeOID(), this.API);
                SnmpVar var = null;
                byte tag = this.data[this.m_idx++];
                switch (tag) {
                    case 2: {
                        var = new SnmpInt(this.decodeInteger());
                        break;
                    }
                    case 4: {
                        var = SnmpString.newInstance(this.decodeOctetString());
                        break;
                    }
                    case 6: {
                        var = SnmpOID.newInstance(this.decodeOID());
                        break;
                    }
                    case 5: {
                        ++this.m_idx;
                        var = new SnmpNull();
                        break;
                    }
                    case 64: {
                        var = SnmpIpAddress.newInstance(this.decodeOctetString());
                        break;
                    }
                    case 65: {
                        var = new SnmpCounter((long)this.decodeInteger() & 0xFFFFFFFFL);
                        break;
                    }
                    case 66: {
                        var = new SnmpGauge((long)this.decodeInteger() & 0xFFFFFFFFL);
                        break;
                    }
                    case 67: {
                        var = new SnmpTimeticks((long)this.decodeInteger() & 0xFFFFFFFFL);
                        break;
                    }
                    case 68: {
                        var = SnmpOpaque.newInstance(this.decodeOctetString());
                        break;
                    }
                    case 3: {
                        var = SnmpBitstring.newInstance(this.decodeOctetString());
                        break;
                    }
                    case 70: {
                        var = new SnmpCounter64(this.decodeLong());
                        break;
                    }
                    case 71: {
                        var = new SnmpUnsignedInt((long)this.decodeInteger() & 0xFFFFFFFFL);
                        break;
                    }
                    case 69: {
                        var = SnmpNsap.newInstance(this.decodeOctetString());
                        break;
                    }
                    case -128: {
                        var = new SnmpNull(-128);
                        ++this.m_idx;
                        varbind.varbindErrindex = var.varbindErrorVal & 0xFF;
                        break;
                    }
                    case -127: {
                        var = new SnmpNull(-127);
                        ++this.m_idx;
                        varbind.varbindErrindex = var.varbindErrorVal & 0xFF;
                        break;
                    }
                    case -126: {
                        var = new SnmpNull(-126);
                        ++this.m_idx;
                        varbind.varbindErrindex = var.varbindErrorVal & 0xFF;
                        break;
                    }
                    default: {
                        throw new SnmpException("Cannot\tdecode ASN Type: " + Integer.toString(tag, 16));
                    }
                }
                varbind.variable = var;
                this.variables.addElement(varbind);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpException("Parse\tError: unrecognized\tSNMP message");
        }
        return true;
    }

    private int decodeLength() throws ArrayIndexOutOfBoundsException {
        int val;
        if ((val = this.data[this.m_idx++]) < 0) {
            int len = val & 0x7F;
            val = 0;
            while (len-- > 0) {
                val = val << 8 | this.data[this.m_idx++] & 0xFF;
            }
        }
        return val;
    }

    private int decodeInteger() throws ArrayIndexOutOfBoundsException {
        int len = this.decodeLength();
        int val = this.data[this.m_idx++];
        while (--len > 0) {
            val = val << 8 | this.data[this.m_idx++] & 0xFF;
        }
        return val;
    }

    private long decodeLong() throws ArrayIndexOutOfBoundsException {
        int len = this.decodeLength();
        long val = this.data[this.m_idx++];
        while (--len > 0) {
            val = val << 8 | (long)(this.data[this.m_idx++] & 0xFF);
        }
        return val;
    }

    private byte[] decodeOctetString() throws ArrayIndexOutOfBoundsException {
        int len = this.decodeLength();
        byte[] val = new byte[len];
        System.arraycopy(this.data, this.m_idx, val, 0, len);
        this.m_idx += len;
        return val;
    }

    private int[] decodeOID() throws ArrayIndexOutOfBoundsException {
        int numBytes = this.decodeLength();
        int end = this.m_idx + numBytes;
        if (numBytes == 0) {
            int[] oid = new int[2];
            oid[1] = 0;
            oid[0] = 0;
            return oid;
        }
        int len = numBytes + 1;
        int i = numBytes - 2;
        int j = this.m_idx + 1;
        while (i > 0) {
            if (this.data[j] < 0) {
                --len;
            }
            --i;
            ++j;
        }
        int[] oid = new int[len];
        int b = this.data[this.m_idx++] & 0xFF;
        oid[0] = b / 40;
        oid[1] = b % 40;
        int i2 = 2;
        while (this.m_idx < end) {
            int subId;
            if ((subId = this.data[this.m_idx++]) < 0) {
                subId &= 0x7F;
                do {
                    b = this.data[this.m_idx++];
                    subId = subId << 7 | b & 0x7F;
                } while (b < 0);
            }
            oid[i2] = subId;
            ++i2;
        }
        return oid;
    }

    public boolean encode(int bufferSize) {
        int endMessage;
        byte[] buff = new byte[Math.max(bufferSize, this.prefferredBufferSize)];
        int checkpoint = endMessage = buff.length;
        int currentVarBind = this.variables.size() - 1;
        boolean encoded = false;
        do {
            try {
                int space = checkpoint;
                while (currentVarBind >= 0) {
                    SnmpVarBind vb = (SnmpVarBind)this.variables.elementAt(currentVarBind);
                    checkpoint = space = vb.encode(buff, space);
                    --currentVarBind;
                }
                space = ASNTypes.encodeSequence(buff, space, endMessage - space, 48);
                if (this.command != -92) {
                    space = ASNTypes.encodeInt(buff, space, this.errindex, 2);
                    space = ASNTypes.encodeInt(buff, space, this.errstat, 2);
                    space = ASNTypes.encodeInt(buff, space, this.reqid, 2);
                } else {
                    space = ASNTypes.encodeUInt(buff, space, (int)this.time, 67);
                    space = ASNTypes.encodeInt(buff, space, this.specific_type, 2);
                    space = ASNTypes.encodeInt(buff, space, this.trap_type, 2);
                    byte[] snmp_addr = null;
                    snmp_addr = this.agent_addr != null ? this.agent_addr.getAddress() : new byte[4];
                    space = ASNTypes.encodeOctets(buff, space, snmp_addr, 0, 4, 64);
                    space = this.enterprise.encode(buff, space);
                }
                space = ASNTypes.encodeSequence(buff, space, endMessage - space, this.command);
                byte[] commBuff = null;
                try {
                    if (this.writeCommunity != null && this.command == -93) {
                        if (this.communityEnc == null) {
                            int n = this.writeCommunity.length();
                            commBuff = new byte[n];
                            this.writeCommunity.getBytes(0, n, commBuff, 0);
                        } else {
                            commBuff = this.writeCommunity.getBytes(this.communityEnc);
                        }
                    } else if (this.community != null) {
                        if (this.communityEnc == null) {
                            int n = this.community.length();
                            commBuff = new byte[n];
                            this.community.getBytes(0, n, commBuff, 0);
                        } else {
                            commBuff = this.community.getBytes(this.communityEnc);
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    commBuff = this.writeCommunity != null && this.command == -93 ? this.writeCommunity.getBytes() : this.community.getBytes();
                    System.err.println("Error for encoding scheme : " + this.communityEnc + " " + e.getMessage() + " Used default");
                }
                space = ASNTypes.encodeOctets(buff, space, commBuff, 0, commBuff != null ? commBuff.length : 0, 4);
                commBuff = null;
                space = ASNTypes.encodeInt(buff, space, this.version, 2);
                space = ASNTypes.encodeSequence(buff, space, endMessage - space, 48);
                this.data = new byte[buff.length - space];
                System.arraycopy(buff, space, this.data, 0, this.data.length);
                encoded = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                byte[] biggerBuff = new byte[buff.length * 2];
                this.prefferredBufferSize = biggerBuff.length;
                int used = buff.length - checkpoint;
                System.arraycopy(buff, checkpoint, biggerBuff, biggerBuff.length - used, used);
                endMessage = biggerBuff.length;
                checkpoint = endMessage - used;
                buff = biggerBuff;
            }
            catch (NullPointerException x) {
                return this.error(((Throwable)x).getMessage());
            }
        } while (!encoded);
        return true;
    }
}

