/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.ASNTypes;
import Snmp2.SASClient;
import Snmp2.SnmpAPI;
import Snmp2.SnmpCallback;
import Snmp2.SnmpClient;
import Snmp2.SnmpException;
import Snmp2.SnmpIpAddress;
import Snmp2.SnmpOID;
import Snmp2.SnmpPDU;
import Snmp2.SnmpVar;
import Snmp2.SnmpVarBind;
import com.novell.net.IpxAddress;
import com.novell.net.IpxDatagramPacket;
import com.novell.net.IpxDatagramSocket;
import java.applet.Applet;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SnmpSession
extends Thread {
    public int version = SnmpAPI.SNMP_VERSION_1;
    public boolean CALLBACK_THREAD = false;
    public int protocol;
    public static final int IP = 0;
    public static final int IPX = 1;
    public String community = "public";
    public int retries;
    public int timeout = 5000;
    public String peername;
    public int remote_port;
    public int local_port;
    private boolean receiverStrt = false;
    public static int startLocalPort = 6000;
    public int encodeBufferSize = 1000;
    public SASClient sasclient;
    public SnmpClient client;
    public String[] local_addrs;
    private String cachedPeername;
    private InetAddress cachedIpAddress;
    private IpxAddress cachedIpxAddress;
    protected int maxDatagramReceiveBuffer = 8000;
    int socketTimeout;
    int socketDelay;
    public String writeCommunity;
    boolean closeSocket = false;
    private SnmpAPI API;
    private DatagramSocket sock;
    private IpxDatagramSocket ipxSock;
    private InetAddress address;
    private IpxAddress ipxAddress;
    Vector requestList = new Vector();
    Vector responseList = new Vector();
    Vector timeouts = new Vector();
    int reqListBegin;
    int respListBegin;
    int timeoutListBegin;
    int RESP_QUEUE_SIZE = 100;
    int TIMEOUT_QUEUE_SIZE = 50;
    SnmpCallback snmpcallback;

    public SnmpSession(SnmpAPI api) {
        this.API = api;
        while (this.API.client == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }

    public void run() {
        this.API.sessionList.addElement(this);
        this.receiver();
    }

    public void setPacketBufferSize(int size) {
        if (size > 8000) {
            this.maxDatagramReceiveBuffer = size;
        }
    }

    public void setSocketParms(int socketTimeout, int socketDelay) {
        if (socketTimeout > 0) {
            this.socketTimeout = socketTimeout;
        }
        if (socketDelay > 0) {
            this.socketDelay = socketDelay;
        }
    }

    public void open() throws SnmpException {
        try {
            if (this.local_port == 0) {
                if (this.protocol == 1) {
                    this.ipxSock = new IpxDatagramSocket();
                    this.local_port = this.ipxSock.getLocalPort();
                } else {
                    this.sock = new DatagramSocket();
                    this.local_port = this.sock.getLocalPort();
                }
            } else if (this.protocol == 1) {
                this.ipxSock = new IpxDatagramSocket(this.local_port);
            } else {
                this.sock = new DatagramSocket(this.local_port);
            }
        }
        catch (SocketException e) {
            if (this.API.DEBUG) {
                if (this.client == null) {
                    this.API.client.debugPrint(e.toString());
                } else {
                    this.client.debugPrint(e.toString());
                }
            }
            throw new SnmpException(e.toString());
        }
        this.start();
        while (!this.receiverStrt) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }

    public void open(Applet applet) throws SnmpException {
        try {
            this.sasclient = new SASClient(applet, this.API.DEBUG);
        }
        catch (SnmpException snmpException) {
            this.sasclient = null;
        }
        if (this.sasclient != null && this.sasclient.connected) {
            System.err.println("Connected to remote socket on applet host.");
            this.sasclient.open(this.local_port);
            this.start();
            return;
        }
        this.sasclient = null;
        block4: while (true) {
            try {
                while (true) {
                    if (this.local_port == 0) {
                        if (this.protocol == 1) {
                            this.ipxSock = new IpxDatagramSocket();
                            this.local_port = this.ipxSock.getLocalPort();
                            continue;
                        }
                        this.sock = System.getProperty("browser", "").equals("ActiveX Scripting Host") ? new DatagramSocket(startLocalPort) : new DatagramSocket();
                        this.local_port = this.sock.getLocalPort();
                        break block4;
                    }
                    if (this.protocol == 1) {
                        this.ipxSock = new IpxDatagramSocket(this.local_port);
                        continue;
                    }
                    this.sock = new DatagramSocket(this.local_port);
                }
            }
            catch (SocketException e) {
                if (this.API.DEBUG) {
                    if (this.client == null) {
                        this.API.client.debugPrint(e.toString());
                    } else {
                        this.client.debugPrint(e.toString());
                    }
                }
                ++startLocalPort;
                continue;
            }
            break;
        }
        this.closeSocket = false;
        this.start();
    }

    public void close() {
        this.API.sessionList.removeElement(this);
        if (this.sasclient != null) {
            this.stop();
            this.sasclient.close();
        } else {
            this.closeSocket = true;
            if (this.protocol == 1) {
                this.ipxSock.close();
            } else {
                this.sock.close();
            }
            if (this.API.DEBUG) {
                if (this.client == null) {
                    this.API.client.debugPrint("Closed socket and stopping SnmpSession Receiver.");
                } else {
                    this.client.debugPrint("Closed socket and stopping SnmpSession Receiver.");
                }
            }
            if (this.snmpcallback != null) {
                this.snmpcallback.stop();
                this.snmpcallback = null;
            }
        }
    }

    public int send(SnmpPDU pdu) throws SnmpException {
        pdu.version = this.version;
        if (pdu.command != -94 && pdu.reqid == 0) {
            pdu.reqid = this.API.genReqID();
        }
        if (this.protocol == 1 && pdu.ipxAddress == null || this.protocol != 1 && pdu.address == null) {
            if (pdu.remoteHost == null && this.peername == null) {
                throw new SnmpException("No remote IP address specified.");
            }
            if (this.sasclient == null) {
                try {
                    if (pdu.remoteHost == null) {
                        pdu.remoteHost = this.peername;
                        if (this.protocol == 1) {
                            if (this.cachedPeername != this.peername) {
                                this.cachedIpxAddress = IpxAddress.getByName((String)this.peername);
                            }
                            pdu.ipxAddress = this.cachedIpxAddress;
                        } else {
                            if (this.cachedPeername != this.peername) {
                                this.cachedIpAddress = InetAddress.getByName(this.peername);
                            }
                            pdu.address = this.cachedIpAddress;
                        }
                        this.cachedPeername = this.peername;
                    }
                    if (this.protocol == 1) {
                        pdu.ipxAddress = IpxAddress.getByName((String)pdu.remoteHost);
                    }
                    pdu.address = InetAddress.getByName(pdu.remoteHost);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new SnmpException("Session Remote Host Unknown.");
                }
                catch (SecurityException securityException) {
                    throw new SnmpException("Security Exception connecting to remote host");
                }
            } else if (pdu.remoteHost == null) {
                pdu.remoteHost = this.peername;
            }
        } else if (this.sasclient != null) {
            pdu.remoteHost = SnmpIpAddress.netbToString(pdu.address.getAddress());
        }
        if (pdu.community == null) {
            pdu.community = this.community;
        }
        if (pdu.writeCommunity == null && this.writeCommunity != null) {
            pdu.writeCommunity = this.writeCommunity;
        }
        if (this.protocol == 1) {
            if (this.remote_port == 0) {
                this.remote_port = 36879;
            }
        } else if (this.remote_port == 0) {
            this.remote_port = this.API.SNMP_PORT;
        }
        if (pdu.remotePort == 0) {
            pdu.remotePort = this.remote_port;
        }
        if (pdu.timeout == 0) {
            pdu.timeout = this.timeout;
        }
        if (pdu.retries == 0) {
            pdu.retries = this.retries;
        }
        if ((pdu.alwaysEncode || pdu.data == null) && !pdu.encode(this.encodeBufferSize)) {
            if (this.API.DEBUG) {
                System.err.println("Unable to encode PDU.");
            }
            throw new SnmpException("Unable to encode PDU.");
        }
        if (this.API.DEBUG) {
            if (this.client == null) {
                this.API.client.debugPrint("Sent Type:" + pdu.command + " Request ID:" + pdu.reqid + " to " + pdu.address + "  : " + pdu.remotePort + "\nDATA\n" + this.printOctets(pdu.data, pdu.data.length));
            } else {
                this.client.debugPrint("Sent Type:" + pdu.command + " Request ID:" + pdu.reqid + " to " + pdu.address + "  : " + pdu.remotePort + "\nDATA\n" + this.printOctets(pdu.data, pdu.data.length));
            }
        }
        if (pdu.command == -96 || pdu.command == -95 || pdu.command == -93 || pdu.command == -91) {
            SnmpPDU npdu = null;
            pdu.time_sent = System.currentTimeMillis();
            pdu.time_expires = pdu.time_sent + (long)pdu.timeout;
            npdu = !pdu.cloneFlag ? pdu : pdu.copy();
            if (npdu != null) {
                this.enQ(this.requestList, npdu);
                if (this.API.DEBUG) {
                    if (this.client == null) {
                        this.API.client.debugPrint("Placed PDU in request queue.");
                    } else {
                        this.client.debugPrint("Placed PDU in request queue.");
                    }
                }
            } else {
                throw new SnmpException("Cannot clone PDU");
            }
        }
        try {
            if (this.sasclient != null) {
                this.sasclient.send(pdu.remoteHost, pdu.remotePort, pdu.data);
            } else if (this.protocol == 1) {
                this.ipxSock.send(new IpxDatagramPacket(pdu.data, pdu.data.length, pdu.ipxAddress, pdu.remotePort));
            } else {
                this.sock.send(new DatagramPacket(pdu.data, pdu.data.length, pdu.address, pdu.remotePort));
            }
        }
        catch (IOException iOException) {
            throw new SnmpException("IO error sending PDU.");
        }
        return pdu.reqid;
    }

    public SnmpPDU syncSend(SnmpPDU pdu) throws SnmpException {
        int sretries = pdu.retries == 0 ? this.retries : pdu.retries;
        long stimeout = pdu.timeout == 0 ? this.timeout : pdu.timeout;
        long time_expires = System.currentTimeMillis() + stimeout * (long)(sretries + 2);
        int i = 1;
        while (i <= sretries) {
            stimeout += stimeout;
            time_expires += stimeout;
            ++i;
        }
        this.send(pdu);
        boolean count = false;
        do {
            int ret;
            if ((ret = this.checkSyncResponse(pdu.reqid)) == -1) {
                return null;
            }
            if (ret <= 0) continue;
            return this.deQ(this.responseList, pdu.reqid);
        } while (System.currentTimeMillis() <= time_expires + 1000L);
        return null;
    }

    synchronized int checkSyncResponse(int reqid) throws SnmpException {
        int[] resp = this.checkResponses();
        if (resp != null) {
            int i = 0;
            while (i < resp.length) {
                if (reqid == resp[i]) {
                    return 1;
                }
                ++i;
            }
        }
        if (this.checkTimeout(reqid)) {
            return -1;
        }
        try {
            this.wait(1000L);
        }
        catch (InterruptedException interruptedException) {}
        return 0;
    }

    public SnmpVar get(String oidString) throws SnmpException {
        SnmpOID oid = new SnmpOID(oidString, this.API);
        if (oid.toValue() == null) {
            throw new SnmpException("Invalid OID String: " + oidString);
        }
        return this.snmpRequest((byte)-96, oid, null);
    }

    public SnmpVar get(SnmpOID oid) throws SnmpException {
        return this.snmpRequest((byte)-96, oid, null);
    }

    public SnmpVar getnext(String oidString) throws SnmpException {
        SnmpOID oid = new SnmpOID(oidString, this.API);
        if (oid.toValue() == null) {
            throw new SnmpException("Invalid OID String: " + oidString);
        }
        return this.snmpRequest((byte)-95, oid, null);
    }

    public SnmpVar getnext(SnmpOID oid) throws SnmpException {
        return this.snmpRequest((byte)-95, oid, null);
    }

    public SnmpVar set(String oidString, String setString) throws SnmpException {
        SnmpOID oid = new SnmpOID(oidString, this.API);
        if (oid.toValue() == null) {
            throw new SnmpException("Invalid OID String: " + oidString);
        }
        if (oid.node == null) {
            throw new SnmpException("No MIB node for OID. Cannot convert set value string to SnmpVar");
        }
        if (oid.node.syntax == null) {
            throw new SnmpException("Not leaf node. Cannot perform set operation");
        }
        SnmpVar var = oid.node.syntax.createVariable(setString);
        return this.snmpRequest((byte)-93, oid, var);
    }

    public SnmpVar set(SnmpOID oid, SnmpVar var) throws SnmpException {
        return this.snmpRequest((byte)-93, oid, var);
    }

    SnmpVar snmpRequest(byte request, SnmpOID oid, SnmpVar setValue) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(this.API);
        pdu.command = request;
        if (request == -93) {
            SnmpVarBind varbind = new SnmpVarBind();
            varbind.oid = oid;
            varbind.variable = setValue;
            pdu.variables.addElement(varbind);
        } else {
            pdu.addNull(oid);
        }
        pdu = this.syncSend(pdu);
        if (pdu == null) {
            return null;
        }
        if (pdu.version == SnmpAPI.SNMP_VERSION_1) {
            if (pdu.errstat != 0) {
                throw new SnmpException(SnmpException.exceptionString((byte)pdu.errstat));
            }
            try {
                return ((SnmpVarBind)pdu.variables.firstElement()).variable;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        if (pdu.version == SnmpAPI.SNMP_VERSION_2C) {
            if (pdu.errstat != 0) {
                throw new SnmpException(SnmpException.exceptionString((byte)pdu.errstat));
            }
            int error = 0;
            SnmpVarBind varbind = (SnmpVarBind)pdu.variables.firstElement();
            error = varbind.varbindErrindex;
            if (error != 0) {
                throw new SnmpException(SnmpException.exceptionString((byte)error));
            }
            return varbind.variable;
        }
        System.err.println("Invalid Version Number");
        return null;
    }

    public SnmpPDU receive(int reqid) {
        Thread.yield();
        return this.deQ(this.responseList, reqid);
    }

    public boolean checkTimeout(int reqid) {
        Enumeration e = this.timeouts.elements();
        while (e.hasMoreElements()) {
            Integer failID = (Integer)e.nextElement();
            if (reqid != failID) continue;
            this.timeouts.removeElement(failID);
            return true;
        }
        return false;
    }

    public synchronized int[] checkResponses() {
        int j = this.responseList.size();
        if (j == 0) {
            return null;
        }
        int[] res = new int[j];
        int i = 0;
        while (i < res.length) {
            res[i] = ((SnmpPDU)this.responseList.elementAt((int)i)).reqid;
            ++i;
        }
        return res;
    }

    synchronized void enQ(Vector v, SnmpPDU pdu) {
        v.addElement(pdu);
        this.notifyAll();
    }

    synchronized SnmpPDU deQ(Vector v, int reqid) {
        if (v == null) {
            return null;
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            SnmpPDU pdu = (SnmpPDU)e.nextElement();
            if (reqid != 0 && pdu.reqid != reqid) continue;
            v.removeElement(pdu);
            this.notifyAll();
            return pdu;
        }
        return null;
    }

    synchronized void monitorRequests() {
        SnmpPDU pdu;
        Enumeration e = this.requestList.elements();
        while (e.hasMoreElements()) {
            pdu = (SnmpPDU)e.nextElement();
            if (System.currentTimeMillis() <= pdu.time_expires) continue;
            if (pdu.retries <= 0) {
                this.deQ(this.requestList, pdu.reqid);
                if (this.client == null) {
                    if (this.API.client != null && !(this.API.client instanceof SnmpAPI)) {
                        if (this.CALLBACK_THREAD) {
                            if (this.snmpcallback == null) {
                                this.snmpcallback = new SnmpCallback(this.protocol);
                                this.snmpcallback.start();
                            }
                            this.snmpcallback.enQ(this.API.client, this, null, pdu.reqid);
                        } else {
                            this.API.client.callback(this, null, pdu.reqid);
                        }
                    }
                } else if (this.CALLBACK_THREAD) {
                    if (this.snmpcallback == null) {
                        this.snmpcallback = new SnmpCallback(this.protocol);
                        this.snmpcallback.start();
                    }
                    this.snmpcallback.enQ(this.client, this, null, pdu.reqid);
                } else {
                    this.client.callback(this, null, pdu.reqid);
                }
                if (this.timeouts.size() >= this.TIMEOUT_QUEUE_SIZE) {
                    this.timeouts.removeElementAt(0);
                }
                this.timeouts.addElement(new Integer(pdu.reqid));
                if (!this.API.DEBUG) continue;
                String remhst = pdu.remoteHost;
                if (remhst == null) {
                    remhst = pdu.address.toString();
                }
                if (this.client == null) {
                    this.API.client.debugPrint("Timed out: no more retries to " + remhst + "  : " + pdu.remotePort + "  ReqID: " + pdu.reqid);
                    continue;
                }
                this.client.debugPrint("Timed out: no more retries to " + remhst + "  : " + pdu.remotePort + "  ReqID: " + pdu.reqid);
                continue;
            }
            --pdu.retries;
            try {
                if (this.sasclient != null) {
                    this.sasclient.send(pdu.remoteHost, pdu.remotePort, pdu.data);
                } else if (this.protocol == 1) {
                    this.ipxSock.send(new IpxDatagramPacket(pdu.data, pdu.data.length, pdu.ipxAddress, pdu.remotePort));
                } else {
                    this.sock.send(new DatagramPacket(pdu.data, pdu.data.length, pdu.address, pdu.remotePort));
                }
            }
            catch (IOException iOException) {
                if (this.sasclient != null) {
                    System.err.println("IO error resending to " + pdu.remoteHost + "  : " + Integer.toString(pdu.remotePort));
                }
                System.err.println("IO error resending to " + pdu.address.toString() + "  : " + Integer.toString(pdu.remotePort));
            }
            if (this.API.DEBUG) {
                if (this.client == null) {
                    this.API.client.debugPrint("Timed out: Resent to " + pdu.address.toString() + "  : " + pdu.remotePort + "  ReqID: " + pdu.reqid);
                } else {
                    this.client.debugPrint("Timed out: Resent to " + pdu.address.toString() + "  : " + pdu.remotePort + "  ReqID: " + pdu.reqid);
                }
            }
            long j = pdu.time_expires - pdu.time_sent;
            pdu.time_sent = System.currentTimeMillis();
            pdu.time_expires = pdu.time_sent + 2L * j;
        }
        int rnum = this.responseList.size() - this.RESP_QUEUE_SIZE;
        int i = 0;
        while (i < rnum) {
            pdu = this.deQ(this.responseList, 0);
            if (this.timeouts.size() >= this.TIMEOUT_QUEUE_SIZE) {
                this.timeouts.removeElementAt(0);
            }
            this.timeouts.addElement(new Integer(pdu.reqid));
            if (this.API.DEBUG) {
                if (this.client == null) {
                    this.API.client.debugPrint("Resp Queue full: bumped reqid " + pdu.reqid);
                } else {
                    this.client.debugPrint("Resp Queue full: bumped reqid " + pdu.reqid);
                }
            }
            ++i;
        }
    }

    private void receiver() {
        if (this.API.DEBUG) {
            if (this.client == null) {
                this.API.client.debugPrint("Starting Receiver on this session");
            } else {
                this.client.debugPrint("Starting Receiver on this session");
            }
        }
        byte[] data = new byte[this.maxDatagramReceiveBuffer];
        try {
            if (this.protocol == 0 && this.sock != null) {
                this.sock.setSoTimeout(this.socketTimeout);
            }
            if (this.protocol == 1 && this.ipxSock != null) {
                this.ipxSock.setSoTimeout(this.socketTimeout);
            }
        }
        catch (Exception e) {
            System.err.println("Failed set timeout : " + e.getMessage());
        }
        while (true) {
            if (this.sock != null || this.ipxSock != null || this.sasclient != null) {
                SnmpPDU pdu;
                DatagramPacket packet;
                IpxDatagramPacket ipxPacket;
                block51: {
                    block50: {
                        ipxPacket = null;
                        packet = null;
                        if (this.protocol == 1) {
                            ipxPacket = new IpxDatagramPacket(data, this.maxDatagramReceiveBuffer);
                        } else {
                            packet = new DatagramPacket(data, this.maxDatagramReceiveBuffer);
                        }
                        try {
                            if (this.sasclient != null) {
                                this.sasclient.receive();
                                break block50;
                            }
                            this.receiverStrt = true;
                            while (true) {
                                try {
                                    if (this.protocol == 1) {
                                        this.ipxSock.receive(ipxPacket);
                                    } else {
                                        this.sock.receive(packet);
                                    }
                                }
                                catch (InterruptedIOException interruptedIOException) {
                                    if (!this.closeSocket) {
                                        try {
                                            Thread.sleep(this.socketDelay);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        continue;
                                    }
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            if (this.sasclient == null) {
                                if (!this.closeSocket) continue;
                                return;
                            }
                            System.err.println("Receive error: Aborting session receiver");
                            return;
                        }
                        catch (SnmpException snmpException) {
                            System.out.println("Receive error: Ignoring the Received message and starting receiver again");
                            continue;
                        }
                    }
                    if (this.closeSocket) {
                        if (this.protocol == 1) {
                            this.ipxSock.close();
                        } else {
                            this.sock.close();
                        }
                        if (this.API.DEBUG) {
                            if (this.client == null) {
                                this.API.client.debugPrint("Closed socket and stopping SnmpSession Receiver.");
                            } else {
                                this.client.debugPrint("Closed socket and stopping SnmpSession Receiver.");
                            }
                        }
                        return;
                    }
                    pdu = null;
                    int packetLength = 0;
                    try {
                        SnmpPDU req_pdu;
                        byte[] message;
                        if (this.sasclient != null) {
                            pdu = new SnmpPDU(this.API, this.sasclient.data);
                            pdu.time_received = System.currentTimeMillis();
                            SnmpPDU req_pdu2 = this.deQ(this.requestList, pdu.reqid);
                            if (req_pdu2 != null) {
                                pdu.time_sent = req_pdu2.time_sent;
                                if (req_pdu2.command == -93 && this.writeCommunity != null) {
                                    pdu.useWriteValidate = true;
                                }
                            } else if (pdu.command == -94) continue;
                            pdu.remoteHost = this.sasclient.remoteHost;
                            pdu.remotePort = this.sasclient.port;
                            packetLength = this.sasclient.data.length;
                        } else if (this.protocol == 1) {
                            packetLength = ipxPacket.getLength();
                            message = new byte[packetLength];
                            System.arraycopy(ipxPacket.getData(), 0, message, 0, packetLength);
                            pdu = new SnmpPDU(this.API, message);
                            pdu.time_received = System.currentTimeMillis();
                            req_pdu = this.deQ(this.requestList, pdu.reqid);
                            if (req_pdu != null) {
                                pdu.time_sent = req_pdu.time_sent;
                                if (req_pdu.command == -93 && this.writeCommunity != null) {
                                    pdu.useWriteValidate = true;
                                }
                            } else if (pdu.command == -94) {
                                continue;
                            }
                        } else {
                            packetLength = packet.getLength();
                            message = new byte[packetLength];
                            System.arraycopy(packet.getData(), 0, message, 0, packetLength);
                            pdu = new SnmpPDU(this.API, message);
                            pdu.time_received = System.currentTimeMillis();
                            req_pdu = this.deQ(this.requestList, pdu.reqid);
                            if (req_pdu != null) {
                                pdu.time_sent = req_pdu.time_sent;
                                if (req_pdu.command == -93 && this.writeCommunity != null) {
                                    pdu.useWriteValidate = true;
                                }
                            } else if (pdu.command == -94) continue;
                        }
                        if (this.CALLBACK_THREAD) {
                            if (this.snmpcallback == null) {
                                this.snmpcallback = new SnmpCallback(this.protocol);
                                this.snmpcallback.start();
                            }
                            if (this.protocol == 1) {
                                this.snmpcallback.enQ(ipxPacket, this, pdu);
                                continue;
                            }
                            if (this.protocol != 0) continue;
                            this.snmpcallback.enQ(packet, this, pdu);
                        }
                        break block51;
                    }
                    catch (SnmpException x) {
                        System.err.println("Error decoding Packet: " + x);
                    }
                    continue;
                }
                if (this.protocol == 1) {
                    this.processPacket(ipxPacket, pdu);
                    continue;
                }
                this.processPacket(packet, pdu);
                continue;
            }
            Thread.yield();
        }
    }

    void processPacket(DatagramPacket packet, SnmpPDU pdu) {
        int reqid;
        block25: {
            int packetLength = pdu.data.length;
            reqid = pdu.reqid;
            pdu.address = packet.getAddress();
            pdu.remotePort = packet.getPort();
            if (this.sasclient == null) {
                pdu.remoteHost = SnmpIpAddress.netbToString(pdu.address.getAddress());
            }
            if (this.API.DEBUG) {
                String ss = this.printOctets(pdu.data, packetLength);
                if (this.client == null) {
                    this.API.client.debugPrint("Packet from: " + pdu.remoteHost + "  : " + pdu.remotePort + "\n" + "DATA:\n" + ss + "\n");
                } else {
                    this.client.debugPrint("Packet from: " + pdu.remoteHost + "  : " + pdu.remotePort + "\n" + "DATA:\n" + ss + "\n");
                }
            }
            try {
                pdu.decode();
            }
            catch (SnmpException ex) {
                String s = this.printOctets(pdu.data, packetLength);
                System.err.println("Error decoding Packet: " + ex);
                System.err.println("Packet from: " + pdu.remoteHost + "  : " + pdu.remotePort + "\n" + "DATA:\n" + s + "\n");
                pdu = null;
                break block25;
            }
            if (this.API.DEBUG) {
                if (this.client == null) {
                    this.API.client.debugPrint("Packet ReqID: " + reqid);
                } else {
                    this.client.debugPrint("Packet ReqID: " + reqid);
                }
            }
            boolean useWrite = false;
            if (pdu.command == -93 && this.writeCommunity != null) {
                useWrite = true;
            }
            if (pdu.useWriteValidate) {
                useWrite = true;
            }
            if (this.community != null || useWrite) {
                if (this.client == null) {
                    if (this.API.client != null && !this.API.client.authenticate(pdu, useWrite ? this.writeCommunity : this.community)) {
                        this.API.client.debugPrint("Authentication failure: Our Community: " + this.community + ", Received: " + pdu.community);
                        pdu = null;
                    }
                } else if (!this.client.authenticate(pdu, useWrite ? this.writeCommunity : this.community)) {
                    this.client.debugPrint("Authentication failure: Our Community: " + this.community + ", Received: " + pdu.community);
                    pdu = null;
                }
            }
        }
        if (this.client == null) {
            if (this.API.client != null && !(this.API.client instanceof SnmpAPI)) {
                if (this.CALLBACK_THREAD) {
                    if (this.snmpcallback == null) {
                        this.snmpcallback = new SnmpCallback(this.protocol);
                        this.snmpcallback.start();
                    }
                    this.snmpcallback.enQ(this.API.client, this, pdu, reqid);
                    return;
                }
                if (this.API.client.callback(this, pdu, reqid)) {
                    return;
                }
            }
        } else {
            if (this.CALLBACK_THREAD) {
                if (this.snmpcallback == null) {
                    this.snmpcallback = new SnmpCallback(this.protocol);
                    this.snmpcallback.start();
                }
                this.snmpcallback.enQ(this.client, this, pdu, reqid);
                return;
            }
            if (this.client.callback(this, pdu, reqid)) {
                return;
            }
        }
        this.enQ(this.responseList, pdu);
    }

    void processPacket(IpxDatagramPacket packet, SnmpPDU pdu) {
        int reqid;
        block23: {
            int packetLength = pdu.data.length;
            reqid = pdu.reqid;
            pdu.ipxAddress = packet.getAddress();
            pdu.remotePort = packet.getPort();
            if (this.sasclient == null) {
                pdu.remoteHost = SnmpIpAddress.netbToString(pdu.ipxAddress.getAddress());
            }
            if (this.API.DEBUG) {
                String ss = this.printOctets(pdu.data, packetLength);
                if (this.client == null) {
                    this.API.client.debugPrint("Packet from: " + pdu.remoteHost + "  : " + pdu.remotePort + "\n" + "DATA:\n" + ss + "\n");
                } else {
                    this.client.debugPrint("Packet from: " + pdu.remoteHost + "  : " + pdu.remotePort + "\n" + "DATA:\n" + ss + "\n");
                }
            }
            try {
                pdu.decode();
            }
            catch (SnmpException ex) {
                String s = this.printOctets(pdu.data, packetLength);
                System.err.println("Error decoding Packet: " + ex);
                System.err.println("Packet from: " + pdu.remoteHost + "  : " + pdu.remotePort + "\n" + "DATA:\n" + s + "\n");
                pdu = null;
                break block23;
            }
            if (this.API.DEBUG) {
                if (this.client == null) {
                    this.API.client.debugPrint("Packet ReqID: " + reqid);
                } else {
                    this.client.debugPrint("Packet ReqID: " + reqid);
                }
            }
            if (this.community != null) {
                if (this.client == null) {
                    if (this.API.client != null && !this.API.client.authenticate(pdu, this.community)) {
                        this.API.client.debugPrint("Authentication failure: Our Community: " + this.community + ", Received: " + pdu.community);
                        pdu = null;
                    }
                } else if (!this.client.authenticate(pdu, this.community)) {
                    this.client.debugPrint("Authentication failure: Our Community: " + this.community + ", Received: " + pdu.community);
                    pdu = null;
                }
            }
        }
        if (this.client == null) {
            if (this.API.client != null && !(this.API.client instanceof SnmpAPI)) {
                if (this.CALLBACK_THREAD) {
                    if (this.snmpcallback == null) {
                        this.snmpcallback = new SnmpCallback(this.protocol);
                        this.snmpcallback.start();
                    }
                    this.snmpcallback.enQ(this.API.client, this, pdu, reqid);
                    return;
                }
                if (this.API.client.callback(this, pdu, reqid)) {
                    return;
                }
            }
        } else {
            if (this.CALLBACK_THREAD) {
                if (this.snmpcallback == null) {
                    this.snmpcallback = new SnmpCallback(this.protocol);
                    this.snmpcallback.start();
                }
                this.snmpcallback.enQ(this.client, this, pdu, reqid);
                return;
            }
            if (this.client.callback(this, pdu, reqid)) {
                return;
            }
        }
        this.enQ(this.responseList, pdu);
    }

    String printOctets(byte[] data, int length) {
        StringBuffer s = new StringBuffer();
        int j = 0;
        int line = 20;
        if (data.length < length) {
            length = data.length;
        }
        int i = 0;
        while (i < length) {
            String bs;
            if (j++ > 19) {
                j = 1;
                s.append("\n");
            }
            if ((bs = Integer.toString(ASNTypes.byteToInt(data[i]), 16)).length() < 2) {
                bs = "0" + bs;
            }
            s.append(String.valueOf(bs) + " ");
            ++i;
        }
        return s.toString();
    }
}

