/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.Session;
import com.novell.webaccess.common.SessionManager;
import com.novell.webaccess.common.XmlProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class I18NServletRequest
implements HttpServletRequest {
    public static final String SESSION_COOKIE_NAME = "NJSCN";
    public static final String SESSION_COOKIE_DELIM = "#";
    private static boolean sm_bCallGetCharacterEncoding = true;
    private static boolean sm_bCheckedForCharEncodingCall = false;
    private HttpServletRequest m_req = null;
    private I18NLocale m_locale = null;
    private String m_sCharEncoding = null;
    private Hashtable m_htParams = null;
    private Map m_paramMap = null;
    private Hashtable m_attributes = new Hashtable();
    private String m_sPathInfo = null;
    private String m_sSessionCookie = null;
    private boolean m_bIsSoap = false;
    private SessionManager m_sessionManager = null;
    private Session m_session = null;
    private boolean m_bIsSessionFromCookie = false;
    private boolean m_bIsSessionValid = false;
    private String[] m_cookieValues = null;
    private PipedOutputStream m_xmlOut = null;
    private PipedInputStream m_xmlIn = null;
    private InputStream m_templateStream = null;
    protected static boolean sm_bCheckedSetAttr = false;
    protected static boolean sm_bCallSetAttr = true;

    public I18NServletRequest(HttpServletRequest httpServletRequest) {
        this.m_req = httpServletRequest;
    }

    public HttpServletRequest getRootHttpServletRequest() {
        return this.m_req;
    }

    public String getMethod() {
        return this.m_req.getMethod();
    }

    public String getRequestURI() {
        return this.m_req.getRequestURI();
    }

    public String getServletPath() {
        return this.m_req.getServletPath();
    }

    public String getPathTranslated() {
        return this.m_req.getPathTranslated();
    }

    public String getQueryString() {
        return this.m_req.getQueryString();
    }

    public String getRemoteUser() {
        return this.m_req.getRemoteUser();
    }

    public String getAuthType() {
        return this.m_req.getAuthType();
    }

    public String getHeader(String string) {
        return this.m_req.getHeader(string);
    }

    public int getIntHeader(String string) {
        return this.m_req.getIntHeader(string);
    }

    public long getDateHeader(String string) {
        return this.m_req.getDateHeader(string);
    }

    public Enumeration getHeaderNames() {
        return this.m_req.getHeaderNames();
    }

    public Cookie[] getCookies() {
        return this.m_req.getCookies();
    }

    public HttpSession getSession(boolean bl) {
        return this.getI18NServletSession(bl);
    }

    public HttpSession getWebAppSession(boolean bl) {
        return this.m_req.getSession(bl);
    }

    public String getRequestedSessionId() {
        return this.m_req.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.m_bIsSessionFromCookie;
    }

    public boolean isRequestedSessionIdValid() {
        return this.m_bIsSessionValid;
    }

    public int getContentLength() {
        return this.m_req.getContentLength();
    }

    public String getContentType() {
        return this.m_req.getContentType();
    }

    public String getProtocol() {
        return this.m_req.getProtocol();
    }

    public String getScheme() {
        return this.m_req.getScheme();
    }

    public String getServerName() {
        return this.m_req.getServerName();
    }

    public int getServerPort() {
        return this.m_req.getServerPort();
    }

    public String getRemoteAddr() {
        return this.m_req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.m_req.getRemoteHost();
    }

    public Object getAttribute(String string) {
        return this.m_attributes.get(string);
    }

    public BufferedReader getReader() throws IOException {
        return this.m_req.getReader();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.m_req.getInputStream();
    }

    public Map getParameterMap() {
        if (this.m_paramMap == null || this.m_paramMap.isEmpty()) {
            this.m_paramMap = new HashMap();
            Enumeration enumeration = this.m_htParams.keys();
            String string = null;
            String[] stringArray = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                stringArray = (String[])this.m_htParams.get(string);
                this.m_paramMap.put(string, stringArray);
            }
        }
        return this.m_paramMap;
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getScheme()).append("://").append(this.getRequestURI());
        String string = this.getQueryString();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    public void setI18NSession(Session session) {
        this.m_session = session;
    }

    public Session getI18NServletSession() {
        return this.getI18NServletSession(true);
    }

    public Session getI18NServletSession(boolean bl) {
        if (this.m_session == null && bl) {
            this.m_session = this.m_sessionManager.getSession(this, "x");
        }
        return this.m_session;
    }

    public void setAttribute(String string, Object object) {
        this.m_attributes.put(string, object);
    }

    public Enumeration getAttributeNames() {
        return this.m_attributes.keys();
    }

    public boolean isRequestedSessionIdFromURL() {
        return !this.isRequestedSessionIdFromCookie();
    }

    public HttpSession getSession() {
        return this.getI18NServletSession(true);
    }

    public HttpSession getWebAppSession() {
        return this.m_req.getSession(true);
    }

    public boolean isRequestedSessionIdFromUrl() {
        return !this.isRequestedSessionIdFromCookie();
    }

    public String getRealPath(String string) {
        return this.m_req.getRealPath(string);
    }

    public Enumeration getHeaders(String string) {
        return this.m_req.getHeaders(string);
    }

    public String getContextPath() {
        return this.m_req.getContextPath();
    }

    public boolean isUserInRole(String string) {
        return this.m_req.isUserInRole(string);
    }

    public Principal getUserPrincipal() {
        return this.m_req.getUserPrincipal();
    }

    public void removeAttribute(String string) {
        this.m_attributes.remove(string);
    }

    public Locale getLocale() {
        return this.m_req.getLocale();
    }

    public Enumeration getLocales() {
        return this.m_req.getLocales();
    }

    public boolean isSecure() {
        return this.m_req.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return this.m_req.getRequestDispatcher(string);
    }

    void setSessionByCookie(boolean bl) {
        this.m_bIsSessionFromCookie = bl;
    }

    public String getCharacterEncoding() {
        if (this.m_sCharEncoding == null) {
            if (this.m_locale == null) {
                this.m_locale = new I18NLocale(this);
            }
            this.m_sCharEncoding = this.m_locale.getCharset();
        }
        return this.m_sCharEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.m_sCharEncoding = string;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.m_sessionManager = sessionManager;
    }

    public String getPathInfo() {
        String string = this.m_req.getPathInfo();
        if (string != null && this.m_sPathInfo == null) {
            byte[] byArray = null;
            byArray = string.getBytes();
            this.m_sPathInfo = this.decode(byArray, 0, byArray.length);
        }
        return this.m_sPathInfo;
    }

    public void setTemplateStream(InputStream inputStream) {
        this.m_templateStream = inputStream;
    }

    InputStream getTemplateStream() {
        return this.m_templateStream;
    }

    public void setXmlInputStream(InputStream inputStream) {
        this.m_attributes.put("XMLStream", inputStream);
    }

    InputStream getXmlInputStream() {
        return (InputStream)this.m_attributes.get("XMLStream");
    }

    public void setParameter(String string, String string2) {
        String[] stringArray = null;
        if (this.m_htParams == null) {
            this.m_htParams = this.getParametersFromRequest();
        }
        if (string != null) {
            if (string2 == null) {
                string2 = "";
            }
            stringArray = new String[]{string2};
            this.m_htParams.put(string, stringArray);
        }
    }

    public void removeParameter(String string) {
        if (this.m_htParams == null) {
            this.m_htParams = this.getParametersFromRequest();
        }
        this.m_htParams.remove(string);
    }

    public String getParameter(String string) {
        String[] stringArray;
        if (this.m_htParams == null) {
            this.m_htParams = this.getParametersFromRequest();
        }
        if ((stringArray = (String[])this.m_htParams.get(string)) == null) {
            return null;
        }
        String string2 = stringArray[0];
        int n = 1;
        while (n < stringArray.length) {
            string2 = string2 + "," + stringArray[n];
            ++n;
        }
        return string2;
    }

    public String[] getParameterValues(String string) {
        if (this.m_htParams == null) {
            this.m_htParams = this.getParametersFromRequest();
        }
        return (String[])this.m_htParams.get(string);
    }

    public Enumeration getParameterNames() {
        if (this.m_htParams == null) {
            this.m_htParams = this.getParametersFromRequest();
        }
        return this.m_htParams.keys();
    }

    private Hashtable getParametersFromRequest() {
        Object object;
        String[] stringArray;
        Object object2;
        Hashtable hashtable = new Hashtable();
        if (this.getMethod() == null) {
            return hashtable;
        }
        this.getCookieData(hashtable);
        String[] stringArray2 = (String[])hashtable.get(SESSION_COOKIE_NAME);
        if (stringArray2 != null) {
            if (stringArray2[0].indexOf(SESSION_COOKIE_DELIM) != -1) {
                object2 = stringArray2[0];
                stringArray = new Vector();
                object = new StringTokenizer((String)object2, SESSION_COOKIE_DELIM);
                int n = 0;
                while (object.hasMoreTokens()) {
                    stringArray.addElement(object.nextToken());
                    ++n;
                }
                if (n > 0) {
                    stringArray2 = new String[n];
                    int n2 = 0;
                    while (n2 < n) {
                        stringArray2[n2] = (String)stringArray.elementAt(n2);
                        ++n2;
                    }
                }
            }
            this.setSessionCookie(stringArray2[0]);
            this.m_session = this.m_sessionManager.getSessionByCookie(stringArray2[0]);
            if (this.m_session != null) {
                this.m_bIsSessionValid = true;
                object2 = this.m_session.getCharacterEncoding();
                if (object2 != null) {
                    this.setCharacterEncoding((String)object2);
                }
            }
        }
        this.m_cookieValues = stringArray2;
        this.getQueryData(hashtable);
        object2 = this.getContentData(hashtable);
        stringArray = (String[])((Hashtable)object2).get("User.context");
        if (stringArray != null) {
            object = stringArray[0];
            Session session = this.m_sessionManager.getSessionById((String)object);
            if (session != null) {
                this.m_bIsSessionValid = true;
                this.m_session = session;
                Session session2 = null;
                if (stringArray2 != null) {
                    int n = 0;
                    while (n < stringArray2.length) {
                        session2 = this.m_sessionManager.getSessionByCookie(stringArray2[n]);
                        if (session2 == session) {
                            this.setSessionCookie(stringArray2[n]);
                            break;
                        }
                        ++n;
                    }
                }
            } else {
                this.m_bIsSessionValid = false;
            }
        } else if (this.m_session != null) {
            object = new String[]{this.m_session.getId()};
            ((Hashtable)object2).put("User.context", object);
            this.m_bIsSessionFromCookie = true;
        }
        return object2;
    }

    void synchronizeSessionCookie(Session session) {
        String string = session.getSessionCookie();
        if (string != null) {
            int n = 0;
            while (n < this.m_cookieValues.length) {
                if (string.equals(this.m_cookieValues[n])) {
                    this.setSessionCookie(this.m_cookieValues[n]);
                    break;
                }
                ++n;
            }
        }
    }

    public String getSessionCookie() {
        return this.m_sSessionCookie;
    }

    public void setSessionCookie(String string) {
        this.m_sSessionCookie = string;
    }

    String[] getCookieValues() {
        return this.m_cookieValues;
    }

    protected Hashtable getCookieData(Hashtable hashtable) {
        String string = this.getHeader("Cookie");
        if (string != null) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                byArray = string.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            byArray2 = new byte[string.length() * 3];
            int n = 0;
            int n2 = 0;
            while (n2 < byArray.length) {
                if (byArray[n2] == 38) {
                    byArray2[n++] = 37;
                    byArray2[n++] = 50;
                    byArray2[n++] = 54;
                    ++n2;
                    continue;
                }
                if (byArray[n2] == 59) {
                    byArray2[n++] = 38;
                    if (byArray[++n2] != 32) continue;
                    ++n2;
                    continue;
                }
                if (byArray[n2] == 37) {
                    byArray2[n++] = 37;
                    byArray2[n++] = 50;
                    byArray2[n++] = 53;
                    ++n2;
                    continue;
                }
                if (byArray[n2] == 32) {
                    byArray2[n++] = 43;
                    ++n2;
                    continue;
                }
                byArray2[n++] = byArray[n2++];
            }
            this.parseKeyValues(byArray2, n, hashtable);
        }
        return hashtable;
    }

    protected Hashtable getQueryData(Hashtable hashtable) {
        String string = this.getQueryString();
        if (string != null) {
            byte[] byArray = null;
            byArray = string.getBytes();
            this.parseKeyValues(byArray, byArray.length, hashtable);
        }
        return hashtable;
    }

    protected Hashtable getContentData(Hashtable hashtable) {
        String string;
        Hashtable hashtable2 = hashtable;
        String string2 = this.getMethod();
        if (string2.equals("POST") && (string = this.getContentType()) != null) {
            if (string.toLowerCase().startsWith("application/x-www-form-urlencoded") || string.toUpperCase().startsWith("CONTENT-TYPE")) {
                try {
                    this.parsePostData(this.getContentLength(), this.getInputStream(), hashtable);
                }
                catch (Exception exception) {}
            } else if (string.toLowerCase().startsWith("text/xml")) {
                try {
                    hashtable2 = this.parseXMLData(this.getContentLength(), this.getInputStream());
                    String[] stringArray = null;
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        stringArray = new String[]{(String)hashtable2.get(string3)};
                        hashtable.put(string3, stringArray);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return hashtable;
    }

    private Hashtable parsePostData(int n, ServletInputStream servletInputStream, Hashtable hashtable) {
        byte[] byArray = null;
        Object var5_5 = null;
        if (n <= 0) {
            return hashtable;
        }
        int n2 = 0;
        try {
            int n3;
            byArray = new byte[n];
            n2 = 0;
            do {
                if ((n3 = servletInputStream.read(byArray, n2, n - n2)) > 0) continue;
                throw new IOException();
            } while (n - (n2 += n3) > 0);
        }
        catch (IOException iOException) {
            System.out.println("IOException");
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
            return hashtable;
        }
        return this.parseKeyValues(byArray, byArray.length, hashtable);
    }

    private Hashtable parseXMLData(int n, ServletInputStream servletInputStream) {
        Properties properties = new Properties();
        XmlProperties.xmlToProperties((InputStream)servletInputStream, properties, "utf-8");
        this.m_bIsSoap = true;
        return properties;
    }

    public boolean isSoap() {
        return this.m_bIsSoap;
    }

    /*
     * Unable to fully structure code
     */
    protected Hashtable parseKeyValues(byte[] var1_1, int var2_2, Hashtable var3_3) {
        var4_4 = 0;
        var8_5 = null;
        if (var1_1 != null) ** GOTO lbl32
        return var3_3;
lbl-1000:
        // 1 sources

        {
            var5_6 = var4_4;
            while (var4_4 < var2_2 && var1_1[var4_4] != 61) {
                ++var4_4;
            }
            var6_7 = this.decode(var1_1, var5_6, var4_4 - var5_6);
            if (var1_1[var4_4++] != 61) {
                throw new IllegalArgumentException();
            }
            var5_6 = var4_4;
            while (var4_4 < var2_2 && var1_1[var4_4] != 38) {
                ++var4_4;
            }
            var7_8 = this.decode(var1_1, var5_6, var4_4 - var5_6);
            if (var4_4 < var2_2 && var1_1[var4_4] == 38) {
                ++var4_4;
            }
            if (var3_3.containsKey(var6_7)) {
                var9_9 = (String[])var3_3.get(var6_7);
                var8_5 = new String[var9_9.length + 1];
                var10_10 = 0;
                while (var10_10 < var9_9.length) {
                    var8_5[var10_10] = var9_9[var10_10];
                    ++var10_10;
                }
                var8_5[var9_9.length] = var7_8;
            } else {
                var8_5 = new String[]{var7_8};
            }
            var3_3.put(var6_7, var8_5);
lbl32:
            // 2 sources

            ** while (var4_4 < var2_2)
        }
lbl33:
        // 1 sources

        return var3_3;
    }

    public void AddHttpParam(String string, String string2) {
        String[] stringArray = null;
        if (this.m_htParams == null) {
            this.m_htParams = this.getParametersFromRequest();
        }
        if (this.m_htParams.containsKey(string)) {
            String[] stringArray2 = (String[])this.m_htParams.get(string);
            stringArray = new String[stringArray2.length + 1];
            int n = 0;
            while (n < stringArray2.length) {
                stringArray[n] = stringArray2[n];
                ++n;
            }
            stringArray[stringArray2.length] = string2;
        } else {
            stringArray = new String[]{string2};
        }
        this.m_htParams.put(string, stringArray);
    }

    protected String decode(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = 0;
        while (n5 < n2) {
            switch (byArray[n3]) {
                case 43: {
                    byArray[n4] = 32;
                    break;
                }
                case 37: {
                    if (byArray[n3 + 1] == 117) {
                        int n6 = 0;
                        int n7 = 0;
                        n6 = Character.digit((char)byArray[n3 + 2], 16) * 16 + Character.digit((char)byArray[n3 + 3], 16);
                        n7 = Character.digit((char)byArray[n3 + 4], 16) * 16 + Character.digit((char)byArray[n3 + 5], 16);
                        char c = (char)((n6 & 0xFF) << 8);
                        c = (char)(c | (char)(n7 & 0xFF));
                        Character c2 = new Character(c);
                        String string = c2.toString();
                        try {
                            byte[] byArray2 = string.getBytes(this.getCharacterEncoding());
                            int n8 = 0;
                            while (n8 < byArray2.length) {
                                byArray[n4] = byArray2[n8];
                                ++n8;
                                ++n4;
                            }
                            --n4;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            System.out.println("Unsupported Encoding Exception (" + this.getCharacterEncoding() + ")");
                        }
                        n3 += 5;
                        n5 += 5;
                        break;
                    }
                    int n9 = Character.digit((char)byArray[n3 + 1], 16) * 16 + Character.digit((char)byArray[n3 + 2], 16);
                    n3 += 2;
                    n5 += 2;
                    byArray[n4] = (byte)n9;
                    break;
                }
                default: {
                    byArray[n4] = byArray[n3];
                }
            }
            ++n3;
            ++n4;
            ++n5;
        }
        String string = null;
        try {
            string = new String(byArray, n, n4 - n, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Unsupported Encoding Exception (" + this.getCharacterEncoding() + ")");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = new String(byArray, n, n4 - n);
        }
        return string;
    }

    public PipedOutputStream getXMLOutputStream() {
        if (this.m_xmlOut == null) {
            this.m_xmlOut = new PipedOutputStream();
            if (this.m_xmlIn != null) {
                try {
                    this.m_xmlOut.connect(this.m_xmlIn);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return this.m_xmlOut;
    }

    public PipedInputStream getXMLInputStream() {
        if (this.m_xmlIn == null) {
            this.m_xmlIn = new PipedInputStream();
            if (this.m_xmlOut != null) {
                try {
                    this.m_xmlIn.connect(this.m_xmlOut);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return this.m_xmlIn;
    }
}

