/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.ByteCodeOutputStream;
import com.novell.webaccess.common.CommandLine;
import com.novell.webaccess.common.CompileException;
import com.novell.webaccess.common.EOTemplateException;
import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NPropertyBundle;
import com.novell.webaccess.common.SBTokenizer;
import com.novell.webaccess.common.TemplateTextStream;
import com.novell.webaccess.common.TemplateToJspPass2;
import com.novell.webaccess.common.njFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;

public class TemplateToJsp {
    static final String OBJECT_NAME = "c";
    static final int IDENT_BAD = 0;
    static final int IDENT_GOOD = 1;
    static final int IDENT_SUBSCRIPT = 2;
    private static final String[][] m_tblKeywords = new String[][]{{"!", "doCOMMENT", "doCOMMENT"}, {"OUTPUT", "doOUTPUT", "doOUTPUT"}, {"NOOUTPUT", "doNOOUTPUT", "doNOOUTPUT"}, {"IF", "doIF", "doIF"}, {"IFDEF", "doIFDEF", "doIFDEF"}, {"ELSE", "doELSE", "doELSE"}, {"ELSEIFDEF", "doELSEIFDEF", "doELSEIFDEF"}, {"ELSEIF", "doELSEIF", "doELSEIF"}, {"ENDIF", "doENDIF", "doENDIF"}, {"WHILE", "doWHILE", "doWHILE"}, {"BREAK", "doBREAK", "doNOOP"}, {"CONTINUE", "doCONTINUE", "doNOOP"}, {"ENDWHILE", "doENDWHILE", "doENDWHILE"}, {"SET", "doSETLOCAL", "doNOOP"}, {"SETGLOBAL", "doSETGLOBAL", "doNOOP"}, {"INC", "doINC", "doNOOP"}, {"DEC", "doDEC", "doNOOP"}, {"INCLUDE", "doINCLUDE", "doNOOP"}, {"STRINGTABLE", "doSTRINGTABLE", "doNOOP"}, {"STRING", "doSTRING", "doNOOP"}, {"VAR", "doVAR", "doNOOP"}, {"IGNOREWHITE", "doIGNOREWHITE", "doNOOP"}, {"NOIGNOREWHITE", "doNOIGNOREWHITE", "doNOOP"}, {"ABORT", "doABORT", "doNOOP"}, {"FLUSH", "doFLUSH", "doNOOP"}, {"DUMPALL", "doDUMPALL", "doNOOP"}, {"COOKIE", "doCOOKIE", "doNOOP"}, {"HEADER", "doHEADER", "doNOOP"}, {"HEADER", "doHEADER", "doNOOP"}, {"ALIAS", "doALIAS", "doALIAS"}, {"NOOP", "doNOOP", "doNOOP"}};
    private static final int TABLE_ENTRIES = 31;
    private static final String[][] m_tblFunctions = new String[][]{{"substring", "3"}, {"toLower", "1"}, {"toUpper", "1"}, {"length", "1"}, {"findLast", "2"}, {"find", "2"}, {"date", "2"}, {"createDate", "3"}, {"firstWeekDayOfMonth", "1"}, {"firstDayOfWeek", "2"}, {"daysInMonth", "1"}, {"today", "0"}, {"todayTZ", "0"}, {"addToDate", "3"}, {"escape", "1"}, {"replaceWith", "3"}, {"linkURLs", "5"}, {"linkEncodedURLs", "5"}, {"toHTML", "1"}, {"toScript", "1"}, {"urlEncode", "1"}, {"urlEncodePath", "1"}, {"listToArray", "3"}, {"trim", "1"}, {"startsWith", "2"}, {"endsWith", "2"}, {"toSpellerText", "2"}, {"getHeader", "1"}, {"toHTMLExt", "1"}, {"listToSortedArray", "4"}, {"toDisplay", "1"}, {"toXML", "1"}, {"xmlEncode", "1"}, {"xmlDecode", "1"}, {"formatMessage", "1+"}, {"toTag", "1"}, {"toWMLExt", "1"}};
    private static final int FUNCTION_COUNT = 37;
    static final char TEMPLATE_START_CHAR = '{';
    static final char TEMPLATE_END_CHAR = '}';
    static final char TEMPLATE_COMMENT_CHAR = '!';
    static final char TEMPLATE_ESCAPE_CHAR = '\\';
    private String m_strTemplatePath;
    private String sTemplate;
    private String m_strJspFile = null;
    private OutputStream m_jStream = null;
    protected TemplateTextStream m_tStream = null;
    private boolean m_bDebug = false;
    private I18NLocale m_uiLocale = null;
    private int m_iResursionDepth = 0;
    private boolean m_bIsInclude = false;
    private static Properties m_inProcess = new Properties();

    public static void main(String[] stringArray) {
        Object object;
        CommandLine commandLine = new CommandLine(stringArray);
        String string = commandLine.getDefaultArg();
        boolean bl = false;
        if (string == null) {
            System.out.println("Please specify a template to convert");
            System.out.println("    TemplateToJsp template.htt");
            return;
        }
        String string2 = commandLine.getArg("d");
        if (string2 == null) {
            object = new File(string);
            string2 = ((File)object).getParent();
        }
        if ((object = commandLine.getArg("debug")) != null) {
            bl = true;
        }
        TemplateToJsp templateToJsp = new TemplateToJsp(null, string, string2, System.out, new I18NLocale(), bl);
        try {
            templateToJsp.compile(false);
            int n = string.lastIndexOf(".");
            string = n != -1 ? string.substring(0, n) + ".jsp1" : string + ".jsp1";
            TemplateToJspPass2.main(new String[]{string});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TemplateToJsp(InputStream inputStream, String string, String string2, OutputStream outputStream, I18NLocale i18NLocale) {
        this(inputStream, string, string2, outputStream, i18NLocale, false);
    }

    public TemplateToJsp(InputStream inputStream, String string, String string2, OutputStream outputStream, I18NLocale i18NLocale, boolean bl) {
        njFile njFile2 = new njFile(string);
        try {
            string = njFile2.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this.init(string, string2, outputStream, i18NLocale, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not open output file: " + this.sTemplate);
        }
    }

    void init(String string, String string2, OutputStream outputStream, I18NLocale i18NLocale, boolean bl) throws FileNotFoundException {
        String string3;
        this.m_bDebug = bl;
        this.m_strTemplatePath = string;
        this.sTemplate = this.getTemplateName();
        int n = this.sTemplate.lastIndexOf(".");
        if (n != -1) {
            string3 = this.sTemplate.substring(n + 1);
            this.sTemplate = this.sTemplate.substring(0, n);
            if (!string3.equalsIgnoreCase("htt")) {
                this.sTemplate = this.sTemplate + "_" + string3;
                this.m_bIsInclude = true;
            }
        }
        string3 = this.sTemplate = this.sTemplate + ".jsp1";
        if (string2 == null) {
            string2 = this.getTemplatePath().toString();
        }
        if (!string2.endsWith("\\") && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        File file = new File(string2);
        file.mkdirs();
        this.m_strJspFile = string2 + string3;
        this.m_jStream = this.m_bDebug ? System.out : new FileOutputStream(this.m_strJspFile);
        this.m_uiLocale = i18NLocale == null ? new I18NLocale() : i18NLocale;
    }

    public String getJSPFile() {
        return this.m_strJspFile;
    }

    public static String getFunctionName(int n) {
        if (n > 37) {
            return "";
        }
        return m_tblFunctions[n][0];
    }

    public boolean compile(boolean bl) throws CompileException, IOException {
        Object object;
        File file = new File(this.m_strTemplatePath);
        if (!file.exists()) {
            object = file.getName();
            int n = ((String)object).lastIndexOf(47);
            if (n < 0) {
                n = ((String)object).lastIndexOf(92);
            }
            if (n > 0) {
                object = ((String)object).substring(n + 1);
            }
            this.compileError("Error.Compile.Template.noExist", (String)object, null, null, null, null, null);
        }
        object = null;
        try {
            object = new FileInputStream(file);
        }
        catch (IOException iOException) {
            object = null;
        }
        if (object == null) {
            String string = file.getName();
            int n = string.lastIndexOf(47);
            if (n < 0) {
                n = string.lastIndexOf(92);
            }
            if (n > 0) {
                string = string.substring(n + 1);
            }
            this.compileError("Error.Compile.Template.noOpen", string, null, null, null, null, null);
        }
        this.m_tStream = new TemplateTextStream((InputStream)object);
        boolean bl2 = this.compileStream(bl);
        if (!this.m_bDebug) {
            this.m_jStream.close();
        }
        return bl2;
    }

    boolean compileStream(boolean bl) throws CompileException, IOException {
        char c;
        String string = null;
        string = "<%@  page import=\"com.novell.webaccess.common.JSPConduit\" %>\n";
        string = string + "<%   JSPConduit c = JSPConduit.getJSPConduit(request); %>\n";
        this.m_jStream.write(string.getBytes());
        try {
            c = this.m_tStream.read();
        }
        catch (EOTemplateException eOTemplateException) {
            try {
                this.m_tStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        try {
            while (true) {
                this.CompilePart(c);
                c = this.m_tStream.read();
            }
        }
        catch (CompileException compileException) {
            try {
                this.m_tStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw compileException;
        }
        catch (EOTemplateException eOTemplateException) {
            try {
                this.m_tStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
    }

    boolean CompilePart(char c) throws CompileException, EOTemplateException, IOException {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(c);
        if (c != '{') {
            this.doTEXT(stringBuffer);
            return true;
        }
        String string = this.getPotentialKeyword(stringBuffer);
        int n = this.isTemplateKeyword(string);
        if (n != -1) {
            this.compileKeyword(string, n, stringBuffer);
        } else {
            this.doTEXT(stringBuffer);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    String getPotentialKeyword(StringBuffer var1_1) {
        var2_2 = null;
        try {
            var3_3 = this.m_tStream.read();
        }
        catch (EOTemplateException var4_4) {
            return "";
        }
        if (var3_3 != '!') ** GOTO lbl17
        var2_2 = "!";
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var1_1.append(var3_3);
            try {
                var3_3 = this.m_tStream.read();
                continue;
            }
            catch (EOTemplateException var4_5) {
                return "";
            }
lbl17:
            // 2 sources

            ** while (Character.isWhitespace((char)var3_3))
        }
lbl18:
        // 1 sources

        var4_6 = new StringBuffer();
        if (Character.isJavaIdentifierStart(var3_3)) ** GOTO lbl31
        this.m_tStream.putBack(var3_3);
        return "";
lbl-1000:
        // 1 sources

        {
            var1_1.append(var3_3);
            var4_6.append(var3_3);
            try {
                var3_3 = this.m_tStream.read();
                continue;
            }
            catch (EOTemplateException var5_7) {
                return "";
            }
lbl31:
            // 2 sources

            ** while (Character.isJavaIdentifierPart((char)var3_3))
        }
lbl32:
        // 1 sources

        this.m_tStream.putBack(var3_3);
        return var4_6.toString();
    }

    private int isTemplateKeyword(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n = 0;
        n = 0;
        while (n < 31) {
            if (string.equals(m_tblKeywords[n][0])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    boolean compileKeyword(String string, int n, StringBuffer stringBuffer) throws EOTemplateException, CompileException, IOException {
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = stringBuffer.length();
        int n3 = 0;
        stringBuffer3.append(stringBuffer.charAt(n3++));
        if (n3 < n2) {
            char c = stringBuffer.charAt(n3);
            while (n3 < n2 && Character.isWhitespace(c)) {
                stringBuffer3.append(c);
                c = stringBuffer.charAt(n3++);
            }
        }
        n3 += string.length();
        int n4 = stringBuffer.length();
        while (n3 < n4) {
            stringBuffer2.append(stringBuffer.charAt(n3));
            ++n3;
        }
        if (string.equals(m_tblKeywords[0][0])) {
            this.getRestOfComment(stringBuffer2);
        } else {
            this.getRestOfKeyword(stringBuffer2);
        }
        return this.processKeyword(stringBuffer2, n, false);
    }

    /*
     * Unable to fully structure code
     */
    void getRestOfComment(StringBuffer var1_1) throws IOException {
        var2_2 = new StringBuffer();
        var2_2.append("<%/*");
        var3_3 = 1;
        var5_4 = false;
        try {
            var4_5 = this.m_tStream.read();
            if (true) ** GOTO lbl52
        }
        catch (EOTemplateException var6_6) {
            var2_2.append(" --%> ");
            this.m_jStream.write(var2_2.toString().getBytes());
            return;
        }
        do {
            if (!var5_4 && var4_5 == '\\') {
                var5_4 = true;
            } else {
                if (var5_4) {
                    switch (var4_5) {
                        case 'n': {
                            var4_5 = '\n';
                            break;
                        }
                        case 'r': {
                            var4_5 = '\r';
                            break;
                        }
                        case 't': {
                            var4_5 = '\t';
                            break;
                        }
                        case 'f': {
                            var4_5 = '\f';
                            break;
                        }
                        case 'b': {
                            var4_5 = '\b';
                        }
                    }
                } else if (var4_5 == '{') {
                    ++var3_3;
                } else if (var4_5 == '}') {
                    --var3_3;
                }
                var5_4 = false;
                if (var3_3 > 0) {
                    var2_2.append(var4_5);
                }
                var1_1.append(var4_5);
            }
            if (var3_3 <= 0) continue;
            try {
                var4_5 = this.m_tStream.read();
            }
            catch (EOTemplateException var6_7) {
                return;
            }
lbl52:
            // 3 sources

        } while (var3_3 > 0);
        var2_2.append(" */%> ");
        this.m_jStream.write(var2_2.toString().getBytes());
    }

    /*
     * Unable to fully structure code
     */
    void getRestOfKeyword(StringBuffer var1_1) throws CompileException, EOTemplateException {
        var2_2 = 1;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 0;
        var7_6 = false;
        var8_7 = -1;
        var9_8 = -1;
        var10_9 = new StringBuffer();
        try {
            var6_10 = this.m_tStream.read();
            if (true) ** GOTO lbl80
        }
        catch (EOTemplateException var11_11) {
            return;
        }
        do {
            if (!var7_6 && var6_10 == '\\') {
                var7_6 = true;
            } else {
                if (var7_6) {
                    switch (var6_10) {
                        case 'n': {
                            var6_10 = '\n';
                            break;
                        }
                        case 'r': {
                            var6_10 = '\r';
                            break;
                        }
                        case 't': {
                            var6_10 = '\t';
                            break;
                        }
                        case 'f': {
                            var6_10 = '\f';
                            break;
                        }
                        case 'b': {
                            var6_10 = '\b';
                        }
                    }
                } else {
                    if (var6_10 == '\r' || var6_10 == '\n') {
                        if (var4_4 > 0) {
                            this.compileError("Error.Compile.noEndDQuote", null, null, null, null, null, null);
                        } else if (var5_5 > 0) {
                            this.compileError("Error.Compile.noEndSQuopte", null, null, null, null, null, null);
                        }
                    }
                    if (var4_4 == 0 && var5_5 == 0) {
                        if (var6_10 == '{') {
                            var8_7 = var1_1.length();
                            ++var2_2;
                        } else if (var6_10 == '}') {
                            --var2_2;
                        } else if (var6_10 == '(') {
                            ++var3_3;
                        } else if (var6_10 == ')') {
                            if (var3_3 > 0) {
                                --var3_3;
                            } else {
                                this.compileError("Error.Compile.parenNotBrace", null, null, null, null, null, null);
                            }
                        }
                    }
                    if (var8_7 >= 0) {
                        if (var6_10 == '}' || Character.isSpaceChar(var6_10)) {
                            var9_8 = var1_1.length();
                            var11_12 = var10_9.toString();
                            var10_9.setLength(0);
                        } else if (var1_1.length() > var8_7) {
                            var10_9.append(var6_10);
                        }
                    }
                    if (var6_10 == '\'' && var4_4 == 0) {
                        var5_5 = var5_5 == 0 ? 1 : 0;
                    } else if (var6_10 == '\"' && var5_5 == 0) {
                        var4_4 = var4_4 == 0 ? 1 : 0;
                    }
                }
                var7_6 = false;
                var1_1.append(var6_10);
            }
            if (var2_2 <= 0) continue;
            try {
                var6_10 = this.m_tStream.read();
            }
            catch (EOTemplateException var11_13) {
                return;
            }
lbl80:
            // 3 sources

        } while (var2_2 > 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean processKeyword(StringBuffer stringBuffer, int n, boolean bl) throws CompileException {
        if (bl) {
            ++this.m_iResursionDepth;
        }
        Class<?> clazz = this.getClass();
        Method method = null;
        try {
            Class[] classArray = new Class[]{Class.forName("java.lang.StringBuffer")};
            method = clazz.getDeclaredMethod(m_tblKeywords[n][1], classArray);
            Object[] objectArray = new Object[]{stringBuffer};
            Boolean bl2 = (Boolean)method.invoke((Object)this, objectArray);
            if (!bl && !bl2.booleanValue()) {
                // empty if block
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            Class<?> clazz2 = throwable.getClass();
            if (clazz2.getName().equals("com.novell.webaccess.common.CompileException")) {
                throw (CompileException)throwable;
            }
            throwable.printStackTrace();
            this.compileError("Error.exception", null, null, null, null, null, null);
            System.out.println(invocationTargetException.getTargetException().getMessage());
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (Exception exception) {
            this.compileError("Error.Compile.unhandledKeyword", m_tblKeywords[n][0], null, null, null, null, null);
            System.out.println(exception.getMessage());
        }
        if (bl) {
            --this.m_iResursionDepth;
        }
        return true;
    }

    public String getTemplateName() {
        String string = new String(this.m_strTemplatePath);
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String getTemplateFullName() {
        Object var1_1 = null;
        File file = new File(this.m_strTemplatePath);
        Object var3_3 = null;
        String string = file.getAbsolutePath();
        return string;
    }

    public StringBuffer getTemplatePath() {
        int n;
        Object var1_1 = null;
        File file = new File(this.m_strTemplatePath);
        Object var3_3 = null;
        String string = file.getAbsolutePath();
        int n2 = string.lastIndexOf(92);
        if (n2 < (n = string.lastIndexOf(47))) {
            n2 = n;
        }
        if (n2 >= 0) {
            if (n2 > 0) {
                ++n2;
            }
            string = string.substring(0, n2);
        } else {
            string = "";
        }
        return new StringBuffer(string);
    }

    int isValidIdentifier(StringBuffer stringBuffer, SBTokenizer sBTokenizer) throws CompileException {
        boolean bl = false;
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            if (c == '[') {
                bl = true;
                while (c != ']' && n2 < n) {
                    if (++n2 == n) {
                        n = this.getRestOfSubscript(stringBuffer, sBTokenizer);
                    }
                    c = stringBuffer.charAt(n2);
                }
                if (n2 == n) {
                    return 0;
                }
            } else if (n2 == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c) && c != '.' && c != ':') {
                return 0;
            }
            ++n2;
        }
        if (bl) {
            return 2;
        }
        return 1;
    }

    private int getRestOfSubscript(StringBuffer stringBuffer, SBTokenizer sBTokenizer) throws CompileException {
        boolean bl = false;
        do {
            StringBuffer stringBuffer2;
            String string;
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Subscript.badFormat", null, null, null, null, null, null);
            }
            if ((string = (stringBuffer2 = sBTokenizer.nextToken()).toString()).indexOf(93) >= 0) {
                bl = true;
            }
            stringBuffer.append(string);
        } while (!bl);
        return stringBuffer.length();
    }

    static boolean isNumeric(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                case '-': {
                    if (n2 <= 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    void stripParens(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n < 2) {
            return;
        }
        char[] cArray = new char[n - 2];
        stringBuffer.getChars(1, n - 1, cArray, 0);
        stringBuffer.setLength(0);
        stringBuffer.append(cArray);
    }

    private void evaluateBooleanExpression(StringBuffer stringBuffer) throws CompileException, IOException {
        Vector vector = new Vector();
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=+-*%/<>!&|");
        StringBuffer stringBuffer3 = new StringBuffer("=+-*%/{<>!&|");
        StringBuffer stringBuffer4 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer5 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Expression.Conditional.missingExpression", null, null, null, null, null, null);
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        this.arithmeticExpression(stringBuffer6, sBTokenizer, true, false);
    }

    private void arithmeticExpression(StringBuffer stringBuffer, SBTokenizer sBTokenizer, boolean bl, boolean bl2) throws CompileException, IOException {
        String string = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl3 = false;
        boolean bl4 = false;
        Vector vector = new Vector();
        this.evaluateOperand(stringBuffer, sBTokenizer, bl, bl2);
        if (!sBTokenizer.hasMoreTokens()) {
            return;
        }
        do {
            StringBuffer stringBuffer3;
            CharSequence charSequence;
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Expression.invalid", null, null, null, null, null, null);
            }
            stringBuffer2 = sBTokenizer.nextToken();
            boolean bl5 = false;
            char c = '\u0000';
            char c2 = stringBuffer2.charAt(0);
            if (stringBuffer2.length() > 1) {
                c = stringBuffer2.charAt(1);
            }
            if (stringBuffer2.length() == 1) {
                char c3;
                if (c2 == '+' || c2 == '-' || c2 == '*' || c2 == '/' || c2 == '%') {
                    bl5 = true;
                } else if (c2 == '=' || c2 == '<' || c2 == '>' || c2 == '!') {
                    bl5 = true;
                    if (sBTokenizer.hasMoreTokens()) {
                        charSequence = sBTokenizer.nextToken();
                        char c4 = ((StringBuffer)charSequence).charAt(0);
                        if (c4 == '=') {
                            c = '=';
                            stringBuffer2.append('=');
                        } else {
                            sBTokenizer.putBackToken();
                        }
                    }
                } else if ((c2 == '&' || c2 == '|') && sBTokenizer.hasMoreTokens() && (c3 = ((StringBuffer)(charSequence = sBTokenizer.nextToken())).charAt(0)) == c2) {
                    stringBuffer2.append(c3);
                    bl5 = true;
                    if (bl3) {
                        if (bl4) {
                            string = ")";
                            this.m_jStream.write(string.getBytes());
                        } else {
                            string = ") == false";
                            this.m_jStream.write(string.getBytes());
                        }
                        bl3 = false;
                    }
                }
            } else if (stringBuffer2.length() == 2 && (c2 == '&' || c2 == '|') && c == c2) {
                bl5 = true;
            }
            if (!bl5) {
                this.compileError("Error.Compile.Expression.badOperator", null, null, null, null, null, null);
            }
            charSequence = stringBuffer2.toString();
            if (stringBuffer2.length() == 2 && stringBuffer2.charAt(1) == '=' || bl && stringBuffer2.charAt(0) == '=') {
                if (stringBuffer2.charAt(0) == '=' || stringBuffer2.charAt(0) == '!') {
                    string = ".equals(";
                    this.m_jStream.write(string.getBytes());
                    bl3 = true;
                    bl4 = stringBuffer2.charAt(0) == '=';
                } else {
                    if (stringBuffer2.charAt(0) != '&' && stringBuffer2.charAt(0) != '|') {
                        stringBuffer2.insert(0, '~');
                        stringBuffer2.append('~');
                    }
                    string = " " + stringBuffer2.toString() + " ";
                    this.m_jStream.write(string.getBytes());
                }
            } else {
                if (stringBuffer2.charAt(0) != '&' && stringBuffer2.charAt(0) != '|') {
                    stringBuffer2.insert(0, '~');
                    stringBuffer2.append('~');
                }
                string = " " + stringBuffer2.toString() + " ";
                this.m_jStream.write(string.getBytes());
            }
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
            }
            if ((stringBuffer3 = sBTokenizer.nextToken()).length() == 1 && stringBuffer3.charAt(0) == '-' && sBTokenizer.hasMoreTokens()) {
                stringBuffer3.append((Object)sBTokenizer.nextToken());
            }
            this.evaluateOperand(stringBuffer3, sBTokenizer, bl, bl2);
        } while (sBTokenizer.hasMoreTokens());
        if (bl3) {
            if (bl4) {
                string = ")";
                this.m_jStream.write(string.getBytes());
            } else {
                string = ") == false";
                this.m_jStream.write(string.getBytes());
            }
        }
    }

    void arithmeticSubExpression(StringBuffer stringBuffer, boolean bl, boolean bl2) throws CompileException, IOException {
        this.stripParens(stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=<>!+-*%/&|");
        StringBuffer stringBuffer3 = new StringBuffer("=+-*%/{<>!&|");
        StringBuffer stringBuffer4 = new StringBuffer("{}()");
        StringBuffer stringBuffer5 = new StringBuffer("{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        this.arithmeticExpression(stringBuffer6, sBTokenizer, bl, bl2);
    }

    void evaluateOperand(StringBuffer stringBuffer, SBTokenizer sBTokenizer, boolean bl, boolean bl2) throws CompileException, IOException {
        char c = stringBuffer.charAt(0);
        String string = stringBuffer.toString();
        if (string.equals("DEF")) {
            StringBuffer stringBuffer2;
            int n;
            String string2 = " c.def(";
            this.m_jStream.write(string2.getBytes());
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.DEF.missingVariable", "DEF", null, null, null, null, null);
            }
            if ((n = this.isValidIdentifier(stringBuffer2 = sBTokenizer.nextToken(), sBTokenizer)) == 2) {
                this.doArrayName(stringBuffer2, bl2);
            } else {
                string2 = "\"" + stringBuffer2.toString() + "\"";
                this.m_jStream.write(string2.getBytes());
            }
            string2 = ")";
            this.m_jStream.write(string2.getBytes());
            return;
        }
        if (string.equals("NOTDEF")) {
            StringBuffer stringBuffer3;
            int n;
            String string3 = " c.notdef(";
            this.m_jStream.write(string3.getBytes());
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.DEF.missingVariable", "NOTDEF", null, null, null, null, null);
            }
            if ((n = this.isValidIdentifier(stringBuffer3 = sBTokenizer.nextToken(), sBTokenizer)) == 2) {
                this.doArrayName(stringBuffer3, bl2);
            } else {
                string3 = "\"" + stringBuffer3.toString() + "\"";
                this.m_jStream.write(string3.getBytes());
            }
            string3 = ")";
            this.m_jStream.write(string3.getBytes());
        } else if (c == '(') {
            String string4 = "(";
            this.m_jStream.write(string4.getBytes());
            this.arithmeticSubExpression(stringBuffer, bl, bl2);
            string4 = ")";
            this.m_jStream.write(string4.getBytes());
        } else if (TemplateToJsp.isNumeric(stringBuffer)) {
            this.handleNumericConstant(stringBuffer);
        } else if (c == '\"' || c == '\'') {
            this.handleStringConstant(stringBuffer);
        } else if (c == '{') {
            this.handleLookup(stringBuffer);
        } else {
            int n = this.isFunction(stringBuffer);
            if (n >= 0) {
                if (!sBTokenizer.hasMoreTokens()) {
                    this.compileError("Error.Compile.Function.syntax", stringBuffer.toString(), null, null, null, null, null);
                }
                this.doFunction(stringBuffer, n, sBTokenizer.nextToken(), bl2, true);
                return;
            }
            this.doVariable(stringBuffer, bl2);
        }
    }

    void handleNumericConstant(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = "\"" + stringBuffer.toString() + "\"";
        this.m_jStream.write(string.getBytes());
    }

    void handleStringConstant(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = stringBuffer.toString();
        this.m_jStream.write(string.getBytes());
    }

    void handleLookup(StringBuffer stringBuffer) throws CompileException, IOException {
        boolean bl;
        StringBuffer stringBuffer2;
        int n;
        StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer4 = new StringBuffer("");
        StringBuffer stringBuffer5 = new StringBuffer("\"\"''");
        StringBuffer stringBuffer6 = new StringBuffer("\"'");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer3, stringBuffer4);
        sBTokenizer.setQuotes(stringBuffer5, stringBuffer6, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
        }
        if ((n = this.isTemplateKeyword((stringBuffer2 = sBTokenizer.nextToken()).toString())) == -1) {
            this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
        }
        if (!(bl = this.processKeyword(sBTokenizer.getRemaining(), n, true))) {
            this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
        }
    }

    private void stringExpression(SBTokenizer sBTokenizer, StringBuffer stringBuffer) {
    }

    void save(OutputStream outputStream) {
    }

    private boolean doCOMMENT(StringBuffer stringBuffer) throws CompileException {
        return false;
    }

    private boolean doNOOUTPUT(StringBuffer stringBuffer) throws CompileException {
        return false;
    }

    private boolean doOUTPUT(StringBuffer stringBuffer) throws CompileException {
        return false;
    }

    private boolean doTEXT(StringBuffer stringBuffer) throws CompileException, IOException {
        ByteCodeOutputStream byteCodeOutputStream = new ByteCodeOutputStream();
        char c = '\u0000';
        int n = 0;
        boolean bl = false;
        int n2 = stringBuffer.length();
        int n3 = 0;
        while (n3 < n2) {
            c = stringBuffer.charAt(n3);
            byteCodeOutputStream.write(c);
            ++n;
            ++n3;
        }
        try {
            c = this.m_tStream.read();
        }
        catch (EOTemplateException eOTemplateException) {
            if (n == 0) {
                return false;
            }
            bl = true;
        }
        while (!bl) {
            if (c == '{') {
                char c2;
                try {
                    c2 = this.m_tStream.read();
                }
                catch (EOTemplateException eOTemplateException) {
                    bl = true;
                    break;
                }
                if (c2 == '!') {
                    if (n > 0) {
                        this.m_jStream.write(byteCodeOutputStream.toByteArray());
                        byteCodeOutputStream.reset();
                        n = 0;
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    this.getRestOfComment(stringBuffer2);
                    try {
                        c = this.m_tStream.read();
                        continue;
                    }
                    catch (EOTemplateException eOTemplateException) {
                        bl = true;
                        break;
                    }
                }
                this.m_tStream.putBack(c2);
                break;
            }
            byteCodeOutputStream.write(c);
            ++n;
            try {
                c = this.m_tStream.read();
            }
            catch (EOTemplateException eOTemplateException) {
                bl = true;
            }
        }
        if (!bl) {
            this.m_tStream.putBack(c);
        }
        if (n > 0) {
            this.m_jStream.write(byteCodeOutputStream.toByteArray());
        }
        return false;
    }

    private boolean doIFDEF(StringBuffer stringBuffer) throws CompileException, IOException {
        StringBuffer stringBuffer2 = new StringBuffer("DEF ");
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        stringBuffer2.append(cArray);
        this.doIF(stringBuffer2);
        return false;
    }

    private boolean doIF(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        string = "<% if (";
        this.m_jStream.write(string.getBytes());
        this.evaluateBooleanExpression(stringBuffer);
        string = ") { %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doENDIF(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        string = "<% } %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doELSE(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        string = "<% } else { %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doELSEIF(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        string = "<% } else if (";
        this.m_jStream.write(string.getBytes());
        this.evaluateBooleanExpression(stringBuffer);
        string = ") { %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doELSEIFDEF(StringBuffer stringBuffer) throws CompileException, IOException {
        StringBuffer stringBuffer2 = new StringBuffer("DEF ");
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        stringBuffer2.append(cArray);
        this.doELSEIF(stringBuffer2);
        return false;
    }

    private boolean doWHILE(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        string = "<% while (";
        this.m_jStream.write(string.getBytes());
        this.evaluateBooleanExpression(stringBuffer);
        string = ") { %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doBREAK(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        string = "<% break; %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doCONTINUE(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        string = "<% continue; %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doENDWHILE(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        string = "<% } %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doALIAS(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{=+-*%/");
        StringBuffer stringBuffer4 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer5 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Alias.missingName", "ALIAS", null, null, null, null, null);
            return false;
        }
        sBTokenizer.nextToken();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Alias.missingName", "ALIAS", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Alias.missingName", "ALIAS", null, null, null, null, null);
            return false;
        }
        sBTokenizer.nextToken();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Alias.missingValue", "ALIAS", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer7 = sBTokenizer.nextToken();
        while (sBTokenizer.hasMoreTokens()) {
            stringBuffer7.append((Object)sBTokenizer.nextToken());
        }
        string = "<% final STATIC String " + stringBuffer6.toString() + " = " + stringBuffer7.toString();
        return false;
    }

    private boolean doHEADER(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer3 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer4 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer5 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        string = "<% response.setHeader(";
        this.m_jStream.write(string.getBytes());
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Header.missingName", "HEADER", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        this.evaluateOperand(stringBuffer6, sBTokenizer, false, false);
        string = ", ";
        this.m_jStream.write(string.getBytes());
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Header.missingValue", "HEADER", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer7 = sBTokenizer.nextToken();
        this.evaluateOperand(stringBuffer7, sBTokenizer, false, false);
        string = "); %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doCOOKIE(StringBuffer stringBuffer) throws CompileException, IOException {
        StringBuffer stringBuffer2;
        String string = null;
        StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer4 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer5 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer6 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer3, stringBuffer4);
        sBTokenizer.setQuotes(stringBuffer5, stringBuffer6, '\u0000');
        sBTokenizer.tokenize();
        string = "<% response.setHeader(\"Set-Cookie\", ";
        this.m_jStream.write(string.getBytes());
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Cookie.missingParameter", "COOKIE", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer7 = sBTokenizer.nextToken();
        this.evaluateOperand(stringBuffer7, sBTokenizer, false, false);
        string = "+ \"=\"+ ";
        this.m_jStream.write(string.getBytes());
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Cookie.missingParameter", "COOKIE", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer8 = sBTokenizer.nextToken();
        this.evaluateOperand(stringBuffer8, sBTokenizer, false, false);
        if (sBTokenizer.hasMoreTokens() && !(stringBuffer2 = sBTokenizer.nextToken()).toString().equals("\"\"")) {
            string = "+ \";+ domain=\"+ ";
            this.m_jStream.write(string.getBytes());
            this.evaluateOperand(stringBuffer2, sBTokenizer, false, false);
        }
        if (sBTokenizer.hasMoreTokens() && !(stringBuffer2 = sBTokenizer.nextToken()).toString().equals("\"\"")) {
            string = "+ \";+ path=\"+ ";
            this.m_jStream.write(string.getBytes());
            this.evaluateOperand(stringBuffer2, sBTokenizer, false, false);
        }
        if (sBTokenizer.hasMoreTokens() && !(stringBuffer2 = sBTokenizer.nextToken()).toString().equals("\"\"")) {
            string = "+ \";+ expires=\"+ ";
            this.m_jStream.write(string.getBytes());
            this.evaluateOperand(stringBuffer2, sBTokenizer, false, false);
        }
        if (sBTokenizer.hasMoreTokens() && !(stringBuffer2 = sBTokenizer.nextToken()).toString().equals("\"\"")) {
            string = "+ \"; \"+ ";
            this.m_jStream.write(string.getBytes());
            this.evaluateOperand(stringBuffer2, sBTokenizer, false, false);
        }
        string = "); %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private void doSET(StringBuffer stringBuffer, boolean bl) throws CompileException, IOException {
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3;
        String string = null;
        String string2 = null;
        StringBuffer stringBuffer4 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer5 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer6 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer7 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer4, stringBuffer5);
        sBTokenizer.setQuotes(stringBuffer6, stringBuffer7, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.SET.missingLValue", "SET", null, null, null, null, null);
        }
        StringBuffer stringBuffer8 = sBTokenizer.nextToken();
        string2 = bl ? ".setGlobal(" : ".set(";
        int n = this.isValidIdentifier(stringBuffer8, sBTokenizer);
        if (n == 0) {
            this.compileError("Error.Compile.SET.invalidRValue", stringBuffer8.toString(), null, null, null, null, null);
        }
        if (n == 2) {
            string = "<% c" + string2;
            this.m_jStream.write(string.getBytes());
            this.doArrayName(stringBuffer8, false);
            string = ", ";
            this.m_jStream.write(string.getBytes());
        } else {
            string = "<% c" + string2 + "\"" + stringBuffer8.toString() + "\", ";
            this.m_jStream.write(string.getBytes());
        }
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.SET.missingEq", "SET", null, null, null, null, null);
        }
        if ((stringBuffer3 = sBTokenizer.nextToken()).length() > 1 || stringBuffer3.charAt(0) != '=') {
            this.compileError("Error.Compile.SET.missingEq", "SET", null, null, null, null, null);
        }
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.SET.missingRValue", "SET", null, null, null, null, null);
        }
        if ((stringBuffer2 = sBTokenizer.nextToken()).length() == 1 && stringBuffer2.charAt(0) == '-' && sBTokenizer.hasMoreTokens()) {
            stringBuffer2.append((Object)sBTokenizer.nextToken());
        }
        boolean bl2 = false;
        if (sBTokenizer.hasMoreTokens()) {
            char c;
            StringBuffer stringBuffer9 = sBTokenizer.nextToken();
            sBTokenizer.putBackToken();
            if (stringBuffer9.length() == 1 && ((c = stringBuffer9.charAt(0)) == '+' || c == '-' || c == '*' || c == '/' || c == '%')) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.arithmeticExpression(stringBuffer2, sBTokenizer, false, false);
        } else {
            int n2 = 1;
            this.evaluateOperand(stringBuffer2, sBTokenizer, false, false);
            Object var16_18 = null;
            Object var17_19 = null;
            while (sBTokenizer.hasMoreTokens()) {
                string = " ~+~ ";
                this.m_jStream.write(string.getBytes());
                stringBuffer2 = sBTokenizer.nextToken();
                this.evaluateOperand(stringBuffer2, sBTokenizer, false, false);
                ++n2;
            }
        }
        string = "); %>";
        this.m_jStream.write(string.getBytes());
    }

    private boolean doSETLOCAL(StringBuffer stringBuffer) throws CompileException, IOException {
        this.doSET(stringBuffer, false);
        return false;
    }

    private boolean doSETGLOBAL(StringBuffer stringBuffer) throws CompileException, IOException {
        this.doSET(stringBuffer, true);
        return false;
    }

    private boolean doINC(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer3 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer4 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer5 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.missingName", null, null, null, null, null, null);
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        string = "<% c.inc(\"" + stringBuffer6.toString() + "\"); %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doDEC(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer3 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer4 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer5 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.missingName", null, null, null, null, null, null);
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        string = "<% c.dec(\"" + stringBuffer6.toString() + "\"); %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doINCLUDE(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = this.getParameterValue(stringBuffer).toString();
        int n = string3.lastIndexOf(46);
        if (n != -1) {
            string2 = string3.substring(n + 1);
            if (!string2.equals("htt")) {
                string3 = string3.substring(0, n) + "_" + string3.substring(n + 1);
            } else {
                bl = true;
                string3 = string3.substring(0, n);
            }
        }
        string3 = string3 + ".jsp";
        string = "<jsp:include page=\"" + string3 + "\" flush=\"true\" />";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doSTRINGTABLE(StringBuffer stringBuffer) throws CompileException, IOException {
        StringBuffer stringBuffer2 = this.getParameterValue(stringBuffer);
        String string = null;
        string = "<% c.stringTable(\"" + stringBuffer2.toString() + "\"); %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    StringBuffer getParameterValue(StringBuffer stringBuffer) throws CompileException {
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t}");
        StringBuffer stringBuffer3 = new StringBuffer("x");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.missingValue", null, null, null, null, null, null);
        }
        StringBuffer stringBuffer4 = sBTokenizer.nextToken();
        return stringBuffer4;
    }

    private boolean doSTRING(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.m_iResursionDepth == 0) {
            string = "<%= ";
            string2 = " %>";
        } else {
            string = "";
            string2 = "";
        }
        string3 = string;
        this.m_jStream.write(string3.getBytes());
        this.doVariable(stringBuffer, true);
        this.m_jStream.write(string2.getBytes());
        return true;
    }

    private boolean doVAR(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.m_iResursionDepth == 0) {
            string = "<%= ";
            string2 = " %>";
        } else {
            string = "";
            string2 = "";
        }
        string3 = string;
        this.m_jStream.write(string3.getBytes());
        this.doVariable(stringBuffer, false);
        this.m_jStream.write(string2.getBytes());
        return true;
    }

    private void doVariable(StringBuffer stringBuffer, boolean bl) throws CompileException, IOException {
        StringBuffer stringBuffer2;
        String string = null;
        StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer4 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer5 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer6 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer3, stringBuffer4);
        sBTokenizer.setQuotes(stringBuffer5, stringBuffer6, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.missingName", null, null, null, null, null, null);
        }
        if ((stringBuffer2 = sBTokenizer.nextToken()).charAt(0) == '{') {
            string = bl ? "c.string(" : "c.var(";
            this.m_jStream.write(string.getBytes());
            this.evaluateOperand(stringBuffer2, sBTokenizer, false, bl);
            string = ")";
            this.m_jStream.write(string.getBytes());
            return;
        }
        int n = this.isFunction(stringBuffer2);
        if (n >= 0) {
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Function.syntax", stringBuffer2.toString(), null, null, null, null, null);
            }
            StringBuffer stringBuffer7 = sBTokenizer.nextToken();
            this.doFunction(stringBuffer2, n, stringBuffer7, bl, false);
            this.handleReplaceableParams(sBTokenizer, false);
            return;
        }
        int n2 = this.isValidIdentifier(stringBuffer2, sBTokenizer);
        if (n2 == 0) {
            this.compileError("Error.Compile.badName", stringBuffer2.toString(), null, null, null, null, null);
        }
        if (n2 == 2) {
            this.doArrayName(stringBuffer2, bl);
        } else {
            string = bl ? "c.string(" : "c.var(";
            string = string + "\"" + stringBuffer2.toString() + "\")";
            this.m_jStream.write(string.getBytes());
        }
        this.handleReplaceableParams(sBTokenizer, false);
    }

    private void handleReplaceableParams(SBTokenizer sBTokenizer, boolean bl) throws CompileException, IOException {
        String string = null;
        boolean bl2 = false;
        if (sBTokenizer.hasMoreTokens()) {
            string = " /*PASS2: formatString*/";
            this.m_jStream.write(string.getBytes());
            bl2 = true;
        }
        int n = 0;
        StringBuffer stringBuffer = null;
        while (sBTokenizer.hasMoreTokens()) {
            string = " ";
            this.m_jStream.write(string.getBytes());
            stringBuffer = sBTokenizer.nextToken();
            this.evaluateOperand(stringBuffer, sBTokenizer, false, bl);
            ++n;
        }
        if (bl2) {
            string = " /*ENDPASS2: formatString*/";
            this.m_jStream.write(string.getBytes());
        }
        if (n > 0 && n > 10) {
            this.compileError("Error.Compile.Replaceable.tooMany", null, null, null, null, null, null);
        }
    }

    private void doArrayName(StringBuffer stringBuffer, boolean bl) throws CompileException, IOException {
        String string = null;
        int n = stringBuffer.length();
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer2 = null;
        string = bl ? "c.string(" : "c.var(";
        string = string + "\"";
        this.m_jStream.write(string.getBytes());
        n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            if (c == '[') {
                ++n3;
                int n4 = n2++;
                stringBuffer2 = new StringBuffer();
                c = stringBuffer.charAt(n2);
                while (c != ']') {
                    stringBuffer2.append(c);
                    c = stringBuffer.charAt(++n2);
                }
                string = stringBuffer.substring(0, n4) + ".\"+";
                this.m_jStream.write(string.getBytes());
                StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{}=+-*%/");
                StringBuffer stringBuffer4 = new StringBuffer("=+-*%/{");
                StringBuffer stringBuffer5 = new StringBuffer("\"\"''{}()");
                StringBuffer stringBuffer6 = new StringBuffer("\"'{(");
                SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer2);
                sBTokenizer.setDelims(stringBuffer3, stringBuffer4);
                sBTokenizer.setQuotes(stringBuffer5, stringBuffer6, '\u0000');
                sBTokenizer.tokenize();
                this.arithmeticExpression(sBTokenizer.nextToken(), sBTokenizer, false, false);
                String string2 = stringBuffer.toString().substring(n2 + 1);
                stringBuffer.setLength(0);
                stringBuffer.append(string2);
                n = stringBuffer.length();
                n2 = -1;
                if (n > 0) {
                    string = "+ \"";
                    this.m_jStream.write(string.getBytes());
                }
            }
            ++n2;
        }
        string = "";
        if (stringBuffer.length() > 0) {
            string = stringBuffer.toString() + "\"";
        }
        string = string + ")";
        this.m_jStream.write(string.getBytes());
    }

    private int isFunction(StringBuffer stringBuffer) throws CompileException {
        String string = stringBuffer.toString();
        int n = 0;
        n = 0;
        while (n < 37) {
            if (string.equals(m_tblFunctions[n][0])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void doFunction(StringBuffer stringBuffer, int n, StringBuffer stringBuffer2, boolean bl, boolean bl2) throws CompileException, IOException {
        String string = null;
        boolean bl3 = true;
        string = "c." + stringBuffer.toString() + "(";
        this.m_jStream.write(string.getBytes());
        this.stripParens(stringBuffer2);
        StringBuffer stringBuffer3 = new StringBuffer(", \r\n\t{}=+-*%/<>!&|");
        StringBuffer stringBuffer4 = new StringBuffer("=+-*%/{<>!&|");
        StringBuffer stringBuffer5 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer6 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer2);
        sBTokenizer.setDelims(stringBuffer3, stringBuffer4);
        sBTokenizer.setQuotes(stringBuffer5, stringBuffer6, '\u0000');
        sBTokenizer.tokenize();
        String string2 = m_tblFunctions[n][1];
        if (string2.endsWith("+")) {
            bl3 = false;
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n2 = Integer.parseInt(string2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (n4 > 0) {
                string = ", ";
                this.m_jStream.write(string.getBytes());
            }
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Function.badParamCount", m_tblFunctions[n][0], string2, null, null, null, null);
            }
            ++n3;
            StringBuffer stringBuffer7 = sBTokenizer.nextToken();
            StringBuffer stringBuffer8 = new StringBuffer(", \r\n\t{}=+-*%/<>!&|");
            StringBuffer stringBuffer9 = new StringBuffer("=+-*%/{<>!&|");
            StringBuffer stringBuffer10 = new StringBuffer("\"\"''{}()");
            StringBuffer stringBuffer11 = new StringBuffer("\"'{(");
            SBTokenizer sBTokenizer2 = new SBTokenizer(stringBuffer7);
            sBTokenizer2.setDelims(stringBuffer8, stringBuffer9);
            sBTokenizer2.setQuotes(stringBuffer10, stringBuffer11, '\u0000');
            sBTokenizer2.tokenize();
            stringBuffer7 = sBTokenizer2.nextToken();
            if (this.isFunction(stringBuffer7) >= 0) {
                this.evaluateOperand(stringBuffer7, sBTokenizer, false, bl);
            } else {
                this.evaluateOperand(stringBuffer7, sBTokenizer2, false, bl);
            }
            if (n4 + 1 == n2 && !bl3 && sBTokenizer.hasMoreTokens()) {
                --n4;
            }
            ++n4;
        }
        string = ")";
        this.m_jStream.write(string.getBytes());
        if (sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Function.badParamCount", m_tblFunctions[n][0], string2, null, null, null, null);
        }
    }

    private boolean doIGNOREWHITE(StringBuffer stringBuffer) throws CompileException {
        return false;
    }

    private boolean doNOIGNOREWHITE(StringBuffer stringBuffer) throws CompileException {
        return false;
    }

    private boolean doABORT(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = "<% return; %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private boolean doFLUSH(StringBuffer stringBuffer) throws CompileException {
        return false;
    }

    private boolean doDUMPALL(StringBuffer stringBuffer) throws CompileException, IOException {
        String string = "<%= c.dumpAll() %>";
        this.m_jStream.write(string.getBytes());
        return false;
    }

    private void compileError(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws CompileException {
        Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7};
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.TemplateResources", this.m_uiLocale);
        String string8 = i18NPropertyBundle.getProperty(string);
        StringBuffer stringBuffer = new StringBuffer();
        String string9 = new String(this.m_strTemplatePath);
        int n = string9.lastIndexOf(47);
        if (n < 0) {
            n = string9.lastIndexOf(92);
        }
        if (n > 0) {
            string9 = string9.substring(n + 1);
        }
        stringBuffer.append(i18NPropertyBundle.getProperty("Error.Compile.Error"));
        stringBuffer.append(": ");
        stringBuffer.append(string9);
        stringBuffer.append(": ");
        stringBuffer.append(i18NPropertyBundle.getProperty("Error.Compile.Line"));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(this.m_tStream.getLineNumber()));
        stringBuffer.append(": ");
        stringBuffer.append(string8);
        stringBuffer.append(".    ");
        string8 = MessageFormat.format(stringBuffer.toString(), objectArray);
        System.out.println(string8);
        throw new CompileException(string8);
    }

    void info(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_strTemplatePath);
        stringBuffer.append(": Line ");
        stringBuffer.append(String.valueOf(this.m_tStream.getLineNumber()));
        stringBuffer.append(": ");
        stringBuffer.append(string);
        stringBuffer.append("\n");
        System.out.println(this.m_strTemplatePath + ": Line " + this.m_tStream.getLineNumber() + ": " + string);
    }
}

