/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Encoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Tagged
extends ASN1Object {
    private boolean explicit;
    private ASN1Object content;

    public ASN1Tagged(ASN1Identifier aSN1Identifier, ASN1Object aSN1Object) {
        this(aSN1Identifier, aSN1Object, true);
    }

    public ASN1Tagged(ASN1Identifier aSN1Identifier, ASN1Object aSN1Object, boolean bl) {
        super(aSN1Identifier);
        this.content = aSN1Object;
        this.explicit = bl;
        if (!bl && this.content != null) {
            this.content.setIdentifier(aSN1Identifier);
        }
    }

    public ASN1Tagged(ASN1Decoder aSN1Decoder, InputStream inputStream, int n, ASN1Identifier aSN1Identifier) throws IOException {
        super(aSN1Identifier);
        this.content = new ASN1OctetString(aSN1Decoder, inputStream, n);
    }

    public final void encode(ASN1Encoder aSN1Encoder, OutputStream outputStream) throws IOException {
        aSN1Encoder.encode(this, outputStream);
    }

    public final ASN1Object taggedValue() {
        return this.content;
    }

    public final void setTaggedValue(ASN1Object aSN1Object) {
        this.content = aSN1Object;
        if (!this.explicit && aSN1Object != null) {
            aSN1Object.setIdentifier(this.getIdentifier());
        }
    }

    public final boolean isExplicit() {
        return this.explicit;
    }

    public String toString() {
        if (this.explicit) {
            return super.toString() + this.content.toString();
        }
        return this.content.toString();
    }
}

