/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SSException
extends RuntimeException {
    public static final short NSSS_E_ACCESS_DENIED = -804;
    public static final short NSSS_E_ATTR_NOT_FOUND = -834;
    public static final short NSSS_E_ATTR_VAL_NOT_FOUND = -840;
    public static final short NSSS_E_BETA_EXPIRED = -899;
    public static final short NSSS_E_BUFFER_LEN = -807;
    public static final short NSSS_E_CONFIG_NOT_SUPPORTED = -843;
    public static final short NSSS_E_CONN_ACCESS_FAILURE = -827;
    public static final short NSSS_E_CORRUPTED_PACKET_DATA = -831;
    public static final short NSSS_E_CORRUPTED_STORE = -809;
    public static final short NSSS_E_CRYPTO_OP_FAILURE = -825;
    public static final short NSSS_E_DN_TOO_LONG = -800;
    public static final short NSSS_E_ENUM_BUFF_TOO_LONG = -828;
    public static final short NSSS_E_ENUM_BUFF_TOO_SHORT = -816;
    public static final short NSSS_E_EP_ACCESS_DENIED = -832;
    public static final short NSSS_E_INCOMPATIBLE_VERSION = -808;
    public static final short NSSS_E_INVALID_PARAM = -841;
    public static final short NSSS_E_INVALID_SECRET_ID = -802;
    public static final short NSSS_E_INVALID_TARGET_OBJECT = -812;
    public static final short NSSS_E_MIGRATION_NEEDED = -835;
    public static final short NSSS_E_MP_PWORD_INVALID = -836;
    public static final short NSSS_E_MP_PWORD_NOT_ALLOWED = -838;
    public static final short NSSS_E_MP_PWORD_NOT_SET = -837;
    public static final short NSSS_E_NDS_INTERNAL_FAILURE = -805;
    public static final short NSSS_E_NDS_PWORD_CHANGED = -811;
    public static final short NSSS_E_NDS_PWORD_INVALID = -819;
    public static final short NSSS_E_NEED_SECURE_CHANNEL = -842;
    public static final short NSSS_E_NICI_FAILURE = -801;
    public static final short NSSS_E_NICI_OUTOF_SYNC = -820;
    public static final short NSSS_E_NOT_AUTHENTICATED = -817;
    public static final short NSSS_E_NOT_IMPLEMENTED = -888;
    public static final short NSSS_E_NOT_SUPPORTED = -818;
    public static final short NSSS_E_OBJECT_NOT_FOUND = -800;
    public static final short NSSS_E_SCHEMA_NOT_EXTENDED = -833;
    public static final short NSSS_E_SECRET_BUFF_TOO_LONG = -829;
    public static final short NSSS_E_SECRET_ID_EXISTS = -810;
    public static final short NSSS_E_SECRET_ID_TOO_LONG = -815;
    public static final short NSSS_E_SECRET_ID_TOO_SHORT = -830;
    public static final short NSSS_E_SECRET_UNINITIALIZED = -806;
    public static final short NSSS_E_SERVER_CONN_FAILURE = -826;
    public static final short NSSS_E_SERVICE_NOT_FOUND = -814;
    public static final short NSSS_E_SERVICE_NOT_SUPPORTED = -821;
    public static final short NSSS_E_STORE_NOT_FOUND = -813;
    public static final short NSSS_E_STORE_NOT_LOCKED = -844;
    public static final short NSSS_E_SYSTEM_FAILURE = -803;
    public static final short NSSS_E_TOKEN_NOT_SUPPORTED = -822;
    public static final short NSSS_E_TRANSPORT_FAILURE = -824;
    public static final short NSSS_E_UNICODE_OP_FAILURE = -823;
    public static final short NSSS_E_WRONG_REPLICA_TYPE = -839;
    private int err;
    private boolean hasRoot;
    private boolean isBundleLoaded;
    private Throwable root;
    private ResourceBundle ssBundle;
    public static final short NSSO_E_ACCESS_DENIED = -804;
    public static final short NSSO_E_ATTR_NOT_FOUND = -834;
    public static final short NSSO_E_ATTR_VAL_NOT_FOUND = -840;
    public static final short NSSO_E_BETA_EXPIRED = -899;
    public static final short NSSO_E_BUFFER_LEN = -807;
    public static final short NSSO_E_CONFIG_NOT_SUPPORTED = -843;
    public static final short NSSO_E_CONN_ACCESS_FAILURE = -827;
    public static final short NSSO_E_CORRUPTED_PACKET_DATA = -831;
    public static final short NSSO_E_CORRUPTED_STORE = -809;
    public static final short NSSO_E_CRYPTO_OP_FAILURE = -825;
    public static final short NSSO_E_DN_TOO_LONG = -800;
    public static final short NSSO_E_ENUM_BUFF_TOO_LONG = -828;
    public static final short NSSO_E_ENUM_BUFF_TOO_SHORT = -816;
    public static final short NSSO_E_EP_ACCESS_DENIED = -832;
    public static final short NSSO_E_INCOMPATIBLE_VERSION = -808;
    public static final short NSSO_E_INVALID_PARAM = -841;
    public static final short NSSO_E_INVALID_SECRET_ID = -802;
    public static final short NSSO_E_INVALID_TARGET_OBJECT = -812;
    public static final short NSSO_E_MIGRATION_NEEDED = -835;
    public static final short NSSO_E_MP_PWORD_INVALID = -836;
    public static final short NSSO_E_MP_PWORD_NOT_ALLOWED = -838;
    public static final short NSSO_E_MP_PWORD_NOT_SET = -837;
    public static final short NSSO_E_NDS_INTERNAL_FAILURE = -805;
    public static final short NSSO_E_NDS_PWORD_CHANGED = -811;
    public static final short NSSO_E_NDS_PWORD_INVALID = -819;
    public static final short NSSO_E_NEED_SECURE_CHANNEL = -842;
    public static final short NSSO_E_NICI_FAILURE = -801;
    public static final short NSSO_E_NICI_OUTOF_SYNC = -820;
    public static final short NSSO_E_NOT_AUTHENTICATED = -817;
    public static final short NSSO_E_NOT_IMPLEMENTED = -888;
    public static final short NSSO_E_NOT_SUPPORTED = -818;
    public static final short NSSO_E_OBJECT_NOT_FOUND = -800;
    public static final short NSSO_E_SCHEMA_NOT_EXTENDED = -833;
    public static final short NSSO_E_SECRET_BUFF_TOO_LONG = -829;
    public static final short NSSO_E_SECRET_ID_EXISTS = -810;
    public static final short NSSO_E_SECRET_ID_TOO_LONG = -815;
    public static final short NSSO_E_SECRET_ID_TOO_SHORT = -830;
    public static final short NSSO_E_SECRET_UNINITIALIZED = -806;
    public static final short NSSO_E_SERVER_CONN_FAILURE = -826;
    public static final short NSSO_E_SERVICE_NOT_FOUND = -814;
    public static final short NSSO_E_SERVICE_NOT_SUPPORTED = -821;
    public static final short NSSO_E_STORE_NOT_FOUND = -813;
    public static final short NSSO_E_STORE_NOT_LOCKED = -844;
    public static final short NSSO_E_SYSTEM_FAILURE = -803;
    public static final short NSSO_E_TOKEN_NOT_SUPPORTED = -822;
    public static final short NSSO_E_TRANSPORT_FAILURE = -824;
    public static final short NSSO_E_UNICODE_OP_FAILURE = -823;
    public static final short NSSO_E_WRONG_REPLICA_TYPE = -839;

    public SSException() {
        super("");
        this.err = 0;
        this.root = this;
    }

    public SSException(int n) {
        super(SSException.generateMessage(n));
        this.err = n;
        this.root = this;
    }

    public SSException(String string, int n) {
        super(string);
        this.err = n;
        this.root = this;
    }

    public SSException(Throwable throwable) {
        this(throwable.getMessage(), -1);
        this.hasRoot = true;
        this.root = throwable;
    }

    public SSException(Throwable throwable, String string) {
        this(string + " " + throwable.getMessage(), -1);
        this.hasRoot = true;
        this.root = throwable;
    }

    public static final String generateMessage(int n) {
        switch (n) {
            case -800: {
                return "Can't find the target object DN in NDS";
            }
            case -801: {
                return "NICI operations have failed";
            }
            case -802: {
                return "Secret ID is not in the User Secret Store";
            }
            case -803: {
                return "Some internal operating system services have not been available";
            }
            case -804: {
                return "Access to the target SecretStore has been denied";
            }
            case -805: {
                return "Some internal NDS services have not been available";
            }
            case -806: {
                return "Secret has not been initialized with a write";
            }
            case -807: {
                return "Size of the buffer is not in a nominal range between minimum and maximum";
            }
            case -808: {
                return "Client and server components are not of the compatible versions";
            }
            case -809: {
                return "SecretStore data on the server has been corrupted";
            }
            case -810: {
                return "Secret ID is already in SecretStore";
            }
            case -811: {
                return "User NDS password has been changed by the administrator";
            }
            case -812: {
                return "Target NDS User object not found";
            }
            case -813: {
                return "Target NDS User object does not have a SecretStore";
            }
            case -814: {
                return "SecretStore not on the Network";
            }
            case -815: {
                return "Length of the Secret ID buffer exceeds the limit";
            }
            case -816: {
                return "Length of the Enumeration buffer too short";
            }
            case -817: {
                return "User not authenticated";
            }
            case -818: {
                return "Not supported operations";
            }
            case -819: {
                return "Typed in NDS password not valid";
            }
            case -820: {
                return "Session keys of the client and server NICI are out of sync";
            }
            case -821: {
                return "Requested service not supported yet";
            }
            case -822: {
                return "NDS authentication type not supported";
            }
            case -823: {
                return "Unicode text conversion operation failed";
            }
            case -824: {
                return "Connection to server is lost";
            }
            case -825: {
                return "Cryptographic operation failed";
            }
            case -826: {
                return "Opening a connection to the server failed";
            }
            case -827: {
                return "Access to server connection failed";
            }
            case -828: {
                return "Size of the enumeration buffer exceeds the limit";
            }
            case -829: {
                return "Size of the Secret buffer exceeds the limit";
            }
            case -830: {
                return "Length of the Secret ID should be greater than zero";
            }
            case -831: {
                return "Protocol data corrupted on the wire";
            }
            case -832: {
                return "EP password validation failed. Access to the secret denied";
            }
            case -833: {
                return "Schema is not extended to support SecreStore on the target tree";
            }
            case -834: {
                return "One of the optional service attributes is not instantiated";
            }
            case -835: {
                return "Server has been upgraded and user SecretStore should be updated";
            }
            case -836: {
                return "Master password could not be verified to read or unlock the secrets";
            }
            case -837: {
                return "Master password has not been set on the SecretStore";
            }
            case -838: {
                return "Ability to use master password has been disabled";
            }
            case -839: {
                return "Not a writeable replica of NDS";
            }
            case -840: {
                return "Target attribute is not instantiated in NDS";
            }
            case -841: {
                return "API parameter is not initialized";
            }
            case -842: {
                return "Connection to SecretStore needs to be over SSL";
            }
            case -843: {
                return "No server to support the given override configuration is found";
            }
            case -844: {
                return "Attempt to unlock SecretStore failed because the store is not locked";
            }
            case -888: {
                return "Feature not implemented yet";
            }
            case -899: {
                return "Product's BETA life has expired! Official release copy should be purchased";
            }
        }
        return "";
    }

    public int getErrorCode() {
        return this.err;
    }

    public String getLocalizedMessage() {
        try {
            if (this.ssBundle == null) {
                if (this.isBundleLoaded) {
                    return this.getMessage();
                }
                this.isBundleLoaded = true;
                this.ssBundle = ResourceBundle.getBundle("com.novell.security.sso.res.SSResourceBundle");
                if (this.ssBundle == null) {
                    return this.getMessage();
                }
            }
            switch (this.err) {
                case -800: {
                    return this.ssBundle.getString("NSSS_E_OBJECT_NOT_FOUND");
                }
                case -801: {
                    return this.ssBundle.getString("NSSS_E_NICI_FAILURE");
                }
                case -802: {
                    return this.ssBundle.getString("NSSS_E_INVALID_SECRET_ID");
                }
                case -803: {
                    return this.ssBundle.getString("NSSS_E_SYSTEM_FAILURE");
                }
                case -804: {
                    return this.ssBundle.getString("NSSS_E_ACCESS_DENIED");
                }
                case -805: {
                    return this.ssBundle.getString("NSSS_E_NDS_INTERNAL_FAILURE");
                }
                case -806: {
                    return this.ssBundle.getString("NSSS_E_SECRET_UNINITIALIZED");
                }
                case -807: {
                    return this.ssBundle.getString("NSSS_E_BUFFER_LEN");
                }
                case -808: {
                    return this.ssBundle.getString("NSSS_E_INCOMPATIBLE_VERSION");
                }
                case -809: {
                    return this.ssBundle.getString("NSSS_E_CORRUPTED_STORE");
                }
                case -810: {
                    return this.ssBundle.getString("NSSS_E_SECRET_ID_EXISTS");
                }
                case -811: {
                    return this.ssBundle.getString("NSSS_E_NDS_PWORD_CHANGED");
                }
                case -812: {
                    return this.ssBundle.getString("NSSS_E_INVALID_TARGET_OBJECT");
                }
                case -813: {
                    return this.ssBundle.getString("NSSS_E_STORE_NOT_FOUND");
                }
                case -814: {
                    return this.ssBundle.getString("NSSS_E_SERVICE_NOT_FOUND");
                }
                case -815: {
                    return this.ssBundle.getString("NSSS_E_SECRET_ID_TOO_LONG");
                }
                case -816: {
                    return this.ssBundle.getString("NSSS_E_ENUM_BUFF_TOO_SHORT");
                }
                case -817: {
                    return this.ssBundle.getString("NSSS_E_NOT_AUTHENTICATED");
                }
                case -818: {
                    return this.ssBundle.getString("NSSS_E_NOT_SUPPORTED");
                }
                case -819: {
                    return this.ssBundle.getString("NSSS_E_NDS_PWORD_INVALID");
                }
                case -820: {
                    return this.ssBundle.getString("NSSS_E_NICI_OUTOF_SYNC");
                }
                case -821: {
                    return this.ssBundle.getString("NSSS_E_SERVICE_NOT_SUPPORTED");
                }
                case -822: {
                    return this.ssBundle.getString("NSSS_E_TOKEN_NOT_SUPPORTED");
                }
                case -823: {
                    return this.ssBundle.getString("NSSS_E_UNICODE_OP_FAILURE");
                }
                case -824: {
                    return this.ssBundle.getString("NSSS_E_TRANSPORT_FAILURE");
                }
                case -825: {
                    return this.ssBundle.getString("NSSS_E_CRYPTO_OP_FAILURE");
                }
                case -826: {
                    return this.ssBundle.getString("NSSS_E_SERVER_CONN_FAILURE");
                }
                case -827: {
                    return this.ssBundle.getString("NSSS_E_CONN_ACCESS_FAILURE");
                }
                case -828: {
                    return this.ssBundle.getString("NSSS_E_ENUM_BUFF_TOO_LONG");
                }
                case -829: {
                    return this.ssBundle.getString("NSSS_E_SECRET_BUFF_TOO_LONG");
                }
                case -830: {
                    return this.ssBundle.getString("NSSS_E_SECRET_ID_TOO_SHORT");
                }
                case -831: {
                    return this.ssBundle.getString("NSSS_E_CORRUPTED_PACKET_DATA");
                }
                case -832: {
                    return this.ssBundle.getString("NSSS_E_EP_ACCESS_DENIED");
                }
                case -833: {
                    return this.ssBundle.getString("NSSS_E_SCHEMA_NOT_EXTENDED");
                }
                case -834: {
                    return this.ssBundle.getString("NSSS_E_ATTR_NOT_FOUND");
                }
                case -835: {
                    return this.ssBundle.getString("NSSS_E_MIGRATION_NEEDED");
                }
                case -836: {
                    return this.ssBundle.getString("NSSS_E_MP_PWORD_INVALID");
                }
                case -837: {
                    return this.ssBundle.getString("NSSS_E_MP_PWORD_NOT_SET");
                }
                case -838: {
                    return this.ssBundle.getString("NSSS_E_MP_PWORD_NOT_ALLOWED");
                }
                case -839: {
                    return this.ssBundle.getString("NSSS_E_WRONG_REPLICA_TYPE");
                }
                case -840: {
                    return this.ssBundle.getString("NSSS_NSSS_E_ATTR_VAL_NOT_FOUND");
                }
                case -841: {
                    return this.ssBundle.getString("NSSS_NSSS_E_INVALID_PARAM");
                }
                case -842: {
                    return this.ssBundle.getString("NSSS_E_NEED_SECURE_CHANNEL");
                }
                case -843: {
                    return this.ssBundle.getString("NSSS_E_CONFIG_NOT_SUPPORTED");
                }
                case -844: {
                    return this.ssBundle.getString("NSSS_E_STORE_NOT_LOCKED");
                }
                case -888: {
                    return this.ssBundle.getString("NSSS_E_NOT_IMPLEMENTED");
                }
                case -899: {
                    return this.ssBundle.getString("NSSS_E_BETA_EXPIRED");
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.getMessage();
    }

    public Throwable getRoot() {
        return this.root;
    }

    public boolean hasRoot() {
        return this.hasRoot;
    }
}

