/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import java.security.Permission;

public final class SSPermission
extends Permission {
    public static final String ADMIN = "admin";
    public static final String DEF_NAME = "SecretStore";
    public static final String READ = "read";
    public static final String WRITE = "write";
    private String acts;
    private boolean canAdmin;
    private boolean canRead;
    private boolean canWrite;

    public SSPermission(String string) throws IllegalArgumentException {
        this(DEF_NAME, string);
    }

    public SSPermission(String string, String string2) throws IllegalArgumentException {
        super(string);
        this.formatActions(string2);
    }

    public String getActions() {
        return this.acts;
    }

    public boolean equals(Object object) {
        SSPermission sSPermission = (SSPermission)object;
        return this.getName().equals(sSPermission.getName()) && this.acts.equals(sSPermission.getActions());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean implies(Permission permission) {
        if (permission instanceof SSPermission) {
            SSPermission sSPermission = (SSPermission)permission;
            if (this.canAdmin) {
                return true;
            }
            if (!this.getName().equals(DEF_NAME) && !sSPermission.getName().equals(this.getName())) {
                return false;
            }
            if (this.canRead && !this.canWrite && sSPermission.canRead && !sSPermission.canWrite) {
                return true;
            }
            if (this.canWrite && !this.canRead && sSPermission.canWrite && !sSPermission.canRead) {
                return true;
            }
            if (this.canRead && this.canWrite && (sSPermission.canRead || sSPermission.canWrite)) {
                return true;
            }
        }
        return false;
    }

    private void formatActions(String string) throws IllegalArgumentException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if ((string = string.toLowerCase()).indexOf(ADMIN) != -1 && this.getName().equals(DEF_NAME)) {
            stringBuffer.append(ADMIN);
            this.canAdmin = true;
        } else {
            if (string.indexOf(READ) != -1) {
                stringBuffer.append(READ);
                bl = true;
                this.canRead = true;
            }
            if (string.indexOf(WRITE) != -1) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(WRITE);
                this.canWrite = true;
            }
        }
        if (stringBuffer.length() == 0) {
            throw new IllegalArgumentException("Invalid Action Specification");
        }
        this.acts = stringBuffer.toString();
    }
}

