/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.SecretStore;
import com.novell.security.sso.SharedEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SharedSecret
extends Secret {
    public static final String APPLICATION_TYPE = "SS_App";
    public static final String CREDENTIAL_TYPE = "SS_CredSet";
    static final String ENCODING = "UTF-16LE";
    private String secretType;
    private transient Set sharedData;
    private Secret wrapSecret;
    protected String name;

    public SharedSecret(Secret secret) {
        this(secret, true);
    }

    public SharedSecret(Secret secret, boolean bl) {
        super(secret.toString());
        this.wrapSecret = secret;
        if (this.id.startsWith(APPLICATION_TYPE)) {
            this.secretType = APPLICATION_TYPE;
        } else if (this.id.startsWith(CREDENTIAL_TYPE)) {
            this.secretType = CREDENTIAL_TYPE;
        } else {
            throw new IllegalArgumentException("This secret is not a shared secret");
        }
        if (this.id.length() > this.secretType.length() + 1) {
            if (this.id.charAt(this.secretType.length()) != ':') {
                throw new IllegalArgumentException("This secret is not a shared secret");
            }
        } else {
            throw new IllegalArgumentException("This secret is not a shared secret");
        }
        this.name = SharedEntry.unescapeString(this.id.substring(this.secretType.length() + 1, this.id.length()));
        this.sharedData = new HashSet();
        if (bl) {
            try {
                this.read();
            }
            catch (SSException sSException) {
                // empty catch block
            }
        }
    }

    public SharedSecret(SecretStore secretStore, String string, String string2) {
        this(secretStore, string, string2, true);
    }

    public SharedSecret(SecretStore secretStore, String string, String string2, boolean bl) {
        super(string2);
        if (secretStore == null) {
            throw new IllegalArgumentException("The secretStore may not be null");
        }
        String string3 = string.intern();
        if (string3 != APPLICATION_TYPE && string3 != CREDENTIAL_TYPE) {
            throw new IllegalArgumentException("Invalid secret type");
        }
        this.secretType = string3;
        String string4 = SharedEntry.escapeString(string2);
        StringBuffer stringBuffer = new StringBuffer(string.length() + string4.length() + 1);
        this.id = stringBuffer.append(string).append(':').append(string4).toString();
        this.name = string2;
        this.sharedData = new HashSet();
        this.wrapSecret = secretStore.getSecret0(this.id, false);
        if (bl) {
            try {
                this.read();
            }
            catch (SSException sSException) {
                // empty catch block
            }
        }
    }

    public Date getAccessTime() throws SSException {
        return this.wrapSecret.getAccessTime();
    }

    public Date getCreateTime() throws SSException {
        return this.wrapSecret.getCreateTime();
    }

    public Set getCredSetEntries() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        HashSet<SharedEntry> hashSet = new HashSet<SharedEntry>(this.sharedData.size());
        Iterator iterator = this.sharedData.iterator();
        while (iterator.hasNext()) {
            SharedEntry sharedEntry = (SharedEntry)iterator.next();
            if (!sharedEntry.isCredSet()) continue;
            hashSet.add(sharedEntry);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Collection getEntries() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        return Collections.unmodifiableCollection(this.sharedData);
    }

    public SharedEntry getEntry(String string) throws SSException {
        SharedEntry sharedEntry;
        if (!this.isInitialized) {
            this.read();
        }
        if (this.sharedData.contains(sharedEntry = new SharedEntry(string, ""))) {
            Iterator iterator = this.sharedData.iterator();
            while (iterator.hasNext()) {
                SharedEntry sharedEntry2 = (SharedEntry)iterator.next();
                if (!sharedEntry.equals(sharedEntry2)) continue;
                return sharedEntry2;
            }
        }
        return null;
    }

    public Date getModifyTime() throws SSException {
        return this.wrapSecret.getModifyTime();
    }

    public String getName() {
        return this.name;
    }

    public String getSecretType() {
        return this.secretType;
    }

    public boolean isCheckingSecretIDCollision() {
        return this.wrapSecret.isCheckingSecretIDCollision();
    }

    public static boolean isSharedSecret(Secret secret) {
        String string;
        String string2 = secret.toString();
        if (string2.startsWith(APPLICATION_TYPE)) {
            string = APPLICATION_TYPE;
        } else if (string2.startsWith(CREDENTIAL_TYPE)) {
            string = CREDENTIAL_TYPE;
        } else {
            return false;
        }
        return string2.length() > string.length() + 1 && string2.charAt(string.length()) == ':';
    }

    public void setCheckingSecretIDCollision(boolean bl) {
        this.wrapSecret.setCheckingSecretIDCollision(bl);
    }

    public void setEnhancedProtectionPassword(char[] cArray) {
        this.wrapSecret.setEnhancedProtectionPassword(cArray);
    }

    public int getStatus() throws SSException {
        return this.wrapSecret.getStatus();
    }

    public byte[] getValue() throws SSException {
        return this.wrapSecret.getValue();
    }

    public void setValue() throws SSException {
        this.setValue(null);
    }

    public void addEntry(SharedEntry sharedEntry) {
        try {
            if (!this.isInitialized) {
                this.read();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.sharedData.add(sharedEntry);
    }

    public void clearEntries() {
        this.sharedData.clear();
    }

    public boolean equals(Object object) {
        return this.wrapSecret.equals(object);
    }

    public boolean exists() throws SSException {
        return this.wrapSecret.exists();
    }

    public int hashCode() {
        return this.wrapSecret.hashCode();
    }

    public void removeEntry(SharedEntry sharedEntry) {
        try {
            if (!this.isInitialized) {
                this.read();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.sharedData.remove(sharedEntry);
    }

    public void unsetEnhancedProtectionPassword() {
        this.wrapSecret.unsetEnhancedProtectionPassword();
    }

    public void update(Secret secret, int n) throws SSException {
        this.wrapSecret.update(secret, n);
    }

    protected void delete0(int n) throws SSException {
        this.wrapSecret.delete(n);
    }

    protected void read0(int n) throws SSException {
        this.isInitialized = true;
        this.wrapSecret.read(n);
        try {
            this.populateDataFromSecret(this.wrapSecret.getValue(), true);
        }
        catch (IOException iOException) {
            throw new SSException("Invalid shared secret", -845);
        }
    }

    protected void write0(byte[] byArray, int n) throws SSException {
        try {
            this.wrapSecret.write(this.populateSecretFromData(byArray), n);
        }
        catch (IOException iOException) {
            throw new SSException(iOException);
        }
    }

    private void populateDataFromSecret(byte[] byArray, boolean bl) throws IOException {
        if (bl) {
            this.sharedData.clear();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, ENCODING);
        StringBuffer stringBuffer = new StringBuffer(32);
        int n = inputStreamReader.read();
        try {
            while (n != -1) {
                SharedEntry sharedEntry;
                if (n == 0) {
                    sharedEntry = SharedEntry.parseEntry(stringBuffer.toString());
                    this.addEntry(sharedEntry);
                    break;
                }
                if (n == 10) {
                    sharedEntry = SharedEntry.parseEntry(stringBuffer.toString());
                    this.addEntry(sharedEntry);
                    stringBuffer.setLength(0);
                } else {
                    stringBuffer.append((char)n);
                }
                n = inputStreamReader.read();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private byte[] populateSecretFromData(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.clearEntries();
            this.populateDataFromSecret(byArray, false);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.sharedData.size() * 32);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, ENCODING);
        boolean bl = true;
        Iterator iterator = this.sharedData.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                outputStreamWriter.write(10);
            }
            SharedEntry sharedEntry = (SharedEntry)iterator.next();
            outputStreamWriter.write(sharedEntry.toString());
        }
        outputStreamWriter.write(0);
        outputStreamWriter.close();
        return byteArrayOutputStream.toByteArray();
    }
}

