/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Numeric;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.ldap.ber.SSResponse;
import java.io.IOException;
import java.util.Arrays;

public class ReadResponse
extends SSResponse {
    private long accTime;
    private long crtTime;
    private long modTime;
    private transient byte[] secret;
    private int statFlags;

    public ReadResponse(byte[] byArray) {
        super("2.16.840.1.113719.1.148.100.4", byArray);
    }

    public long getAccessedTime() {
        return this.accTime;
    }

    public long getCreatedTime() {
        return this.crtTime;
    }

    public long getModifiedTime() {
        return this.modTime;
    }

    public byte[] getSecretValue() {
        byte[] byArray = new byte[this.secret.length];
        System.arraycopy(this.secret, 0, byArray, 0, this.secret.length);
        return byArray;
    }

    public int getStatFlags() {
        return this.statFlags;
    }

    protected void finalize() throws Throwable {
        Arrays.fill(this.secret, (byte)0);
        super.finalize();
    }

    protected void parsePacket() throws IOException {
        ASN1Object aSN1Object;
        super.parsePacket();
        int n = this.asn1_seq.size();
        if (this.packetIdx < n) {
            if ((aSN1Object = this.asn1_seq.get(this.packetIdx++)) instanceof ASN1OctetString) {
                ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Object;
                this.secret = aSN1OctetString.byteValue();
            } else {
                this.secret = new byte[0];
            }
        }
        if (this.packetIdx < n) {
            aSN1Object = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.statFlags = ((ASN1Numeric)aSN1Object).intValue();
        }
        if (this.packetIdx < n) {
            aSN1Object = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.crtTime = ((ASN1Numeric)aSN1Object).intValue();
        }
        if (this.packetIdx < n) {
            aSN1Object = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.accTime = ((ASN1Numeric)aSN1Object).intValue();
        }
        if (this.packetIdx < n) {
            aSN1Object = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.modTime = ((ASN1Numeric)aSN1Object).intValue();
        }
    }
}

