/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.jndi;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.SecretStore;
import com.novell.security.sso.ldap.ber.EnumRequest;
import com.novell.security.sso.ldap.ber.EnumResponse;
import com.novell.security.sso.ldap.ber.GetInfoResponse;
import com.novell.security.sso.ldap.ber.SSRequest;
import com.novell.security.sso.ldap.ber.SSResponse;
import com.novell.security.sso.ldap.ber.SetMasterPassRequest;
import com.novell.security.sso.ldap.ber.UnlockRequest;
import com.novell.security.sso.ldap.jndi.JNDISecret;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;

public final class JNDISecretStore
extends SecretStore {
    private transient LdapContext ctx;

    public JNDISecretStore(Hashtable hashtable) throws IllegalArgumentException, SSException {
        block13: {
            if (System.getProperty("javax.net.debug") != null) {
                throw new SecurityException("javax.net.debug is turned on. Access to LdapSecretStore denied. Necessary to turn debugging off!");
            }
            try {
                if (hashtable.containsKey("com.novell.sso.handle")) {
                    Object v = hashtable.get("com.novell.sso.handle");
                    if (v instanceof LdapContext) {
                        this.env = (Hashtable)hashtable.clone();
                        this.ctx = (LdapContext)v;
                        if (!this.env.containsKey("com.novell.sso.userdn") || this.env.get("com.novell.sso.userdn").toString().length() == 0) {
                            try {
                                String string = this.ctx.getNameInNamespace();
                                if (string != null && string.length() > 0) {
                                    this.env.put("com.novell.sso.userdn", string);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!this.env.containsKey("com.novell.sso.userdn") && this.ctx.getEnvironment().containsKey("java.naming.security.principal") && this.ctx.getEnvironment().get("java.naming.security.principal").toString().length() > 0) {
                            this.env.put("com.novell.sso.userdn", this.ctx.getEnvironment().get("java.naming.security.principal"));
                        }
                        if (this.ctx.getEnvironment().contains("java.naming.security.principal")) {
                            this.env.put("com.novell.sso.callerdn", this.ctx.getEnvironment().get("java.naming.security.principal"));
                        }
                        if (this.ctx.getEnvironment().contains("java.naming.provider.url")) {
                            this.env.put("com.novell.sso.serverdn", this.ctx.getEnvironment().get("java.naming.provider.url"));
                        }
                        if (!this.env.containsKey("com.novell.sso.userdn") || this.env.get("com.novell.sso.userdn").toString().length() <= 0) {
                            throw new IllegalArgumentException("not possible to obtain \"com.novell.sso.userdn\" from \"com.novell.sso.handle\" or environment");
                        }
                        break block13;
                    }
                    throw new IllegalArgumentException("\"com.novell.sso.context\" is not a LdapContext object");
                }
                throw new IllegalArgumentException("\"com.novell.sso.context\" not specified");
            }
            catch (NamingException namingException) {
                throw new SSException(namingException);
            }
        }
    }

    public synchronized Secret getSecret0(String string, boolean bl) {
        if (bl) {
            return new JNDISecret(this.ctx, (String)this.env.get("com.novell.sso.userdn"), string, this.masterPassword);
        }
        return new JNDISecret(this.ctx, (String)this.env.get("com.novell.sso.userdn"), string);
    }

    protected final synchronized void getServiceInfo0(int n) throws SSException {
        try {
            this.initialized = true;
            SSRequest sSRequest = new SSRequest("2.16.840.1.113719.1.148.100.1", n, (String)this.env.get("com.novell.sso.userdn"));
            InternalRequest internalRequest = new InternalRequest(sSRequest.getID(), sSRequest.getEncodedValue());
            InternalResponse internalResponse = (InternalResponse)this.ctx.extendedOperation(internalRequest);
            GetInfoResponse getInfoResponse = new GetInfoResponse(internalResponse.getEncodedValue());
            if (getInfoResponse.getErrorCode() != 0) {
                throw new SSException(getInfoResponse.getErrorCode());
            }
            this.serverVersion = getInfoResponse.getServerVersion();
            this.clientVersion = 784;
            this.lockCount = getInfoResponse.getNumLockedSecrets();
            this.secretCount = getInfoResponse.getNumSecrets();
            this.hiddenCount = getInfoResponse.getNumHiddenSecrets();
            this.status = getInfoResponse.getStatus();
            this.enumBuffLen = getInfoResponse.getEnumBuffLen();
            this.clientCryptoStrength = 0;
            this.serverCryptoStrength = getInfoResponse.getServerCryptoStrength();
            this.lastAdminUnlockDn = getInfoResponse.getLastAdminUnlockDN();
            this.lastAdminUnlockTime = getInfoResponse.getLastAdminUnlockTime();
            this.env.put("com.novell.sso.tree", getInfoResponse.getTreeName());
            Arrays.fill(this.hint, ' ');
            this.hint = getInfoResponse.getHint();
        }
        catch (NamingException namingException) {
            throw new SSException(JNDISecretStore.checkException(namingException));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void commitMasterPasswordChange0(int n, char[] cArray) throws SSException {
        if (this.masterPassword.length() <= 0) {
            throw new IllegalArgumentException("Master Password length is zero");
        }
        char[] cArray2 = new char[this.masterPassword.length()];
        if (cArray2.length > 0) {
            this.masterPassword.getChars(0, cArray2.length, cArray2, 0);
        }
        try {
            try {
                SetMasterPassRequest setMasterPassRequest = new SetMasterPassRequest(n, (String)this.env.get("com.novell.sso.userdn"), cArray2, cArray);
                InternalRequest internalRequest = new InternalRequest(setMasterPassRequest.getID(), setMasterPassRequest.getEncodedValue());
                InternalResponse internalResponse = (InternalResponse)this.ctx.extendedOperation(internalRequest);
                SSResponse sSResponse = new SSResponse(internalResponse.getID(), internalResponse.getEncodedValue());
                if (sSResponse.getErrorCode() != 0) {
                    throw new SSException(sSResponse.getErrorCode());
                }
                Arrays.fill(this.hint, ' ');
                char[] cArray3 = cArray;
                synchronized (cArray3) {
                    char[] cArray4 = new char[cArray.length];
                    System.arraycopy(cArray, 0, cArray4, 0, cArray.length);
                    this.hint = cArray4;
                }
            }
            catch (NullPointerException nullPointerException) {
                Arrays.fill(this.hint, ' ');
                char[] cArray5 = cArray;
                synchronized (cArray5) {
                    char[] cArray6 = new char[cArray.length];
                    System.arraycopy(cArray, 0, cArray6, 0, cArray.length);
                    this.hint = cArray6;
                }
                Object var13_15 = null;
                Arrays.fill(cArray2, ' ');
                return;
            }
            catch (NamingException namingException) {
                throw new SSException(JNDISecretStore.checkException(namingException));
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            Arrays.fill(cArray2, ' ');
            throw throwable;
        }
        Arrays.fill(cArray2, ' ');
    }

    protected final synchronized StringTokenizer enumerateSecrets0(int n, String string, int n2) throws SSException {
        try {
            EnumRequest enumRequest = new EnumRequest(n, (String)this.env.get("com.novell.sso.userdn"), string, n2);
            InternalRequest internalRequest = new InternalRequest(enumRequest.getID(), enumRequest.getEncodedValue());
            InternalResponse internalResponse = (InternalResponse)this.ctx.extendedOperation(internalRequest);
            EnumResponse enumResponse = new EnumResponse(internalResponse.getEncodedValue());
            if (enumResponse.getErrorCode() != 0) {
                throw new SSException(enumResponse.getErrorCode());
            }
            return new StringTokenizer(new String(enumResponse.getEnumeration()), "*");
        }
        catch (NamingException namingException) {
            throw new SSException(JNDISecretStore.checkException(namingException));
        }
    }

    protected final synchronized void removeSecretStore0(int n) throws SSException {
        try {
            SSRequest sSRequest = new SSRequest("2.16.840.1.113719.1.148.100.11", n, (String)this.env.get("com.novell.sso.userdn"));
            InternalRequest internalRequest = new InternalRequest(sSRequest.getID(), sSRequest.getEncodedValue());
            InternalResponse internalResponse = (InternalResponse)this.ctx.extendedOperation(internalRequest);
            SSResponse sSResponse = new SSResponse(internalResponse.getID(), internalResponse.getEncodedValue());
            if (sSResponse.getErrorCode() != 0) {
                throw new SSException(sSResponse.getErrorCode());
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NamingException namingException) {
            throw new SSException(JNDISecretStore.checkException(namingException));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void unlockSecretStore0(int n) throws SSException {
        char[] cArray = null;
        if ((n & 4) != 4) {
            if (this.masterPassword == null) {
                throw new IllegalArgumentException("master password is null");
            }
            n |= 0x20;
            cArray = new char[this.masterPassword.length()];
            if (cArray.length > 0) {
                this.masterPassword.getChars(0, cArray.length, cArray, 0);
            }
        }
        try {
            try {
                UnlockRequest unlockRequest = new UnlockRequest(n, (String)this.env.get("com.novell.sso.userdn"), cArray);
                InternalRequest internalRequest = new InternalRequest(unlockRequest.getID(), unlockRequest.getEncodedValue());
                InternalResponse internalResponse = (InternalResponse)this.ctx.extendedOperation(internalRequest);
                SSResponse sSResponse = new SSResponse(internalResponse.getID(), internalResponse.getEncodedValue());
                if (sSResponse.getErrorCode() != 0) {
                    throw new SSException(sSResponse.getErrorCode());
                }
                Object var8_9 = null;
            }
            catch (NullPointerException nullPointerException) {
                Object var8_10 = null;
                Arrays.fill(cArray, ' ');
                return;
            }
            catch (NamingException namingException) {
                throw new SSException(JNDISecretStore.checkException(namingException));
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            Arrays.fill(cArray, ' ');
            throw throwable;
        }
        Arrays.fill(cArray, ' ');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void unlockSecretStore0(int n, char[] cArray) throws SSException {
        char[] cArray2;
        if ((n & 4) != 4) {
            if (cArray == null) {
                throw new IllegalArgumentException("NDS Password is null");
            }
        } else if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray3 = cArray;
        synchronized (cArray3) {
            cArray2 = new char[cArray.length];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        }
        try {
            try {
                UnlockRequest unlockRequest = new UnlockRequest(n, (String)this.env.get("com.novell.sso.userdn"), cArray2);
                InternalRequest internalRequest = new InternalRequest(unlockRequest.getID(), unlockRequest.getEncodedValue());
                InternalResponse internalResponse = (InternalResponse)this.ctx.extendedOperation(internalRequest);
                SSResponse sSResponse = new SSResponse(internalResponse.getID(), internalResponse.getEncodedValue());
                if (sSResponse.getErrorCode() != 0) {
                    throw new SSException(sSResponse.getErrorCode());
                }
                Object var10_11 = null;
            }
            catch (NullPointerException unlockRequest) {
                Object var10_12 = null;
                Arrays.fill(cArray2, '\u0000');
                return;
            }
            catch (NamingException internalRequest) {
                throw new SSException(JNDISecretStore.checkException(internalRequest));
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            Arrays.fill(cArray2, '\u0000');
            throw throwable;
        }
        Arrays.fill(cArray2, '\u0000');
    }

    static int checkException(NamingException namingException) throws SSException {
        try {
            String string = namingException.getMessage();
            int n = string.indexOf("8");
            if (n != -1) {
                ++n;
                String string2 = string.substring(n = string.indexOf("-8", n), n + 4);
                int n2 = Integer.parseInt(string2);
                if (n2 >= -899 && n2 <= -800) {
                    return n2;
                }
            }
        }
        catch (Exception exception) {
            throw new SSException(namingException);
        }
        throw new SSException(namingException);
    }

    static class InternalResponse
    implements ExtendedResponse {
        private String id;
        private byte[] value;

        public InternalResponse(String string, byte[] byArray) {
            this.id = string;
            this.value = byArray;
        }

        public byte[] getEncodedValue() {
            return this.value;
        }

        public String getID() {
            return this.id;
        }
    }

    static class InternalRequest
    implements ExtendedRequest {
        private String id;
        private byte[] value;

        public InternalRequest(String string, byte[] byArray) {
            this.id = string;
            this.value = byArray;
        }

        public byte[] getEncodedValue() {
            return this.value;
        }

        public String getID() {
            return this.id;
        }

        public ExtendedResponse createExtendedResponse(String string, byte[] byArray, int n, int n2) throws NamingException {
            return new InternalResponse(string, byArray);
        }
    }
}

