/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.authentication;

import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.nps.WebappUtil;
import com.novell.nps.authentication.Authenticatable;
import com.novell.nps.authentication.AuthenticationEventListener;
import com.novell.nps.authentication.BasicCredentials;
import com.novell.nps.authentication.DefaultSSO;
import com.novell.nps.authentication.LDAPCredentials;
import com.novell.nps.authentication.LoginException;
import com.novell.nps.authentication.LogoutException;
import com.novell.nps.authentication.MultipleLdapObjectsException;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.authentication.SingleSignOnProvider;
import com.novell.nps.authentication.sso.AuthSSProvider;
import com.novell.nps.authentication.sso.SSException;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.debug.Debug;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.event.PortalLogoutEvent;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.serviceProviders.ServiceManager;
import com.novell.nps.sessionManager.PortalSession;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AuthenticationManager {
    private static Vector authListeners = new Vector();
    private static ResourceBundle m_res = null;
    private static final String SESSION_ATTR_POST_AUTH_SERVICE_DELEGATES = "System.authentication.PostAuthServiceDelegates";
    private static final String SES_ATTR_POST_AUTH_DELEGS = "System.authentication.PostAuthServiceDelegates";
    private static final String SETTING_POST_AUTH_SERVICES = "System.authentication.PostAuthServices";
    private static final String DT = "AuthenticationManager";
    private static AuthSSProvider ssProvider = null;
    private static final String PORTAL_CONNECTION = "AuthenticationManager.PortalConnection";
    private static final String PUBLIC_CONNECTION = "AuthenticationManager.PublicConnection";
    private static final String AUTH_PORTAL_CONNECTION = "AuthenticationManager.AuthenticatingPortalConnection";
    private static final String AUTH_PROPS = "AuthenticationManager.AuthenticatingProperties";
    private static final String CREDENTIALS = "PortalCredentials";
    private static final String PORTAL_ID = "Portal";
    private static final String USER_CREDENTIALS_ENTRY = "USER";
    private static final String PORTAL_ID_KEY = "Portal_2000";
    public static final SingleSignOnProvider defaultSSOProvider = new DefaultSSO();
    public static final String AUTHENTICATION_PROCESS_STATE = "System.AuthProcessState";
    public static final String STATE_VALUE = "System.CurrentState";
    public static final String STATE_LOGGED_IN = "StateLoggedIn";
    public static final String STATE_LOGGED_OUT = "StateLoggedOut";
    public static final String STATE_SS_VALUE = "SS.CurrentState";
    public static final String STATE_SS_LOCKED = "SSLocked";
    public static final String STATE_SS_PROMPT = "SSLockedPrompt";
    public static final String STATE_SS_OKAY = "SSOkay";
    public static final String STATE_SS_MANAGE = "SSManage";
    public static final String SESS_LISTENERS = "SessionListeners";
    public static final String ICS_SSO = "ICS_SSO";
    public static final String CONTEXTLESS_LOGIN_ALLOW_WILDCARD = "Authentication.AllowWildcard";
    public static final String CTX_LOGIN_USER_DNS = "CTX_LOGIN_USER_DNS";
    public static final int GET_MSS_IMANAGER = 3;
    public static final int SET_MSS_IMANAGER = 2;

    public static void init() {
        m_res = ResourceBundle.getBundle("com.novell.nps.authentication.AuthenticationRes");
    }

    public static void unlockSS(String oldPassword, String newPassword, PortalSession session) {
    }

    public static void beginPortalLogin(Properties properties, PortalSession session) throws LoginException {
        throw new LoginException("Method beginPortalLogin is no longer supported.");
    }

    public static boolean delegateToPostAuthServiceDelegates(HttpServletRequest req, PortalSession session, GadgetInstance authGadget) {
        return true;
    }

    public static void finishAuthentication(PortalSession session) {
    }

    void finishPostAuthentication(PortalSession session) {
        session.setAttribute(STATE_VALUE, STATE_LOGGED_IN);
    }

    public static final void portalChangePassword(PortalSession session, String sOldPassword, String sNewPassword) throws PortalDirectoryException {
        AuthenticationManager.portalChangePassword(session, sOldPassword, sNewPassword, true);
    }

    public static final void portalChangePassword(PortalSession session, String sOldPassword, String sNewPassword, boolean bUpdateDirectory) throws PortalDirectoryException {
        PortalConnection pc = AuthenticationManager.getConnection(session);
        if (bUpdateDirectory) {
            pc.setPassword(pc.getUsername(), sOldPassword, sNewPassword);
        }
        pc.setConnectionPassword(sNewPassword);
        session.removeAttribute("SESSION_COOKIES");
    }

    public static final void setUserDNAndCN(PortalSession session, String userDN) {
    }

    public static void portalLogout(PortalSession session) throws LogoutException {
        PortalConnection pc = (PortalConnection)session.getAttribute(PORTAL_CONNECTION);
        if (null != pc) {
            AuthenticationEventListener authListener;
            Enumeration<Object> myenum = authListeners.elements();
            while (myenum.hasMoreElements()) {
                AuthenticationEventListener authListener2 = (AuthenticationEventListener)myenum.nextElement();
                authListener2.preLogoutEvent(session);
            }
            Vector sessListeners = (Vector)session.getAttribute(SESS_LISTENERS);
            if (sessListeners != null) {
                myenum = sessListeners.elements();
                while (myenum.hasMoreElements()) {
                    AuthenticationEventListener authListener3 = (AuthenticationEventListener)myenum.nextElement();
                    authListener3.preLogoutEvent(session);
                }
            }
            Enumeration providerEnum = ServiceManager.getProviders(session);
            while (providerEnum.hasMoreElements()) {
                Authenticatable authProvider = (Authenticatable)providerEnum.nextElement();
                authProvider.logout();
            }
            session.removeAttribute("SESSION_COOKIES");
            ssProvider.logoutAuthMgr(session);
            pc.logout();
            Hashtable gadgetInstances = (Hashtable)session.getAttribute("fw_SessionTaskInstances");
            if (gadgetInstances != null && gadgetInstances.size() != 0) {
                myenum = gadgetInstances.elements();
                while (myenum.hasMoreElements()) {
                    GadgetInstance gi = (GadgetInstance)myenum.nextElement();
                }
            }
            PortalEventManager.postEvent(new PortalLogoutEvent(session));
            session.removeAttribute(PORTAL_CONNECTION);
            session.removeAttribute(AUTH_PROPS);
            session.removeAttribute(AUTH_PORTAL_CONNECTION);
            session.setAttribute(STATE_VALUE, STATE_LOGGED_OUT);
            session.setAttribute(STATE_SS_VALUE, STATE_SS_OKAY);
            AuthenticationManager.setUserDNAndCN(session, "");
            session.removeAttribute("System.SessionDirectoryProvider");
            myenum = authListeners.elements();
            while (myenum.hasMoreElements()) {
                authListener = (AuthenticationEventListener)myenum.nextElement();
                authListener.postLogoutEvent(session);
            }
            if (sessListeners != null) {
                myenum = sessListeners.elements();
                while (myenum.hasMoreElements()) {
                    authListener = (AuthenticationEventListener)myenum.nextElement();
                    authListener.postLogoutEvent(session);
                }
                session.removeAttribute(SESS_LISTENERS);
            }
        } else {
            throw new LogoutException(m_res.getString("Not_logged_in_"));
        }
    }

    public static String getFullLdapDN(String username, PortalSession session) throws MultipleLdapObjectsException {
        try {
            ManagementServiceSet mms = AuthenticationManager.getManagementServiceSet(session, 3);
            return mms.getAuthenticationBroker().getAuthLdapName();
        }
        catch (AuthBrokerException e) {
            D.log((Throwable)e);
            boolean bFound = false;
            String fullDN = null;
            fullDN = username;
            if (!bFound) {
                PortalConnection pc = AuthenticationManager.getConnection(session);
                try {
                    fullDN = pc.normalizeObjectDN(username);
                }
                catch (PortalDirectoryException ex) {
                    // empty catch block
                }
            }
            return fullDN;
        }
    }

    public static String isLdapFormat(String sLdapName, PortalSession session) {
        PortalConnection pc = AuthenticationManager.getConnection(session);
        String sName = null;
        try {
            sName = sLdapName.indexOf(61) == -1 ? null : pc.normalizeObjectDN(sLdapName);
        }
        catch (PortalDirectoryException ex) {
            // empty catch block
        }
        return sName;
    }

    public static void addAuthenticationListener(AuthenticationEventListener authListener) {
        if (null == authListener) {
            return;
        }
        if (authListener instanceof GadgetInstance) {
            GadgetInstance gadInst = (GadgetInstance)((Object)authListener);
            PortalSession sess = gadInst.getSession();
            if (sess == null) {
                D.log((String)("AuthListener: No Session found in " + authListener.getClass().toString()));
                return;
            }
            AuthenticationManager.addAuthenticationListener(authListener, sess);
        } else {
            authListeners.addElement(authListener);
        }
    }

    public static void addAuthenticationListener(AuthenticationEventListener authListener, PortalSession sess) {
        Vector<AuthenticationEventListener> sessListeners = (Vector<AuthenticationEventListener>)sess.getAttribute(SESS_LISTENERS);
        if (sessListeners == null) {
            sessListeners = new Vector<AuthenticationEventListener>();
            sess.setAttribute(SESS_LISTENERS, sessListeners);
        }
        sessListeners.addElement(authListener);
    }

    public static void removeAuthenticationListener(AuthenticationEventListener authListener, PortalSession sess) {
        Vector sessListeners = (Vector)sess.getAttribute(SESS_LISTENERS);
        if (sessListeners != null) {
            sessListeners.remove(authListener);
        }
    }

    public static void removeAuthenticationListener(AuthenticationEventListener authListener) {
    }

    public static Object getCredentials(PortalSession session, String gadgetID, String subID, String key) throws SSException {
        return ssProvider.getCredentials(session, gadgetID, subID, key);
    }

    public static Object getCredentials(PortalSession session, GadgetInstance gadgetInst, String subID, String key) throws SSException {
        GadgetAssignment ga = gadgetInst.getGadgetAssignment();
        String id = null;
        try {
            id = ga.getUniqueID();
        }
        catch (Exception e) {
            Debug.log("No assignment found", e);
        }
        return ssProvider.getCredentials(session, id, subID, key);
    }

    public static Object getCredentials(PortalSession session, String gadgetID, String subID) throws SSException {
        return AuthenticationManager.getCredentials(session, gadgetID, subID, null);
    }

    public static Object getCredentials(PortalSession session, GadgetInstance gadgetInst, String subID) throws SSException {
        return AuthenticationManager.getCredentials(session, gadgetInst, subID, null);
    }

    public static Object getCredentials(PortalConnection pc, String sObjectDN, String gadgetID, String subID, String key) throws SSException, PortalDirectoryException {
        return ssProvider.getCredentials(pc, sObjectDN, gadgetID, subID, key);
    }

    public static BasicCredentials getSharedCredentials(PortalSession session, String secretName, String key) throws SSException {
        return ssProvider.getSharedCredentials(session, secretName, key);
    }

    public static String getUserIPAddress(PortalSession session) {
        String userIP = null;
        userIP = (String)session.getAttribute("BROWSER_ADDR");
        return userIP;
    }

    public static void setCredentials(PortalSession session, String gadgetID, String subID, Object credentials) throws SSException {
        AuthenticationManager.setCredentials(session, gadgetID, subID, credentials, null);
    }

    public static void setCredentials(PortalSession session, GadgetInstance gadgetInst, String subID, Object credentials) throws SSException {
        AuthenticationManager.setCredentials(session, gadgetInst, subID, credentials, null);
    }

    public static void setCredentials(PortalSession session, String gadgetID, String subID, Object credentials, String key) throws SSException {
        ssProvider.setCredentials(session, gadgetID, subID, credentials, key);
    }

    public static void setCredentials(PortalSession session, GadgetInstance gadgetInst, String subID, Object credentials, String key) throws SSException {
        GadgetAssignment ga = gadgetInst.getGadgetAssignment();
        String id = null;
        try {
            id = ga.getUniqueID();
        }
        catch (Exception e) {
            Debug.log("No assignment found", e);
        }
        if (id == null) {
            id = gadgetInst.getClass().getName();
        }
        ssProvider.setCredentials(session, id, subID, credentials, key);
    }

    public static void setCredentials(PortalConnection pc, String sObjectDN, String gadgetID, String subID, Object credentials, String key) throws SSException, PortalDirectoryException {
        ssProvider.setCredentials(pc, sObjectDN, gadgetID, subID, credentials, key);
    }

    public static void setSharedCredentials(PortalSession session, String secretName, BasicCredentials credentials, String key) throws SSException {
        ssProvider.setSharedCredentials(session, secretName, credentials, key);
    }

    public static void removeSecretStore(PortalSession session, String gadgetID, String subID) {
        try {
            ssProvider.removeSecretStore(session, gadgetID, subID);
        }
        catch (SSException ss) {
            Debug.log("SecretStore", ss);
        }
    }

    public static void removeSharedSecretStore(PortalSession session, String secretName) {
        try {
            ssProvider.removeSharedSecretStore(session, secretName);
        }
        catch (SSException ss) {
            Debug.log("SecretStore", ss);
        }
    }

    public static void removeCredentials(PortalConnection pc, String sObjectDN, String gadgetID, String subID) throws PortalDirectoryException {
        ssProvider.removeCredentials(pc, sObjectDN, gadgetID, subID);
    }

    public static void removeSecretStore(PortalSession session, GadgetInstance gadgetInst, String subID) {
        GadgetAssignment ga = gadgetInst.getGadgetAssignment();
        String id = null;
        try {
            id = ga.getUniqueID();
        }
        catch (Exception e) {
            Debug.log("No assignment found", e);
        }
        if (id == null) {
            id = gadgetInst.getClass().getName();
        }
        try {
            ssProvider.removeSecretStore(session, id, subID);
        }
        catch (SSException ss) {
            Debug.log("SecretStore", ss);
        }
    }

    public static void syncStorage(PortalSession session, String oldPassword, String newPassword) {
        try {
            ssProvider.syncStorage(session, oldPassword, newPassword);
        }
        catch (SSException ss) {
            Debug.log("SecretStore", ss);
        }
        PortalConnection pc = (PortalConnection)session.getAttribute(PORTAL_CONNECTION);
        if (pc != null) {
            LDAPCredentials theUser = new LDAPCredentials(pc.getUsername(), newPassword);
            session.setAttribute(CREDENTIALS, theUser);
        }
    }

    public static int getAuthFlags(PortalSession session) {
        return ssProvider.getAuthFlags(session);
    }

    public static void setAuthFlags(PortalSession session, int authFlags) {
        ssProvider.setAuthFlags(session, authFlags);
    }

    public static void unlockSecrets(PortalSession session, Object key) {
        try {
            ssProvider.unlockSecrets(session, key);
        }
        catch (SSException ss) {
            Debug.log("SecretStore", ss);
        }
    }

    public static void deleteSS(PortalSession session, String newPassword) {
    }

    public static PortalConnection getConnection(PortalSession session) {
        return AuthenticationManager.getConnection((HttpSession)session);
    }

    public static PortalConnection getConnection(HttpSession session) {
        DirAuthenticator dirAuth = DirAuthenticator.getDirAuth((HttpServletRequest)FwUtils.getRequest((HttpSession)session));
        return (PortalConnection)dirAuth.getAuthenticationBroker().getAPIObject("PortalConnection");
    }

    public static void clearPublicConnection(PortalSession session) {
        PortalConnection pc = (PortalConnection)session.getAttribute(PUBLIC_CONNECTION);
        if (pc != null) {
            try {
                pc.logout();
            }
            catch (LogoutException ex) {
                D.log((String)"Clearing public connection");
                D.log((Throwable)ex);
            }
            session.removeAttribute(PUBLIC_CONNECTION);
        }
    }

    public static LDAPCredentials getCurrentCredentials(PortalSession session) {
        try {
            ManagementServiceSet mms = AuthenticationManager.getManagementServiceSet(session, 3);
            String ldapName = mms.getAuthenticationBroker().getAuthLdapName();
            String[] identity = mms.getAuthenticationBroker().getIdentity();
            String pwd = identity[1];
            LDAPCredentials credentials = new LDAPCredentials(ldapName, pwd);
            return credentials;
        }
        catch (Throwable e) {
            D.log((Throwable)e);
            LDAPCredentials theUser = null;
            theUser = (LDAPCredentials)session.getAttribute(CREDENTIALS);
            return theUser;
        }
    }

    public static String getAuthenticationState(PortalSession session) {
        return STATE_LOGGED_IN;
    }

    public static ResourceBundle getResourceBundle() {
        return m_res;
    }

    public static void setManagementServiceSet(ManagementServiceSet manageSS, PortalSession session, int mssType) {
    }

    public static ManagementServiceSet getManagementServiceSet(PortalSession session, int mssType) {
        return DirAuthenticator.getManagementServiceSet((HttpSession)session);
    }

    public static ManagementServiceSet getManagementServiceSet(PortalSession session) {
        return DirAuthenticator.getManagementServiceSet((HttpSession)session);
    }

    private static List getPostAuthServices() {
        return (List)WebappUtil.getStaticServletContext().getAttribute(SETTING_POST_AUTH_SERVICES);
    }
}

