/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.authentication;

import com.novell.nps.authentication.sso.XORCrypt;
import com.novell.nps.debug.Debug;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class LDAPCredentials
implements Serializable {
    Hashtable currentUser = new Hashtable();
    private byte[] usernameValue = null;
    private byte[] passwordValue = null;
    private byte[] shortnameValue = null;
    private Integer encryptKey = new Integer(568);

    public byte[] encrypt(String newString) {
        XORCrypt encryption = new XORCrypt();
        byte[] newArray = new byte[]{};
        try {
            newArray = newString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.log("LDAPCredentials", 1, e);
        }
        encryption.encryptCredentials(this.encryptKey, newArray);
        return newArray;
    }

    public String decrypt(byte[] currentArray) {
        XORCrypt encryption = new XORCrypt();
        byte[] newArray = (byte[])currentArray.clone();
        encryption.decryptCredentials(this.encryptKey, newArray);
        String newString = null;
        try {
            newString = new String(newArray, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.log("LDAPCredentials", 1, e);
        }
        return newString;
    }

    public LDAPCredentials(String fullUserName, String password) {
        this.encryptKey = new Integer(password.hashCode());
        this.usernameValue = this.encrypt(fullUserName);
        this.passwordValue = this.encrypt(password);
        int index1 = fullUserName.indexOf("=");
        this.shortnameValue = this.encrypt(fullUserName.substring(index1 + 1, fullUserName.indexOf(",")));
    }

    public String getUserName() {
        return this.decrypt(this.shortnameValue);
    }

    public String getFullLdapUserName() {
        return this.decrypt(this.usernameValue);
    }

    public String getPassword() {
        return this.decrypt(this.passwordValue);
    }
}

